/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.hpel.impl;

import com.ibm.ws.logging.hpel.GenericOutputFile;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Timer;

public abstract class AccessHelper {
    private static FlexibleAccessController proxyController = null;
    private static final String WS_ACCESS_CONTROLLER = "com.ibm.ws.security.util.AccessController";
    private static final String DO_PRIVILEGED_METHOD = "doPrivileged";

    private static FlexibleAccessController getInstance() {
        if (proxyController == null) {
            try {
                Class<?> accessControllerClass = Class.forName(WS_ACCESS_CONTROLLER);
                if (accessControllerClass != null) {
                    final Method method1 = accessControllerClass.getMethod(DO_PRIVILEGED_METHOD, PrivilegedAction.class);
                    final Method method2 = accessControllerClass.getMethod(DO_PRIVILEGED_METHOD, PrivilegedExceptionAction.class);
                    proxyController = new FlexibleAccessController(){

                        @Override
                        <T> T doPrivileged(PrivilegedAction<T> action) {
                            try {
                                return (T)method1.invoke(null, action);
                            }
                            catch (InvocationTargetException ex) {
                                if (ex.getCause() instanceof RuntimeException) {
                                    throw (RuntimeException)ex.getCause();
                                }
                                throw new RuntimeException(ex.getCause());
                            }
                            catch (Exception ex) {
                                throw new RuntimeException(ex);
                            }
                        }

                        @Override
                        <T> T doPrivileged(PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
                            try {
                                return (T)method2.invoke(null, action);
                            }
                            catch (InvocationTargetException ex) {
                                if (ex.getCause() instanceof PrivilegedActionException) {
                                    throw (PrivilegedActionException)ex.getCause();
                                }
                                if (ex.getCause() instanceof RuntimeException) {
                                    throw (RuntimeException)ex.getCause();
                                }
                                throw new RuntimeException(ex.getCause());
                            }
                            catch (Exception ex) {
                                throw new RuntimeException(ex);
                            }
                        }
                    };
                }
            }
            catch (ClassNotFoundException ex) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (proxyController == null) {
                proxyController = new FlexibleAccessController(){

                    @Override
                    <T> T doPrivileged(PrivilegedAction<T> action) {
                        return AccessController.doPrivileged(action);
                    }

                    @Override
                    <T> T doPrivileged(PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
                        return AccessController.doPrivileged(action);
                    }
                };
            }
        }
        return proxyController;
    }

    static boolean isFile(final File file) {
        try {
            Boolean isFile = AccessHelper.getInstance().doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return file.isFile();
                }
            });
            return isFile;
        }
        catch (SecurityException se) {
            return false;
        }
    }

    static boolean isDirectory(final File file) {
        try {
            Boolean exists = AccessHelper.getInstance().doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return file.isDirectory();
                }
            });
            return exists;
        }
        catch (SecurityException se) {
            return false;
        }
    }

    static long getFileLength(final File fileToCheck) {
        try {
            Long size = AccessHelper.getInstance().doPrivileged(new PrivilegedAction<Long>(){

                @Override
                public Long run() {
                    return fileToCheck.length();
                }
            });
            return size;
        }
        catch (SecurityException se) {
            return 0L;
        }
    }

    static boolean makeDirectories(final File dirToMake) {
        try {
            Boolean result = AccessHelper.getInstance().doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return dirToMake.mkdirs();
                }
            });
            return result;
        }
        catch (SecurityException se) {
            return false;
        }
    }

    static boolean canMakeDirectories(final File dirToMake) throws IllegalArgumentException {
        if (dirToMake == null) {
            throw new IllegalArgumentException("Parameter dirToMake cannot be null");
        }
        try {
            Boolean result = AccessHelper.getInstance().doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    File curDir = dirToMake.getAbsoluteFile();
                    do {
                        if (curDir.isDirectory()) {
                            if (curDir.canWrite()) {
                                return Boolean.TRUE;
                            }
                            throw new IllegalArgumentException("Cannot create directories in \"" + dirToMake + "\" since \"" + curDir + "\" is not a writable directory");
                        }
                        if (!curDir.exists()) continue;
                        throw new IllegalArgumentException("Cannot create directories in \"" + dirToMake + "\" since \"" + curDir + "\" exists and is not a directory");
                    } while ((curDir = curDir.getParentFile()) != null);
                    throw new IllegalArgumentException("Cannot create directories in \"" + dirToMake + "\" since none of its parents exists");
                }
            });
            return result;
        }
        catch (SecurityException se) {
            throw new IllegalArgumentException("Cannot create directories in \"" + dirToMake + "\" due to security issue: " + se.getMessage(), se);
        }
    }

    static FileInputStream createFileInputStream(final File file) throws IOException {
        try {
            FileInputStream fs = AccessHelper.getInstance().doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                @Override
                public FileInputStream run() throws IOException {
                    return new FileInputStream(file);
                }
            });
            return fs;
        }
        catch (PrivilegedActionException ex) {
            throw new IOException("Unable to create FileInputStream over file " + file.getName(), ex);
        }
    }

    static boolean deleteFile(final File fileToDelete) {
        try {
            Boolean deleted = AccessHelper.getInstance().doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return fileToDelete.delete();
                }
            });
            return deleted;
        }
        catch (SecurityException se) {
            return false;
        }
    }

    static FileOutputStream createFileOutputStream(final File file, final boolean append) throws IOException {
        try {
            FileOutputStream fs = AccessHelper.getInstance().doPrivileged(new PrivilegedExceptionAction<FileOutputStream>(){

                @Override
                public FileOutputStream run() throws IOException {
                    if (file instanceof GenericOutputFile) {
                        return ((GenericOutputFile)((Object)file)).createOutputStream(append);
                    }
                    return new FileOutputStream(file, append);
                }
            });
            return fs;
        }
        catch (PrivilegedActionException ex) {
            throw new IOException("Unable to create FileOutputStream over file " + file.getName(), ex);
        }
    }

    static File[] listFiles(final File parent, final FileFilter fileFilter) {
        try {
            File[] result = AccessHelper.getInstance().doPrivileged(new PrivilegedAction<File[]>(){

                @Override
                public File[] run() {
                    return parent.listFiles(fileFilter);
                }
            });
            return result == null ? new File[]{} : result;
        }
        catch (SecurityException se) {
            return new File[0];
        }
    }

    static long getFreeSpace(final File fileInFs) {
        try {
            long result = AccessHelper.getInstance().doPrivileged(new PrivilegedAction<Long>(){

                @Override
                public Long run() {
                    return fileInFs.getFreeSpace();
                }
            });
            return result;
        }
        catch (SecurityException se) {
            return -1L;
        }
    }

    static long getTotalSpace(final File fileInFs) {
        try {
            long result = AccessHelper.getInstance().doPrivileged(new PrivilegedAction<Long>(){

                @Override
                public Long run() {
                    return fileInFs.getTotalSpace();
                }
            });
            return result;
        }
        catch (SecurityException se) {
            return -1L;
        }
    }

    static Timer createTimer() {
        try {
            return AccessHelper.getInstance().doPrivileged(new PrivilegedAction<Timer>(){

                @Override
                public Timer run() {
                    return new Timer(true);
                }
            });
        }
        catch (SecurityException se) {
            return null;
        }
    }

    private static abstract class FlexibleAccessController {
        private FlexibleAccessController() {
        }

        abstract <T> T doPrivileged(PrivilegedAction<T> var1);

        abstract <T> T doPrivileged(PrivilegedExceptionAction<T> var1) throws PrivilegedActionException;
    }
}

