/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.hpel.handlers;

import com.ibm.ejs.ras.hpel.HpelHelper;
import com.ibm.websphere.logging.hpel.reader.HpelFormatter;
import com.ibm.ws.logging.hpel.LogRepositoryWriter;
import com.ibm.ws.logging.hpel.SerializationObject;
import com.ibm.ws.logging.hpel.impl.SerializationObjectPool;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class LogRecordTextHandler
extends Handler {
    private HpelFormatter formatter = HpelFormatter.getFormatter("Basic");
    private LogRepositoryWriter writer = null;
    private final SerializationObjectPool pool;
    private final byte[] headerBytes;
    private final int traceThreshold;
    private boolean includeTrace = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogRecordTextHandler(int traceThreshold) {
        this.traceThreshold = traceThreshold;
        this.pool = new SerializationObjectPool(){

            @Override
            public SerializationObject createNewObject() {
                return new SerializationBuffer();
            }
        };
        SerializationObject serializationObject = this.pool.getSerializationObject();
        try {
            this.headerBytes = serializationObject.serializeFileHeader(HpelHelper.getHeaderAsProperties());
        }
        finally {
            this.pool.returnSerializationObject(serializationObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(LogRecord record) {
        byte[] bytes;
        LogRecordTextHandler logRecordTextHandler = this;
        synchronized (logRecordTextHandler) {
            if (!this.includeTrace && record.getLevel().intValue() < this.traceThreshold) {
                return;
            }
        }
        SerializationObject serializationObject = this.pool.getSerializationObject();
        try {
            bytes = serializationObject.serialize(record);
        }
        finally {
            this.pool.returnSerializationObject(serializationObject);
        }
        LogRecordTextHandler logRecordTextHandler2 = this;
        synchronized (logRecordTextHandler2) {
            if (this.writer != null) {
                this.writer.logRecord(record.getMillis(), bytes);
            }
        }
    }

    public synchronized void setFormat(String formatType) {
        this.formatter = HpelFormatter.getFormatter(formatType);
    }

    public synchronized void setIncludeTrace(boolean includeTrace) {
        this.includeTrace = includeTrace;
    }

    public void stop() {
        if (this.writer != null) {
            this.writer.stop();
            this.writer.getLogRepositoryManager().stop();
            this.writer = null;
        }
    }

    public void copyHeader(LogRepositoryWriter writer) throws IllegalArgumentException {
        if (writer == null) {
            throw new IllegalArgumentException("Parameter writer can't be null");
        }
        writer.setHeader(this.headerBytes);
    }

    public synchronized LogRepositoryWriter getWriter() {
        return this.writer;
    }

    public synchronized void setWriter(LogRepositoryWriter writer) {
        if (this.writer != null) {
            this.writer.stop();
        }
        this.writer = writer;
        if (this.writer != null) {
            this.writer.setHeader(this.headerBytes);
        }
    }

    private synchronized HpelFormatter getFormatterType() {
        return this.formatter;
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    @Override
    public void publish(LogRecord record) {
        this.processEvent(record);
    }

    private class SerializationBuffer
    implements SerializationObject {
        private static final int BYTE_ARRAY_INITIAL_SIZE = 1024;
        private final ByteArrayOutputStream buffer = new ByteArrayOutputStream(1024);

        private SerializationBuffer() {
        }

        @Override
        public byte[] serialize(LogRecord record) {
            this.buffer.reset();
            PrintStream stream = new PrintStream(this.buffer);
            stream.println(LogRecordTextHandler.this.getFormatterType().formatRecord(record));
            stream.flush();
            return this.buffer.toByteArray();
        }

        @Override
        public byte[] serializeFileHeader(Properties header) {
            this.buffer.reset();
            PrintStream stream = new PrintStream(this.buffer);
            HpelHelper.printHeader(stream, header);
            stream.flush();
            return this.buffer.toByteArray();
        }
    }
}

