/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.hpel;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.util.Random;

public final class Guid {
    private int timeLow = 0;
    private short timeMiddle = 0;
    private short timeHighWithVersion = 0;
    private byte clockSequenceHighWithReserved = 0;
    private byte clockSequenceLow = 0;
    private static long lastTimeStamp = 0L;
    private static long clockSequence = 0L;
    private static int clockSequenceAdjustment = 0;
    private static byte[] pseudoIEEE802MACAddress = null;
    private static Random randomNumberGenerator = null;
    private static boolean isInitialized = false;
    private static final char[] HEXADECIMAL_CHARACTERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final Object LOCK = new Object();
    private static final String TEMPORARY_DIRECTORY = Guid.getSystemProperty("java.io.tmpdir");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Guid() {
        long adjustedTimestamp = 0L;
        Object object = LOCK;
        synchronized (object) {
            if (!isInitialized) {
                long uniqueTimeStamp = this.getUniqueTimeStamp();
                pseudoIEEE802MACAddress = this.getPseudoIEEE802MACAddress(uniqueTimeStamp);
                try {
                    randomNumberGenerator = SecureRandom.getInstance("MD5");
                    randomNumberGenerator.setSeed(uniqueTimeStamp);
                }
                catch (Throwable t) {
                    randomNumberGenerator = new Random(uniqueTimeStamp);
                }
                clockSequence = randomNumberGenerator.nextLong();
                isInitialized = true;
            }
            boolean timeIsValid = true;
            do {
                if ((adjustedTimestamp = this.getAdjustedTimestamp()) < lastTimeStamp) {
                    clockSequence = randomNumberGenerator.nextLong();
                    clockSequenceAdjustment = 0;
                }
                if (adjustedTimestamp > lastTimeStamp) {
                    clockSequenceAdjustment = 0;
                }
                if (adjustedTimestamp != lastTimeStamp) continue;
                if (clockSequenceAdjustment < 9999) {
                    ++clockSequenceAdjustment;
                    continue;
                }
                timeIsValid = false;
            } while (!timeIsValid);
            lastTimeStamp = adjustedTimestamp;
            if (clockSequenceAdjustment != 0) {
                adjustedTimestamp += (long)clockSequenceAdjustment;
            }
            this.timeLow = (int)(adjustedTimestamp & 0xFFFFFFFFFFFFFFFFL);
            this.timeMiddle = (short)(adjustedTimestamp >>> 32 & 0xFFFFL);
            this.timeHighWithVersion = (short)((short)(adjustedTimestamp >>> 48 & 0xFFFL) | 0xFFFFA000);
            this.clockSequenceLow = (byte)(clockSequence & 0xFFL);
            this.clockSequenceHighWithReserved = (byte)((byte)((clockSequence & 0x3F00L) >>> 8) | 0xFFFFFFC0);
        }
    }

    public String toString() {
        int pos;
        char[] stringBuffer = new char[32];
        int shift = 12;
        for (pos = 0; pos < 4; ++pos) {
            stringBuffer[pos] = HEXADECIMAL_CHARACTERS[this.timeHighWithVersion >>> shift & 0xF];
            shift -= 4;
        }
        shift = 12;
        while (pos < 8) {
            stringBuffer[pos] = HEXADECIMAL_CHARACTERS[this.timeMiddle >>> shift & 0xF];
            shift -= 4;
            ++pos;
        }
        shift = 28;
        while (pos < 16) {
            stringBuffer[pos] = HEXADECIMAL_CHARACTERS[this.timeLow >>> shift & 0xF];
            shift -= 4;
            ++pos;
        }
        stringBuffer[pos++] = HEXADECIMAL_CHARACTERS[this.clockSequenceHighWithReserved >>> 4 & 0xF];
        stringBuffer[pos++] = HEXADECIMAL_CHARACTERS[this.clockSequenceHighWithReserved & 0xF];
        stringBuffer[pos++] = HEXADECIMAL_CHARACTERS[this.clockSequenceLow >>> 4 & 0xF];
        stringBuffer[pos++] = HEXADECIMAL_CHARACTERS[this.clockSequenceLow & 0xF];
        int i = 0;
        while (pos < 32) {
            stringBuffer[pos] = HEXADECIMAL_CHARACTERS[pseudoIEEE802MACAddress[i] >>> 4 & 0xF];
            stringBuffer[pos + 1] = HEXADECIMAL_CHARACTERS[pseudoIEEE802MACAddress[i] & 0xF];
            ++i;
            pos += 2;
        }
        return new String(stringBuffer).trim();
    }

    private synchronized byte[] getPseudoIEEE802MACAddress(long uniqueTimeStamp) {
        byte[] ieee802Addr = new byte[6];
        byte[] currentTime = String.valueOf(uniqueTimeStamp).getBytes();
        byte[] localHostAddress = null;
        try {
            localHostAddress = InetAddress.getLocalHost().getAddress();
        }
        catch (UnknownHostException u) {
            localHostAddress = new byte[]{127, 0, 0, 1};
        }
        byte[] inMemoryObject = Integer.toHexString(new Object().hashCode()).getBytes();
        byte[] freeMemory = String.valueOf(Runtime.getRuntime().freeMemory()).getBytes();
        byte[] totalMemory = String.valueOf(Runtime.getRuntime().totalMemory()).getBytes();
        byte[] messageDigestInput = new byte[currentTime.length + localHostAddress.length + inMemoryObject.length + freeMemory.length + totalMemory.length];
        int messageDigestInputIndex = 0;
        System.arraycopy(currentTime, 0, messageDigestInput, messageDigestInputIndex, currentTime.length);
        System.arraycopy(localHostAddress, 0, messageDigestInput, messageDigestInputIndex += currentTime.length, localHostAddress.length);
        System.arraycopy(inMemoryObject, 0, messageDigestInput, messageDigestInputIndex += localHostAddress.length, inMemoryObject.length);
        System.arraycopy(freeMemory, 0, messageDigestInput, messageDigestInputIndex += inMemoryObject.length, freeMemory.length);
        System.arraycopy(totalMemory, 0, messageDigestInput, messageDigestInputIndex += freeMemory.length, totalMemory.length);
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.reset();
            System.arraycopy(md5.digest(messageDigestInput), 0, ieee802Addr, 0, 6);
        }
        catch (Throwable t) {
            int hashCode = 0;
            for (int counter = 0; counter < messageDigestInput.length; ++counter) {
                hashCode = 31 * hashCode + messageDigestInput[counter];
            }
            byte[] hashCodeBytes = Integer.toHexString(hashCode).getBytes();
            if (hashCodeBytes.length < 6) {
                System.arraycopy(hashCodeBytes, 0, ieee802Addr, 6 - hashCodeBytes.length, hashCodeBytes.length);
            }
            System.arraycopy(hashCodeBytes, hashCodeBytes.length - 6, ieee802Addr, 0, 6);
        }
        ieee802Addr[0] = (byte)(ieee802Addr[0] | 0x80);
        return ieee802Addr;
    }

    private synchronized long getAdjustedTimestamp() {
        return System.currentTimeMillis() * 10000L + 122192928000000000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized long getUniqueTimeStamp() {
        long timeStamp = System.currentTimeMillis();
        File lockFile = null;
        try {
            lockFile = new File(TEMPORARY_DIRECTORY, "guid.lock");
            long lastModified = this.fileLastModified(lockFile);
            long maxWaitTimeStamp = System.currentTimeMillis() + 1000L;
            while (true) {
                try {
                    if (lockFile.createNewFile()) break;
                    if (System.currentTimeMillis() <= maxWaitTimeStamp) continue;
                    if (this.fileLastModified(lockFile) <= lastModified) {
                        this.delete(lockFile);
                        lastModified = -1L;
                        continue;
                    }
                    long l = timeStamp;
                    return l;
                }
                catch (IOException i) {
                    long l = timeStamp;
                    return l;
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            timeStamp = System.currentTimeMillis();
        }
        catch (SecurityException s) {
        }
        finally {
            try {
                if (lockFile != null) {
                    this.delete(lockFile);
                }
            }
            catch (SecurityException s) {}
        }
        return timeStamp;
    }

    private boolean delete(final File lockFile) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return lockFile.delete();
            }
        });
    }

    private long fileLastModified(final File lockFile) {
        return AccessController.doPrivileged(new PrivilegedAction<Long>(){

            @Override
            public Long run() {
                return lockFile.lastModified();
            }
        });
    }

    public static String generate() {
        return new Guid().toString();
    }

    private static String getSystemProperty(final String prop) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(prop);
            }
        });
    }
}

