/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.logging.hpel.reader;

import com.ibm.ejs.ras.hpel.Messages;
import com.ibm.websphere.logging.hpel.reader.HpelAdvancedFormatter;
import com.ibm.websphere.logging.hpel.reader.HpelBasicFormatter;
import com.ibm.websphere.logging.hpel.reader.HpelCBEFormatter;
import com.ibm.websphere.logging.hpel.reader.HpelJsonFormatter;
import com.ibm.websphere.logging.hpel.reader.RepositoryLogRecord;
import com.ibm.ws.logging.hpel.FormatSet;
import com.ibm.ws.logging.hpel.impl.LogRecordWrapper;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public abstract class HpelFormatter {
    public static final String FORMAT_BASIC = "Basic";
    public static final String FORMAT_ADVANCED = "Advanced";
    public static final String FORMAT_CBE101 = "CBE-1.0.1";
    public static final String FORMAT_JSON = "Json";
    protected String lineSeparator = this.getProperty("line.separator");
    protected Properties headerProps = new Properties();
    protected Locale locale = null;
    protected TimeZone timeZone = TimeZone.getDefault();
    protected DateFormat dateFormat = FormatSet.customizeDateFormat(DateFormat.getDateTimeInstance(3, 2));
    protected static final String nullParamString = "null";
    private static final String svEmptyString = "";
    private static final String svEmptyStringReplacement = "\"\"";
    protected static final Map<Level, String> customLevels = new HashMap<Level, String>();
    protected CustomHeaderLine[] customHeader = new CustomHeaderLine[0];

    public static HpelFormatter getFormatter(String formatStyle) {
        if (formatStyle != null && !svEmptyString.equals(formatStyle)) {
            if (formatStyle.equalsIgnoreCase(FORMAT_BASIC)) {
                return new HpelBasicFormatter();
            }
            if (formatStyle.equalsIgnoreCase(FORMAT_ADVANCED)) {
                return new HpelAdvancedFormatter();
            }
            if (formatStyle.equalsIgnoreCase(FORMAT_CBE101)) {
                return new HpelCBEFormatter();
            }
            if (formatStyle.equalsIgnoreCase(FORMAT_JSON)) {
                return new HpelJsonFormatter();
            }
        }
        throw new IllegalArgumentException(formatStyle + " is not a valid formatter style");
    }

    private String getProperty(String string) {
        final String temp = string;
        try {
            String prop = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(temp);
                }
            });
            return prop;
        }
        catch (SecurityException se) {
            return null;
        }
    }

    public static Level addCustomLevel(String name, int intValue, String id, String resourceBundleName) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter name can not be 'null' in this call.");
        }
        Level level = null;
        try {
            level = Level.parse(name);
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        if (level == null || level.intValue() != intValue) {
            level = new CustomLevel(name, intValue, resourceBundleName);
        }
        HpelFormatter.addCustomLevel(level, id);
        return level;
    }

    public static void addCustomLevel(Level level, String id) {
        if (level == null) {
            throw new IllegalArgumentException("Parameter level can not be 'null' in this call");
        }
        if (id == null) {
            id = level.getName().substring(0, 1);
        }
        customLevels.put(level, id);
    }

    public void setCustomHeader(String[] header) {
        if (header == null) {
            throw new IllegalArgumentException("Custom header can't be null.");
        }
        this.customHeader = new CustomHeaderLine[header.length];
        for (int i = 0; i < header.length; ++i) {
            this.customHeader[i] = new CustomHeaderLine(header[i]);
        }
    }

    public String getTimeZoneID() {
        return this.timeZone.getID();
    }

    public void setTimeZoneID(String timeZoneId) {
        if (!HpelFormatter.verifyTimeZoneID(timeZoneId)) {
            throw new IllegalArgumentException(timeZoneId + " is not a valid time zone");
        }
        this.timeZone = TimeZone.getTimeZone(timeZoneId);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.dateFormat = null == locale ? FormatSet.customizeDateFormat(DateFormat.getDateTimeInstance(3, 2)) : FormatSet.customizeDateFormat(DateFormat.getDateTimeInstance(3, 2, locale));
    }

    public void setHeaderProps(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Argument 'sysProps' cannot be null.");
        }
        this.headerProps = properties;
    }

    public Properties getHeaderProps() {
        return this.headerProps;
    }

    public String formatMessage(RepositoryLogRecord record, Locale tmpLocale) {
        if (record.getLocalizable() == 2) {
            String traceString = record.getRawMessage();
            Object[] parms = record.getParameters();
            return this.formatUnlocalized(traceString, parms);
        }
        if (tmpLocale == null) {
            tmpLocale = this.locale;
        }
        String localizedMsg = null;
        if (tmpLocale == null || tmpLocale.toString().equals(record.getMessageLocale())) {
            localizedMsg = record.getLocalizedMessage();
        }
        if (localizedMsg == null) {
            localizedMsg = HpelFormatter.translateMessage(record, tmpLocale);
        }
        if (localizedMsg == null) {
            return svEmptyString;
        }
        try {
            localizedMsg = MessageFormat.format(localizedMsg, record.getParameters());
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        return localizedMsg;
    }

    public static Object[] convertParameters(Object[] parms) {
        if (parms == null) {
            return null;
        }
        if (parms.length == 0) {
            return parms;
        }
        Object[] newParms = new Object[parms.length];
        for (int i = 0; i < parms.length; ++i) {
            newParms[i] = parms[i] instanceof String && ((String)parms[i]).equals(svEmptyString) ? svEmptyStringReplacement : parms[i];
        }
        return newParms;
    }

    protected String formatUnlocalized(String traceString, Object[] parms) {
        Object[] newParms = HpelFormatter.convertParameters(parms);
        if (newParms == null) {
            return traceString;
        }
        String formattedTrace = traceString.indexOf(123) >= 0 ? Messages.getFormattedMessageFromLocalizedMessage(traceString, newParms, true) : traceString;
        if (formattedTrace.equals(traceString)) {
            return this.appendUnusedParms(traceString, newParms);
        }
        return formattedTrace;
    }

    protected abstract String appendUnusedParms(String var1, Object[] var2);

    public static String translateMessage(RepositoryLogRecord record, Locale tmpLocale) {
        if (null == record) {
            throw new IllegalArgumentException("Record cannot be null");
        }
        String rawMessage = record.getRawMessage();
        if (rawMessage == null || tmpLocale == null || record.getLocalizable() == 2 || record.getResourceBundleName() == null) {
            return rawMessage;
        }
        String msgKey = rawMessage.replace(' ', '.');
        return Messages.getStringFromBundle(record.getResourceBundleName(), msgKey, tmpLocale, rawMessage);
    }

    public String formatRecord(RepositoryLogRecord record) {
        if (null == record) {
            throw new IllegalArgumentException("Record cannot be null");
        }
        return this.formatRecord(record, null);
    }

    public abstract String formatRecord(RepositoryLogRecord var1, Locale var2);

    public String formatRecord(LogRecord record) {
        return this.formatRecord(new LogRecordWrapper(record));
    }

    public abstract String[] getHeader();

    public abstract String getFooter();

    protected static boolean verifyTimeZoneID(String timeZoneID) {
        if (timeZoneID != null) {
            TimeZone gmt = TimeZone.getTimeZone("GMT");
            if (timeZoneID.equals(gmt.getID())) {
                return true;
            }
            TimeZone tzId = TimeZone.getTimeZone(timeZoneID);
            return !gmt.equals(tzId);
        }
        return false;
    }

    protected static void formatThreadID(RepositoryLogRecord r, StringBuilder buffer) {
        for (int i = Integer.toHexString(r.getThreadID()).length(); i < 8; ++i) {
            buffer.append('0');
        }
        buffer.append(Integer.toHexString(r.getThreadID()));
        buffer.append(" ");
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public void setStartDatetime(long headerStartDatetime) {
    }

    protected class CustomHeaderLine {
        private final String pattern;
        private final ArrayList<String[]> vars = new ArrayList();

        private CustomHeaderLine(String line) {
            int end;
            StringBuilder sb = new StringBuilder();
            int index = 0;
            int start = line.indexOf(123);
            int rest = 0;
            while (start >= 0 && (end = line.indexOf(125, start)) >= 0) {
                String var;
                if (end - start > 2 && !(var = line.substring(start + 1, end).trim()).isEmpty()) {
                    this.vars.add(var.split("\\s*\\|\\s*"));
                    sb.append(line.substring(rest, start + 1));
                    sb.append(Integer.toString(index++));
                    rest = end;
                }
                start = line.indexOf(123, end);
            }
            sb.append(line.substring(rest));
            this.pattern = sb.toString();
        }

        public String formatLine(Properties header) {
            if (this.vars.size() == 0) {
                return this.pattern;
            }
            Object[] args = new Object[this.vars.size()];
            int index = 0;
            for (String[] varList : this.vars) {
                String value = null;
                for (String var : varList) {
                    value = header.getProperty(var);
                    if (value == null || value.isEmpty()) continue;
                    args[index++] = value;
                    break;
                }
                if (value != null && !value.isEmpty()) continue;
                return null;
            }
            return MessageFormat.format(this.pattern, args);
        }
    }

    private static class CustomLevel
    extends Level {
        private static final long serialVersionUID = 3927638037228330703L;

        private CustomLevel(String name, int level, String resourceBundleName) {
            super(name, level, resourceBundleName);
        }
    }
}

