/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.crypto.certificateutil.keytool;

import com.ibm.ws.crypto.certificateutil.DefaultSSLCertificateCreator;
import com.ibm.ws.crypto.certificateutil.keytool.KeytoolCommand;
import java.io.File;
import java.security.cert.CertificateException;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;

public class KeytoolSSLCertificateCreator
implements DefaultSSLCertificateCreator {
    @Override
    public File createDefaultSSLCertificate(String filePath, String password, int validity, String subjectDN, int keySize, String sigAlg) throws CertificateException {
        this.validateParameters(filePath, password, validity, subjectDN, keySize, sigAlg);
        String keyType = this.getKeyFromSigAlg(sigAlg);
        KeytoolCommand keytoolCmd = new KeytoolCommand(filePath, password, validity, subjectDN, keySize, keyType, sigAlg);
        keytoolCmd.executeCommand();
        File f = new File(filePath);
        if (f.exists()) {
            return f;
        }
        throw new CertificateException("KeytoolCommand executed successfully but file does not exist.");
    }

    private void validateParameters(String filePath, String password, int validity, String subjectDN, int keySize, String sigAlg) {
        if (!this.validateFilePath(filePath)) {
            throw new IllegalArgumentException("filePath must be a valid filePath within the file system.");
        }
        if (password == null || password.length() < 6) {
            throw new IllegalArgumentException("The password must be at least 6 characters in length.");
        }
        if (validity < 365) {
            throw new IllegalArgumentException("The validity period must be at least 365 days.");
        }
        List validSigAlg = VALID_SIG_ALG;
        if (!validSigAlg.contains(sigAlg)) {
            throw new IllegalArgumentException("The signagure algorithm values include " + VALID_SIG_ALG);
        }
        String type = this.getKeyFromSigAlg(sigAlg);
        if (type.equals("RSA")) {
            List validKeySizes = VALID_RSA_KEYSIZE;
            if (!validKeySizes.contains(keySize)) {
                throw new IllegalArgumentException("The key sizes for an RSA key include " + VALID_RSA_KEYSIZE);
            }
        } else {
            List validKeySizes = VALID_EC_KEYSIZE;
            if (!validKeySizes.contains(keySize)) {
                throw new IllegalArgumentException("The key sizes for an EC key include " + VALID_EC_KEYSIZE);
            }
        }
        this.validateSubjectDN(subjectDN);
    }

    private boolean validateFilePath(String filePath) {
        if (filePath == null || filePath.isEmpty()) {
            throw new IllegalArgumentException("filePath must be a valid filePath within the file system.");
        }
        File loc = new File(filePath).getAbsoluteFile();
        return loc.exists() || loc.getParentFile().exists();
    }

    private void validateSubjectDN(String subjectDN) {
        if (subjectDN == null || subjectDN.isEmpty()) {
            throw new IllegalArgumentException("The subject DN must be a valid DN");
        }
        try {
            new LdapName(subjectDN);
        }
        catch (InvalidNameException e) {
            throw new IllegalArgumentException("The subject DN must be a valid DN");
        }
    }

    private String getKeyFromSigAlg(String sigAlg) {
        if (sigAlg.endsWith("ECDSA")) {
            return "EC";
        }
        return "RSA";
    }
}

