/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jaas.common.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.config.xml.internal.nester.Nester;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.jaas.common.JAASLoginModuleConfig;
import com.ibm.ws.security.jaas.common.internal.ModuleConfig;
import com.ibm.ws.security.jaas.common.modules.WSLoginModuleProxy;
import com.ibm.wsspi.classloading.ClassLoadingService;
import com.ibm.wsspi.library.Library;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(configurationPid={"com.ibm.ws.security.authentication.internal.jaas.jaasLoginModuleConfig"}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.vendor=IBM"})
public class JAASLoginModuleConfigImpl
implements JAASLoginModuleConfig {
    private static final TraceComponent tc = Tr.register(JAASLoginModuleConfigImpl.class);
    public static final String CERTIFICATE = "certificate";
    public static final String HASHTABLE = "hashtable";
    public static final String IDENTITY_ASSERTION = "identityAssertion";
    public static final String TOKEN = "token";
    public static final String USERNAME_AND_PASSWORD = "userNameAndPassword";
    public static final String DELEGATE = "delegate";
    public static final Class<WSLoginModuleProxy> WSLOGIN_MODULE_PROXY_CLASS = WSLoginModuleProxy.class;
    public static final String WSLOGIN_MODULE_PROXY = WSLOGIN_MODULE_PROXY_CLASS.getName();
    public static final List<String> defaultLoginModuleIds = Collections.unmodifiableList(Arrays.asList("hashtable", "userNameAndPassword", "certificate", "token", "hashtable", "proxy", "identityAssertion"));
    static final String CFG_KEY_ID = "id";
    static final String CFG_KEY_CLASSNAME = "className";
    static final String CFG_KEY_CONTROL_FLAG = "controlFlag";
    static final String CFG_KEY_OPTION_PID = "optionsRef";
    public static final String WAS_LM_SHARED_LIB = "WAS_LM_SHAREDLIB";
    private ModuleConfig moduleConfig;
    private AppConfigurationEntry.LoginModuleControlFlag controlFlag = null;
    private Map<String, Object> options = Collections.emptyMap();
    private Library sharedLibrary;
    private ClassLoadingService classLoadingService;
    static final long serialVersionUID = 8863186601840053785L;

    @Activate
    protected void activate(ModuleConfig moduleConfig, Map<String, Object> props) {
        this.moduleConfig = moduleConfig;
        this.processConfigProps(props);
    }

    private void processConfigProps(Map<String, Object> props) {
        this.controlFlag = JAASLoginModuleConfigImpl.setControlFlag(this.moduleConfig.controlFlag());
        Map<String, Object> options = this.extractOptions(props);
        String originalLoginModuleClassName = this.moduleConfig.className();
        if (this.isDefaultLoginModule()) {
            String target = JAASLoginModuleConfigImpl.getTargetClassName(originalLoginModuleClassName, options);
            Class<?> cl = this.getTargetClassForName(target);
            options.put("kernelDelegate", cl);
        } else {
            options = JAASLoginModuleConfigImpl.processDelegateOptions(options, originalLoginModuleClassName, this.classLoadingService, this.sharedLibrary, false);
        }
        this.options = options;
    }

    @FFDCIgnore(value={ClassNotFoundException.class})
    public static Map<String, Object> processDelegateOptions(Map<String, Object> inOptions, String originalLoginModuleClassName, ClassLoadingService classLoadingService, Library sharedLibrary, boolean jaasConfigFile) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.putAll(inOptions);
        String target = JAASLoginModuleConfigImpl.getTargetClassName(originalLoginModuleClassName, options);
        options.put("kernelDelegate", WSLOGIN_MODULE_PROXY_CLASS);
        if (target != null) {
            Class<?> cl;
            block5: {
                ClassLoader loader = classLoadingService == null ? null : classLoadingService.getSharedLibraryClassLoader(sharedLibrary);
                cl = null;
                try {
                    if (JAASLoginModuleConfigImpl.isIBMJDK() || !"com.ibm.security.auth.module.Krb5LoginModule".equalsIgnoreCase(target)) {
                        cl = Class.forName(target, false, loader);
                    }
                }
                catch (ClassNotFoundException e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Exception performing class for name.", (Object[])new Object[]{e});
                    }
                    if (!jaasConfigFile) break block5;
                    Tr.error((TraceComponent)tc, (String)"JAAS_CUSTOM_LOGIN_MODULE_CLASS_NOT_FOUND", (Object[])new Object[]{originalLoginModuleClassName, e});
                }
            }
            options.put(DELEGATE, cl);
        }
        return options;
    }

    private static String getTargetClassName(String className, Map<String, Object> options) {
        String target;
        if (WSLOGIN_MODULE_PROXY.equals(className)) {
            target = (String)options.get(DELEGATE);
            if (target == null || target.length() == 0) {
                Tr.error((TraceComponent)tc, (String)"JAAS_WSLOGIN_MODULE_PROXY_DELEGATE_NOT_SET", (Object[])new Object[0]);
            }
        } else {
            target = className;
        }
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={ClassNotFoundException.class})
    private Class<?> getTargetClassForName(String tg) {
        Class<?> cl = null;
        ClassLoader contextClassLoader = null;
        try {
            ClassLoader bundleClassLoader = JAASLoginModuleConfigImpl.class.getClassLoader();
            contextClassLoader = this.classLoadingService.createThreadContextClassLoader(bundleClassLoader);
            cl = Class.forName(tg, true, contextClassLoader);
        }
        catch (ClassNotFoundException e) {
            block4: {
                try {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                    Tr.debug((TraceComponent)tc, (String)"Exception performing class for name.", (Object[])new Object[]{e});
                }
                catch (Throwable throwable) {
                    this.classLoadingService.destroyThreadContextClassLoader(contextClassLoader);
                    throw throwable;
                }
            }
            this.classLoadingService.destroyThreadContextClassLoader(contextClassLoader);
        }
        this.classLoadingService.destroyThreadContextClassLoader(contextClassLoader);
        return cl;
    }

    private Map<String, Object> extractOptions(Map<String, Object> props) {
        List<Map<String, Object>> optionsList = Nester.nest("options", props);
        if (!optionsList.isEmpty()) {
            HashMap<String, Object> options = new HashMap<String, Object>(optionsList.get(0).size());
            for (Map.Entry<String, Object> option : optionsList.get(0).entrySet()) {
                String key = option.getKey();
                if (key.startsWith(".") || key.startsWith("config.") || key.startsWith("service.") || key.equals(CFG_KEY_ID)) continue;
                options.put(key, option.getValue());
            }
            return options;
        }
        return new HashMap<String, Object>(2);
    }

    @Override
    public String getId() {
        return this.moduleConfig.id();
    }

    @Override
    public String getClassName() {
        return "com.ibm.ws.kernel.boot.security.LoginModuleProxy";
    }

    static AppConfigurationEntry.LoginModuleControlFlag setControlFlag(String flag) {
        if ("REQUISITE".equalsIgnoreCase(flag)) {
            return AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
        }
        if ("SUFFICIENT".equalsIgnoreCase(flag)) {
            return AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
        }
        if ("OPTIONAL".equalsIgnoreCase(flag)) {
            return AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
        }
        return AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
    }

    @Override
    public AppConfigurationEntry.LoginModuleControlFlag getControlFlag() {
        return this.controlFlag;
    }

    @Override
    public Map<String, ?> getOptions() {
        return this.options;
    }

    @Reference
    protected void setSharedLib(Library svc) {
        this.sharedLibrary = svc;
    }

    @Override
    public boolean isDefaultLoginModule() {
        return defaultLoginModuleIds.contains(this.moduleConfig.id());
    }

    @Reference
    protected void setClassLoadingSvc(ClassLoadingService classLoadingService) {
        this.classLoadingService = classLoadingService;
    }

    private static boolean isIBMJDK() {
        String vendorName = (String)AccessController.doPrivileged(new PrivilegedAction(){
            static final long serialVersionUID = 3270245280819069737L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public Object run() {
                return System.getProperty("java.vendor");
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
        return vendorName != null && vendorName.toLowerCase().contains("ibm");
    }
}

