/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.modelling.impl;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.apache.aries.application.InvalidAttributeException;
import org.apache.aries.application.modelling.ExportedService;
import org.apache.aries.application.modelling.ImportedService;
import org.apache.aries.application.modelling.ModellingManager;
import org.apache.aries.application.modelling.ParsedServiceElements;
import org.apache.aries.application.modelling.ParserProxy;
import org.apache.aries.application.modelling.WrappedServiceMetadata;
import org.apache.aries.blueprint.ComponentDefinitionRegistry;
import org.apache.aries.util.manifest.ManifestHeaderProcessor;
import org.osgi.service.blueprint.reflect.BeanArgument;
import org.osgi.service.blueprint.reflect.BeanMetadata;
import org.osgi.service.blueprint.reflect.BeanProperty;
import org.osgi.service.blueprint.reflect.CollectionMetadata;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.MapEntry;
import org.osgi.service.blueprint.reflect.MapMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.osgi.service.blueprint.reflect.RefMetadata;
import org.osgi.service.blueprint.reflect.ReferenceListMetadata;
import org.osgi.service.blueprint.reflect.ReferenceListener;
import org.osgi.service.blueprint.reflect.RegistrationListener;
import org.osgi.service.blueprint.reflect.ServiceMetadata;
import org.osgi.service.blueprint.reflect.ServiceReferenceMetadata;
import org.osgi.service.blueprint.reflect.Target;
import org.osgi.service.blueprint.reflect.ValueMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractParserProxy
implements ParserProxy {
    private final Logger _logger = LoggerFactory.getLogger(AbstractParserProxy.class);
    private ModellingManager _modellingManager;

    protected abstract ComponentDefinitionRegistry parseCDR(List<URL> var1) throws Exception;

    protected abstract ComponentDefinitionRegistry parseCDR(InputStream var1) throws Exception;

    public void setModellingManager(ModellingManager m) {
        this._modellingManager = m;
    }

    public List<? extends WrappedServiceMetadata> parse(List<URL> blueprintsToParse) throws Exception {
        this._logger.debug("Method entry: {}, args {}", (Object)"parse", (Object)new Object[]{blueprintsToParse});
        ComponentDefinitionRegistry cdr = this.parseCDR(blueprintsToParse);
        List<ExportedService> result = this.parseCDRForServices(cdr, true);
        this._logger.debug("Method exit: {}, returning {}", (Object)"parse", (Object)new Object[]{result});
        return result;
    }

    public List<? extends WrappedServiceMetadata> parse(URL blueprintToParse) throws Exception {
        this._logger.debug("Method entry: {}, args {}", (Object)"parse", (Object)new Object[]{blueprintToParse});
        ArrayList<URL> list = new ArrayList<URL>();
        list.add(blueprintToParse);
        List<? extends WrappedServiceMetadata> result = this.parse(list);
        this._logger.debug("Method exit: {}, returning {}", (Object)"parse", (Object)new Object[]{result});
        return result;
    }

    public List<? extends WrappedServiceMetadata> parse(InputStream blueprintToParse) throws Exception {
        this._logger.debug("Method entry: {}, args {}", (Object)"parse", (Object)new Object[]{blueprintToParse});
        ComponentDefinitionRegistry cdr = this.parseCDR(blueprintToParse);
        List<ExportedService> result = this.parseCDRForServices(cdr, true);
        this._logger.debug("Method exit: {}, returning {}", (Object)"parse", (Object)new Object[]{result});
        return result;
    }

    public ParsedServiceElements parseAllServiceElements(InputStream blueprintToParse) throws Exception {
        this._logger.debug("Method entry: {}, args {}", (Object)"parseAllServiceElements", (Object)new Object[]{blueprintToParse});
        ComponentDefinitionRegistry cdr = this.parseCDR(blueprintToParse);
        List<ExportedService> services = this.parseCDRForServices(cdr, false);
        List<ImportedService> references = this.parseCDRForReferences(cdr);
        ParsedServiceElements result = this._modellingManager.getParsedServiceElements(services, references);
        this._logger.debug("Method exit: {}, returning {}", (Object)"parseAllServiceElements", (Object)new Object[]{result});
        return result;
    }

    private List<ExportedService> parseCDRForServices(ComponentDefinitionRegistry cdr, boolean suppressAnonymousServices) {
        this._logger.debug("Method entry: {}, args {}", (Object)"parseCDRForServices", (Object)new Object[]{cdr, suppressAnonymousServices});
        ArrayList<ExportedService> result = new ArrayList<ExportedService>();
        for (ComponentMetadata compMetadata : this.findAllComponents(cdr)) {
            if (!(compMetadata instanceof ServiceMetadata)) continue;
            ServiceMetadata serviceMetadata = (ServiceMetadata)compMetadata;
            ArrayList<String> interfaces = new ArrayList<String>();
            HashMap<String, Object> serviceProps = new HashMap<String, Object>();
            int ranking = serviceMetadata.getRanking();
            for (String i : serviceMetadata.getInterfaces()) {
                interfaces.add(i);
            }
            List props = serviceMetadata.getServiceProperties();
            for (MapEntry entry : props) {
                String key = ((ValueMetadata)entry.getKey()).getStringValue();
                Metadata value = entry.getValue();
                if (value instanceof CollectionMetadata) {
                    this.processMultiValueProperty(serviceProps, key, value);
                    continue;
                }
                serviceProps.put(key, ((ValueMetadata)entry.getValue()).getStringValue());
            }
            String serviceName = serviceMetadata.getId();
            Target t = serviceMetadata.getServiceComponent();
            String targetId = null;
            if (t instanceof RefMetadata) {
                targetId = ((RefMetadata)t).getComponentId();
            } else if (t instanceof BeanMetadata) {
                targetId = ((BeanMetadata)t).getId();
            }
            if (targetId != null && !targetId.startsWith(".")) {
                serviceProps.put("osgi.service.blueprint.compname", targetId);
                if (serviceName == null || serviceName.equals("") || serviceName.startsWith(".")) {
                    serviceName = targetId;
                }
            }
            if (serviceName != null && serviceName.startsWith(".")) {
                serviceName = null;
            }
            if (suppressAnonymousServices && serviceName == null) continue;
            ExportedService wsm = this._modellingManager.getExportedService(serviceName, ranking, interfaces, serviceProps);
            result.add(wsm);
        }
        this._logger.debug("Method exit: {}, returning {}", (Object)"parseAllServiceElements", (Object)new Object[]{result});
        return result;
    }

    private void processMultiValueProperty(Map<String, Object> serviceProps, String key, Metadata value) {
        String[] collectionValue;
        List values = ((CollectionMetadata)value).getValues();
        Class collectionClass = ((CollectionMetadata)value).getCollectionClass();
        if (Collection.class.isAssignableFrom(collectionClass)) {
            String[] theseValues = this.getCollectionFromClass(collectionClass);
            for (Metadata m : values) {
                theseValues.add(((ValueMetadata)m).getStringValue());
            }
            collectionValue = theseValues;
        } else {
            String[] theseValues = new String[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                Metadata m = (Metadata)values.get(i);
                theseValues[i] = ((ValueMetadata)m).getStringValue();
            }
            collectionValue = theseValues;
        }
        serviceProps.put(key, collectionValue);
    }

    private Collection<String> getCollectionFromClass(Class<?> collectionClass) {
        if (List.class.isAssignableFrom(collectionClass)) {
            return new ArrayList<String>();
        }
        if (Set.class.isAssignableFrom(collectionClass)) {
            return new LinkedHashSet<String>();
        }
        if (Queue.class.isAssignableFrom(collectionClass)) {
            return new LinkedList<String>();
        }
        throw new IllegalArgumentException(collectionClass.getName());
    }

    private List<ImportedService> parseCDRForReferences(ComponentDefinitionRegistry cdr) throws InvalidAttributeException {
        this._logger.debug("Method entry: {}, args {}", (Object)"parseCDRForReferences", (Object)new Object[]{cdr});
        ArrayList<ImportedService> result = new ArrayList<ImportedService>();
        for (ComponentMetadata compMetadata : this.findAllComponents(cdr)) {
            if (!(compMetadata instanceof ServiceReferenceMetadata)) continue;
            ServiceReferenceMetadata referenceMetadata = (ServiceReferenceMetadata)compMetadata;
            boolean optional = referenceMetadata.getAvailability() == 2;
            String iface = referenceMetadata.getInterface();
            String compName = referenceMetadata.getComponentName();
            String blueprintFilter = referenceMetadata.getFilter();
            String id = referenceMetadata.getId();
            boolean isMultiple = referenceMetadata instanceof ReferenceListMetadata;
            if (this.isBlacklisted(iface, blueprintFilter)) continue;
            ImportedService ref = this._modellingManager.getImportedService(optional, iface, compName, blueprintFilter, id, isMultiple);
            result.add(ref);
        }
        this._logger.debug("Method exit: {}, returning {}", (Object)"parseCDRForReferences", (Object)new Object[]{result});
        return result;
    }

    private Set<ComponentMetadata> findAllComponents(ComponentDefinitionRegistry cdr) {
        HashSet<ComponentMetadata> components = new HashSet<ComponentMetadata>();
        for (String name : cdr.getComponentDefinitionNames()) {
            ComponentMetadata component = cdr.getComponentDefinition(name);
            this.traverseComponent(component, components);
        }
        return components;
    }

    private void traverse(Metadata metadata, Set<ComponentMetadata> output) {
        block3: {
            block4: {
                block2: {
                    if (!(metadata instanceof ComponentMetadata)) break block2;
                    this.traverseComponent((ComponentMetadata)metadata, output);
                    break block3;
                }
                if (!(metadata instanceof CollectionMetadata)) break block4;
                CollectionMetadata collection = (CollectionMetadata)metadata;
                for (Metadata v : collection.getValues()) {
                    this.traverse(v, output);
                }
                break block3;
            }
            if (!(metadata instanceof MapMetadata)) break block3;
            MapMetadata map = (MapMetadata)metadata;
            for (MapEntry e : map.getEntries()) {
                this.traverse((Metadata)e.getKey(), output);
                this.traverse(e.getValue(), output);
            }
        }
    }

    private void traverseComponent(ComponentMetadata component, Set<ComponentMetadata> output) {
        block7: {
            block8: {
                block6: {
                    if (!output.add(component)) {
                        return;
                    }
                    if (!(component instanceof BeanMetadata)) break block6;
                    BeanMetadata bean = (BeanMetadata)component;
                    this.traverse((Metadata)bean.getFactoryComponent(), output);
                    for (BeanArgument argument : bean.getArguments()) {
                        this.traverse(argument.getValue(), output);
                    }
                    for (BeanProperty property : bean.getProperties()) {
                        this.traverse(property.getValue(), output);
                    }
                    break block7;
                }
                if (!(component instanceof ServiceMetadata)) break block8;
                ServiceMetadata service = (ServiceMetadata)component;
                this.traverse((Metadata)service.getServiceComponent(), output);
                for (RegistrationListener listener : service.getRegistrationListeners()) {
                    this.traverse((Metadata)listener.getListenerComponent(), output);
                }
                for (MapEntry e : service.getServiceProperties()) {
                    this.traverse((Metadata)e.getKey(), output);
                    this.traverse(e.getValue(), output);
                }
                break block7;
            }
            if (!(component instanceof ServiceReferenceMetadata)) break block7;
            ServiceReferenceMetadata reference = (ServiceReferenceMetadata)component;
            for (ReferenceListener listener : reference.getReferenceListeners()) {
                this.traverse((Metadata)listener.getListenerComponent(), output);
            }
        }
    }

    protected boolean isBlacklisted(String iface, String blueprintFilter) {
        this._logger.debug("Method entry: {}, args {}", (Object)"isBlacklisted", (Object)new Object[]{iface, blueprintFilter});
        boolean blacklisted = false;
        if (iface != null) {
            blacklisted |= iface.equals("javax.persistence.EntityManagerFactory");
            blacklisted |= iface.equals("javax.persistence.EntityManager");
            blacklisted |= iface.equals("javax.transaction.UserTransaction");
            blacklisted |= iface.equals("javax.transaction.TransactionSynchronizationRegistry");
            blacklisted |= iface.equals("org.osgi.service.cm.ConfigurationAdmin");
            if (blueprintFilter != null && blueprintFilter.trim().length() != 0) {
                Map filter = ManifestHeaderProcessor.parseFilter((String)blueprintFilter);
                blacklisted |= filter.containsKey("osgi.jndi.service.name");
            }
        }
        this._logger.debug("Method exit: {}, returning {}", (Object)"isBlacklisted", (Object)new Object[]{!blacklisted});
        return blacklisted;
    }
}

