/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bluemix.utility.cloudfoundry;

import com.ibm.ws.bluemix.utility.api.BluemixZones;
import com.ibm.ws.bluemix.utility.cloudfoundry.CloudFoundryException;
import com.ibm.ws.bluemix.utility.cloudfoundry.CloudFoundryLoginException;
import com.ibm.ws.bluemix.utility.cloudfoundry.CloudFoundryService;
import com.ibm.ws.bluemix.utility.cloudfoundry.CloudFoundryServiceInstance;
import com.ibm.ws.bluemix.utility.cloudfoundry.CloudFoundryServiceKey;
import com.ibm.ws.bluemix.utility.cloudfoundry.CloudFoundryServicePlan;
import com.ibm.ws.bluemix.utility.cloudfoundry.OauthToken;
import com.ibm.ws.bluemix.utility.cloudfoundry.ObjectMapping;
import com.ibm.ws.bluemix.utility.credentials.BluemixProperties;
import com.ibm.ws.bluemix.utility.credentials.TargetInfo;
import com.ibm.ws.bluemix.utility.utils.HttpRequest;
import com.ibm.ws.bluemix.utility.utils.HttpRequestBuilder;
import com.ibm.ws.bluemix.utility.utils.JsonUtils;
import com.ibm.ws.bluemix.utility.utils.NLS;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;

public class CloudFoundryClient {
    private static final Logger logger = Logger.getLogger(CloudFoundryClient.class.getName());
    private static final long JOB_WAIT_TIME = TimeUnit.MINUTES.toNanos(3L);
    private static final long JOB_SLEEP_TIME = TimeUnit.SECONDS.toMillis(3L);
    private final TargetInfo properties;

    public CloudFoundryClient(TargetInfo properties) {
        this.properties = properties;
    }

    private static String getUrl(String api, String path) {
        if (api.endsWith("/")) {
            return api + path.substring(1);
        }
        return api + path;
    }

    private static Map<String, Object> parseErrorDetails(HttpRequest request) {
        if (request.isJsonContentType()) {
            try {
                String json = request.getErrorResponseBody();
                if (json != null) {
                    JsonObject jsonObject = JsonUtils.deserialize(json);
                    return JsonUtils.jsonObjectToMap(jsonObject);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static Number getErrorCode(Map<String, Object> errorDetails) {
        Object code = errorDetails.get("code");
        if (code instanceof Long) {
            return (Long)code;
        }
        if (code instanceof Integer) {
            return (Integer)code;
        }
        return null;
    }

    private static CloudFoundryException handleError(HttpRequest request) throws IOException {
        Map<String, Object> errorDetails = CloudFoundryClient.parseErrorDetails(request);
        String errorDescription = null;
        if (errorDetails != null) {
            errorDescription = (String)errorDetails.get("description");
        }
        String message = errorDescription == null ? request.getResponseMessage() : errorDescription;
        CloudFoundryException exception = new CloudFoundryException(NLS.getMessage("CF_UNEXPECTED_ERROR", message));
        exception.setHttpStatus(request.getHttpStatus());
        return exception;
    }

    private static String lookupApiEndpoint(String api) {
        Map<String, String> map = BluemixZones.getPublicBluemixZones();
        String value = map.get(api.toLowerCase());
        if (value == null) {
            return "https://" + api;
        }
        return value;
    }

    public static URL getApiEndpoint(String api) {
        URL url = null;
        try {
            if (!api.contains("://")) {
                api = CloudFoundryClient.lookupApiEndpoint(api);
            }
            url = new URL(api);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(NLS.getMessage("API_URL_MALFORMED_URL", api, e.getMessage()));
        }
        if ("https".equals(url.getProtocol()) || "http".equals(url.getProtocol())) {
            return url;
        }
        throw new IllegalArgumentException(NLS.getMessage("API_URL_INVALID_PROTOCOL", api));
    }

    public static Map<String, Object> getInfo(String api) throws CloudFoundryException {
        URL url = CloudFoundryClient.toURL(CloudFoundryClient.getUrl(api, "/v2/info"));
        HttpRequestBuilder requestBuilder = new HttpRequestBuilder();
        requestBuilder.setURL(url);
        requestBuilder.setRequestMethod("GET");
        String json = null;
        try {
            HttpRequest request = requestBuilder.build();
            int responseCode = request.getResponseCode();
            if (responseCode != 200) {
                throw CloudFoundryClient.handleError(request);
            }
            json = request.getResponseBody();
        }
        catch (IOException e) {
            throw CloudFoundryClient.handleIOException(e);
        }
        JsonObject object = JsonUtils.deserialize(json);
        return JsonUtils.jsonObjectToMap(object);
    }

    public String getUserName() {
        JsonObject jsonObject = this.getJsonObjectFromAuthToken();
        String username = jsonObject.getString("user_name");
        return username;
    }

    public String getSpaceGuid() throws CloudFoundryLoginException {
        String guid = this.properties.getSpaceGuid();
        if (guid == null) {
            throw new CloudFoundryLoginException(NLS.getMessage("SPACE_NOT_SET", new Object[0]));
        }
        return guid;
    }

    public String getOrganizationGuid() throws CloudFoundryLoginException {
        String guid = this.properties.getOrganizationGuid();
        if (guid == null) {
            throw new CloudFoundryLoginException(NLS.getMessage("ORG_NOT_SET", new Object[0]));
        }
        return guid;
    }

    private JsonObject getJsonObjectFromAuthToken() {
        String auth = new String(this.properties.getAccessToken().getChars());
        int begin = auth.indexOf(46) + 1;
        int end = auth.indexOf(46, begin);
        String encodedString = auth.substring(begin, end);
        String json = StringUtils.newString((byte[])Base64.decodeBase64((String)encodedString), (String)"UTF-8");
        JsonObject obj = JsonUtils.deserialize(json);
        return obj;
    }

    private URL getUrl(String path) throws CloudFoundryException {
        return CloudFoundryClient.toURL(CloudFoundryClient.getUrl(this.properties.getAPI(), path));
    }

    private static CloudFoundryException handleLoginError(HttpRequest request) throws IOException {
        CloudFoundryException exception;
        if (request.getResponseCode() == 401) {
            exception = new CloudFoundryLoginException(NLS.getMessage("AUTH_ERROR", new Object[0]));
        } else {
            Map<String, Object> errorDetails = CloudFoundryClient.parseErrorDetails(request);
            String errorDescription = null;
            if (errorDetails != null) {
                errorDescription = (String)errorDetails.get("error_description");
            }
            String message = errorDescription == null ? request.getResponseMessage() : errorDescription;
            exception = new CloudFoundryException(NLS.getMessage("CF_UNEXPECTED_ERROR", message));
        }
        exception.setHttpStatus(request.getHttpStatus());
        return exception;
    }

    private static OauthToken getOAuthToken(String authorizationEndpoint, String messageBody) throws CloudFoundryException {
        authorizationEndpoint = authorizationEndpoint + "/oauth/token";
        URL url = CloudFoundryClient.toURL(authorizationEndpoint);
        HttpRequestBuilder builder = new HttpRequestBuilder();
        builder.setURL(url);
        builder.setRequestMethod("POST");
        builder.setHeader("Accept", "application/json");
        builder.setHeader("Content-Type", "application/x-www-form-urlencoded");
        builder.setHeader("Authorization", "Basic Y2Y6");
        builder.setMessageBody(messageBody);
        String json = null;
        try {
            HttpRequest request = builder.build();
            int responseCode = request.getResponseCode();
            if (responseCode != 200) {
                throw CloudFoundryClient.handleLoginError(request);
            }
            json = request.getResponseBody();
        }
        catch (IOException e) {
            throw CloudFoundryClient.handleIOException(e);
        }
        JsonObject object = JsonUtils.deserialize(json);
        return ObjectMapping.toOauthToken(object);
    }

    public static OauthToken login(String authorizationEndpoint, String user, String password) throws CloudFoundryException {
        logger.log(Level.FINE, "Logging in using {0} as {1}.", new Object[]{authorizationEndpoint, user});
        String messageBody = "grant_type=password&username=" + user + "&password=" + password;
        OauthToken token = CloudFoundryClient.getOAuthToken(authorizationEndpoint, messageBody);
        logger.log(Level.FINE, "Login successful.");
        return token;
    }

    public static OauthToken login(String authorizationEndpoint, String passcode) throws CloudFoundryException {
        logger.log(Level.FINE, "Logging in using {0} with one-time passcode.", new Object[]{authorizationEndpoint});
        String messageBody = "grant_type=password&passcode=" + passcode;
        OauthToken token = CloudFoundryClient.getOAuthToken(authorizationEndpoint, messageBody);
        logger.log(Level.FINE, "Login successful.");
        return token;
    }

    private OauthToken refreshToken() throws CloudFoundryException {
        String authorizationEndpoint = this.properties.getAuthorizationEndpoint();
        if (authorizationEndpoint == null) {
            return null;
        }
        logger.log(Level.FINE, "Refreshing oauth token using {0}.", new Object[]{authorizationEndpoint});
        String refreshToken = new String(this.properties.getRefreshToken().getChars());
        String messageBody = "grant_type=refresh_token&refresh_token=" + refreshToken;
        OauthToken token = CloudFoundryClient.getOAuthToken(authorizationEndpoint, messageBody);
        logger.log(Level.FINE, "Refresh successful.");
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpRequest doRequest(HttpRequestBuilder builder) throws IOException, CloudFoundryException {
        HttpRequest request = builder.build();
        int response = request.getResponseCode();
        if (response == 401) {
            TargetInfo copy;
            OauthToken token = this.refreshToken();
            if (token == null) {
                throw CloudFoundryClient.handleError(request);
            }
            TargetInfo targetInfo = this.properties;
            synchronized (targetInfo) {
                this.properties.setAccessToken(token.getAuthorizationHeader());
                this.properties.setRefreshToken(token.getRefreshToken());
                copy = new TargetInfo(this.properties);
            }
            BluemixProperties.save(copy);
            builder.setHeader("Authorization", new String(this.properties.getAccessToken().getChars()));
            request = builder.build();
        }
        return request;
    }

    public void checkToken() throws CloudFoundryException {
        String spaceGuid = this.getSpaceGuid();
        URL url = this.getUrl("/v2/spaces/" + spaceGuid);
        HttpRequestBuilder requestBuilder = this.createGetRequestBuilder(url);
        this.performRequest(requestBuilder);
    }

    public List<String> getOrganizations() throws CloudFoundryException {
        ArrayList<String> orgs = new ArrayList<String>();
        URL url = this.getUrl("/v2/organizations");
        while (url != null) {
            HttpRequestBuilder requestBuilder = this.createGetRequestBuilder(url);
            String json = this.performRequest(requestBuilder);
            JsonObject jsonObject = JsonUtils.deserialize(json);
            JsonArray resources = JsonUtils.getJsonArray(jsonObject, "resources");
            if (resources != null) {
                for (int i = 0; i < resources.size(); ++i) {
                    JsonObject resource = resources.getJsonObject(i);
                    JsonObject entity = JsonUtils.getJsonObject(resource, "entity");
                    String orgName = JsonUtils.getString(entity, "name");
                    if (orgName == null) continue;
                    orgs.add(orgName);
                }
            }
            url = jsonObject.isNull("next_url") ? null : this.getUrl(jsonObject.getString("next_url"));
        }
        return orgs;
    }

    public String getOrganization(String orgName) throws CloudFoundryException {
        URL url = this.getUrl("/v2/organizations?q=name:" + CloudFoundryClient.encode(orgName));
        HttpRequestBuilder requestBuilder = this.createGetRequestBuilder(url);
        String json = this.performRequest(requestBuilder);
        JsonObject object = JsonUtils.deserialize(json);
        JsonArray resources = object.getJsonArray("resources");
        if (resources == null || resources.isEmpty()) {
            return null;
        }
        JsonObject resource = resources.getJsonObject(0);
        JsonObject metadata = resource.getJsonObject("metadata");
        String guid = metadata.getString("guid");
        return guid;
    }

    public void setOrganization(String orgName) throws CloudFoundryException {
        String orgGuid = this.getOrganization(orgName);
        if (orgGuid == null) {
            throw new IllegalArgumentException(NLS.getMessage("NO_SUCH_ORG", orgName));
        }
        this.properties.setOrganizationName(orgName);
        this.properties.setOrganizationGuid(orgGuid);
    }

    public List<String> getSpaces() throws CloudFoundryException {
        return this.getSpaces(this.getOrganizationGuid());
    }

    public List<String> getSpaces(String orgGuid) throws CloudFoundryException {
        ArrayList<String> spaces = new ArrayList<String>();
        URL url = this.getUrl("/v2/organizations/" + orgGuid + "/spaces");
        while (url != null) {
            HttpRequestBuilder requestBuilder = this.createGetRequestBuilder(url);
            String json = this.performRequest(requestBuilder);
            JsonObject jsonObject = JsonUtils.deserialize(json);
            JsonArray resources = JsonUtils.getJsonArray(jsonObject, "resources");
            if (resources != null) {
                for (int i = 0; i < resources.size(); ++i) {
                    JsonObject resource = resources.getJsonObject(i);
                    JsonObject entity = JsonUtils.getJsonObject(resource, "entity");
                    String spaceName = JsonUtils.getString(entity, "name");
                    if (spaceName == null) continue;
                    spaces.add(spaceName);
                }
            }
            url = jsonObject.isNull("next_url") ? null : this.getUrl(jsonObject.getString("next_url"));
        }
        return spaces;
    }

    public String getSpace(String orgGuid, String spaceName) throws CloudFoundryException {
        URL url = this.getUrl("/v2/organizations/" + orgGuid + "/spaces?q=name:" + CloudFoundryClient.encode(spaceName));
        HttpRequestBuilder requestBuilder = this.createGetRequestBuilder(url);
        String json = this.performRequest(requestBuilder);
        JsonObject jsonObject = JsonUtils.deserialize(json);
        JsonArray resources = jsonObject.getJsonArray("resources");
        if (resources == null || resources.isEmpty()) {
            return null;
        }
        JsonObject resource = resources.getJsonObject(0);
        JsonObject metadata = resource.getJsonObject("metadata");
        String guid = metadata.getString("guid");
        return guid;
    }

    public void setSpace(String spaceName) throws CloudFoundryException {
        String orgGuid = this.getOrganizationGuid();
        String spaceGuid = this.getSpace(orgGuid, spaceName);
        if (spaceGuid == null) {
            throw new IllegalArgumentException(NLS.getMessage("NO_SUCH_SPACE", spaceName, this.properties.getOrganizationName()));
        }
        this.properties.setSpaceName(spaceName);
        this.properties.setSpaceGuid(spaceGuid);
    }

    public boolean deleteServiceInstance(String guid) throws CloudFoundryException {
        URL url = this.getUrl("/v2/service_instances/" + guid + "?async=true");
        HttpRequestBuilder requestBuilder = this.createDeleteRequestBuilder(url);
        try {
            HttpRequest request = this.doRequest(requestBuilder);
            int responseCode = request.getResponseCode();
            if (responseCode == 204) {
                return true;
            }
            if (responseCode == 202) {
                String json = request.getResponseBody();
                JsonObject jsonObject = JsonUtils.deserialize(json);
                JsonObject metadata = jsonObject.getJsonObject("metadata");
                String jobUrl = metadata.getString("url");
                return this.waitForJobToFinish(jobUrl);
            }
            throw CloudFoundryClient.handleError(request);
        }
        catch (IOException e) {
            throw CloudFoundryClient.handleIOException(e);
        }
    }

    private CloudFoundryServicePlan findServicePlan(CloudFoundryService serviceOffering, String planName) {
        for (CloudFoundryServicePlan servicePlan : serviceOffering.getServicePlans()) {
            if (!planName.equals(servicePlan.getName())) continue;
            return servicePlan;
        }
        return null;
    }

    public CloudFoundryServiceInstance createServiceInstance(String serviceType, String planName, String serviceName) throws CloudFoundryException {
        List<CloudFoundryService> serviceOfferings = this.getServiceOfferings(Collections.singleton(serviceType));
        if (serviceOfferings.isEmpty()) {
            throw new IllegalArgumentException(NLS.getMessage("NO_SUCH_SERVICE_OFFERING", serviceType));
        }
        CloudFoundryService serviceOffering = serviceOfferings.get(0);
        CloudFoundryServicePlan servicePlan = this.findServicePlan(serviceOffering, planName);
        if (servicePlan == null) {
            throw new IllegalArgumentException(NLS.getMessage("NO_SUCH_SERVICE_PLAN", planName));
        }
        JsonObjectBuilder jsonBuilder = Json.createObjectBuilder();
        jsonBuilder.add("space_guid", this.getSpaceGuid());
        jsonBuilder.add("name", serviceName);
        jsonBuilder.add("service_plan_guid", servicePlan.getGuid());
        String jsonPayload = JsonUtils.serialize((JsonStructure)jsonBuilder.build());
        URL url = this.getUrl("/v2/service_instances?accepts_incomplete=true");
        HttpRequestBuilder requestBuilder = this.createPostRequestBuilder(url, jsonPayload);
        try {
            HttpRequest request = this.doRequest(requestBuilder);
            int responseCode = request.getResponseCode();
            if (responseCode == 202 || responseCode == 201) {
                String json = request.getResponseBody();
                JsonObject jsonObject = JsonUtils.deserialize(json);
                CloudFoundryServiceInstance instance = ObjectMapping.toCloudFoundryServiceInstance(jsonObject);
                if (instance.getService() == null) {
                    instance.setService(serviceOffering);
                }
                if (instance.getPlan() == null) {
                    instance.setPlan(servicePlan);
                }
                return instance;
            }
            if (responseCode == 400) {
                Number errorCode;
                Map<String, Object> errorDetails = CloudFoundryClient.parseErrorDetails(request);
                if (errorDetails != null && (errorCode = CloudFoundryClient.getErrorCode(errorDetails)) != null && errorCode.intValue() == 60002) {
                    throw new IllegalArgumentException(NLS.getMessage("SERVER_NAME_EXISTS", serviceName));
                }
                throw CloudFoundryClient.handleError(request);
            }
            throw CloudFoundryClient.handleError(request);
        }
        catch (IOException e) {
            throw CloudFoundryClient.handleIOException(e);
        }
    }

    public List<CloudFoundryServiceInstance> getServiceInstances(Set<String> serviceNames) throws CloudFoundryException {
        List<CloudFoundryServiceInstance> serviceInstances = this.getServiceInstances();
        if (serviceNames == null) {
            return serviceInstances;
        }
        ArrayList<CloudFoundryServiceInstance> filteredServices = new ArrayList<CloudFoundryServiceInstance>();
        for (CloudFoundryServiceInstance service : serviceInstances) {
            String label = service.getService().getLabel();
            if (!serviceNames.contains(label)) continue;
            filteredServices.add(service);
        }
        return filteredServices;
    }

    private List<CloudFoundryServiceInstance> getServiceInstances() throws CloudFoundryException {
        String spaceGuid = this.getSpaceGuid();
        URL url = this.getUrl("/v2/spaces/" + spaceGuid + "/summary");
        HttpRequestBuilder requestBuilder = this.createGetRequestBuilder(url);
        String json = this.performRequest(requestBuilder);
        JsonObject jsonObject = JsonUtils.deserialize(json);
        ArrayList<CloudFoundryServiceInstance> serviceInstances = new ArrayList<CloudFoundryServiceInstance>();
        JsonArray services = jsonObject.getJsonArray("services");
        for (int i = 0; i < services.size(); ++i) {
            JsonObject serviceEntry = services.getJsonObject(i);
            JsonObject servicePlan = serviceEntry.getJsonObject("service_plan");
            if (servicePlan == null) continue;
            String instanceName = serviceEntry.getString("name");
            String instanceGuid = serviceEntry.getString("guid");
            CloudFoundryServiceInstance instance = new CloudFoundryServiceInstance();
            instance.setGuid(instanceGuid);
            instance.setName(instanceName);
            String planName = servicePlan.getString("name");
            String planGuid = servicePlan.getString("guid");
            CloudFoundryServicePlan plan = new CloudFoundryServicePlan();
            plan.setGuid(planGuid);
            plan.setName(planName);
            instance.setPlan(plan);
            JsonObject serviceResource = servicePlan.getJsonObject("service");
            String serviceLabel = serviceResource.getString("label");
            String serviceGuid = serviceResource.getString("guid");
            CloudFoundryService service = new CloudFoundryService();
            service.setGuid(serviceGuid);
            service.setLabel(serviceLabel);
            instance.setService(service);
            serviceInstances.add(instance);
        }
        return serviceInstances;
    }

    public CloudFoundryServiceInstance getServiceInstance(String serviceName) throws CloudFoundryException {
        String spaceGuid = this.getSpaceGuid();
        URL url = this.getUrl("/v2/spaces/" + spaceGuid + "/service_instances?inline-relations-depth=1&q=name:" + CloudFoundryClient.encode(serviceName));
        HttpRequestBuilder requestBuilder = this.createGetRequestBuilder(url);
        String json = this.performRequest(requestBuilder);
        JsonObject jsonObject = JsonUtils.deserialize(json);
        JsonArray resources = jsonObject.getJsonArray("resources");
        if (resources == null || resources.isEmpty()) {
            throw new IllegalArgumentException(NLS.getMessage("NO_SUCH_SERVICE", serviceName));
        }
        JsonObject resource = resources.getJsonObject(0);
        CloudFoundryServiceInstance instance = ObjectMapping.toCloudFoundryServiceInstance(resource);
        CloudFoundryServicePlan servicePlan = instance.getPlan();
        if (servicePlan != null) {
            CloudFoundryService service = this.getServiceOffering(servicePlan.getServiceGuid(), false);
            instance.setService(service);
        }
        return instance;
    }

    public List<CloudFoundryService> getServiceOfferings(Set<String> serviceNames) throws CloudFoundryException {
        String spaceGuid = this.getSpaceGuid();
        URL url = this.getUrl("/v2/spaces/" + spaceGuid + "/services?inline-relations-depth=1" + CloudFoundryClient.constructFilterQuery(serviceNames));
        ArrayList<CloudFoundryService> offerings = new ArrayList<CloudFoundryService>();
        while (url != null) {
            HttpRequestBuilder requestBuilder = this.createGetRequestBuilder(url);
            String json = this.performRequest(requestBuilder);
            JsonObject jsonObject = JsonUtils.deserialize(json);
            JsonArray resources = jsonObject.getJsonArray("resources");
            for (int i = 0; i < resources.size(); ++i) {
                JsonObject resource = resources.getJsonObject(i);
                CloudFoundryService service = ObjectMapping.toCloudFoundryService(resource);
                offerings.add(service);
            }
            url = jsonObject.isNull("next_url") ? null : this.getUrl(jsonObject.getString("next_url"));
        }
        return offerings;
    }

    public CloudFoundryServiceKey createServiceKey(String serviceInstanceGuid, String credentialName) throws CloudFoundryException {
        URL url = this.getUrl("/v2/service_keys");
        JsonObjectBuilder jsonBuilder = Json.createObjectBuilder();
        jsonBuilder.add("service_instance_guid", serviceInstanceGuid);
        jsonBuilder.add("name", credentialName);
        String jsonPayload = JsonUtils.serialize((JsonStructure)jsonBuilder.build());
        HttpRequestBuilder requestBuilder = this.createPostRequestBuilder(url, jsonPayload);
        try {
            HttpRequest request = this.doRequest(requestBuilder);
            int responseCode = request.getResponseCode();
            if (responseCode == 201) {
                String json = request.getResponseBody();
                JsonObject jsonObject = JsonUtils.deserialize(json);
                CloudFoundryServiceKey key = ObjectMapping.toCloudFoundryServiceKey(jsonObject);
                return key;
            }
            throw CloudFoundryClient.handleError(request);
        }
        catch (IOException e) {
            throw CloudFoundryClient.handleIOException(e);
        }
    }

    public void deleteServiceKey(String guid) throws CloudFoundryException {
        URL url = this.getUrl("/v2/service_keys/" + guid);
        HttpRequestBuilder requestBuilder = this.createDeleteRequestBuilder(url);
        try {
            HttpRequest request = this.doRequest(requestBuilder);
            int responseCode = request.getResponseCode();
            if (responseCode != 204) {
                throw CloudFoundryClient.handleError(request);
            }
        }
        catch (IOException e) {
            throw CloudFoundryClient.handleIOException(e);
        }
    }

    private CloudFoundryService getServiceOffering(String guid, boolean withPlans) throws CloudFoundryException {
        URL url = null;
        url = withPlans ? this.getUrl("/v2/services/" + guid + "?inline-relations-depth=1") : this.getUrl("/v2/services/" + guid);
        HttpRequestBuilder requestBuilder = this.createGetRequestBuilder(url);
        String json = this.performRequest(requestBuilder);
        JsonObject jsonObject = JsonUtils.deserialize(json);
        CloudFoundryService service = ObjectMapping.toCloudFoundryService(jsonObject);
        return service;
    }

    private static String constructFilterQuery(Set<String> services) throws CloudFoundryException {
        if (services == null || services.size() == 0) {
            return "";
        }
        if (services.size() == 1) {
            String serviceName = services.iterator().next();
            return "&q=label:" + CloudFoundryClient.encode(serviceName);
        }
        StringBuffer filter = new StringBuffer(" IN ");
        Iterator<String> iterator = services.iterator();
        while (iterator.hasNext()) {
            filter.append(iterator.next());
            if (!iterator.hasNext()) continue;
            filter.append(',');
        }
        return "&q=label" + CloudFoundryClient.encode(filter.toString());
    }

    private boolean waitForJobToFinish(String urlSuffix) throws CloudFoundryException {
        URL url = this.getUrl(urlSuffix);
        long currTime = System.nanoTime();
        long jobTimeout = currTime + JOB_WAIT_TIME;
        while (currTime < jobTimeout) {
            HttpRequestBuilder requestBuilder = this.createGetRequestBuilder(url);
            String json = this.performRequest(requestBuilder);
            JsonObject jsonObject = JsonUtils.deserialize(json);
            JsonObject entity = jsonObject.getJsonObject("entity");
            String status = entity.getString("status");
            if (status.equals("finished")) {
                return true;
            }
            if (status.equals("failed")) {
                return false;
            }
            try {
                Thread.sleep(JOB_SLEEP_TIME);
            }
            catch (InterruptedException e) {
                return false;
            }
            currTime = System.nanoTime();
        }
        return false;
    }

    private String performRequest(HttpRequestBuilder requestBuilder) throws CloudFoundryException {
        try {
            HttpRequest request = this.doRequest(requestBuilder);
            int response = request.getResponseCode();
            if (response != 200) {
                throw CloudFoundryClient.handleError(request);
            }
            return request.getResponseBody();
        }
        catch (IOException e) {
            throw CloudFoundryClient.handleIOException(e);
        }
    }

    private HttpRequestBuilder createPostRequestBuilder(URL url, String messageBody) {
        HttpRequestBuilder requestBuilder = new HttpRequestBuilder();
        requestBuilder.setURL(url);
        requestBuilder.setRequestMethod("POST");
        requestBuilder.setHeader("Content-Type", "application/x-www-form-urlencoded");
        requestBuilder.setHeader("Accept", "application/json");
        requestBuilder.setHeader("Authorization", new String(this.properties.getAccessToken().getChars()));
        requestBuilder.setMessageBody(messageBody);
        return requestBuilder;
    }

    private HttpRequestBuilder createGetRequestBuilder(URL url) {
        HttpRequestBuilder requestBuilder = new HttpRequestBuilder();
        requestBuilder.setURL(url);
        requestBuilder.setRequestMethod("GET");
        requestBuilder.setHeader("Authorization", new String(this.properties.getAccessToken().getChars()));
        requestBuilder.setHeader("Cookie", "");
        return requestBuilder;
    }

    private HttpRequestBuilder createDeleteRequestBuilder(URL url) {
        HttpRequestBuilder requestBuilder = new HttpRequestBuilder();
        requestBuilder.setURL(url);
        requestBuilder.setRequestMethod("DELETE");
        requestBuilder.setHeader("Authorization", new String(this.properties.getAccessToken().getChars()));
        requestBuilder.setHeader("Cookie", "");
        requestBuilder.setHeader("Content-Type", "application/x-www-form-urlencoded");
        return requestBuilder;
    }

    private static String encode(String value) throws CloudFoundryException {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new CloudFoundryException(NLS.getMessage("CF_UNEXPECTED_ERROR", e.getMessage()), e);
        }
    }

    private static URL toURL(String url) throws CloudFoundryException {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new CloudFoundryException(NLS.getMessage("CF_UNEXPECTED_ERROR", e.getMessage()), e);
        }
    }

    private static CloudFoundryException handleIOException(Exception e) {
        if (e instanceof UnknownHostException) {
            return new CloudFoundryException(NLS.getMessage("CF_UNKNOWN_HOST_ERROR", e.getMessage()), e);
        }
        if (e instanceof ConnectException) {
            return new CloudFoundryException(NLS.getMessage("CF_CONNECT_ERROR", e.getMessage()), e);
        }
        if (e instanceof SocketTimeoutException) {
            return new CloudFoundryException(NLS.getMessage("CF_TIMEOUT_ERROR", e.getMessage()), e);
        }
        if (e instanceof NoRouteToHostException) {
            return new CloudFoundryException(NLS.getMessage("CF_NO_ROUTE_ERROR", e.getMessage()), e);
        }
        return new CloudFoundryException(NLS.getMessage("CF_UNEXPECTED_ERROR", e.getMessage()), e);
    }
}

