/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bluemix.utility.api;

import com.ibm.ws.bluemix.utility.cloudfoundry.CloudFoundryClient;
import com.ibm.ws.bluemix.utility.cloudfoundry.CloudFoundryException;
import com.ibm.ws.bluemix.utility.cloudfoundry.CloudFoundryLoginException;
import com.ibm.ws.bluemix.utility.cloudfoundry.CloudFoundryService;
import com.ibm.ws.bluemix.utility.cloudfoundry.CloudFoundryServiceInstance;
import com.ibm.ws.bluemix.utility.cloudfoundry.CloudFoundryServiceKey;
import com.ibm.ws.bluemix.utility.cloudfoundry.CloudFoundryServicePlan;
import com.ibm.ws.bluemix.utility.cloudfoundry.OauthToken;
import com.ibm.ws.bluemix.utility.credentials.BluemixProperties;
import com.ibm.ws.bluemix.utility.credentials.ConfigJson;
import com.ibm.ws.bluemix.utility.credentials.TargetInfo;
import com.ibm.ws.bluemix.utility.utils.NLS;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BluemixClient {
    private final TargetInfo info;
    private final CloudFoundryClient client;
    private static final String BLUEMIX_LOG_SERVICE = "bluemixLog";

    private BluemixClient(TargetInfo targetInfo) {
        this.info = targetInfo;
        this.client = new CloudFoundryClient(targetInfo);
    }

    private static TargetInfo loadTargetInfo() throws IOException {
        TargetInfo targetInfo = BluemixProperties.load();
        if (targetInfo != null && targetInfo.containsTokenInfo()) {
            return targetInfo;
        }
        targetInfo = ConfigJson.load();
        if (targetInfo != null && targetInfo.containsTokenInfo()) {
            return targetInfo;
        }
        return null;
    }

    public static BluemixClient getBluemixClient() throws IOException, CloudFoundryLoginException {
        TargetInfo targetInfo = BluemixClient.loadTargetInfo();
        if (targetInfo == null) {
            throw new CloudFoundryLoginException(NLS.getMessage("NOT_LOGGED_IN", new Object[0]));
        }
        return new BluemixClient(targetInfo);
    }

    public static URL getApiEndpoint(String api) {
        return CloudFoundryClient.getApiEndpoint(api);
    }

    public static TargetInfo newTarget(URL api) throws CloudFoundryException {
        Map<String, Object> info = CloudFoundryClient.getInfo(api.toExternalForm());
        String authEndpoint = (String)info.get("authorization_endpoint");
        if (authEndpoint == null) {
            throw new CloudFoundryException(NLS.getMessage("NO_AUTH_ENDPOINT", new Object[0]));
        }
        TargetInfo targetInfo = new TargetInfo();
        targetInfo.setAPI(api.toExternalForm());
        targetInfo.setAuthorizationEndpoint(authEndpoint);
        return targetInfo;
    }

    public static BluemixClient login(TargetInfo targetInfo, String user, String password) throws CloudFoundryException {
        String authEndpoint = targetInfo.getAuthorizationEndpoint();
        if (authEndpoint == null) {
            throw new CloudFoundryException(NLS.getMessage("NO_AUTH_ENDPOINT", new Object[0]));
        }
        OauthToken token = CloudFoundryClient.login(authEndpoint, user, password);
        return BluemixClient.createBluemixClient(targetInfo, token);
    }

    public static BluemixClient login(TargetInfo targetInfo, String passcode) throws CloudFoundryException {
        String authEndpoint = targetInfo.getAuthorizationEndpoint();
        if (authEndpoint == null) {
            throw new CloudFoundryException(NLS.getMessage("NO_AUTH_ENDPOINT", new Object[0]));
        }
        OauthToken token = CloudFoundryClient.login(authEndpoint, passcode);
        return BluemixClient.createBluemixClient(targetInfo, token);
    }

    private static BluemixClient createBluemixClient(TargetInfo targetInfo, OauthToken token) {
        targetInfo.setAccessToken(token.getAuthorizationHeader());
        targetInfo.setRefreshToken(token.getRefreshToken());
        targetInfo.setOrganizationName(null);
        targetInfo.setOrganizationGuid(null);
        targetInfo.setSpaceName(null);
        targetInfo.setSpaceGuid(null);
        BluemixClient client = new BluemixClient(targetInfo);
        return client;
    }

    public static BluemixClient login(URL api, String user, String password) throws CloudFoundryException {
        TargetInfo targetInfo = BluemixClient.newTarget(api);
        return BluemixClient.login(targetInfo, user, password);
    }

    public List<String> getOrganizations() throws CloudFoundryException {
        return this.client.getOrganizations();
    }

    public List<String> getSpaces() throws CloudFoundryException {
        return this.client.getSpaces();
    }

    public TargetInfo getTargetInfo() {
        return this.info;
    }

    public void checkOrganization() throws CloudFoundryLoginException {
        this.client.getOrganizationGuid();
    }

    public void checkSpace() throws CloudFoundryLoginException {
        this.client.getSpaceGuid();
    }

    public String getUserName() {
        return this.client.getUserName();
    }

    public CloudFoundryServiceInstance createService(String serviceType, String plan, String serviceName) throws CloudFoundryException {
        if (this.isLogServiceEnabled() && BLUEMIX_LOG_SERVICE.equalsIgnoreCase(serviceName)) {
            throw new IllegalArgumentException(NLS.getMessage("CANNOT_CREATE_SERVICE", serviceName));
        }
        CloudFoundryServiceInstance instance = this.client.createServiceInstance(serviceType, plan, serviceName);
        return instance;
    }

    public void setOrganization(String orgName) throws CloudFoundryException {
        this.client.setOrganization(orgName);
    }

    public void setSpace(String spaceName) throws CloudFoundryException {
        this.client.setSpace(spaceName);
    }

    public CloudFoundryServiceInstance getService(String serviceName) throws CloudFoundryException {
        CloudFoundryServiceInstance service = null;
        if (this.isLogServiceEnabled() && BLUEMIX_LOG_SERVICE.equalsIgnoreCase(serviceName)) {
            this.client.checkToken();
            service = this.createLogmetService(serviceName);
        } else {
            service = this.client.getServiceInstance(serviceName);
        }
        return service;
    }

    public boolean deleteService(CloudFoundryServiceInstance service) throws CloudFoundryException {
        if (!service.isDeletable()) {
            throw new IllegalArgumentException(NLS.getMessage("CANNOT_DELETE_SERVICE", service.getName()));
        }
        return this.client.deleteServiceInstance(service.getGuid());
    }

    public CloudFoundryServiceKey createServiceKey(String serviceInstanceGuid, String credentialName) throws CloudFoundryException {
        return this.client.createServiceKey(serviceInstanceGuid, credentialName);
    }

    public void deleteServiceKey(CloudFoundryServiceKey key) throws CloudFoundryException {
        if (!key.isDeletable()) {
            throw new IllegalArgumentException(NLS.getMessage("CANNOT_DELETE_SERVICE", key.getName()));
        }
        this.client.deleteServiceKey(key.getGuid());
    }

    public List<CloudFoundryService> getServiceOffering(Set<String> services) throws CloudFoundryException {
        List<CloudFoundryService> offerings = this.client.getServiceOfferings(services);
        return offerings;
    }

    public List<CloudFoundryServiceInstance> getServices(Set<String> supportedServices) throws CloudFoundryException {
        List<CloudFoundryServiceInstance> instances = this.client.getServiceInstances(supportedServices);
        if (this.isLogServiceEnabled() && supportedServices != null && supportedServices.contains(BLUEMIX_LOG_SERVICE)) {
            instances.add(this.createLogmetService(BLUEMIX_LOG_SERVICE));
        }
        return instances;
    }

    private CloudFoundryServiceInstance createLogmetService(String serviceName) throws CloudFoundryException {
        HashMap<String, Object> credentials = new HashMap<String, Object>();
        String oauth = new String(this.info.getAccessToken().getChars());
        String spaceGuid = this.info.getSpaceGuid();
        credentials.put("oauth", oauth);
        credentials.put("space", spaceGuid);
        CloudFoundryServiceKey key = new CloudFoundryServiceKey();
        key.setName("credential-1");
        key.setCredentials(credentials);
        key.setDeletable(false);
        CloudFoundryService service = new CloudFoundryService();
        service.setLabel(BLUEMIX_LOG_SERVICE);
        CloudFoundryServicePlan plan = new CloudFoundryServicePlan();
        CloudFoundryServiceInstance logmet = new CloudFoundryServiceInstance();
        logmet.setKeys(Arrays.asList(key));
        logmet.setName(serviceName);
        logmet.setService(service);
        logmet.setPlan(plan);
        logmet.setDeletable(false);
        return logmet;
    }

    private boolean isLogServiceEnabled() {
        return false;
    }
}

