/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bluemix.utility.actions;

import com.ibm.ws.bluemix.utility.actions.BaseAction;
import com.ibm.ws.bluemix.utility.api.ServiceConfigurationRegistry;
import com.ibm.ws.bluemix.utility.utils.Arguments;
import com.ibm.ws.bluemix.utility.utils.NLS;
import com.ibm.ws.bluemix.utility.utils.ReturnCode;
import com.ibm.ws.kernel.boot.cmdline.Utils;

public class UnbindServiceAction
extends BaseAction {
    public UnbindServiceAction() {
        this.registerArguments("serverName", "serviceName");
    }

    @Override
    public String getActionName() {
        return "unbind";
    }

    @Override
    public ReturnCode handleAction(Arguments arguments) throws Exception {
        String serverName = arguments.getPositionalArguments().get(0);
        String serviceName = arguments.getPositionalArguments().get(1);
        ServiceConfigurationRegistry registry = new ServiceConfigurationRegistry(Utils.getUserDir());
        boolean success = registry.unbind(serviceName, serverName);
        if (success) {
            this.stdout.println(NLS.getOption("unbind.success", serviceName, serverName));
            return ReturnCode.OK;
        }
        this.stderr.println(NLS.getOption("unbind.fail", serviceName, serverName));
        return ReturnCode.IO_FAILURE;
    }
}

