/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bluemix.utility.actions;

import com.ibm.ws.bluemix.utility.actions.BaseAction;
import com.ibm.ws.bluemix.utility.api.BluemixClient;
import com.ibm.ws.bluemix.utility.api.ServiceConfigurationRegistry;
import com.ibm.ws.bluemix.utility.cloudfoundry.CloudFoundryServiceInstance;
import com.ibm.ws.bluemix.utility.cloudfoundry.CloudFoundryServiceKey;
import com.ibm.ws.bluemix.utility.utils.Arguments;
import com.ibm.ws.bluemix.utility.utils.NLS;
import com.ibm.ws.bluemix.utility.utils.Option;
import com.ibm.ws.bluemix.utility.utils.ReturnCode;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import java.util.List;
import java.util.Set;

public class DeleteServiceAction
extends BaseAction {
    private static final Option FORCE_OPT = new Option("force", false);

    public DeleteServiceAction() {
        this.registerOption(FORCE_OPT);
        this.registerArguments("serviceName");
    }

    @Override
    public String getActionName() {
        return "deleteService";
    }

    @Override
    public ReturnCode handleAction(Arguments arguments) throws Exception {
        String prompt;
        Set<String> servers;
        String serviceName;
        BluemixClient client = BluemixClient.getBluemixClient();
        CloudFoundryServiceInstance service = client.getService(serviceName = arguments.getPositionalArguments().get(0));
        if (!service.isDeletable()) {
            throw new IllegalArgumentException(NLS.getMessage("CANNOT_DELETE_SERVICE", service.getName()));
        }
        ServiceConfigurationRegistry registry = new ServiceConfigurationRegistry(Utils.getUserDir());
        boolean isImported = registry.hasService(serviceName);
        if (isImported && !(servers = registry.getServersBound(serviceName)).isEmpty()) {
            StringBuilder builder = new StringBuilder();
            for (String server : servers) {
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                builder.append(server);
            }
            this.stdout.println(NLS.getOption("deleteService.servers.bound", builder));
            return ReturnCode.USER_ABORT;
        }
        if (!arguments.hasOption(FORCE_OPT) && !this.getResponse(prompt = NLS.getOption("deleteService.delete.prompt", serviceName, "[1]", "[2]"), "1", "2", "2")) {
            this.stdout.println(NLS.getOption("deleteService.delete.cancelled", new Object[0]));
            return ReturnCode.USER_ABORT;
        }
        List<CloudFoundryServiceKey> serviceKeys = service.getServiceKeys();
        if (serviceKeys != null) {
            for (CloudFoundryServiceKey serviceKey : serviceKeys) {
                client.deleteServiceKey(serviceKey);
                this.stdout.println(NLS.getOption("deleteService.key.deleted", serviceKey.getName()));
            }
        }
        client.deleteService(service);
        this.stdout.println(NLS.getOption("deleteService.service.deleted", serviceName));
        if (isImported) {
            registry.uninstall(serviceName);
        }
        return ReturnCode.OK;
    }
}

