/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer31.srt;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.webcontainer.srt.SRTInputStream;
import com.ibm.ws.webcontainer31.async.AsyncReadCallback;
import com.ibm.ws.webcontainer31.async.ThreadContextManager;
import com.ibm.ws.webcontainer31.srt.SRTServletRequest31;
import com.ibm.wsspi.channelfw.InterChannelCallback;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import com.ibm.wsspi.http.ee7.HttpInputStreamEE7;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ReadListener;

public class SRTInputStream31
extends SRTInputStream {
    protected HttpInputStreamEE7 httpin;
    private ReadListener listener = null;
    private AsyncReadCallback callback;
    private SRTServletRequest31 request;
    private Object lockObj = new Object(){};
    private Object completeLockObj = new Object(){};
    private Boolean asyncReadOutstanding = false;
    private static final TraceComponent tc = Tr.register(SRTInputStream31.class, (String)"webcontainer", (String)"com.ibm.ws.webcontainer31.resources.Messages");

    public SRTInputStream31(SRTServletRequest31 request) {
        this.request = request;
    }

    public void init(InputStream in) throws IOException {
        if (in != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"init , Servlet 3.1 enabled, casting to HttpInputStreamExtended", (Object[])new Object[0]);
            }
            if (in instanceof HttpInputStreamEE7) {
                this.httpin = (HttpInputStreamEE7)in;
            }
            this.in = in;
        } else {
            this.httpin = null;
            this.in = null;
        }
    }

    public boolean isFinished() {
        boolean isFinished = this.httpin.isFinished();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isFinished returning : " + isFinished), (Object[])new Object[0]);
        }
        return isFinished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReady() {
        if (this.listener == null) {
            return true;
        }
        boolean isReady = false;
        Object object = this.lockObj;
        synchronized (object) {
            if (!this.asyncReadOutstanding.booleanValue()) {
                if (!this.checkAvailable()) {
                    isReady = this.httpin.asyncCheckBuffers((InterChannelCallback)this.callback);
                    if (!isReady) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"asyncCheckBuffers returned false. An async read is now outstanding", (Object[])new Object[0]);
                        }
                        this.asyncReadOutstanding = true;
                    }
                } else {
                    isReady = true;
                }
            }
        }
        return isReady;
    }

    private boolean checkAvailable() {
        int i;
        block3: {
            i = 0;
            try {
                i = this.in.available();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Current amount immediately available in buffers : " + i), (Object[])new Object[0]);
                }
            }
            catch (Exception e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)("There was an IOException during the checkAvailable method : " + e), (Object[])new Object[0]);
            }
        }
        return i > 0;
    }

    public void setReadListener(ReadListener arg0) {
        if (arg0 == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isErrorEnabled()) {
                Tr.error((TraceComponent)tc, (String)"readlistener.is.null", (Object[])new Object[0]);
            }
            throw new NullPointerException(Tr.formatMessage((TraceComponent)tc, (String)"readlistener.is.null", (Object[])new Object[0]));
        }
        if (!this.request.isAsyncStarted()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isErrorEnabled()) {
                Tr.error((TraceComponent)tc, (String)"readlistener.async.not.started", (Object[])new Object[0]);
            }
            throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"readlistener.async.not.started", (Object[])new Object[0]));
        }
        if (this.listener != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isErrorEnabled()) {
                Tr.error((TraceComponent)tc, (String)"readlistener.already.started", (Object[])new Object[0]);
            }
            throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"readlistener.already.started", (Object[])new Object[0]));
        }
        this.listener = arg0;
        ThreadContextManager tcm = new ThreadContextManager();
        this.callback = new AsyncReadCallback(this.listener, this, tcm);
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Issuing the async read for the data", (Object[])new Object[0]);
            }
            this.httpin.getISC().getRequestBodyBuffer((InterChannelCallback)this.callback, true);
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("An exception occurred during the async read : " + e), (Object[])new Object[0]);
            }
            this.listener.onError((Throwable)e);
        }
    }

    public HttpInboundServiceContext getISC() {
        return this.httpin.getISC();
    }

    public void initialRead() {
        this.httpin.initialRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        int returnByte;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"read", (Object[])new Object[]{"SRTInputStream31.read()"});
        }
        if (this.request.isAsyncStarted()) {
            SRTInputStream31 sRTInputStream31 = this;
            synchronized (sRTInputStream31) {
                this.isReadyFalseCheck();
                returnByte = super.read();
            }
        } else {
            returnByte = super.read();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"read", (Object)("SRTInputStream31.read() : " + returnByte));
        }
        return returnByte;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] output) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"read", (Object[])new Object[]{"SRTInputStream31.read(byte[])"});
        }
        if (output == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isErrorEnabled()) {
                Tr.error((TraceComponent)tc, (String)"read.write.bytearray.null", (Object[])new Object[0]);
            }
            throw new NullPointerException(Tr.formatMessage((TraceComponent)tc, (String)"read.write.bytearray.null", (Object[])new Object[0]));
        }
        int returnSize = 0;
        if (this.request.isAsyncStarted()) {
            SRTInputStream31 sRTInputStream31 = this;
            synchronized (sRTInputStream31) {
                this.isReadyFalseCheck();
                returnSize = super.read(output);
            }
        } else {
            returnSize = super.read(output);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"read", (Object)("SRTInputStream31.read(byte[]) : " + returnSize));
        }
        return returnSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] output, int offset, int length) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"read", (Object[])new Object[]{"SRTInputStream31.read(byte[], int, int)"});
        }
        if (output == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isErrorEnabled()) {
                Tr.error((TraceComponent)tc, (String)"read.write.bytearray.null", (Object[])new Object[0]);
            }
            throw new NullPointerException(Tr.formatMessage((TraceComponent)tc, (String)"read.write.bytearray.null", (Object[])new Object[0]));
        }
        if (offset < 0 || length < 0 || length > output.length - offset) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isErrorEnabled()) {
                Tr.error((TraceComponent)tc, (String)"read.write.offset.length.bytearraylength", (Object[])new Object[]{offset, length, output.length});
            }
            throw new IndexOutOfBoundsException(Tr.formatMessage((TraceComponent)tc, (String)"read.write.offset.length.bytearraylength", (Object[])new Object[]{offset, length, output.length}));
        }
        int returnSize = 0;
        if (this.request.isAsyncStarted()) {
            SRTInputStream31 sRTInputStream31 = this;
            synchronized (sRTInputStream31) {
                this.isReadyFalseCheck();
                returnSize = super.read(output, offset, length);
            }
        } else {
            returnSize = super.read(output, offset, length);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"read", (Object)("SRTInputStream31.read(byte[], int, int) : " + returnSize));
        }
        return returnSize;
    }

    private void isReadyFalseCheck() {
        if (this.listener != null && !this.checkAvailable()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isErrorEnabled()) {
                Tr.error((TraceComponent)tc, (String)"read.failed.isReady.false", (Object[])new Object[0]);
            }
            throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"read.failed.isReady.false", (Object[])new Object[0]));
        }
    }

    public ReadListener getReadListener() {
        return this.listener;
    }

    public void setAsyncReadOutstanding(Boolean asyncReadOutstanding) {
        this.asyncReadOutstanding = asyncReadOutstanding;
    }

    public Object getCompleteLockObj() {
        return this.completeLockObj;
    }
}

