/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer31.async;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.webcontainer31.async.ThreadContextManager;
import com.ibm.ws.webcontainer31.srt.SRTInputStream31;
import com.ibm.wsspi.channelfw.InterChannelCallback;
import com.ibm.wsspi.channelfw.VirtualConnection;
import java.io.IOException;
import javax.servlet.ReadListener;

public class AsyncReadCallback
implements InterChannelCallback {
    private static final TraceComponent tc = Tr.register(AsyncReadCallback.class, (String)"webcontainer", (String)"com.ibm.ws.webcontainer.resources.Messages");
    private ReadListener rl;
    private SRTInputStream31 in;
    private ThreadContextManager threadContextManager;

    public AsyncReadCallback(ReadListener rl, SRTInputStream31 in, ThreadContextManager tcm) {
        this.rl = rl;
        this.in = in;
        this.threadContextManager = tcm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={IOException.class})
    public void complete(VirtualConnection vc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"complete called : {0}", (Object[])new Object[]{vc});
        }
        if (null == vc) {
            return;
        }
        Object object = this.in.getCompleteLockObj();
        synchronized (object) {
            this.in.setAsyncReadOutstanding(false);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Calling user's ReadListener onDataAvailable", (Object[])new Object[0]);
            }
            this.threadContextManager.pushContextData();
            try {
                this.rl.onDataAvailable();
            }
            catch (Throwable onDataAvailableException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception occurred during ReadListener.onDataAvailable : " + onDataAvailableException), (Object[])new Object[0]);
                }
                this.threadContextManager.popContextData();
                this.error(vc, onDataAvailableException);
                return;
            }
            if (this.in.getISC().isIncomingMessageFullyRead()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Message is fully read, calling ReadListener onAllDataRead", (Object[])new Object[0]);
                }
                try {
                    this.rl.onAllDataRead();
                }
                catch (Throwable onAllDataReadException) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Exception occurred during ReadListener.onAllDataRead : " + onAllDataReadException), (Object[])new Object[0]);
                    }
                    this.threadContextManager.popContextData();
                    this.error(vc, onAllDataReadException);
                    return;
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Data hasn't been fully read yet. There should be an outstanding read at this point", (Object[])new Object[0]);
            }
            this.threadContextManager.popContextData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(VirtualConnection vc, Throwable t) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Calling user's ReadListener onError", (Object[])new Object[0]);
        }
        Object object = this.in.getCompleteLockObj();
        synchronized (object) {
            this.in.setAsyncReadOutstanding(false);
            try {
                this.threadContextManager.pushContextData();
                this.rl.onError(t);
            }
            finally {
                this.threadContextManager.popContextData();
            }
        }
    }
}

