/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.jsf.core;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.el.MethodNotFoundException;
import javax.faces.FacesException;
import javax.faces.component.PartialStateHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.event.PreRenderViewEvent;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletException;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;
import org.apache.myfaces.view.facelets.FaceletViewDeclarationLanguage;
import org.apache.myfaces.view.facelets.el.CompositeComponentELUtils;
import org.apache.myfaces.view.facelets.tag.jsf.ComponentSupport;
import org.apache.myfaces.view.facelets.util.ReflectionUtil;

public final class EventHandler
extends TagHandler {
    private static final Class<?>[] COMPONENT_SYSTEM_EVENT_PARAMETER = new Class[]{ComponentSystemEvent.class};
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private TagAttribute listener = this.getRequiredAttribute("listener");
    private TagAttribute type;
    private boolean listenerIsCompositeComponentME = !this.listener.isLiteral() ? CompositeComponentELUtils.isCompositeComponentExpression(this.listener.getValue()) : false;

    public EventHandler(TagConfig tagConfig) {
        super(tagConfig);
        this.type = this.getRequiredAttribute("type");
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws ELException, FacesException, FaceletException, IOException {
        if (!ComponentHandler.isNew((UIComponent)parent)) {
            return;
        }
        if (parent instanceof UIViewRoot) {
            if (FaceletCompositionContext.getCurrentInstance(ctx).isRefreshingTransientBuild()) {
                return;
            }
            if (!FaceletViewDeclarationLanguage.isBuildingViewMetadata(ctx.getFacesContext()) && "javax_faces_metadata".equals((String)parent.getAttributes().get("facelets.FACET_NAME"))) {
                return;
            }
        }
        Class<? extends ComponentSystemEvent> eventClass = this.getEventClass(ctx);
        MethodExpression methodExpOneArg = this.listener.getMethodExpression(ctx, Void.TYPE, (Class[])COMPONENT_SYSTEM_EVENT_PARAMETER);
        MethodExpression methodExpZeroArg = this.listener.getMethodExpression(ctx, Void.TYPE, (Class[])EMPTY_CLASS_ARRAY);
        if (eventClass == PreRenderViewEvent.class) {
            UIViewRoot viewRoot = ComponentSupport.getViewRoot(ctx, parent);
            if (this.listenerIsCompositeComponentME) {
                UIComponent parentCompositeComponent = FaceletCompositionContext.getCurrentInstance(ctx).getCompositeComponentFromStack();
                parentCompositeComponent.subscribeToEvent(PostAddToViewEvent.class, (ComponentSystemEventListener)new SubscribeEventListener(eventClass, methodExpOneArg, methodExpZeroArg, eventClass == PreRenderViewEvent.class ? null : parent));
            } else {
                viewRoot.subscribeToEvent(eventClass, (ComponentSystemEventListener)new Listener(methodExpOneArg, methodExpZeroArg));
            }
        } else {
            parent.subscribeToEvent(eventClass, (ComponentSystemEventListener)new Listener(methodExpOneArg, methodExpZeroArg));
        }
    }

    private Class<? extends ComponentSystemEvent> getEventClass(FaceletContext context) {
        Class<Object> eventClass = null;
        String value = null;
        value = this.type.isLiteral() ? this.type.getValue() : (String)this.type.getValueExpression(context, String.class).getValue(context.getFacesContext().getELContext());
        Collection<Class<? extends ComponentSystemEvent>> events = RuntimeConfig.getCurrentInstance(context.getFacesContext().getExternalContext()).getNamedEventManager().getNamedEvent(value);
        if (events == null) {
            try {
                eventClass = ReflectionUtil.forName(value);
            }
            catch (Throwable e) {
                throw new TagAttributeException(this.type, "Couldn't create event class", e);
            }
        } else {
            if (events.size() > 1) {
                StringBuilder classNames = new StringBuilder("[");
                Iterator<Class<? extends ComponentSystemEvent>> eventIterator = events.iterator();
                while (eventIterator.hasNext()) {
                    classNames.append(eventIterator.next().getName());
                    if (eventIterator.hasNext()) {
                        classNames.append(", ");
                        continue;
                    }
                    classNames.append("]");
                }
                throw new FacesException("The event name '" + value + "' is mapped to more than one " + " event class: " + classNames.toString());
            }
            eventClass = events.iterator().next();
        }
        if (!ComponentSystemEvent.class.isAssignableFrom(eventClass)) {
            throw new TagAttributeException(this.type, "Event class " + eventClass.getName() + " is not of type javax.faces.event.ComponentSystemEvent");
        }
        return eventClass;
    }

    public static final class SubscribeEventListener
    implements ComponentSystemEventListener,
    PartialStateHolder {
        private MethodExpression methodExpOneArg;
        private MethodExpression methodExpZeroArg;
        private Class<? extends ComponentSystemEvent> eventClass;
        private UIComponent _targetComponent;
        private String _targetFindComponentExpression;
        private boolean markInitialState;

        public SubscribeEventListener() {
        }

        public SubscribeEventListener(Class<? extends ComponentSystemEvent> eventClass, MethodExpression methodExpOneArg, MethodExpression methodExpZeroArg, UIComponent targetComponent) {
            this.eventClass = eventClass;
            this.methodExpOneArg = methodExpOneArg;
            this.methodExpZeroArg = methodExpZeroArg;
            this._targetComponent = targetComponent;
        }

        public void processEvent(ComponentSystemEvent event) {
            UIComponent parentCompositeComponent = event.getComponent();
            FacesContext facesContext = FacesContext.getCurrentInstance();
            String findComponentExpression = ComponentSupport.getFindComponentExpression(facesContext, parentCompositeComponent);
            if (this.eventClass == PreRenderViewEvent.class) {
                UIViewRoot viewRoot = facesContext.getViewRoot();
                viewRoot.subscribeToEvent(this.eventClass, (ComponentSystemEventListener)new CompositeComponentRelativeListener(this.methodExpOneArg, this.methodExpZeroArg, findComponentExpression));
            } else {
                if (this._targetComponent == null) {
                    this._targetComponent = this._targetFindComponentExpression.startsWith(findComponentExpression) ? ComponentSupport.findComponentChildOrFacetFrom(facesContext, parentCompositeComponent, this._targetFindComponentExpression.substring(findComponentExpression.length())) : facesContext.getViewRoot().findComponent(this._targetFindComponentExpression);
                }
                this._targetComponent.subscribeToEvent(this.eventClass, (ComponentSystemEventListener)new CompositeComponentRelativeListener(this.methodExpOneArg, this.methodExpZeroArg, findComponentExpression));
            }
        }

        public Object saveState(FacesContext context) {
            if (!this.initialStateMarked()) {
                Object[] values = new Object[]{this._targetComponent != null && this._targetFindComponentExpression == null ? ComponentSupport.getFindComponentExpression(context, this._targetComponent) : this._targetFindComponentExpression, this.eventClass, this.methodExpZeroArg, this.methodExpOneArg};
                return values;
            }
            return null;
        }

        public void restoreState(FacesContext context, Object state) {
            if (state == null) {
                return;
            }
            Object[] values = (Object[])state;
            this._targetFindComponentExpression = (String)values[0];
            this.eventClass = (Class)values[1];
            this.methodExpZeroArg = (MethodExpression)values[2];
            this.methodExpOneArg = (MethodExpression)values[3];
        }

        public boolean isTransient() {
            return false;
        }

        public void setTransient(boolean newTransientValue) {
        }

        public void clearInitialState() {
            this.markInitialState = false;
        }

        public boolean initialStateMarked() {
            return this.markInitialState;
        }

        public void markInitialState() {
            this.markInitialState = true;
        }
    }

    public static class CompositeComponentRelativeListener
    implements ComponentSystemEventListener,
    Serializable {
        private static final long serialVersionUID = 3822330995358746099L;
        private String _compositeComponentExpression;
        private MethodExpression methodExpOneArg;
        private MethodExpression methodExpZeroArg;

        public CompositeComponentRelativeListener() {
        }

        public CompositeComponentRelativeListener(MethodExpression methodExpOneArg, MethodExpression methodExpZeroArg, String compositeComponentExpression) {
            this.methodExpOneArg = methodExpOneArg;
            this.methodExpZeroArg = methodExpZeroArg;
            this._compositeComponentExpression = compositeComponentExpression;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processEvent(ComponentSystemEvent event) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            UIComponent cc = facesContext.getViewRoot().findComponent(this._compositeComponentExpression);
            if (cc != null) {
                this.pushAllComponentsIntoStack(facesContext, cc);
                cc.pushComponentToEL(facesContext, cc);
                try {
                    ELContext elContext = facesContext.getELContext();
                    try {
                        this.methodExpOneArg.invoke(elContext, new Object[]{event});
                    }
                    catch (MethodNotFoundException mnfeOneArg) {
                        try {
                            this.methodExpZeroArg.invoke(elContext, new Object[0]);
                        }
                        catch (MethodNotFoundException mnfeZeroArg) {
                            throw mnfeOneArg;
                        }
                    }
                }
                finally {
                    this.popAllComponentsIntoStack(facesContext, cc);
                }
            } else {
                throw new NullPointerException("Composite Component associated with expression cannot be found");
            }
        }

        private void pushAllComponentsIntoStack(FacesContext facesContext, UIComponent component) {
            UIComponent parent = component.getParent();
            if (parent != null) {
                this.pushAllComponentsIntoStack(facesContext, parent);
            }
            component.pushComponentToEL(facesContext, component);
        }

        private void popAllComponentsIntoStack(FacesContext facesContext, UIComponent component) {
            UIComponent parent = component.getParent();
            component.popComponentFromEL(facesContext);
            if (parent != null) {
                this.popAllComponentsIntoStack(facesContext, parent);
            }
        }
    }

    public static class Listener
    implements ComponentSystemEventListener,
    Serializable {
        private static final long serialVersionUID = 7318240026355007052L;
        private MethodExpression methodExpOneArg;
        private MethodExpression methodExpZeroArg;

        public Listener() {
        }

        private Listener(MethodExpression methodExpOneArg, MethodExpression methodExpZeroArg) {
            this.methodExpOneArg = methodExpOneArg;
            this.methodExpZeroArg = methodExpZeroArg;
        }

        public void processEvent(ComponentSystemEvent event) {
            ELContext elContext = FacesContext.getCurrentInstance().getELContext();
            try {
                this.methodExpOneArg.invoke(elContext, new Object[]{event});
            }
            catch (MethodNotFoundException mnfeOneArg) {
                try {
                    this.methodExpZeroArg.invoke(elContext, new Object[0]);
                }
                catch (MethodNotFoundException mnfeZeroArg) {
                    throw mnfeOneArg;
                }
            }
        }
    }
}

