/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.pool.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.config.element.ViewPoolMapping;
import org.apache.myfaces.config.element.ViewPoolParameter;
import org.apache.myfaces.shared.util.ViewProtectionUtils;
import org.apache.myfaces.view.facelets.pool.ViewPool;
import org.apache.myfaces.view.facelets.pool.ViewPoolFactory;
import org.apache.myfaces.view.facelets.pool.impl.ViewPoolImpl;

public class ViewPoolFactoryImpl
extends ViewPoolFactory {
    private List<String> urlPatterns;
    private List<ViewPool> viewPoolList;
    private ViewPool defaultViewPool;

    public ViewPoolFactoryImpl(FacesContext context) {
        RuntimeConfig runtimeConfig = RuntimeConfig.getCurrentInstance(context.getExternalContext());
        if (runtimeConfig.getViewPoolMappings().isEmpty()) {
            this.defaultViewPool = new ViewPoolImpl(context, new HashMap<String, String>());
        }
        this.urlPatterns = new ArrayList<String>();
        this.viewPoolList = new ArrayList<ViewPool>();
        for (ViewPoolMapping vpm : runtimeConfig.getViewPoolMappings()) {
            this.urlPatterns.add(vpm.getUrlPattern());
            HashMap<String, String> parameters = new HashMap<String, String>();
            for (ViewPoolParameter param : vpm.getParameterList()) {
                parameters.put(param.getName(), param.getValue());
            }
            this.viewPoolList.add(new ViewPoolImpl(context, parameters));
        }
    }

    @Override
    public ViewPool getViewPool(FacesContext context, UIViewRoot root) {
        for (int i = 0; i < this.urlPatterns.size(); ++i) {
            String urlPattern = this.urlPatterns.get(i);
            if (!ViewProtectionUtils.matchPattern(root.getViewId(), urlPattern)) continue;
            return this.viewPoolList.get(i);
        }
        if (this.defaultViewPool != null) {
            return this.defaultViewPool;
        }
        return null;
    }
}

