/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import javax.faces.view.facelets.FaceletCache;
import javax.faces.view.facelets.FaceletException;
import org.apache.myfaces.shared.resource.ResourceLoaderUtils;
import org.apache.myfaces.view.facelets.impl.DefaultFacelet;
import org.apache.myfaces.view.facelets.util.ParameterCheck;

class FaceletCacheImpl
extends FaceletCache<DefaultFacelet> {
    private static final long INFINITE_DELAY = -1L;
    private static final long NO_CACHE_DELAY = 0L;
    private Map<String, DefaultFacelet> _facelets;
    private Map<String, DefaultFacelet> _viewMetadataFacelets;
    private long _refreshPeriod;

    FaceletCacheImpl(long refreshPeriod) {
        this._refreshPeriod = refreshPeriod < 0L ? -1L : refreshPeriod * 1000L;
        this._facelets = new HashMap<String, DefaultFacelet>();
        this._viewMetadataFacelets = new HashMap<String, DefaultFacelet>();
    }

    public DefaultFacelet getFacelet(URL url) throws IOException {
        ParameterCheck.notNull("url", url);
        String key = url.toString();
        DefaultFacelet f = this._facelets.get(key);
        if (f == null || this.needsToBeRefreshed(f)) {
            f = (DefaultFacelet)((Object)this.getMemberFactory().newInstance(url));
            if (this._refreshPeriod != 0L) {
                HashMap<String, DefaultFacelet> newLoc = new HashMap<String, DefaultFacelet>(this._facelets);
                newLoc.put(key, f);
                this._facelets = newLoc;
            }
        }
        return f;
    }

    public boolean isFaceletCached(URL url) {
        return this._facelets.containsKey(url.toString());
    }

    public DefaultFacelet getViewMetadataFacelet(URL url) throws IOException {
        ParameterCheck.notNull("url", url);
        String key = url.toString();
        DefaultFacelet f = this._viewMetadataFacelets.get(key);
        if (f == null || this.needsToBeRefreshed(f)) {
            f = (DefaultFacelet)((Object)this.getMetadataMemberFactory().newInstance(url));
            if (this._refreshPeriod != 0L) {
                HashMap<String, DefaultFacelet> newLoc = new HashMap<String, DefaultFacelet>(this._viewMetadataFacelets);
                newLoc.put(key, f);
                this._viewMetadataFacelets = newLoc;
            }
        }
        return f;
    }

    public boolean isViewMetadataFaceletCached(URL url) {
        return this._viewMetadataFacelets.containsKey(url.toString());
    }

    protected boolean needsToBeRefreshed(DefaultFacelet facelet) {
        if (this._refreshPeriod == 0L) {
            return true;
        }
        if (this._refreshPeriod == -1L) {
            return false;
        }
        long target = facelet.getCreateTime() + this._refreshPeriod;
        if (System.currentTimeMillis() > target) {
            URLConnection conn = null;
            try {
                conn = facelet.getSource().openConnection();
                long lastModified = ResourceLoaderUtils.getResourceLastModified(conn);
                boolean bl = lastModified == 0L || lastModified > target;
                return bl;
            }
            catch (IOException e) {
                throw new FaceletException("Error Checking Last Modified for " + facelet.getAlias(), (Throwable)e);
            }
            finally {
                if (conn != null) {
                    try {
                        InputStream is = conn.getInputStream();
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException e) {}
                }
            }
        }
        return false;
    }
}

