/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.logging;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.myfaces.logging.MyfacesLogKey;
import org.apache.myfaces.logging.MyfacesLogMessage;
import org.apache.myfaces.logging.MyfacesLogRecord;

public class MyfacesLogger {
    private static final String LOGGER_NAME_PREFIX = "org.apache.myfaces.";
    public static final MyfacesLogger APPLICATION_LOGGER = MyfacesLogger.createMyfacesLogger("org.apache.myfaces.application");
    public static final MyfacesLogger COMPONENT_LOGGER = MyfacesLogger.createMyfacesLogger("org.apache.myfaces.component");
    public static final MyfacesLogger COMPONENT_HTML_LOGGER = MyfacesLogger.createMyfacesLogger("org.apache.myfaces.component.html");
    public static final MyfacesLogger COMPONENT_BEHAVIOR_LOGGER = MyfacesLogger.createMyfacesLogger("org.apache.myfaces.component.behavior");
    public static final MyfacesLogger COMPONENT_VISIT_LOGGER = MyfacesLogger.createMyfacesLogger("org.apache.myfaces.component.visit");
    public static final MyfacesLogger CONTEXT_LOGGER = MyfacesLogger.createMyfacesLogger("org.apache.myfaces.context");
    public static final MyfacesLogger CONVERT_LOGGER = MyfacesLogger.createMyfacesLogger("org.apache.myfaces.convert");
    public static final MyfacesLogger EVENT_LOGGER = MyfacesLogger.createMyfacesLogger("org.apache.myfaces.event");
    public static final MyfacesLogger LIFECYCLE_LOGGER = MyfacesLogger.createMyfacesLogger("org.apache.myfaces.lifecycle");
    public static final MyfacesLogger MODEL_LOGGER = MyfacesLogger.createMyfacesLogger("org.apache.myfaces.model");
    public static final MyfacesLogger RENDER_LOGGER = MyfacesLogger.createMyfacesLogger("org.apache.myfaces.render");
    public static final MyfacesLogger VALIDATOR_LOGGER = MyfacesLogger.createMyfacesLogger("org.apache.myfaces.validator");
    public static final MyfacesLogger VIEW_LOGGER = MyfacesLogger.createMyfacesLogger("org.apache.myfaces.view");
    public static final MyfacesLogger VIEW_FACELETS_LOGGER = MyfacesLogger.createMyfacesLogger("org.apache.myfaces.view.facelets");
    public static final MyfacesLogger RESOURCE_LOGGER = MyfacesLogger.createMyfacesLogger("org.apache.myfaces.resource");
    public static final MyfacesLogger CONFIG_LOGGER = MyfacesLogger.createMyfacesLogger("org.apache.myfaces.config");
    private Logger _log;
    private static final String _API_LOGGER_BUNDLE = "org.apache.myfaces.resource.LoggerBundle";
    private static final String _IMPL_LOGGER_BUNDLE = "org.apache.myfaces.resource.LoggerBundle";
    private static final MyfacesLogger _LOG = MyfacesLogger.createMyfacesLogger(MyfacesLogger.class);

    private MyfacesLogger(Logger log) {
        this._log = log;
    }

    public Logger getLogger() {
        return this._log;
    }

    private static MyfacesLogger createMyfacesLogger(String name) {
        if (name == null) {
            throw new IllegalArgumentException(_LOG.getMessage("LOGGER_NAME_REQUIRED"));
        }
        Logger log = name.startsWith("javax.faces") ? Logger.getLogger(name, "org.apache.myfaces.resource.LoggerBundle") : (name.startsWith(LOGGER_NAME_PREFIX) ? Logger.getLogger(name, "org.apache.myfaces.resource.LoggerBundle") : Logger.getLogger(name));
        return new MyfacesLogger(log);
    }

    private static MyfacesLogger createMyfacesLogger(String name, String resourceBundleName) {
        if (name == null) {
            throw new IllegalArgumentException(_LOG.getMessage("LOGGER_NAME_REQUIRED"));
        }
        Logger log = Logger.getLogger(name, resourceBundleName);
        return new MyfacesLogger(log);
    }

    public static MyfacesLogger createMyfacesLogger(Class<?> c) {
        if (c == null) {
            throw new IllegalArgumentException(_LOG.getMessage("CLASS_REQUIRED"));
        }
        String name = c.getName();
        return MyfacesLogger.createMyfacesLogger(name);
    }

    public static MyfacesLogger createMyfacesLogger(Class<?> c, String resourceBundleName) {
        if (c == null) {
            throw new IllegalArgumentException(_LOG.getMessage("CLASS_REQUIRED"));
        }
        String name = c.getName();
        return MyfacesLogger.createMyfacesLogger(name, resourceBundleName);
    }

    public static MyfacesLogger createMyfacesLogger(Package p) {
        if (p == null) {
            throw new IllegalArgumentException(_LOG.getMessage("PACKAGE_REQUIRED"));
        }
        String name = p.getName();
        return MyfacesLogger.createMyfacesLogger(name);
    }

    public static MyfacesLogger createMyfacesLogger(Package p, String resourceBundleName) {
        if (p == null) {
            throw new IllegalArgumentException(_LOG.getMessage("PACKAGE_REQUIRED"));
        }
        String name = p.getName();
        return MyfacesLogger.createMyfacesLogger(name, resourceBundleName);
    }

    public void log(LogRecord record) {
        this._log.log(record);
    }

    public void log(String msg) {
        this.log(Level.FINE, msg);
    }

    public void log(Level level, String msg) {
        if (this.isLoggable(level)) {
            MyfacesLogRecord lr = new MyfacesLogRecord(level, msg);
            this.doLog(lr);
        }
    }

    public void log(Level level, String msg, Object param1) {
        if (this.isLoggable(level)) {
            MyfacesLogRecord lr = new MyfacesLogRecord(level, msg);
            Object[] params = new Object[]{param1};
            lr.setParameters(params);
            this.doLog(lr);
        }
    }

    public void log(Level level, String msg, Object[] params) {
        if (this.isLoggable(level)) {
            MyfacesLogRecord lr = new MyfacesLogRecord(level, msg);
            lr.setParameters(params);
            this.doLog(lr);
        }
    }

    public void log(Level level, String msg, Throwable thrown) {
        if (this.isLoggable(level)) {
            MyfacesLogRecord lr = new MyfacesLogRecord(level, msg);
            lr.setThrown(thrown);
            this.doLog(lr);
        }
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg) {
        if (this.isLoggable(level)) {
            MyfacesLogRecord lr = new MyfacesLogRecord(level, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            this.doLog(lr);
        }
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object param1) {
        if (this.isLoggable(level)) {
            MyfacesLogRecord lr = new MyfacesLogRecord(level, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            Object[] params = new Object[]{param1};
            lr.setParameters(params);
            this.doLog(lr);
        }
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object[] params) {
        if (this.isLoggable(level)) {
            MyfacesLogRecord lr = new MyfacesLogRecord(level, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            lr.setParameters(params);
            this.doLog(lr);
        }
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Throwable thrown) {
        if (this.isLoggable(level)) {
            MyfacesLogRecord lr = new MyfacesLogRecord(level, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            lr.setThrown(thrown);
            this.doLog(lr);
        }
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg) {
        if (this.isLoggable(level)) {
            MyfacesLogRecord lr = new MyfacesLogRecord(level, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            this.doLog(lr, bundleName);
        }
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object param1) {
        if (this.isLoggable(level)) {
            MyfacesLogRecord lr = new MyfacesLogRecord(level, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            Object[] params = new Object[]{param1};
            lr.setParameters(params);
            this.doLog(lr, bundleName);
        }
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object[] params) {
        if (this.isLoggable(level)) {
            MyfacesLogRecord lr = new MyfacesLogRecord(level, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            lr.setParameters(params);
            this.doLog(lr, bundleName);
        }
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Throwable thrown) {
        if (this.isLoggable(level)) {
            MyfacesLogRecord lr = new MyfacesLogRecord(level, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            lr.setThrown(thrown);
            this.doLog(lr, bundleName);
        }
    }

    public void entering(String sourceClass, String sourceMethod) {
        this._log.entering(sourceClass, sourceMethod);
    }

    public void entering(String sourceClass, String sourceMethod, Object param1) {
        this._log.entering(sourceClass, sourceMethod, param1);
    }

    public void entering(String sourceClass, String sourceMethod, Object[] params) {
        this._log.entering(sourceClass, sourceMethod, params);
    }

    public void exiting(String sourceClass, String sourceMethod) {
        this._log.exiting(sourceClass, sourceMethod);
    }

    public void exiting(String sourceClass, String sourceMethod, Object result) {
        this._log.exiting(sourceClass, sourceMethod, result);
    }

    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        this._log.throwing(sourceClass, sourceMethod, thrown);
    }

    public void severe(String msg) {
        this.log(Level.SEVERE, msg);
    }

    public void warning(String msg) {
        this.log(Level.WARNING, msg);
    }

    public void info(String msg) {
        this.log(Level.INFO, msg);
    }

    public void config(String msg) {
        this.log(Level.CONFIG, msg);
    }

    public void fine(String msg) {
        this.log(Level.FINE, msg);
    }

    public void finer(String msg) {
        this.log(Level.FINER, msg);
    }

    public void finest(String msg) {
        this.log(Level.FINEST, msg);
    }

    public void throwing(Level level, String sourceClass, String sourceMethod, Throwable thrown) {
        this.logp(level, sourceClass, sourceMethod, null, thrown);
    }

    public void severe(String sourceClass, String sourceMethod, String msg) {
        this.logp(Level.SEVERE, sourceClass, sourceMethod, msg);
    }

    public void severe(String sourceClass, String sourceMethod, String msg, Object param1) {
        this.logp(Level.SEVERE, sourceClass, sourceMethod, msg, param1);
    }

    public void severe(String sourceClass, String sourceMethod, String msg, Object[] params) {
        this.logp(Level.SEVERE, sourceClass, sourceMethod, msg, params);
    }

    public void warning(String sourceClass, String sourceMethod, String msg) {
        this.logp(Level.WARNING, sourceClass, sourceMethod, msg);
    }

    public void warning(String sourceClass, String sourceMethod, String msg, Object param1) {
        this.logp(Level.WARNING, sourceClass, sourceMethod, msg, param1);
    }

    public void warning(String sourceClass, String sourceMethod, String msg, Object[] params) {
        this.logp(Level.WARNING, sourceClass, sourceMethod, msg, params);
    }

    public void info(String sourceClass, String sourceMethod, String msg) {
        this.logp(Level.INFO, sourceClass, sourceMethod, msg);
    }

    public void info(String sourceClass, String sourceMethod, String msg, Object param1) {
        this.logp(Level.INFO, sourceClass, sourceMethod, msg, param1);
    }

    public void info(String sourceClass, String sourceMethod, String msg, Object[] params) {
        this.logp(Level.INFO, sourceClass, sourceMethod, msg, params);
    }

    public void config(String sourceClass, String sourceMethod, String msg) {
        this.logp(Level.CONFIG, sourceClass, sourceMethod, msg);
    }

    public void config(String sourceClass, String sourceMethod, String msg, Object param1) {
        this._log.logp(Level.CONFIG, sourceClass, sourceMethod, msg, param1);
    }

    public void config(String sourceClass, String sourceMethod, String msg, Object[] params) {
        this.logp(Level.CONFIG, sourceClass, sourceMethod, msg, params);
    }

    public void fine(String sourceClass, String sourceMethod, String msg) {
        this.logp(Level.FINE, sourceClass, sourceMethod, msg);
    }

    public void fine(String sourceClass, String sourceMethod, String msg, Object param1) {
        this.logp(Level.FINE, sourceClass, sourceMethod, msg, param1);
    }

    public void fine(String sourceClass, String sourceMethod, String msg, Object[] params) {
        this.logp(Level.FINE, sourceClass, sourceMethod, msg, params);
    }

    public void finer(String sourceClass, String sourceMethod, String msg) {
        this.logp(Level.FINER, sourceClass, sourceMethod, msg);
    }

    public void finer(String sourceClass, String sourceMethod, String msg, Object param1) {
        this.logp(Level.FINER, sourceClass, sourceMethod, msg, param1);
    }

    public void finer(String sourceClass, String sourceMethod, String msg, Object[] params) {
        this.logp(Level.FINER, sourceClass, sourceMethod, msg, params);
    }

    public void finest(String sourceClass, String sourceMethod, String msg) {
        this.logp(Level.FINEST, sourceClass, sourceMethod, msg);
    }

    public void finest(String sourceClass, String sourceMethod, String msg, Object param1) {
        this.logp(Level.FINEST, sourceClass, sourceMethod, msg, param1);
    }

    public void finest(String sourceClass, String sourceMethod, String msg, Object[] params) {
        this.logp(Level.FINEST, sourceClass, sourceMethod, msg, params);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object params1, Object params2, Object params3) {
        this.logp(level, sourceClass, sourceMethod, msg, new Object[]{params1, params2, params3});
    }

    public void setLevel(Level newLevel) throws SecurityException {
        this._log.setLevel(newLevel);
    }

    public Level getLevel() {
        return this._log.getLevel();
    }

    public boolean isLoggable(Level level) {
        return this._log.isLoggable(level);
    }

    public String getName() {
        return this._log.getName();
    }

    public void addHandler(Handler handler) throws SecurityException {
        this._log.addHandler(handler);
    }

    public void removeHandler(Handler handler) throws SecurityException {
        this._log.removeHandler(handler);
    }

    public Handler[] getHandlers() {
        return this._log.getHandlers();
    }

    public void setUseParentHandlers(boolean useParentHandlers) {
        this._log.setUseParentHandlers(useParentHandlers);
    }

    public boolean getUseParentHandlers() {
        return this._log.getUseParentHandlers();
    }

    public Logger getParent() {
        return this._log.getParent();
    }

    public void setParent(Logger parent) {
        this._log.setParent(parent);
    }

    private ResourceBundle findResourceBundle(String name) {
        if (name == null) {
            return null;
        }
        Locale currentLocale = Locale.getDefault();
        return ResourceBundle.getBundle(name, currentLocale);
    }

    private void doLog(LogRecord lr, String rbname) {
        lr.setLoggerName(this._log.getName());
        if (rbname != null) {
            lr.setResourceBundleName(rbname);
            lr.setResourceBundle(this.findResourceBundle(rbname));
        }
        this.log(lr);
    }

    private void doLog(LogRecord lr) {
        lr.setLoggerName(this._log.getName());
        String ebname = this._log.getResourceBundleName();
        if (ebname != null) {
            lr.setResourceBundleName(ebname);
            lr.setResourceBundle(this._log.getResourceBundle());
        }
        this._log.log(lr);
    }

    public void severe(Throwable t) {
        this.severe(null, t);
    }

    public void severe(String message, Throwable t) {
        this.log(Level.SEVERE, message, t);
    }

    public void severe(String message, Object param) {
        this.log(Level.SEVERE, message, param);
    }

    public void severe(String message, Object[] params) {
        this.log(Level.SEVERE, message, params);
    }

    public void warning(Throwable t) {
        this.warning(null, t);
    }

    public void warning(String message, Throwable t) {
        this.log(Level.WARNING, message, t);
    }

    public void warning(String message, Object param) {
        this.log(Level.WARNING, message, param);
    }

    public void warning(String message, Object[] params) {
        this.log(Level.WARNING, message, params);
    }

    public void info(Throwable t) {
        this.info(null, t);
    }

    public void info(String message, Throwable t) {
        this.log(Level.INFO, message, t);
    }

    public void info(String message, Object param) {
        this.log(Level.INFO, message, param);
    }

    public void info(String message, Object[] params) {
        this.log(Level.INFO, message, params);
    }

    public void fine(Throwable t) {
        this.fine(null, t);
    }

    public void fine(String message, Throwable t) {
        this.log(Level.FINE, message, t);
    }

    public void fine(String message, Object param) {
        this.log(Level.FINE, message, param);
    }

    public void fine(String message, Object[] params) {
        this.log(Level.FINE, message, params);
    }

    public void finer(Throwable t) {
        this.finer(null, t);
    }

    public void finer(String message, Throwable t) {
        this.log(Level.FINER, message, t);
    }

    public void finer(String message, Object param) {
        this.log(Level.FINER, message, param);
    }

    public void finer(String message, Object[] params) {
        this.log(Level.FINER, message, params);
    }

    public void finest(Throwable t) {
        this.finest(null, t);
    }

    public void finest(String message, Throwable t) {
        this.log(Level.FINEST, message, t);
    }

    public void finest(String message, Object param) {
        this.log(Level.FINEST, message, param);
    }

    public void finest(String message, Object[] params) {
        this.log(Level.FINEST, message, params);
    }

    public boolean isSevere() {
        return this.isLoggable(Level.SEVERE);
    }

    public boolean isWarning() {
        return this.isLoggable(Level.WARNING);
    }

    public boolean isInfo() {
        return this.isLoggable(Level.INFO);
    }

    public boolean isConfig() {
        return this.isLoggable(Level.CONFIG);
    }

    public boolean isFine() {
        return this.isLoggable(Level.FINE);
    }

    public boolean isFiner() {
        return this.isLoggable(Level.FINER);
    }

    public boolean isFinest() {
        return this.isLoggable(Level.FINEST);
    }

    public String getMessage(String key) {
        try {
            return this._log.getResourceBundle().getString(key);
        }
        catch (MissingResourceException mre) {
            return key;
        }
    }

    public String getMessage(MyfacesLogKey key) {
        try {
            String name = key.name();
            return this._log.getResourceBundle().getString(name);
        }
        catch (MissingResourceException mre) {
            return key.name();
        }
    }

    public MyfacesLogMessage getMyfacesMessage(MyfacesLogKey key) {
        MyfacesLogMessage facesMessage = new MyfacesLogMessage();
        try {
            String name = key.name();
            String summary = this._log.getResourceBundle().getString(name);
            facesMessage.setSummary(summary);
            try {
                String detail = this._log.getResourceBundle().getString(name + "_detail");
                facesMessage.setDetail(detail);
            }
            catch (MissingResourceException e) {
                facesMessage.setDetail(name);
            }
            try {
                String related = this._log.getResourceBundle().getString(name + "_related");
                facesMessage.setRelated(related);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            return facesMessage;
        }
        catch (MissingResourceException mre) {
            facesMessage.setSummary(key.name());
            return facesMessage;
        }
    }

    public String getMessage(String key, Object ... params) {
        String message = this.getMessage(key);
        MessageFormat fmt = new MessageFormat(message);
        return fmt.format(params);
    }

    public String getMessage(String key, Object param) {
        return this.getMessage(key, new Object[]{param});
    }
}

