/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.el.unified.resolver;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.PropertyNotFoundException;
import org.apache.myfaces.el.unified.resolver.ScopedAttributeResolver;
import org.apache.myfaces.shared.util.ClassUtils;

public class ImportHandlerResolver
extends ScopedAttributeResolver {
    private static final Class EL_CLASS;
    private static final Constructor EL_CLASS_CONSTRUCTOR;
    private static final Method GET_IMPORT_HANDLER_METHOD;
    private static final Method IMPORT_HANDLER_RESOLVE_CLASS_METHOD;

    @Override
    public Object getValue(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (EL_CLASS != null && EL_CLASS_CONSTRUCTOR != null && GET_IMPORT_HANDLER_METHOD != null && IMPORT_HANDLER_RESOLVE_CLASS_METHOD != null) {
            Object importHandler = null;
            try {
                Class clazz;
                importHandler = GET_IMPORT_HANDLER_METHOD.invoke((Object)context, new Object[0]);
                if (importHandler != null && (clazz = (Class)IMPORT_HANDLER_RESOLVE_CLASS_METHOD.invoke(importHandler, property.toString())) != null) {
                    context.setPropertyResolved(true);
                    return EL_CLASS_CONSTRUCTOR.newInstance(clazz);
                }
            }
            catch (IllegalAccessException ex) {
            }
            catch (IllegalArgumentException ex) {
            }
            catch (InvocationTargetException ex) {
            }
            catch (SecurityException ex) {
            }
            catch (InstantiationException e) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        Class elClass = null;
        Class importHandlerClass = null;
        Constructor elClassConstructor = null;
        Method getImportHandlerMethod = null;
        Method importHandlerResolveClassMethod = null;
        try {
            elClass = ClassUtils.classForName("javax.el.ELClass");
            importHandlerClass = ClassUtils.classForName("javax.el.ImportHandler");
            getImportHandlerMethod = ELContext.class.getMethod("getImportHandler", new Class[0]);
            if (elClass != null && importHandlerClass != null) {
                importHandlerResolveClassMethod = importHandlerClass.getDeclaredMethod("resolveClass", String.class);
                elClassConstructor = elClass.getConstructor(Class.class);
            }
        }
        catch (SecurityException ex) {
        }
        catch (ClassNotFoundException ex) {
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        EL_CLASS = elClass;
        GET_IMPORT_HANDLER_METHOD = getImportHandlerMethod;
        IMPORT_HANDLER_RESOLVE_CLASS_METHOD = importHandlerResolveClassMethod;
        EL_CLASS_CONSTRUCTOR = elClassConstructor;
    }
}

