/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.bean.ApplicationScoped;
import javax.faces.bean.CustomScoped;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ManagedProperty;
import javax.faces.bean.NoneScoped;
import javax.faces.bean.RequestScoped;
import javax.faces.bean.SessionScoped;
import javax.faces.bean.ViewScoped;
import javax.faces.component.FacesComponent;
import javax.faces.component.behavior.Behavior;
import javax.faces.component.behavior.FacesBehavior;
import javax.faces.context.ExternalContext;
import javax.faces.convert.FacesConverter;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.NamedEvent;
import javax.faces.render.FacesBehaviorRenderer;
import javax.faces.render.FacesRenderer;
import javax.faces.validator.FacesValidator;
import javax.faces.view.facelets.FaceletsResourceResolver;
import org.apache.myfaces.config.impl.digester.elements.ApplicationImpl;
import org.apache.myfaces.config.impl.digester.elements.BehaviorImpl;
import org.apache.myfaces.config.impl.digester.elements.ClientBehaviorRendererImpl;
import org.apache.myfaces.config.impl.digester.elements.ComponentTagDeclarationImpl;
import org.apache.myfaces.config.impl.digester.elements.ConverterImpl;
import org.apache.myfaces.config.impl.digester.elements.FacesConfigImpl;
import org.apache.myfaces.config.impl.digester.elements.ManagedBeanImpl;
import org.apache.myfaces.config.impl.digester.elements.ManagedPropertyImpl;
import org.apache.myfaces.config.impl.digester.elements.NamedEventImpl;
import org.apache.myfaces.config.impl.digester.elements.RenderKitImpl;
import org.apache.myfaces.config.impl.digester.elements.RendererImpl;
import org.apache.myfaces.spi.AnnotationProvider;
import org.apache.myfaces.spi.AnnotationProviderFactory;

public class AnnotationConfigurator {
    private static final Logger log = Logger.getLogger(AnnotationConfigurator.class.getName());

    public FacesConfigImpl createFacesConfig(ExternalContext externalcontext, boolean metadataComplete) {
        if (!metadataComplete) {
            AnnotationProvider provider = AnnotationProviderFactory.getAnnotationProviderFactory(externalcontext).getAnnotationProvider(externalcontext);
            Map<Class<? extends Annotation>, Set<Class<?>>> map = provider.getAnnotatedClasses(externalcontext);
            return this.createFacesConfig(map);
        }
        return null;
    }

    protected FacesConfigImpl createFacesConfig(Map<Class<? extends Annotation>, Set<Class<?>>> map) {
        FacesConfigImpl facesConfig = new FacesConfigImpl();
        Set<Class<?>> classes = map.get(FacesComponent.class);
        if (classes != null && !classes.isEmpty()) {
            for (Class<?> clazz : classes) {
                String value;
                FacesComponent comp = clazz.getAnnotation(FacesComponent.class);
                if (comp == null) continue;
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("addComponent(" + comp.value() + "," + clazz.getName() + ")");
                }
                if ((value = comp.value()) == null || value != null && value.length() <= 0) {
                    String simpleName = clazz.getSimpleName();
                    value = Character.toLowerCase(simpleName.charAt(0)) + simpleName.substring(1);
                }
                facesConfig.addComponent(value, clazz.getName());
                if (!comp.createTag()) continue;
                facesConfig.addComponentTagDeclaration(value, new ComponentTagDeclarationImpl(value, comp.namespace(), comp.tagName()));
            }
        }
        if ((classes = map.get(FacesConverter.class)) != null && !classes.isEmpty()) {
            for (Class<?> clazz : classes) {
                boolean hasValue;
                FacesConverter conv = clazz.getAnnotation(FacesConverter.class);
                if (conv == null) continue;
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("addConverter(" + conv.value() + "," + clazz.getName() + ")");
                }
                boolean hasForClass = !Object.class.equals((Object)conv.forClass());
                boolean bl = hasValue = conv.value().length() > 0;
                if (hasForClass || hasValue) {
                    ConverterImpl converter = new ConverterImpl();
                    if (hasForClass) {
                        converter.setForClass(conv.forClass().getName());
                    }
                    if (hasValue) {
                        converter.setConverterId(conv.value());
                    }
                    converter.setConverterClass(clazz.getName());
                    facesConfig.addConverter(converter);
                    continue;
                }
                throw new FacesException("@FacesConverter must have value, forClass or both. Check annotation @FacesConverter on class: " + clazz.getName());
            }
        }
        if ((classes = map.get(FacesValidator.class)) != null && !classes.isEmpty()) {
            for (Class<?> clazz : classes) {
                String value;
                FacesValidator val = clazz.getAnnotation(FacesValidator.class);
                if (val == null) continue;
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("addValidator(" + val.value() + "," + clazz.getName() + ")");
                }
                if ((value = val.value()) == null || value != null && value.length() <= 0) {
                    String simpleName = clazz.getSimpleName();
                    value = Character.toLowerCase(simpleName.charAt(0)) + simpleName.substring(1);
                }
                facesConfig.addValidator(value, clazz.getName());
                if (!val.isDefault()) continue;
                ApplicationImpl app = null;
                app = facesConfig.getApplications().isEmpty() ? new ApplicationImpl() : (ApplicationImpl)facesConfig.getApplications().get(0);
                app.addDefaultValidatorId(value);
            }
        }
        if ((classes = map.get(FacesRenderer.class)) != null && !classes.isEmpty()) {
            for (Class<?> clazz : classes) {
                RenderKitImpl renderKit;
                FacesRenderer rend = clazz.getAnnotation(FacesRenderer.class);
                if (rend == null) continue;
                String renderKitId = rend.renderKitId();
                if (renderKitId == null) {
                    renderKitId = "HTML_BASIC";
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("addRenderer(" + renderKitId + ", " + rend.componentFamily() + ", " + rend.rendererType() + ", " + clazz.getName() + ")");
                }
                if ((renderKit = (RenderKitImpl)facesConfig.getRenderKit(renderKitId)) == null) {
                    renderKit = new RenderKitImpl();
                    renderKit.setId(renderKitId);
                    facesConfig.addRenderKit(renderKit);
                }
                RendererImpl renderer = new RendererImpl();
                renderer.setComponentFamily(rend.componentFamily());
                renderer.setRendererClass(clazz.getName());
                renderer.setRendererType(rend.rendererType());
                renderKit.addRenderer(renderer);
            }
        }
        if ((classes = map.get(ManagedBean.class)) != null && !classes.isEmpty()) {
            this.handleManagedBean(facesConfig, classes);
        }
        if ((classes = map.get(NamedEvent.class)) != null && !classes.isEmpty()) {
            this.handleNamedEvent(facesConfig, classes);
        }
        if ((classes = map.get(FacesBehavior.class)) != null && !classes.isEmpty()) {
            this.handleFacesBehavior(facesConfig, classes);
        }
        if ((classes = map.get(FacesBehaviorRenderer.class)) != null && !classes.isEmpty()) {
            this.handleFacesBehaviorRenderer(facesConfig, classes);
        }
        if ((classes = map.get(FaceletsResourceResolver.class)) != null && !classes.isEmpty()) {
            this.handleFaceletsResourceResolver(facesConfig, classes);
        }
        return facesConfig;
    }

    private void handleManagedBean(FacesConfigImpl facesConfig, Set<Class<?>> classes) {
        for (Class<?> clazz : classes) {
            Field[] fields;
            ManagedBean bean = clazz.getAnnotation(ManagedBean.class);
            if (bean == null) continue;
            if (log.isLoggable(Level.FINE)) {
                log.fine("Class '" + clazz.getName() + "' has an @ManagedBean annotation");
            }
            ManagedBeanImpl mbc = new ManagedBeanImpl();
            String beanName = bean.name();
            if (beanName == null || beanName.equals("")) {
                beanName = clazz.getName();
                int index = beanName.lastIndexOf(".");
                if (index != -1) {
                    beanName = beanName.substring(index + 1);
                }
                beanName = Character.toLowerCase(beanName.charAt(0)) + beanName.substring(1);
            }
            mbc.setName(beanName);
            mbc.setEager(Boolean.toString(bean.eager()));
            mbc.setBeanClass(clazz.getName());
            ApplicationScoped appScoped = clazz.getAnnotation(ApplicationScoped.class);
            if (appScoped != null) {
                mbc.setScope("application");
            } else {
                NoneScoped noneScoped = clazz.getAnnotation(NoneScoped.class);
                if (noneScoped != null) {
                    mbc.setScope("none");
                } else {
                    RequestScoped requestScoped = clazz.getAnnotation(RequestScoped.class);
                    if (requestScoped != null) {
                        mbc.setScope("request");
                    } else {
                        SessionScoped sessionScoped = clazz.getAnnotation(SessionScoped.class);
                        if (sessionScoped != null) {
                            mbc.setScope("session");
                        } else {
                            ViewScoped viewScoped = clazz.getAnnotation(ViewScoped.class);
                            if (viewScoped != null) {
                                mbc.setScope("view");
                            } else {
                                CustomScoped customScoped = clazz.getAnnotation(CustomScoped.class);
                                if (customScoped != null) {
                                    mbc.setScope(customScoped.value());
                                } else {
                                    mbc.setScope("request");
                                }
                            }
                        }
                    }
                }
            }
            for (Field field : fields = this.fields(clazz)) {
                ManagedProperty property;
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("  Scanning field '" + field.getName() + "'");
                }
                if ((property = field.getAnnotation(ManagedProperty.class)) == null) continue;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("  Field '" + field.getName() + "' has a @ManagedProperty annotation");
                }
                ManagedPropertyImpl mpc = new ManagedPropertyImpl();
                String name = property.name();
                if (name == null || "".equals(name)) {
                    name = field.getName();
                }
                mpc.setPropertyName(name);
                mpc.setPropertyClass(field.getType().getName());
                mpc.setValue(property.value());
                mbc.addProperty(mpc);
            }
            facesConfig.addManagedBean(mbc);
        }
    }

    private void handleNamedEvent(FacesConfigImpl facesConfig, Set<Class<?>> classes) {
        for (Class<?> clazz : classes) {
            NamedEvent namedEvent = clazz.getAnnotation(NamedEvent.class);
            if (namedEvent == null) continue;
            if (!ComponentSystemEvent.class.isAssignableFrom(clazz) && log.isLoggable(Level.WARNING)) {
                log.warning(clazz.getName() + " is annotated with @javax.faces.event.NamedEvent, but does " + "not extend javax.faces.event.ComponentSystemEvent");
            }
            NamedEventImpl namedEventConfig = new NamedEventImpl();
            namedEventConfig.setEventClass(clazz.getName());
            namedEventConfig.setShortName(namedEvent.shortName());
            facesConfig.addNamedEvent(namedEventConfig);
        }
    }

    private void handleFacesBehavior(FacesConfigImpl facesConfig, Set<Class<?>> classes) {
        for (Class<?> clazz : classes) {
            FacesBehavior facesBehavior = clazz.getAnnotation(FacesBehavior.class);
            if (facesBehavior == null) continue;
            if (!Behavior.class.isAssignableFrom(clazz) && log.isLoggable(Level.WARNING)) {
                log.warning(clazz.getName() + " is annotated with @javax.faces.component.behavior.FacesBehavior, " + "but does not implement javax.faces.component.behavior.Behavior");
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("addBehavior(" + facesBehavior.value() + ", " + clazz.getName() + ")");
            }
            BehaviorImpl behavior = new BehaviorImpl();
            behavior.setBehaviorId(facesBehavior.value());
            behavior.setBehaviorClass(clazz.getName());
            facesConfig.addBehavior(behavior);
        }
    }

    private void handleFacesBehaviorRenderer(FacesConfigImpl facesConfig, Set<Class<?>> classes) {
        for (Class<?> clazz : classes) {
            RenderKitImpl renderKit;
            FacesBehaviorRenderer facesBehaviorRenderer = clazz.getAnnotation(FacesBehaviorRenderer.class);
            if (facesBehaviorRenderer == null) continue;
            String renderKitId = facesBehaviorRenderer.renderKitId();
            if (log.isLoggable(Level.FINEST)) {
                log.finest("addClientBehaviorRenderer(" + renderKitId + ", " + facesBehaviorRenderer.rendererType() + ", " + clazz.getName() + ")");
            }
            if ((renderKit = (RenderKitImpl)facesConfig.getRenderKit(renderKitId)) == null) {
                renderKit = new RenderKitImpl();
                renderKit.setId(renderKitId);
                facesConfig.addRenderKit(renderKit);
            }
            ClientBehaviorRendererImpl cbr = new ClientBehaviorRendererImpl();
            cbr.setRendererType(facesBehaviorRenderer.rendererType());
            cbr.setRendererClass(clazz.getName());
            renderKit.addClientBehaviorRenderer(cbr);
        }
    }

    private void handleFaceletsResourceResolver(FacesConfigImpl facesConfig, Set<Class<?>> classes) {
        for (Class<?> clazz : classes) {
            FaceletsResourceResolver faceletsResourceResolver = clazz.getAnnotation(FaceletsResourceResolver.class);
            if (faceletsResourceResolver == null) continue;
            facesConfig.addResourceResolver(clazz.getName());
        }
    }

    private Field[] fields(Class<?> clazz) {
        HashMap<String, Field> fields = new HashMap<String, Field>();
        do {
            for (Field field : clazz.getDeclaredFields()) {
                if (fields.containsKey(field.getName())) continue;
                fields.put(field.getName(), field);
            }
        } while ((clazz = clazz.getSuperclass()) != Object.class);
        return fields.values().toArray(new Field[fields.size()]);
    }
}

