/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim.registry.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.wim.RealmConfig;
import com.ibm.ws.security.wim.registry.WIMUserRegistryDefines;
import com.ibm.ws.security.wim.registry.util.BridgeUtils;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class TypeMappings
implements WIMUserRegistryDefines {
    private static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2012";
    private static final TraceComponent tc = Tr.register(TypeMappings.class);
    private BridgeUtils mappingUtils = null;
    static final long serialVersionUID = -8278113195941234502L;

    public TypeMappings(BridgeUtils mappingUtil) {
        this.mappingUtils = mappingUtil;
    }

    public String getInputUniqueUserId(String inputVirtualRealm) {
        String returnValue = this.getInputMapping(inputVirtualRealm, "uniqueUserIdMapping", "uniqueName");
        return returnValue;
    }

    public String getOutputUniqueUserId(String inputVirtualRealm) {
        String returnValue = this.getOutputMapping(inputVirtualRealm, "uniqueUserIdMapping", "uniqueName");
        return returnValue;
    }

    public String getInputUserSecurityName(String inputVirtualRealm) {
        String returnValue = this.getInputMapping(inputVirtualRealm, "userSecurityNameMapping", "principalName");
        return returnValue;
    }

    public String getOutputUserSecurityName(String inputVirtualRealm) {
        String returnValue = this.getOutputMapping(inputVirtualRealm, "userSecurityNameMapping", "uniqueName");
        return returnValue;
    }

    public String getOutputUserPrincipal(String inputVirtualRealm) {
        String returnValue = this.getOutputMapping(inputVirtualRealm, "userSecurityNameMapping", "principalName");
        return returnValue;
    }

    public String getInputUserDisplayName(String inputVirtualRealm) {
        String returnValue = this.getInputMapping(inputVirtualRealm, "userDisplayNameMapping", "principalName");
        return returnValue;
    }

    public String getOutputUserDisplayName(String inputVirtualRealm) {
        String returnValue = this.getOutputMapping(inputVirtualRealm, "userDisplayNameMapping", "principalName");
        return returnValue;
    }

    public String getInputUniqueGroupId(String inputVirtualRealm) {
        String returnValue = this.getInputMapping(inputVirtualRealm, "uniqueGroupIdMapping", "cn");
        return returnValue;
    }

    public String getOutputUniqueGroupId(String inputVirtualRealm) {
        String returnValue = this.getOutputMapping(inputVirtualRealm, "uniqueGroupIdMapping", "uniqueName");
        return returnValue;
    }

    public String getInputGroupSecurityName(String inputVirtualRealm) {
        String returnValue = this.getInputMapping(inputVirtualRealm, "groupSecurityNameMapping", "cn");
        return returnValue;
    }

    public String getOutputGroupSecurityName(String inputVirtualRealm) {
        String returnValue = this.getOutputMapping(inputVirtualRealm, "groupSecurityNameMapping", "uniqueName");
        return returnValue;
    }

    public String getInputGroupDisplayName(String inputVirtualRealm) {
        String returnValue = this.getInputMapping(inputVirtualRealm, "groupDisplayNameMapping", "cn");
        return returnValue;
    }

    public String getOutputGroupDisplayName(String inputVirtualRealm) {
        String returnValue = this.getOutputMapping(inputVirtualRealm, "groupDisplayNameMapping", "cn");
        return returnValue;
    }

    @FFDCIgnore(value={Exception.class})
    private String getInputMapping(String inputVirtualRealm, String inputProperty, String inputDefaultProperty) {
        String returnValue;
        block5: {
            String methodName = "getInputMapping";
            returnValue = null;
            RealmConfig realmConfig = this.mappingUtils.getCoreConfiguration().getRealmConfig(inputVirtualRealm);
            if (realmConfig != null) {
                try {
                    returnValue = realmConfig.getURMapInputPropertyInRealm(inputProperty);
                    if (returnValue == null || returnValue.equals("")) {
                        returnValue = inputDefaultProperty;
                    }
                    break block5;
                }
                catch (Exception toCatch) {
                    returnValue = inputDefaultProperty;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(methodName + " " + toCatch.getMessage()), (Object[])new Object[0]);
                    }
                    break block5;
                }
            }
            returnValue = inputDefaultProperty;
        }
        return returnValue;
    }

    @FFDCIgnore(value={Exception.class})
    private String getOutputMapping(String inputVirtualRealm, String inputProperty, String inputDefaultProperty) {
        String returnValue;
        block5: {
            String methodName = "getOutputMapping";
            returnValue = null;
            RealmConfig realmConfig = this.mappingUtils.getCoreConfiguration().getRealmConfig(inputVirtualRealm);
            if (realmConfig != null) {
                try {
                    returnValue = realmConfig.getURMapOutputPropertyInRealm(inputProperty);
                    if (returnValue == null || returnValue.equals("")) {
                        returnValue = inputDefaultProperty;
                    }
                    break block5;
                }
                catch (Exception toCatch) {
                    returnValue = inputDefaultProperty;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(methodName + " " + toCatch.getMessage()), (Object[])new Object[0]);
                    }
                    break block5;
                }
            }
            returnValue = inputDefaultProperty;
        }
        return returnValue;
    }
}

