/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.eba.jpa.wab.integration;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.eba.jpa.lookup.OSGiJPALookup;
import com.ibm.ws.eba.jpa.wab.integration.UnsupportedContextTypeException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicReference;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.aries.jpa.container.context.PersistenceContextProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OSGiJPALookupService
implements OSGiJPALookup {
    private static final String DEFAULT_UNIT_NAME_FILTER = "(&(org.apache.aries.jpa.default.unit.name=true)";
    private static final String OSGI_UNIT_NAME_FILTER_PREFIX = "(&(osgi.unit.name=";
    private static final String CONTAINER_FILTER_SECTION = "(org.apache.aries.jpa.container.managed=true)(!(org.apache.aries.jpa.proxy.factory=*))";
    private static final String CONTEXT_FILTER_SECTION = "(org.apache.aries.jpa.container.managed=true)(org.apache.aries.jpa.proxy.factory=true)";
    private static final int TIMEOUT = 10000;
    private static final TraceComponent tc = Tr.register(OSGiJPALookupService.class, (String)"Aries.jpa.extensions", (String)"com.ibm.ws.eba.jpa.wab.integration.nls.Messages");
    private static final ResourceBundle rb = ResourceBundle.getBundle("com.ibm.ws.eba.jpa.wab.integration.nls.Messages");
    private static final String TRACKER_FILTER_SUFFIX = "(objectClass=" + EntityManagerFactory.class.getName() + "))";
    private final AtomicReference<PersistenceContextProvider> contextProvider = new AtomicReference();
    static final long serialVersionUID = -719393972366390669L;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ManualTrace
    public EntityManager findEntityManager(Bundle localBundle, String unitName, boolean isExtendedScope, Map<?, ?> props) {
        EntityManager result;
        block14: {
            block12: {
                block13: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.entry((TraceComponent)tc, (String)"findEntityManager", (Object[])new Object[]{localBundle, unitName, isExtendedScope, props});
                    }
                    result = null;
                    if (isExtendedScope) {
                        Tr.error((TraceComponent)tc, (String)"EXTENDED_SCOPE_UNSUPPORTED", (Object[])new Object[]{localBundle.getSymbolicName(), localBundle.getVersion(), unitName});
                        throw new UnsupportedContextTypeException(MessageFormat.format(rb.getString("EXTENDED_SCOPE_UNSUPPORTED"), localBundle.getSymbolicName(), localBundle.getVersion(), unitName));
                    }
                    BundleContext localContext = localBundle.getBundleContext();
                    PersistenceContextProvider provider = this.contextProvider.get();
                    if (provider == null) break block12;
                    if (localContext == null) break block13;
                    HashMap map = new HashMap();
                    if (props != null) {
                        for (Map.Entry<?, ?> entry : props.entrySet()) {
                            map.put(entry.getKey().toString(), entry.getValue());
                        }
                    }
                    provider.registerContext(unitName, localBundle, map);
                    String filterString = this.getUnitNameFilterPart(unitName);
                    ServiceReference[] refs = null;
                    try {
                        refs = this.getServiceWithWait(localContext, filterString + CONTEXT_FILTER_SECTION);
                    }
                    catch (InvalidSyntaxException invalidSyntaxException) {
                        void e;
                        FFDCFilter.processException((Throwable)invalidSyntaxException, (String)"com.ibm.ws.eba.jpa.wab.integration.OSGiJPALookupService", (String)"102", (Object)this, (Object[])new Object[]{localBundle, unitName, isExtendedScope, props});
                        FFDCFilter.processException((Throwable)e, (String)OSGiJPALookupService.class.getName(), (String)"114");
                        throw new RuntimeException(rb.getString("INVALID_FILTER_EM"));
                    }
                    if (refs != null && refs.length > 0) {
                        EntityManagerFactory emf = (EntityManagerFactory)localContext.getService(refs[0]);
                        if (emf != null) {
                            result = emf.createEntityManager();
                        }
                        if (refs.length > 1) {
                            Tr.warning((TraceComponent)tc, (String)"MULTIPLE_PERSISTENCE_CONTEXTS", (Object[])new Object[]{unitName, localBundle.getSymbolicName(), localBundle.getVersion()});
                        }
                    }
                    break block14;
                }
                Tr.error((TraceComponent)tc, (String)"NO_WAB_BUNDLE_CONTEXT", (Object[])new Object[]{localBundle.getSymbolicName(), localBundle.getVersion()});
                IllegalStateException ise = new IllegalStateException(MessageFormat.format(rb.getString("NO_WAB_BUNDLE_CONTEXT"), localBundle.getSymbolicName(), localBundle.getVersion()));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"findEntityManager", (Object)ise);
                }
                throw ise;
            }
            Tr.error((TraceComponent)tc, (String)"UNABLE_TO_LOCATE_PCP", (Object[])new Object[0]);
            IllegalStateException ise = new IllegalStateException(rb.getString("UNABLE_TO_LOCATE_PCP"));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"findEntityManager", (Object)ise);
            }
            throw ise;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findEntityManager", result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceReference[] getServiceWithWait(BundleContext localContext, String filterString) throws InvalidSyntaxException {
        ServiceReference[] refs;
        ServiceTracker tracker = new ServiceTracker(localContext, localContext.createFilter(filterString + TRACKER_FILTER_SUFFIX), null);
        try {
            tracker.open();
            refs = tracker.getServiceReferences();
            if (refs == null) {
                try {
                    tracker.waitForService(10000L);
                    refs = tracker.getServiceReferences();
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.eba.jpa.wab.integration.OSGiJPALookupService", (String)"161", (Object)this, (Object[])new Object[]{localContext, filterString});
                }
            }
        }
        finally {
            tracker.close();
        }
        return refs;
    }

    @ManualTrace
    private String getUnitNameFilterPart(String unitName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUnitNameFilterPart", (Object[])new Object[]{unitName});
        }
        String filterString = unitName == null || unitName.isEmpty() ? DEFAULT_UNIT_NAME_FILTER : OSGI_UNIT_NAME_FILTER_PREFIX + unitName + ")";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUnitNameFilterPart", (Object)filterString);
        }
        return filterString;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    @ManualTrace
    public EntityManagerFactory findEntityManagerFactory(Bundle localBundle, String unitName) {
        EntityManagerFactory result;
        block5: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"findEntityManagerFactory", (Object[])new Object[]{localBundle, unitName});
            }
            result = null;
            BundleContext localContext = localBundle.getBundleContext();
            if (localContext == null) {
                Tr.error((TraceComponent)tc, (String)"NO_WAB_BUNDLE_CONTEXT", (Object[])new Object[]{localBundle.getSymbolicName(), localBundle.getVersion()});
                IllegalStateException ise = new IllegalStateException(MessageFormat.format(rb.getString("NO_WAB_BUNDLE_CONTEXT"), localBundle.getSymbolicName(), localBundle.getVersion()));
                if (!TraceComponent.isAnyTracingEnabled()) throw ise;
                if (!tc.isEntryEnabled()) throw ise;
                Tr.exit((TraceComponent)tc, (String)"findEntityManagerFactory", (Object)ise);
                throw ise;
            }
            String filterString = this.getUnitNameFilterPart(unitName);
            try {
                ServiceReference[] refs = this.getServiceWithWait(localContext, filterString + CONTAINER_FILTER_SECTION);
                if (refs == null || refs.length <= 0) break block5;
                result = (EntityManagerFactory)localContext.getService(refs[0]);
                if (refs.length > 1) {
                    Tr.warning((TraceComponent)tc, (String)"MULTIPLE_PERSISTENCE_UNITS", (Object[])new Object[]{unitName, localBundle.getSymbolicName(), localBundle.getVersion()});
                }
            }
            catch (InvalidSyntaxException refs) {
                void e;
                FFDCFilter.processException((Throwable)refs, (String)"com.ibm.ws.eba.jpa.wab.integration.OSGiJPALookupService", (String)"211", (Object)this, (Object[])new Object[]{localBundle, unitName});
                FFDCFilter.processException((Throwable)e, (String)OSGiJPALookupService.class.getName(), (String)"200");
                throw new RuntimeException(rb.getString("INVALID_FILTER_EMF"));
            }
        }
        if (!TraceComponent.isAnyTracingEnabled()) return result;
        if (!tc.isEntryEnabled()) return result;
        Tr.exit((TraceComponent)tc, (String)"findEntityManagerFactory", (Object)result);
        return result;
    }

    public void setContextProvider(PersistenceContextProvider ref) {
        this.contextProvider.set(ref);
    }

    public void unsetContextProvider(PersistenceContextProvider ref) {
        this.contextProvider.lazySet(null);
    }
}

