/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.filetransfer.internal.mbean;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.filetransfer.FileServiceMXBean;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.filetransfer.util.FileServiceUtil;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={EventHandler.class}, configurationPid={"com.ibm.ws.management.filetransfer"}, immediate=true, property={"jmx.objectname=WebSphere:feature=restConnector,type=FileService,name=FileService", "publishAttributesToCollectiveController=true", "service.vendor=IBM", "event.topics=com/ibm/wsspi/collective/repository/publishStatus/mbean", "event.filter=(mbeanObjectName=WebSphere:feature=restConnector,type=FileService,name=FileService)"})
public class FileService
extends StandardMBean
implements FileServiceMXBean,
EventHandler {
    private static final TraceComponent tc = Tr.register(FileService.class);
    static final String KEY_LOCATION_ADMIN = "locationAdmin";
    private final AtomicServiceReference<WsLocationAdmin> locationAdminRef = new AtomicServiceReference("locationAdmin");
    static final String KEY_EVENT_ADMIN = "eventAdmin";
    private final AtomicServiceReference<EventAdmin> eventAdminRef = new AtomicServiceReference("eventAdmin");
    private static final String READ_LIST_CONFIGURATION = "readDir";
    private static final String WRITE_LIST_CONFIGURATION = "writeDir";
    private static final String EMPTY_PATH_STRING = "";
    private List<String> ReadList;
    private List<String> WriteList;
    static final long serialVersionUID = -8730626727558605299L;

    public FileService() throws NotCompliantMBeanException {
        super(FileServiceMXBean.class, true);
    }

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> properties) throws IOException {
        this.locationAdminRef.activate(context);
        this.eventAdminRef.activate(context);
        this.processReadWriteLists(properties);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"FileServiceMXBean has been fully activated", (Object[])new Object[0]);
        }
    }

    @Modified
    protected void modified(Map<String, Object> properties) throws IOException {
        this.processReadWriteLists(properties);
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        this.locationAdminRef.deactivate(context);
        this.eventAdminRef.deactivate(context);
    }

    private List<String> normalizePaths(String[] paths) {
        ArrayList<String> pathList = new ArrayList<String>();
        for (String path : paths) {
            pathList.add(this.normalizePath(path));
        }
        return pathList;
    }

    private String normalizePath(String path) {
        if (EMPTY_PATH_STRING.equals(path)) {
            return EMPTY_PATH_STRING;
        }
        WsLocationAdmin wsLocation = this.getWsLocationAdmin();
        if (wsLocation != null) {
            path = wsLocation.resolveString(path);
        }
        if (path != null && !path.isEmpty() && path.charAt(path.length() - 1) == '/') {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    private void processReadWriteLists(Map<String, Object> properties) throws IOException {
        EventAdmin eventAdmin;
        Object readListConfig = properties.get(READ_LIST_CONFIGURATION);
        if (readListConfig instanceof String[]) {
            this.ReadList = this.normalizePaths((String[])readListConfig);
        } else {
            this.ReadList = new ArrayList<String>();
            WsLocationAdmin wsLocation = this.getWsLocationAdmin();
            if (wsLocation == null) {
                throw new IOException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.filetransfer.internal.resources.FileServiceMessages", (String)"OSGI_SERVICE_ERROR", (Object[])new Object[]{"WsLocationAdmin"}, (String)"CWWKX7911E: OSGi service is not available."));
            }
            this.ReadList.add(this.normalizePath(wsLocation.resolveString("${wlp.install.dir}/")));
            this.ReadList.add(this.normalizePath(wsLocation.resolveString("${wlp.user.dir}/")));
            this.ReadList.add(this.normalizePath(wsLocation.resolveString("${server.output.dir}/")));
        }
        Object writeListConfig = properties.get(WRITE_LIST_CONFIGURATION);
        this.WriteList = writeListConfig instanceof String[] ? this.normalizePaths((String[])writeListConfig) : Collections.EMPTY_LIST;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            if (this.ReadList.isEmpty()) {
                sb.append("empty");
            } else {
                for (String readLocation : this.ReadList) {
                    sb.append(readLocation);
                    sb.append("   ");
                }
            }
            Tr.debug((Object)this, (TraceComponent)tc, (String)("readList: " + sb.toString()), (Object[])new Object[0]);
            sb = sb.delete(0, sb.length());
            if (this.WriteList.isEmpty()) {
                sb.append("empty");
            } else {
                for (String writeLocation : this.ReadList) {
                    sb.append(writeLocation);
                    sb.append("   ");
                }
            }
            Tr.debug((Object)this, (TraceComponent)tc, (String)("writeList: " + sb.toString()), (Object[])new Object[0]);
        }
        if ((eventAdmin = this.getEventAdmin()) == null) {
            throw new IOException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.filetransfer.internal.resources.FileServiceMessages", (String)"OSGI_SERVICE_ERROR", (Object[])new Object[]{"EventAdmin"}, (String)"CWWKX7911E: OSGi service is not available."));
        }
        this.publishAttributeChange(eventAdmin, "ReadList", this.ReadList.toArray(new String[this.ReadList.size()]));
        this.publishAttributeChange(eventAdmin, "WriteList", this.WriteList.toArray(new String[this.WriteList.size()]));
    }

    @Reference(name="locationAdmin", service=WsLocationAdmin.class)
    protected void setLocationAdmin(ServiceReference<WsLocationAdmin> ref) {
        this.locationAdminRef.setReference(ref);
    }

    protected void unsetLocationAdmin(ServiceReference<WsLocationAdmin> ref) {
        this.locationAdminRef.unsetReference(ref);
    }

    protected WsLocationAdmin getWsLocationAdmin() {
        WsLocationAdmin locationAdmin = (WsLocationAdmin)this.locationAdminRef.getService();
        if (locationAdmin == null) {
            this.logMissingService("WsLocationAdmin");
        }
        return locationAdmin;
    }

    @Reference(name="eventAdmin", service=EventAdmin.class)
    protected void setEventAdminService(ServiceReference<EventAdmin> ref) {
        this.eventAdminRef.setReference(ref);
    }

    protected void unsetEventAdminService(ServiceReference<EventAdmin> ref) {
        this.eventAdminRef.unsetReference(ref);
    }

    protected EventAdmin getEventAdmin() {
        EventAdmin eventAdmin = (EventAdmin)this.eventAdminRef.getService();
        if (eventAdmin == null) {
            this.logMissingService("EventAdmin");
        }
        return eventAdmin;
    }

    public List<String> getReadList() {
        return this.ReadList;
    }

    public List<String> getWriteList() {
        return this.WriteList;
    }

    public FileServiceMXBean.MetaData getMetaData(String path, String requestOptions) {
        if (path == null || EMPTY_PATH_STRING.equals(path)) {
            this.logInvalidPath(EMPTY_PATH_STRING);
            return null;
        }
        path = this.normalizePath(path);
        if (!FileServiceUtil.isPathContained(this.getReadList(), path) && !FileServiceUtil.isPathContained(this.getWriteList(), path)) {
            this.logAccessDenied(path);
            return null;
        }
        File pathFile = new File(path);
        if (!FileUtils.fileExists((File)pathFile)) {
            return null;
        }
        Boolean directory = null;
        Boolean readOnly = null;
        Date lastModified = null;
        Long size = null;
        boolean requestedAll = requestOptions.contains("a");
        if (requestedAll || requestOptions.contains("d")) {
            directory = FileUtils.fileIsDirectory((File)pathFile);
        }
        if (requestedAll || requestOptions.contains("t")) {
            lastModified = new Date(FileUtils.fileLastModified((File)pathFile));
        }
        if (requestedAll || requestOptions.contains("s")) {
            size = FileUtils.fileLength((File)pathFile);
        }
        if (requestedAll || requestOptions.contains("r")) {
            readOnly = !FileUtils.fileCanWrite((File)pathFile);
        }
        FileServiceMXBean.MetaData retData = new FileServiceMXBean.MetaData(directory, lastModified, size, readOnly, path);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Returning MetData for path[" + path + "] and options[" + requestOptions + "] with " + "\nsize=" + retData.getSize() + "\ndirectory=" + retData.getDirectory() + "\nreadOnly=" + retData.getReadOnly() + "\nlastModified=" + retData.getLastModified() + "\nfileName=" + retData.getFileName()), (Object[])new Object[0]);
        }
        return retData;
    }

    public FileServiceMXBean.MetaData[] getDirectoryEntries(String directory, boolean recursive, String requestOptions) {
        if (directory == null || EMPTY_PATH_STRING.equals(directory)) {
            this.logInvalidPath(EMPTY_PATH_STRING);
            return null;
        }
        File dir = new File(directory = this.normalizePath(directory));
        if (!FileUtils.fileIsDirectory((File)dir)) {
            this.logInvalidPath(directory);
            return null;
        }
        if (!FileServiceUtil.isPathContained(this.getReadList(), directory) && !FileServiceUtil.isPathContained(this.getWriteList(), directory)) {
            this.logAccessDenied(directory);
            return null;
        }
        FileServiceMXBean.MetaData[] md = this.getEntries(dir, recursive, requestOptions);
        return md;
    }

    private FileServiceMXBean.MetaData[] getEntries(File dir, boolean recurse, String requestOptions) {
        ArrayList<FileServiceMXBean.MetaData> v = new ArrayList<FileServiceMXBean.MetaData>();
        v = this.processDir(dir, recurse, requestOptions, v);
        FileServiceMXBean.MetaData[] md = new FileServiceMXBean.MetaData[v.size()];
        v.toArray(md);
        return md;
    }

    private ArrayList<FileServiceMXBean.MetaData> processDir(File dir, boolean recurse, String requestOptions, ArrayList<FileServiceMXBean.MetaData> v) {
        File[] entries = FileUtils.listFiles((File)dir);
        for (int i = 0; i < entries.length; ++i) {
            v.add(this.getMetaData(entries[i].getPath(), requestOptions));
            if (!FileUtils.fileIsDirectory((File)entries[i]) || !recurse) continue;
            v = this.processDir(entries[i], recurse, requestOptions, v);
        }
        return v;
    }

    public boolean createArchive(String sourcePath, String targetPath) {
        boolean rc = true;
        String normalizedSourcePath = this.normalizePath(sourcePath);
        if (!FileServiceUtil.isPathContained(this.getReadList(), normalizedSourcePath)) {
            if (tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"ARCHIVE_CREATE_SOURCE_DENIED_WARNING", (Object[])new Object[]{sourcePath});
            }
            rc = false;
        }
        String normalizedTargetPath = this.normalizePath(targetPath);
        if (!FileServiceUtil.isPathContained(this.getWriteList(), normalizedTargetPath)) {
            if (tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"ARCHIVE_CREATE_TARGET_DENIED_WARNING", (Object[])new Object[]{targetPath});
            }
            rc = false;
        }
        if (!rc) {
            return rc;
        }
        FileServiceUtil ftau = new FileServiceUtil();
        rc = ftau.createArchive(normalizedSourcePath, normalizedTargetPath);
        if (rc) {
            if (tc.isInfoEnabled()) {
                Tr.info((TraceComponent)tc, (String)"ARCHIVE_CREATE_SUCCESS_INFO", (Object[])new Object[]{sourcePath, targetPath});
            }
        } else if (tc.isWarningEnabled()) {
            Tr.warning((TraceComponent)tc, (String)"ARCHIVE_CREATE_FAILURE_WARNING", (Object[])new Object[]{sourcePath, targetPath});
        }
        return rc;
    }

    public boolean expandArchive(String sourcePath, String targetPath) {
        boolean rc = true;
        String normalizedSourcePath = this.normalizePath(sourcePath);
        if (!FileServiceUtil.isPathContained(this.getReadList(), normalizedSourcePath) && !FileServiceUtil.isPathContained(this.getWriteList(), normalizedSourcePath)) {
            if (tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"ARCHIVE_EXPAND_SOURCE_DENIED_WARNING", (Object[])new Object[]{sourcePath});
            }
            rc = false;
        }
        String normalizedTargetPath = this.normalizePath(targetPath);
        if (!FileServiceUtil.isPathContained(this.getWriteList(), normalizedTargetPath)) {
            if (tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"ARCHIVE_EXPAND_TARGET_DENIED_WARNING", (Object[])new Object[]{targetPath});
            }
            rc = false;
        }
        if (!rc) {
            return rc;
        }
        FileServiceUtil ftau = new FileServiceUtil();
        rc = ftau.expandArchive(normalizedSourcePath, normalizedTargetPath);
        if (rc) {
            if (tc.isInfoEnabled()) {
                Tr.info((TraceComponent)tc, (String)"ARCHIVE_EXPAND_SUCCESS_INFO", (Object[])new Object[]{sourcePath, targetPath});
            }
        } else if (tc.isWarningEnabled()) {
            Tr.warning((TraceComponent)tc, (String)"ARCHIVE_EXPAND_FAILURE_WARNING", (Object[])new Object[]{sourcePath, targetPath});
        }
        return rc;
    }

    private void logAccessDenied(String path) {
        Tr.error((TraceComponent)tc, (String)"ACCESS_DENIED_ERROR", (Object[])new Object[]{path});
    }

    private void logInvalidPath(String path) {
        Tr.error((TraceComponent)tc, (String)"PATH_ERROR", (Object[])new Object[]{path});
    }

    private void logMissingService(String service) {
        Tr.error((TraceComponent)tc, (String)"OSGI_SERVICE_ERROR", (Object[])new Object[]{service});
    }

    @Override
    protected String getParameterName(MBeanOperationInfo op, MBeanParameterInfo param, int sequence) {
        if ("createArchive".equals(op.getName())) {
            return sequence == 0 ? "sourcePath" : "targetPath";
        }
        if ("expandArchive".equals(op.getName())) {
            return sequence == 0 ? "sourcePath" : "targetPath";
        }
        if ("getDirectoryEntries".equals(op.getName())) {
            switch (sequence) {
                case 0: {
                    return "directory";
                }
                case 1: {
                    return "recursive";
                }
                case 2: {
                    return "requestOptions";
                }
            }
        } else if ("getMetaData".equals(op.getName())) {
            return sequence == 0 ? "path" : "requestOptions";
        }
        return "p" + sequence;
    }

    private void publishAttributeChange(EventAdmin eventAdmin, String attributeName, Object attributeValue) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("operation", "UPDATE");
        props.put("sendStatusEvent", "true");
        props.put("mbeanObjectName", "WebSphere:feature=restConnector,type=FileService,name=FileService");
        props.put("mbeanAttributeName", attributeName);
        props.put("mbeanAttributeValue", attributeValue);
        eventAdmin.postEvent(new Event("com/ibm/wsspi/collective/repository/publish/mbean", props));
    }

    public void handleEvent(Event statusEvent) {
        String attributeName = (String)statusEvent.getProperty("mbeanAttributeName");
        Tr.info((TraceComponent)tc, (String)"ATTRIBUTE_UPDATED", (Object[])new Object[]{attributeName});
    }
}

