/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs.injection;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.injectionengine.ComponentNameSpaceConfiguration;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.InjectionSimpleBinding;
import com.ibm.wsspi.injectionengine.InjectionTarget;
import com.ibm.wsspi.injectionengine.InjectionTargetContext;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.apache.wink.common.RuntimeContext;
import org.apache.wink.common.internal.registry.InjectableFactory;
import org.apache.wink.common.internal.runtime.RuntimeContextTLS;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class AbstractParamInjectionBinding<A extends Annotation>
extends InjectionSimpleBinding<A> {
    private static final TraceComponent tc = Tr.register(AbstractParamInjectionBinding.class, (String)"JAXRS", (String)"com.ibm.ws.jaxrs.internal.resources.JAXRSMessages");
    static final long serialVersionUID = -1274325999838661877L;

    public AbstractParamInjectionBinding(A annotation, ComponentNameSpaceConfiguration nameSpaceConfig) {
        super(annotation, nameSpaceConfig);
    }

    public boolean isResolved() {
        return true;
    }

    protected abstract Object getJAXRSValueFromContext(A var1, Class<?> var2, Type var3, Annotation[] var4, Member var5, InjectableFactory var6, RuntimeContext var7) throws IOException;

    @ManualTrace
    public Object getInjectionObject(Object target, InjectionTargetContext targetContext) throws InjectionException {
        RuntimeContext context;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getInjectionObject", (Object[])new Object[0]);
        }
        InjectionTarget it = this.getInjectionTarget();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Injection target {0} for this {1} injection binding", (Object[])new Object[]{it, this});
        }
        if ((context = RuntimeContextTLS.getRuntimeContext()) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Could not get a runtime context so not injecting for injection binding {0}", (Object[])new Object[]{this});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getInjectionObject");
            }
            return null;
        }
        Object value = null;
        Member itMember = it.getMember();
        Annotation[] annotations = new Annotation[]{};
        Type t = null;
        if (itMember instanceof Field) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"itMember was a field instance", (Object[])new Object[0]);
            }
            Field f = (Field)itMember;
            annotations = f.getAnnotations();
            t = f.getGenericType();
        } else if (itMember instanceof Method) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"itMember was a method instance", (Object[])new Object[0]);
            }
            Method m = (Method)itMember;
            annotations = m.getAnnotations();
            t = m.getGenericParameterTypes()[0];
        }
        try {
            InjectableFactory factory = InjectableFactory.getInstance();
            value = this.getJAXRSValueFromContext(this.getAnnotation(), it.getInjectionClassType(), t, annotations, it.getMember(), factory, context);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"value from instance was {0}", (Object[])new Object[]{value});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getInjectionObject", (Object)new Object[]{value});
            }
            return value;
        }
        catch (IOException factory) {
            FFDCFilter.processException((Throwable)factory, (String)"com.ibm.ws.jaxrs.injection.AbstractParamInjectionBinding", (String)"123", (Object)((Object)this), (Object[])new Object[]{target, targetContext});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Could not inject into the member {0}", (Object[])new Object[]{it.getMember()});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getInjectionObject", (Object)new Object[]{value});
            }
            return value;
        }
    }
}

