/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.utility.internal.cmdline;

import com.ibm.ws.install.InstallConstants;
import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.InstallKernel;
import com.ibm.ws.install.InstallKernelFactory;
import com.ibm.ws.install.InstallKernelInteractive;
import com.ibm.ws.install.RepositoryConfigUtils;
import com.ibm.ws.install.internal.InstallKernelImpl;
import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.internal.InstallUtils;
import com.ibm.ws.install.internal.cmdline.InstallExecutor;
import com.ibm.ws.install.utility.internal.cmdline.CmdUtils;
import com.ibm.ws.kernel.boot.cmdline.ActionHandler;
import com.ibm.ws.kernel.boot.cmdline.Arguments;
import com.ibm.ws.kernel.boot.cmdline.ExitCode;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.feature.internal.cmdline.NLS;
import com.ibm.ws.repository.common.enums.ResourceType;
import com.ibm.ws.repository.common.enums.Visibility;
import com.ibm.ws.repository.connections.DirectoryRepositoryConnection;
import com.ibm.ws.repository.connections.RepositoryConnection;
import com.ibm.ws.repository.connections.RepositoryConnectionList;
import com.ibm.ws.repository.connections.ZipRepositoryConnection;
import com.ibm.ws.repository.exceptions.RepositoryBackendException;
import com.ibm.ws.repository.resources.ApplicableToProduct;
import com.ibm.ws.repository.resources.EsaResource;
import com.ibm.ws.repository.resources.RepositoryResource;
import com.ibm.ws.repository.resources.SampleResource;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import wlp.lib.extract.ReturnCode;
import wlp.lib.extract.SelfExtractor;

public class FindAction
implements ActionHandler {
    protected static final Logger logger = InstallLogUtils.getInstallLogger();
    private String searchStr;
    private boolean showDescriptions;
    private InstallConstants.AssetType assetType = InstallConstants.AssetType.all;
    private String name;
    private String fromDir;
    private boolean isDebug = false;
    private boolean isBadConnectionFound = false;

    com.ibm.ws.install.utility.cmdline.ReturnCode initialize(Arguments args) {
        String t;
        String verboseLevel = args.getOption("verbose");
        this.isDebug = verboseLevel != null && verboseLevel.equalsIgnoreCase("debug");
        this.searchStr = "";
        if (!args.getPositionalArguments().isEmpty()) {
            if (args.getPositionalArguments().size() > 1) {
                logger.log(Level.SEVERE, CmdUtils.getMessage("ERROR_MORE_THAN_0_OR_1_ARGUMENTS", "find", args.getPositionalArguments().size()));
                return com.ibm.ws.install.utility.cmdline.ReturnCode.BAD_ARGUMENT;
            }
            this.searchStr = (String)args.getPositionalArguments().get(0);
        }
        if ((t = args.getOption("type")) != null && !t.isEmpty()) {
            try {
                this.assetType = InstallConstants.AssetType.valueOf((String)t);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, CmdUtils.getMessage("ERROR_TYPE_INVALID_OPTION", t));
                return com.ibm.ws.install.utility.cmdline.ReturnCode.BAD_ARGUMENT;
            }
        }
        if (args.getOption("name") != null) {
            if (this.searchStr.isEmpty()) {
                logger.log(Level.SEVERE, CmdUtils.getMessage("ERROR_NO_SEARCHSTRING_NAME_OPTION", new Object[0]));
                return com.ibm.ws.install.utility.cmdline.ReturnCode.BAD_ARGUMENT;
            }
            this.name = this.searchStr;
            this.searchStr = "";
        }
        this.showDescriptions = args.getOption("showdescriptions") != null;
        this.fromDir = args.getOption("from");
        if (this.fromDir != null && this.fromDir.isEmpty()) {
            InstallLogUtils.getInstallLogger().log(Level.SEVERE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_DIRECTORY_REQUIRED", new Object[]{"from"}));
            return com.ibm.ws.install.utility.cmdline.ReturnCode.BAD_ARGUMENT;
        }
        return com.ibm.ws.install.utility.cmdline.ReturnCode.OK;
    }

    public ExitCode handleTask(PrintStream stdout, PrintStream stderr, Arguments args) {
        Properties repoProperties;
        com.ibm.ws.install.utility.cmdline.ReturnCode rc = this.initialize(args);
        if (!rc.equals((Object)com.ibm.ws.install.utility.cmdline.ReturnCode.OK)) {
            return rc;
        }
        InstallKernel installKernel = InstallKernelFactory.getInstance();
        try {
            repoProperties = RepositoryConfigUtils.loadRepoProperties();
            if (repoProperties != null) {
                installKernel.setRepositoryProperties(repoProperties);
            }
        }
        catch (InstallException e) {
            logger.log(Level.SEVERE, e.getMessage());
            return InstallExecutor.returnCode((int)e.getRc());
        }
        installKernel.setUserAgent("installUtility");
        try {
            rc = CmdUtils.checkRepositoryStatus((InstallKernelInteractive)installKernel, repoProperties, "find", this.fromDir);
            if (rc.equals((Object)com.ibm.ws.install.utility.cmdline.ReturnCode.BAD_CONNECTION_FOUND)) {
                rc = com.ibm.ws.install.utility.cmdline.ReturnCode.OK;
                this.isBadConnectionFound = true;
            }
            if (rc.equals((Object)com.ibm.ws.install.utility.cmdline.ReturnCode.USER_ABORT)) {
                return rc;
            }
        }
        catch (InstallException e) {
            logger.log(Level.SEVERE, e.getMessage());
            return InstallExecutor.returnCode((int)e.getRc());
        }
        try {
            logger.log(Level.INFO, CmdUtils.getMessage("MSG_SEARCHING", new Object[0]));
            logger.log(Level.INFO, "");
            Map<ResourceType, List<RepositoryResource>> assets = this.queryDirectoryRepo(installKernel.getLoginInfo());
            Map remoteAssets = ((InstallKernelImpl)installKernel).queryAssets(this.searchStr, this.assetType);
            this.merge(assets, remoteAssets);
            if (assets.isEmpty()) {
                logger.log(Level.INFO, CmdUtils.getMessage("MSG_NO_ASSET_FIND", new Object[0]));
            } else {
                this.log(assets);
                if (this.name == null) {
                    this.showAllResults(assets);
                } else {
                    boolean shown = this.showResult(assets, this.name);
                    if (!shown) {
                        logger.log(Level.INFO, CmdUtils.getMessage("MSG_NO_ASSET_FIND", new Object[0]));
                    }
                }
            }
        }
        catch (InstallException e) {
            InstallException newError = CmdUtils.convertToBadConnectionError(e, this.isBadConnectionFound);
            logger.log(Level.SEVERE, newError.getMessage(), newError);
            return InstallExecutor.returnCode((int)newError.getRc());
        }
        return com.ibm.ws.install.utility.cmdline.ReturnCode.OK;
    }

    private void log(Map<ResourceType, List<RepositoryResource>> assets) {
        if (this.isDebug) {
            for (List<RepositoryResource> mrList : assets.values()) {
                InstallUtils.log(mrList);
            }
        }
    }

    private boolean searchDescription(String description) {
        if (description != null && !description.trim().isEmpty()) {
            String[] search = this.searchStr.split(" ");
            String lowerCaseDesc = description.toLowerCase();
            for (String s : search) {
                String trimmed = s.trim();
                if (trimmed.isEmpty() || !lowerCaseDesc.contains(trimmed.toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean match(RepositoryResource mr) {
        if (this.searchStr == null || this.searchStr.trim().isEmpty()) {
            return true;
        }
        String name = mr.getName();
        if (name != null && name.toLowerCase().contains(this.searchStr.toLowerCase())) {
            return true;
        }
        if (this.searchDescription(mr.getDescription())) {
            return true;
        }
        String description = mr instanceof EsaResource ? ((EsaResource)mr).getShortDescription() : (mr instanceof SampleResource ? ((SampleResource)mr).getShortDescription() : null);
        return this.searchDescription(description);
    }

    private boolean isApplicable(RepositoryResource mr) {
        boolean typeMatched;
        ResourceType type = mr.getType();
        if (ResourceType.FEATURE.equals((Object)type)) {
            Visibility v = ((EsaResource)mr).getVisibility();
            if (!v.equals((Object)Visibility.PUBLIC) && !v.equals((Object)Visibility.INSTALL)) {
                return false;
            }
            if (v.equals((Object)Visibility.INSTALL)) {
                type = ResourceType.ADDON;
            }
        }
        boolean bl = typeMatched = this.assetType.equals((Object)InstallConstants.AssetType.all) || this.assetType.equals((Object)InstallConstants.AssetType.feature) && ResourceType.FEATURE.equals((Object)type) || this.assetType.equals((Object)InstallConstants.AssetType.addon) && ResourceType.ADDON.equals((Object)type) || this.assetType.equals((Object)InstallConstants.AssetType.sample) && ResourceType.PRODUCTSAMPLE.equals((Object)type) || this.assetType.equals((Object)InstallConstants.AssetType.opensource) && ResourceType.OPENSOURCE.equals((Object)type);
        if (!typeMatched) {
            return false;
        }
        String appliesTo = null;
        if (mr instanceof ApplicableToProduct) {
            appliesTo = ((ApplicableToProduct)mr).getAppliesTo();
        }
        List productMatchers = SelfExtractor.parseAppliesTo(appliesTo);
        ReturnCode validInstallRC = SelfExtractor.validateProductMatches((File)Utils.getInstallDir(), (List)productMatchers);
        if (validInstallRC != ReturnCode.OK) {
            logger.log(Level.FINEST, mr.getName() + " is not applicable: " + appliesTo);
            return false;
        }
        return true;
    }

    private Map<ResourceType, List<RepositoryResource>> queryDirectoryRepo(RepositoryConnectionList loginInfo) {
        HashMap<ResourceType, List<RepositoryResource>> results = new HashMap<ResourceType, List<RepositoryResource>>();
        ArrayList<RepositoryResource> addOns = new ArrayList<RepositoryResource>();
        ArrayList<RepositoryResource> features = new ArrayList<RepositoryResource>();
        ArrayList<RepositoryResource> samples = new ArrayList<RepositoryResource>();
        ArrayList<RepositoryResource> openSources = new ArrayList<RepositoryResource>();
        if (loginInfo == null) {
            return results;
        }
        for (RepositoryConnection rc : loginInfo) {
            if (!(rc instanceof DirectoryRepositoryConnection) && !(rc instanceof ZipRepositoryConnection)) continue;
            try {
                logger.log(Level.FINEST, "query directory repository " + rc.getRepositoryLocation());
                Collection resources = new RepositoryConnectionList(rc).getAllResources();
                for (RepositoryResource mr : resources) {
                    if (!(mr instanceof EsaResource) && !(mr instanceof SampleResource)) continue;
                    ResourceType t = mr.getType();
                    if (ResourceType.FEATURE.equals((Object)t) && ((EsaResource)mr).getVisibility().equals((Object)Visibility.INSTALL)) {
                        t = ResourceType.ADDON;
                    }
                    if (!this.match(mr) || !this.isApplicable(mr)) continue;
                    if (ResourceType.FEATURE.equals((Object)t)) {
                        if (InstallUtils.contains(features, (RepositoryResource)mr)) continue;
                        features.add(mr);
                        continue;
                    }
                    if (ResourceType.ADDON.equals((Object)t)) {
                        if (InstallUtils.contains(addOns, (RepositoryResource)mr)) continue;
                        addOns.add(mr);
                        continue;
                    }
                    if (ResourceType.PRODUCTSAMPLE.equals((Object)t)) {
                        if (InstallUtils.contains(samples, (RepositoryResource)mr)) continue;
                        samples.add(mr);
                        continue;
                    }
                    if (!ResourceType.OPENSOURCE.equals((Object)t) || InstallUtils.contains(openSources, (RepositoryResource)mr)) continue;
                    openSources.add(mr);
                }
            }
            catch (RepositoryBackendException e) {
                String msg = e.getFailingConnection() == null ? "" : " from " + e.getFailingConnection().getRepositoryLocation();
                logger.log(Level.FINEST, "Failed to get resources" + msg + ". Reason: " + e.getMessage());
            }
        }
        if (!addOns.isEmpty()) {
            results.put(ResourceType.ADDON, addOns);
        }
        if (!features.isEmpty()) {
            results.put(ResourceType.FEATURE, features);
        }
        if (!samples.isEmpty()) {
            results.put(ResourceType.PRODUCTSAMPLE, samples);
        }
        if (!openSources.isEmpty()) {
            results.put(ResourceType.OPENSOURCE, openSources);
        }
        return results;
    }

    private void merge(Map<ResourceType, List<RepositoryResource>> assets, Map<ResourceType, List<RepositoryResource>> remoteAssets) {
        for (Map.Entry<ResourceType, List<RepositoryResource>> remote : remoteAssets.entrySet()) {
            ResourceType t = remote.getKey();
            List<RepositoryResource> mrList = assets.get(t);
            if (mrList == null) {
                assets.put(t, remote.getValue());
                continue;
            }
            for (RepositoryResource remoteMr : remote.getValue()) {
                if (InstallUtils.contains(mrList, (RepositoryResource)remoteMr)) continue;
                mrList.add(remoteMr);
            }
        }
    }

    private boolean matchName(EsaResource esa, String name) {
        String shortName = esa.getShortName();
        if (shortName != null && shortName.equalsIgnoreCase(name)) {
            return true;
        }
        String provideFeature = esa.getProvideFeature();
        if (provideFeature != null && provideFeature.equals(name)) {
            return true;
        }
        String displayName = esa.getName();
        return displayName != null && displayName.equalsIgnoreCase(name);
    }

    private boolean matchName(SampleResource sr, String name) {
        String shortName = sr.getShortName();
        if (shortName != null && shortName.equalsIgnoreCase(name)) {
            return true;
        }
        String displayName = sr.getName();
        return displayName != null && displayName.equalsIgnoreCase(name);
    }

    private boolean showResult(Map<ResourceType, List<RepositoryResource>> assets, String name) {
        List<RepositoryResource> openSources;
        List<RepositoryResource> samples;
        List<RepositoryResource> features;
        boolean shown = false;
        List<RepositoryResource> addons = assets.get(ResourceType.ADDON);
        if (addons != null) {
            for (RepositoryResource addon : addons) {
                EsaResource esa = (EsaResource)addon;
                if (!this.matchName(esa, name)) continue;
                this.showESA(esa, "addon", this.showDescriptions);
                shown = true;
            }
        }
        if ((features = assets.get(ResourceType.FEATURE)) != null) {
            for (RepositoryResource feature : features) {
                EsaResource esa = (EsaResource)feature;
                if (!this.matchName(esa, name)) continue;
                this.showESA(esa, "feature", this.showDescriptions);
                shown = true;
            }
        }
        if ((samples = assets.get(ResourceType.PRODUCTSAMPLE)) != null) {
            for (RepositoryResource sample : samples) {
                SampleResource sr = (SampleResource)sample;
                if (!this.matchName(sr, name)) continue;
                this.showSample(sr, "sample", this.showDescriptions);
                shown = true;
            }
        }
        if ((openSources = assets.get(ResourceType.OPENSOURCE)) != null) {
            for (RepositoryResource openSource : openSources) {
                SampleResource sr = (SampleResource)openSource;
                if (!this.matchName(sr, name)) continue;
                this.showSample(sr, "opensource", this.showDescriptions);
                shown = true;
            }
        }
        return shown;
    }

    private void showAllResults(Map<ResourceType, List<RepositoryResource>> assets) {
        List<RepositoryResource> openSources;
        List<RepositoryResource> samples;
        List<RepositoryResource> features;
        List<RepositoryResource> addons = assets.get(ResourceType.ADDON);
        if (addons != null) {
            Collections.sort(addons, new Comparator<RepositoryResource>(){

                @Override
                public int compare(RepositoryResource mr1, RepositoryResource mr2) {
                    return FindAction.this.getName((EsaResource)mr1).compareTo(FindAction.this.getName((EsaResource)mr2));
                }
            });
            for (RepositoryResource esa : addons) {
                if (esa instanceof EsaResource) {
                    this.showESA((EsaResource)esa, "addon", this.showDescriptions);
                    continue;
                }
                logger.log(Level.FINEST, "Unexpected addon: " + esa.getName() + " - " + esa.getShortDescription());
            }
        }
        if ((features = assets.get(ResourceType.FEATURE)) != null) {
            Collections.sort(features, new Comparator<RepositoryResource>(){

                @Override
                public int compare(RepositoryResource mr1, RepositoryResource mr2) {
                    return FindAction.this.getName((EsaResource)mr1).compareTo(FindAction.this.getName((EsaResource)mr2));
                }
            });
            for (RepositoryResource esa : features) {
                if (esa instanceof EsaResource) {
                    this.showESA((EsaResource)esa, "feature", this.showDescriptions);
                    continue;
                }
                logger.log(Level.FINEST, "Unexpected feature: " + esa.getName() + " - " + esa.getShortDescription());
            }
        }
        if ((samples = assets.get(ResourceType.PRODUCTSAMPLE)) != null) {
            Collections.sort(samples, new Comparator<RepositoryResource>(){

                @Override
                public int compare(RepositoryResource mr1, RepositoryResource mr2) {
                    return mr1.getName().compareTo(mr2.getName());
                }
            });
            for (RepositoryResource sample : samples) {
                if (sample instanceof SampleResource) {
                    this.showSample((SampleResource)sample, "sample", this.showDescriptions);
                    continue;
                }
                logger.log(Level.FINEST, "Unexpected sample: " + sample.getName() + " - " + sample.getShortDescription());
            }
        }
        if ((openSources = assets.get(ResourceType.OPENSOURCE)) != null) {
            Collections.sort(openSources, new Comparator<RepositoryResource>(){

                @Override
                public int compare(RepositoryResource mr1, RepositoryResource mr2) {
                    return mr1.getName().compareTo(mr2.getName());
                }
            });
            for (RepositoryResource openSource : openSources) {
                if (openSource instanceof SampleResource) {
                    this.showSample((SampleResource)openSource, "opensource", this.showDescriptions);
                    continue;
                }
                logger.log(Level.FINEST, "Unexpected opensource: " + openSource.getName() + " - " + openSource.getShortDescription());
            }
        }
    }

    private String getName(EsaResource esa) {
        String shortName = esa.getShortName();
        if (shortName != null && !shortName.isEmpty()) {
            return shortName;
        }
        return esa.getProvideFeature();
    }

    private void showESA(EsaResource esa, String type, boolean viewInfo) {
        Collection requiredFeatures;
        if (!viewInfo) {
            logger.log(Level.INFO, type + " : " + this.getName(esa) + " : " + esa.getName());
            return;
        }
        logger.log(Level.INFO, this.getName(esa));
        logger.log(Level.INFO, NLS.getMessage((String)"find.view.info.name", (Object[])new Object[]{esa.getName()}));
        logger.log(Level.INFO, NLS.getMessage((String)"find.view.info.symbolic.name", (Object[])new Object[]{esa.getProvideFeature()}));
        String description = esa.getShortDescription();
        if (description != null && !description.isEmpty()) {
            description = NLS.getMessage((String)"find.view.info.description", (Object[])new Object[]{description});
            StringBuffer sb = new StringBuffer();
            BufferedReader reader = new BufferedReader(new StringReader(description));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    InstallUtils.wordWrap((StringBuffer)sb, (String)line, (String)"        ");
                }
                logger.log(Level.INFO, sb.toString());
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.getMessage());
            }
        }
        if ((requiredFeatures = esa.getRequireFeature()) != null && !requiredFeatures.isEmpty()) {
            logger.log(Level.INFO, NLS.getMessage((String)"find.view.info.enabled.by", (Object[])new Object[0]));
            for (String requiredFeature : requiredFeatures) {
                logger.log(Level.INFO, "        " + requiredFeature);
            }
        }
        logger.log(Level.INFO, "");
    }

    private void showSample(SampleResource sample, String type, boolean viewInfo) {
        Collection requiredFeatures;
        String shortName = sample.getShortName();
        if (shortName == null) {
            shortName = CmdUtils.getMessage("MSG_NO_NAME", new Object[0]);
        }
        if (!viewInfo) {
            logger.log(Level.INFO, type + " : " + shortName + " : " + sample.getName());
            return;
        }
        logger.log(Level.INFO, shortName);
        logger.log(Level.INFO, NLS.getMessage((String)"find.view.info.name", (Object[])new Object[]{sample.getName()}));
        String description = sample.getShortDescription();
        if (description != null && !description.isEmpty()) {
            description = NLS.getMessage((String)"find.view.info.description", (Object[])new Object[]{description});
            StringBuffer sb = new StringBuffer();
            BufferedReader reader = new BufferedReader(new StringReader(description));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    InstallUtils.wordWrap((StringBuffer)sb, (String)line, (String)"        ");
                }
                logger.log(Level.INFO, sb.toString());
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, description);
            }
        }
        if ((requiredFeatures = sample.getRequireFeature()) != null && !requiredFeatures.isEmpty()) {
            logger.log(Level.INFO, NLS.getMessage((String)"find.view.info.enabled.by", (Object[])new Object[0]));
            for (String requiredFeature : requiredFeatures) {
                logger.log(Level.INFO, "        " + requiredFeature);
            }
        }
        logger.log(Level.INFO, "");
    }
}

