/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.zos.logging.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.logging.RoutedMessage;
import com.ibm.ws.logging.WsLogHandler;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.zos.logging.internal.LoggingHandlerDiagnosticsVector;
import com.ibm.ws.zos.logging.internal.ZosLoggingBundleActivator;
import java.io.IOException;
import java.util.Hashtable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class MsgLogLogHandler
implements WsLogHandler {
    private final LoggingHandlerDiagnosticsVector savedDiagnostics = new LoggingHandlerDiagnosticsVector();
    private volatile ServiceRegistration<WsLogHandler> serviceRegistration;
    private final ZosLoggingBundleActivator zosLoggingBundleActivator;
    private volatile long msgLogFilePtr = 0L;
    static final long serialVersionUID = -7370778761265593861L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public MsgLogLogHandler(ZosLoggingBundleActivator zosLoggingBundleActivator) {
        this.zosLoggingBundleActivator = zosLoggingBundleActivator;
    }

    protected synchronized void register(BundleContext bundleContext) {
        if (this.serviceRegistration != null) {
            return;
        }
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("service.vendor", "IBM");
        props.put("id", "MSGLOG");
        this.serviceRegistration = bundleContext.registerService(WsLogHandler.class, (Object)this, props);
    }

    protected synchronized void unregister() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
            this.serviceRegistration = null;
        }
    }

    protected String parseHeaderLine(String msg) {
        return msg.length() > 96 ? msg.substring(0, 96) : msg;
    }

    protected String parseMessage(String msg) {
        return msg.length() > 96 ? msg.substring(96) : "";
    }

    /*
     * WARNING - void declaration
     */
    public void publish(RoutedMessage routedMessage) {
        String msg = routedMessage.getMessageLogFormat();
        if (msg != null) {
            try {
                this.publishMessage(msg);
            }
            catch (IOException iOException) {
                void ioe;
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.zos.logging.internal.MsgLogLogHandler", (String)"113", (Object)this, (Object[])new Object[]{routedMessage});
                this.savedDiagnostics.insertElementAtBegining(ioe.getMessage(), -1);
            }
        }
    }

    protected void publishMessage(String msg) throws IOException {
        this.zosLoggingBundleActivator.writeFile(this.getMsgLogFilePtr(), this.parseHeaderLine(msg) + "\n");
        this.zosLoggingBundleActivator.writeFile(this.getMsgLogFilePtr(), "    " + this.parseMessage(msg) + "\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getMsgLogFilePtr() throws IOException {
        if (this.msgLogFilePtr == 0L) {
            MsgLogLogHandler msgLogLogHandler = this;
            synchronized (msgLogLogHandler) {
                if (this.msgLogFilePtr == 0L) {
                    this.msgLogFilePtr = this.zosLoggingBundleActivator.openFile("DD:MSGLOG");
                }
            }
        }
        return this.msgLogFilePtr;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(MsgLogLogHandler.class);
    }
}

