/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.zos.logging.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.logging.RoutedMessage;
import com.ibm.ws.logging.WsLogHandler;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.zos.jni.NativeMethodUtils;
import com.ibm.ws.zos.logging.internal.LocaleHelper;
import com.ibm.ws.zos.logging.internal.LoggingHandlerDiagnosticsVector;
import com.ibm.ws.zos.logging.internal.ZosLoggingBundleActivator;
import java.util.Hashtable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class LoggingWtoLogHandler
implements WsLogHandler {
    private final LoggingHandlerDiagnosticsVector savedDiagnostics = new LoggingHandlerDiagnosticsVector();
    private final LocaleHelper localeHelper = new LocaleHelper();
    private volatile ServiceRegistration<WsLogHandler> serviceRegistration;
    private final ZosLoggingBundleActivator zosLoggingBundleActivator;
    static final long serialVersionUID = 733471633337583703L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public LoggingWtoLogHandler(ZosLoggingBundleActivator zosLoggingBundleActivator) {
        this.zosLoggingBundleActivator = zosLoggingBundleActivator;
    }

    protected synchronized void register(BundleContext bundleContext) {
        if (this.serviceRegistration != null) {
            return;
        }
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("service.vendor", "IBM");
        props.put("id", "WTO");
        this.serviceRegistration = bundleContext.registerService(WsLogHandler.class, (Object)this, props);
    }

    protected synchronized void unregister() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
            this.serviceRegistration = null;
        }
    }

    public void publish(RoutedMessage routedMessage) {
        int writeReturnCode;
        String englishMsg = this.localeHelper.translateToEnglish(routedMessage.getFormattedMsg(), routedMessage.getLogRecord());
        if (englishMsg != null && (writeReturnCode = this.writeToOperatorConsole(NativeMethodUtils.convertToEBCDIC((String)englishMsg))) != 0) {
            this.savedDiagnostics.insertElementAtBegining(englishMsg, writeReturnCode);
        }
    }

    protected int writeToOperatorConsole(byte[] msg) {
        return this.zosLoggingBundleActivator.ntv_WriteToOperatorConsole(msg);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(LoggingWtoLogHandler.class);
    }
}

