/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.zos.logging.console;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.zos.core.command.processing.CommandHandler;
import com.ibm.ws.zos.core.command.processing.ModifyResults;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(name="com.ibm.ws.zos.command.processing.logging.LoggingCommandHandler", configurationPolicy=ConfigurationPolicy.IGNORE, property={"modify.filter.regex=((?i)(logging).*)", "service.vendor=IBM"})
public class LoggingCommandHandler
implements CommandHandler {
    static final String NAME = "Logging Command Handler";
    static final List<String> HELP_TEXT;
    static final String LOGGING_PID = "com.ibm.ws.logging";
    static final String TRACE_SPEC_KEY = "traceSpecification";
    protected ConfigurationAdmin configAdmin;
    protected String configuredTraceSpec = null;
    static final long serialVersionUID = -6698286871415759882L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Reference
    protected void setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
        this.setConfiguredTraceSpec();
    }

    public List<String> getHelp() {
        return HELP_TEXT;
    }

    public String getName() {
        return NAME;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleModify(String command, ModifyResults results) {
        ArrayList<String> responses;
        block8: {
            responses = null;
            String[] loggingCmd = command.split("=", 2);
            if (loggingCmd.length > 1 && loggingCmd[1] != null) {
                try {
                    String traceSpec = loggingCmd[1];
                    traceSpec = this.trimQuotes(traceSpec);
                    if (traceSpec.isEmpty()) {
                        results.setCompletionStatus(2);
                        break block8;
                    }
                    Configuration config = this.configAdmin.getConfiguration(LOGGING_PID, null);
                    Dictionary props = config.getProperties();
                    if (traceSpec.equalsIgnoreCase("reset")) {
                        if (this.configuredTraceSpec == null) {
                            responses = new ArrayList<String>();
                            responses.add("Unexpected null found for configuredTraceSpec");
                            results.setCompletionStatus(3);
                            results.setResponsesContainMSGIDs(false);
                            results.setResponses(responses);
                            return;
                        }
                        props.put(TRACE_SPEC_KEY, this.configuredTraceSpec);
                        config.update(props);
                    } else {
                        props.put(TRACE_SPEC_KEY, traceSpec);
                        config.update(props);
                    }
                    results.setCompletionStatus(1);
                }
                catch (IOException traceSpec) {
                    FFDCFilter.processException((Throwable)traceSpec, (String)"com.ibm.ws.zos.logging.console.LoggingCommandHandler", (String)"133", (Object)this, (Object[])new Object[]{command, results});
                    results.setCompletionStatus(3);
                    Object ioe = null;
                }
            } else {
                results.setCompletionStatus(2);
            }
        }
        results.setResponsesContainMSGIDs(false);
        results.setResponses(responses);
    }

    String trimQuotes(String aString) {
        if (aString == null) {
            return "";
        }
        if (!aString.startsWith("'") && !aString.endsWith("'")) {
            return aString;
        }
        if (!aString.startsWith("'")) {
            return "";
        }
        aString = aString.substring(1, aString.length());
        if (!aString.endsWith("'")) {
            return "";
        }
        aString = aString.substring(0, aString.length() - 1);
        return aString;
    }

    private static List<String> buildHelpText() {
        ArrayList<String> responses = new ArrayList<String>();
        responses.add("Issue \"MODIFY <jobname.>identifier,logging='tracespec'\"");
        responses.add("  to change the trace specification of the server");
        responses.add("  The tracespec value is a valid trace specification or the value reset");
        responses.add("  The tracespec is case sensitive and must be enclosed in single quotes");
        responses.add("  Specifying the value reset will return the server to the settings specified in the configuration");
        return responses;
    }

    protected void setConfiguredTraceSpec() {
        if (this.configuredTraceSpec != null) {
            return;
        }
        try {
            Configuration config = this.configAdmin.getConfiguration(LOGGING_PID, null);
            Dictionary props = config.getProperties();
            this.configuredTraceSpec = (String)props.get(TRACE_SPEC_KEY);
        }
        catch (IOException config) {
            FFDCFilter.processException((Throwable)config, (String)"com.ibm.ws.zos.logging.console.LoggingCommandHandler", (String)"201", (Object)this, (Object[])new Object[0]);
            this.configuredTraceSpec = null;
            Object var1_3 = null;
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(LoggingCommandHandler.class);
        HELP_TEXT = LoggingCommandHandler.buildHelpText();
    }
}

