/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.zos.logging;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.logging.osgi.MessageRouterConfigListener;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.zos.logging.internal.ZosLoggingConfigListener;
import java.util.Hashtable;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(name="com.ibm.ws.zos.logging.config", service={ZosLoggingConfiguration.class}, immediate=true, property={"service.vendor = IBM"})
public class ZosLoggingConfiguration {
    private volatile Hashtable<String, Object> zosLoggingConfig = null;
    private ZosLoggingConfigListener zosLoggingConfigListener;
    private MessageRouterConfigListener msgRouterConfigListener;
    static final long serialVersionUID = -2282081071771740775L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Reference(policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.OPTIONAL)
    protected void setZosLoggingConfigListener(ZosLoggingConfigListener listener) {
        this.zosLoggingConfigListener = listener;
        this.updateListeners();
    }

    @Reference(policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.OPTIONAL)
    protected void setMessageRouterConfigListener(MessageRouterConfigListener listener) {
        this.msgRouterConfigListener = listener;
        this.updateListeners();
    }

    protected void activate(Map<String, Object> config) {
        this.zosLoggingConfig = new Hashtable<String, Object>(config);
        this.updateListeners();
    }

    protected void deactivate(Map<String, Object> config, int reason) {
        this.zosLoggingConfig = null;
        this.msgRouterConfigListener = null;
        this.zosLoggingConfigListener = null;
    }

    protected void modified(Map<String, Object> config) {
        this.zosLoggingConfig = new Hashtable<String, Object>(config);
        this.updateListeners();
    }

    private void updateListeners() {
        if (this.zosLoggingConfig != null) {
            if (this.zosLoggingConfigListener != null) {
                this.zosLoggingConfigListener.updated(this.zosLoggingConfig);
            }
            if (this.msgRouterConfigListener != null) {
                String hardcopyMessages;
                String wtoMessages = (String)this.zosLoggingConfig.get("wtoMessage");
                if (wtoMessages != null) {
                    this.msgRouterConfigListener.updateMessageListForHandler(wtoMessages, "WTO");
                }
                if ((hardcopyMessages = (String)this.zosLoggingConfig.get("hardCopyMessage")) != null) {
                    this.msgRouterConfigListener.updateMessageListForHandler(hardcopyMessages, "HARDCOPY");
                }
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ZosLoggingConfiguration.class);
    }
}

