/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.server.schemagen;

import com.ibm.wsspi.kernel.service.utils.PathUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Map;
import java.util.ResourceBundle;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class ServerSchemaGenCommand {
    private static final String SCRIPT_NAME = "serverSchemaGen";
    private static final ResourceBundle messages = ResourceBundle.getBundle("com.ibm.ws.config.server.schemagen.resources.SchemaGenMessages");
    private static final ResourceBundle options = ResourceBundle.getBundle("com.ibm.ws.config.server.schemagen.resources.SchemaGenOptions");
    private final PrintStream stdout;
    private final PrintStream stderr;
    private static final int RC_INVALID_OPTION = 20;
    private static final int RC_SERVER_NOT_FOUND = 21;
    private static final int RC_LOCAL_CONNECTOR_URL_NOT_FOUND = 22;
    private static final int RC_MBEAN_NOT_FOUND = 23;
    private static final int RC_MBEAN_INVALID_RESULT = 24;
    private static final int RC_UNEXPECTED_ERROR = 255;

    protected ServerSchemaGenCommand() {
        this(System.out, System.err);
    }

    private ServerSchemaGenCommand(PrintStream stdout, PrintStream stderr) {
        this.stdout = stdout;
        this.stderr = stderr;
    }

    private String getMessage(String key, Object ... args) {
        String message = messages.getString(key);
        return args.length == 0 ? message : MessageFormat.format(message, args);
    }

    private File getServerSchemaGenJar() {
        File launchHome = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("com.ibm.ws.config.server.schemagen.ServerSchemaGenCommand");
        }
        catch (Exception e) {
            return null;
        }
        URL home = clazz.getProtectionDomain().getCodeSource().getLocation();
        if (!home.getProtocol().equals("file")) {
            return null;
        }
        String path = PathUtils.normalize((String)home.getPath());
        launchHome = new File(path);
        return launchHome;
    }

    private String getInstallDir() {
        String installDir = System.getenv("WLP_INSTALL_DIR");
        if (installDir == null) {
            File serverSchemaGenJarFile = this.getServerSchemaGenJar();
            installDir = serverSchemaGenJarFile == null ? System.getProperty("user.dir") + File.separator : serverSchemaGenJarFile.getParentFile().getParentFile().getAbsolutePath() + File.separator;
        } else if (!installDir.endsWith("/") && !installDir.endsWith("\\")) {
            installDir = installDir + File.separator;
        }
        return installDir;
    }

    private String getUserDir() {
        String usrDir = System.getenv("WLP_USER_DIR");
        if (usrDir == null) {
            usrDir = this.getInstallDir() + "usr" + File.separator;
        } else if (!usrDir.endsWith("/") && !usrDir.endsWith("\\")) {
            usrDir = usrDir + File.separator;
        }
        return usrDir;
    }

    private String getOutputDir() {
        String outputDir = System.getenv("WLP_OUTPUT_DIR");
        if (outputDir == null) {
            outputDir = this.getUserDir() + "servers" + File.separator;
        } else if (!outputDir.endsWith("/") && !outputDir.endsWith("\\")) {
            outputDir = outputDir + File.separator;
        }
        return outputDir;
    }

    private String getScriptUsage() {
        return this.getMessage("usage", SCRIPT_NAME);
    }

    protected int generateServerSchema(String[] args) {
        int retCode = 0;
        try {
            String[] mbeanParams = new String[4];
            if (args == null || args.length == 0) {
                this.stdout.println(this.getScriptUsage());
                return 0;
            }
            String userDir = this.getUserDir();
            String serverName = args[0];
            File serverDirectory = new File(userDir + File.separator + "servers" + File.separator + serverName);
            if (!serverDirectory.exists() || !serverDirectory.isDirectory()) {
                this.stderr.println(this.getMessage("server.not.found", serverName, serverDirectory.getAbsolutePath()));
                this.stdout.println(this.getScriptUsage());
                return 21;
            }
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                String argToLower = arg.toLowerCase();
                if (argToLower.contains("help")) {
                    this.stdout.println(this.getScriptUsage());
                    this.stdout.println();
                    this.showUsageInfo();
                    return 0;
                }
                if (!arg.startsWith("-")) continue;
                if (argToLower.contains("-schemaversion")) {
                    mbeanParams[0] = this.getArgumentValue(args[i]);
                    continue;
                }
                if (argToLower.contains("-outputversion")) {
                    mbeanParams[1] = this.getArgumentValue(argToLower);
                    continue;
                }
                if (argToLower.contains("-encoding")) {
                    mbeanParams[2] = this.getArgumentValue(argToLower);
                    continue;
                }
                if (argToLower.contains("-locale")) {
                    mbeanParams[3] = this.getArgumentValue(argToLower);
                    continue;
                }
                this.stdout.println(MessageFormat.format(messages.getString("error.unknownArgument"), arg));
                this.stdout.println();
                return 20;
            }
            retCode = this.invokeSchemaGen(serverName, mbeanParams);
        }
        catch (Throwable t) {
            this.stderr.println(this.getMessage("exception.catch", t.toString()));
            t.printStackTrace(this.stderr);
            return 255;
        }
        return retCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private int invokeSchemaGen(String serverName, String[] mbeanParams) {
        block48: {
            block46: {
                block47: {
                    block44: {
                        block45: {
                            block42: {
                                block43: {
                                    block40: {
                                        block41: {
                                            block38: {
                                                block39: {
                                                    block36: {
                                                        block37: {
                                                            block34: {
                                                                block35: {
                                                                    jmxLocalConnectorUrlFile = new File(this.getOutputDir() + serverName + File.separator + "logs" + File.separator + "state" + File.separator + "/com.ibm.ws.jmx.local.address");
                                                                    if (!jmxLocalConnectorUrlFile.exists()) {
                                                                        this.stderr.println(this.getMessage("local.connector.not.found", new Object[]{serverName}));
                                                                        return 22;
                                                                    }
                                                                    signature = new String[]{String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName()};
                                                                    connector = null;
                                                                    br = new BufferedReader(new FileReader(jmxLocalConnectorUrlFile));
                                                                    urlString = br.readLine();
                                                                    br.close();
                                                                    if (urlString != null) break block34;
                                                                    this.stderr.println(this.getMessage("local.connector.url.empty", new Object[]{serverName}));
                                                                    var8_11 = 255;
                                                                    if (connector == null) break block35;
                                                                    try {
                                                                        connector.close();
                                                                        connector = null;
                                                                    }
                                                                    catch (Throwable t) {
                                                                        // empty catch block
                                                                    }
                                                                }
                                                                return var8_11;
                                                            }
                                                            url = new JMXServiceURL(urlString);
                                                            connector = JMXConnectorFactory.connect(url);
                                                            con = connector.getMBeanServerConnection();
                                                            name = new ObjectName("WebSphere:name=com.ibm.ws.config.serverSchemaGenerator");
                                                            objects = con.queryMBeans(name, null);
                                                            if (objects == null || objects.size() <= 0) ** GOTO lbl112
                                                            i = objects.iterator();
                                                            o = i.next();
                                                            instanceName = o.getObjectName();
                                                            generateResults = (Map)con.invoke(instanceName, "generateServerSchema", mbeanParams, signature);
                                                            if (generateResults != null) break block36;
                                                            this.stderr.println(this.getMessage("mbean.null.result", new Object[0]));
                                                            var16_24 = 24;
                                                            if (connector == null) break block37;
                                                            try {
                                                                connector.close();
                                                                connector = null;
                                                            }
                                                            catch (Throwable t) {
                                                                // empty catch block
                                                            }
                                                        }
                                                        return var16_24;
                                                    }
                                                    if (!generateResults.containsKey("keyReturnCode")) ** GOTO lbl66
                                                    success = (Integer)generateResults.get("keyReturnCode");
                                                    if (success != null && success == 0) break block38;
                                                    this.stderr.println(this.getMessage("mbean.bad.result", new Object[0]));
                                                    t = 24;
                                                    if (connector == null) break block39;
                                                    try {
                                                        connector.close();
                                                        connector = null;
                                                    }
                                                    catch (Throwable t) {
                                                        // empty catch block
                                                    }
                                                }
                                                return t;
                                            }
                                            break block40;
lbl66:
                                            // 1 sources

                                            this.stderr.println(this.getMessage("mbean.missing.result", new Object[0]));
                                            success = 24;
                                            if (connector == null) break block41;
                                            try {
                                                connector.close();
                                                connector = null;
                                            }
                                            catch (Throwable t) {
                                                // empty catch block
                                            }
                                        }
                                        return success;
                                    }
                                    outputDirectory = null;
                                    if (!generateResults.containsKey("keyFilePath")) ** GOTO lbl98
                                    outputDirectory = (String)generateResults.get("keyFilePath");
                                    if (outputDirectory != null && outputDirectory.length() > 0) break block42;
                                    this.stderr.println(this.getMessage("mbean.missing.output.dir", new Object[0]));
                                    var17_30 = 24;
                                    if (connector == null) break block43;
                                    try {
                                        connector.close();
                                        connector = null;
                                    }
                                    catch (Throwable t) {
                                        // empty catch block
                                    }
                                }
                                return var17_30;
                            }
                            this.stdout.println(this.getMessage("mbean.output.dir", new Object[]{outputDirectory}));
                            break block44;
lbl98:
                            // 1 sources

                            this.stderr.println(this.getMessage("mbean.missing.output.dir", new Object[0]));
                            var17_31 = 24;
                            if (connector == null) break block45;
                            try {
                                connector.close();
                                connector = null;
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                        }
                        return var17_31;
                    }
                    break block46;
lbl112:
                    // 1 sources

                    this.stderr.println(this.getMessage("mbean.not.found", new Object[]{serverName}));
                    var12_19 = 23;
                    if (connector == null) break block47;
                    try {
                        connector.close();
                        connector = null;
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                return var12_19;
            }
            if (connector != null) {
                try {
                    connector.close();
                    connector = null;
                }
                catch (Throwable t) {}
            }
            break block48;
            catch (Throwable t) {
                try {
                    this.stderr.println(this.getMessage("exception.catch", new Object[]{t.toString()}));
                    t.printStackTrace(this.stderr);
                    var7_10 = 255;
                    return var7_10;
                }
                catch (Throwable var19_35) {
                    throw var19_35;
                }
                finally {
                    if (connector != null) {
                        try {
                            connector.close();
                            connector = null;
                        }
                        catch (Throwable t) {}
                    }
                }
            }
        }
        return 0;
    }

    private String getArgumentValue(String arg) {
        int idx = arg.lastIndexOf("=");
        if (idx < 1) {
            throw new RuntimeException(MessageFormat.format(messages.getString("error.invalidArgument"), arg));
        }
        return arg.substring(idx + 1);
    }

    public static void main(String[] args) {
        ServerSchemaGenCommand util = new ServerSchemaGenCommand();
        int rc = util.generateServerSchema(args);
        System.exit(rc);
    }

    private void showUsageInfo() {
        String[] optionKeys = new String[]{"option-key.schemaversion", "option-key.outputversion", "option-key.encoding", "option-key.locale"};
        String okpfx = "option-key.";
        String odpfx = "option-desc.";
        this.stdout.println(options.getString("use.options"));
        this.stdout.println();
        for (String optionKey : optionKeys) {
            String option = optionKey.substring("option-key.".length());
            this.stdout.println(options.getString(optionKey));
            this.stdout.println(options.getString("option-desc." + option));
            this.stdout.println();
        }
    }
}

