/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.utils.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.apache.aries.application.modelling.ExportedService;
import org.apache.aries.application.modelling.WrappedServiceMetadata;

public class ExportedServiceHelper {
    public static String generatePortableExportedServiceToString(ExportedService svc) {
        ArrayList interfaces = new ArrayList(svc.getInterfaces());
        Collections.sort(interfaces);
        ArrayList<String> props = new ArrayList<String>();
        for (Map.Entry entry : svc.getServiceProperties().entrySet()) {
            String entryText;
            Object entryValue = entry.getValue();
            if (entryValue.getClass().isArray()) {
                Object[] entryArray = (Object[])entryValue;
                StringBuilder sb = new StringBuilder();
                for (Object o : entryArray) {
                    sb.append(String.valueOf(o) + ",");
                }
                sb = sb.deleteCharAt(sb.length() - 1);
                entryText = sb.toString();
            } else {
                entryText = String.valueOf(entryValue);
            }
            props.add("<entry> key=\"" + (String)entry.getKey() + "\" value=\"" + entryText + "\"/>");
        }
        Collections.sort(props);
        StringBuffer buf = new StringBuffer("<service>");
        if (svc.getName() != null) {
            buf.append("<name>" + svc.getName() + "</name>");
        }
        if (interfaces.size() > 0) {
            buf.append("<interfaces>");
        }
        for (String i : interfaces) {
            buf.append("<value>" + i + "</value>");
        }
        if (interfaces.size() > 0) {
            buf.append("</interfaces>");
        }
        if (svc.getServiceProperties().size() > 0) {
            buf.append("<service-properties>");
        }
        for (String p : props) {
            buf.append(p);
        }
        if (svc.getServiceProperties().size() > 0) {
            buf.append("</service-properties>");
        }
        buf.append("</service>");
        return buf.toString();
    }

    public static boolean portableExportedServiceIdenticalOrDiffersOnlyByName(ExportedService svc, WrappedServiceMetadata wsmi) {
        HashSet cmpInterfaces;
        if (svc.equals(wsmi)) {
            return true;
        }
        HashSet svcInterfaces = new HashSet(svc.getInterfaces());
        if (!((Object)svcInterfaces).equals(cmpInterfaces = new HashSet(wsmi.getInterfaces()))) {
            return false;
        }
        boolean propertiesEqual = ((Object)svc.getServiceProperties()).equals(wsmi.getServiceProperties());
        return propertiesEqual;
    }

    public static boolean portableExportedServiceEquals(ExportedService left, Object right) {
        if (!(right instanceof WrappedServiceMetadata)) {
            return false;
        }
        if (right == left) {
            return true;
        }
        boolean eq = left.toString().equals(right.toString());
        return eq;
    }

    public static int portableExportedServiceHashCode(ExportedService svc) {
        int result = svc.toString().hashCode();
        return result;
    }

    public static int portableExportedServiceCompareTo(ExportedService svc, WrappedServiceMetadata o) {
        if (o == null) {
            return -1;
        }
        int result = svc.toString().compareTo(o.toString());
        return result;
    }
}

