/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.aries.application.DeploymentContent;
import org.apache.aries.application.impl.ContentImpl;
import org.apache.aries.util.VersionRange;
import org.apache.aries.util.manifest.ManifestHeaderProcessor;
import org.osgi.framework.Version;

public final class DeploymentContentImpl
implements DeploymentContent {
    private final ContentImpl _content;

    public DeploymentContentImpl(String bundleSymbolicName, Version version) {
        HashMap<String, String> nvMap = new HashMap<String, String>();
        nvMap.put("deployed-version", version.toString());
        this._content = new ContentImpl(bundleSymbolicName, nvMap);
    }

    public DeploymentContentImpl(String deployedContent) {
        this._content = new ContentImpl(deployedContent);
    }

    public Version getExactVersion() {
        return this.getVersion().getExactVersion();
    }

    public String getAttribute(String key) {
        return this._content.getAttribute(key);
    }

    public Map<String, String> getAttributes() {
        return this._content.getAttributes();
    }

    public String getContentName() {
        return this._content.getContentName();
    }

    public String getDirective(String key) {
        return this._content.getDirective(key);
    }

    public Map<String, String> getDirectives() {
        return this._content.getDirectives();
    }

    public VersionRange getVersion() {
        String deployedVersion = this._content.getAttribute("deployed-version");
        VersionRange vr = null;
        if (deployedVersion != null && deployedVersion.length() > 0) {
            vr = ManifestHeaderProcessor.parseVersionRange((String)deployedVersion, (boolean)true);
        }
        return vr;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof DeploymentContentImpl) {
            return this._content.equals(((DeploymentContentImpl)other)._content);
        }
        return false;
    }

    public int hashCode() {
        return this._content.hashCode();
    }

    public Map<String, String> getNameValueMap() {
        return this._content.getNameValueMap();
    }

    public String toString() {
        return this._content.toString();
    }
}

