/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.rsadapter.DataStoreHelperMetaData;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.Transaction.UOWCurrent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.jca.adapter.PurgePolicy;
import com.ibm.ws.jca.adapter.WSManagedConnection;
import com.ibm.ws.jdbc.internal.DataSourceDef;
import com.ibm.ws.jdbc.osgi.JDBCRuntimeVersion;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.CommitOrRollbackOnCleanup;
import com.ibm.ws.rsadapter.ConnectionSharing;
import com.ibm.ws.rsadapter.DSConfig;
import com.ibm.ws.rsadapter.DSConfigHelper;
import com.ibm.ws.rsadapter.FFDCLogger;
import com.ibm.ws.rsadapter.exceptions.DataStoreAdapterException;
import com.ibm.ws.rsadapter.jdbc.WSJdbcConnection;
import com.ibm.ws.rsadapter.jdbc.WSJdbcUtil;
import com.ibm.ws.rsadapter.jdbc.WSJdbcWrapper;
import com.ibm.ws.rsadapter.spi.CacheMap;
import com.ibm.ws.rsadapter.spi.InternalDataStoreHelper;
import com.ibm.ws.rsadapter.spi.StatementCacheKey;
import com.ibm.ws.rsadapter.spi.WSConnectionEvent;
import com.ibm.ws.rsadapter.spi.WSConnectionRequestInfoImpl;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;
import com.ibm.ws.rsadapter.spi.WSRdbOnePhaseXaResourceImpl;
import com.ibm.ws.rsadapter.spi.WSRdbSpiLocalTransactionImpl;
import com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl;
import com.ibm.ws.rsadapter.spi.WSStateManager;
import com.ibm.ws.tx.embeddable.EmbeddableWebSphereTransactionManager;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.DissociatableManagedConnection;
import javax.resource.spi.LazyEnlistableConnectionManager;
import javax.resource.spi.LazyEnlistableManagedConnection;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.LocalTransactionException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.SecurityException;
import javax.security.auth.Subject;
import javax.sql.ConnectionEvent;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;
import javax.sql.XAConnection;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSName;

public class WSRdbManagedConnectionImpl
extends WSManagedConnection
implements DissociatableManagedConnection,
LazyEnlistableManagedConnection,
javax.sql.ConnectionEventListener,
StatementEventListener,
FFDCSelfIntrospectable {
    private boolean aborted;
    public boolean haveVendorConnectionPropertiesChanged;
    public boolean resetStmtsInCacheOnRemove;
    public Map<String, Object> CONNECTION_VENDOR_DEFAULT_PROPERTIES;
    public static final Set<String> VENDOR_PROPERTY_SETTERS = new HashSet<String>();
    public static final Set<String> VENDOR_STM_AND_CONNECTION_PROPERTY_SETTERS;
    public int connectionSharing;
    final AtomicReference<DSConfig> dsConfig;
    byte[] trustedContextCookie;
    String mc_tc_name;
    String mc_tc_realm;
    byte[] mc_tc_userSecToken;
    String mc_tc_originalUser;
    private boolean trustedConnection;
    private boolean kerberosConnection;
    GSSCredential mc_gssCredential;
    GSSName mc_gssName;
    private Boolean transactional;
    public boolean workNeedsToBeUnDone;
    boolean _claimedVictim;
    private transient boolean rrsGlobalTransactionReallyActive;
    boolean _mcStale;
    Connection sqlConn;
    private PooledConnection poolConn;
    private WSJdbcConnection[] handlesInUse;
    private int numHandlesInUse;
    private static int maxHandlesInUse;
    private ConnectionEventListener[] ivEventListeners;
    private int numListeners;
    private static final int KNOWN_NUMBER_OF_CELS = 1;
    private static final int CEL_ARRAY_INCREMENT_SIZE = 3;
    WSManagedConnectionFactoryImpl mcf;
    InternalDataStoreHelper internalHelper;
    private WSConnectionEvent connEvent;
    WSStateManager stateMgr;
    private LocalTransaction localTran;
    private XAResource xares;
    WSConnectionRequestInfoImpl cri;
    private Subject subject;
    protected boolean defaultAutoCommit;
    protected boolean currentAutoCommit;
    private boolean rrsTransactional;
    private String defaultCatalog;
    private Map<String, Class<?>> defaultTypeMap;
    private boolean defaultReadOnly;
    private String defaultSchema;
    private String currentSchema;
    private int defaultNetworkTimeout;
    public int currentNetworkTimeout;
    private int currentTransactionIsolation;
    private boolean isolationChanged;
    private boolean connectionPropertyChanged;
    private final DataStoreHelperMetaData mData;
    private int currentHoldability;
    private boolean holdabilityChanged;
    private int defaultHoldability;
    private CacheMap statementCache;
    static final Object key;
    private static final TraceComponent tc;
    boolean loggingEnabled;
    public boolean clientInfoExplicitlySet;
    public boolean clientInfoImplicitlySet;
    private String[] clientInfoHolder;
    private boolean shouldDoConPropFirstCallBeReset;
    private Properties doConnectoinSetupPerTranProps;
    private boolean is2Phase;
    boolean wasLazilyEnlisted;
    private boolean connectionErrorDetected;
    private boolean cleaningUpHandles;
    Object threadID;
    private Object sqljContext;
    protected WSJdbcConnection cachedConnection;
    boolean supportIsolvlSwitching;
    private long fatalErrorCount;
    private boolean inCleanup;

    public void setTrustedConnection() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"setting this mc to indicate its a trusted connection", (Object[])new Object[0]);
        }
        this.trustedConnection = true;
    }

    public void setKerberosConnection() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"setting this mc to indicate it was gotten using kerberos", (Object[])new Object[0]);
        }
        this.kerberosConnection = true;
    }

    public void setRrsGlobalTransactionReallyActive(boolean flag) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"setRrsGlobalTransactionReallyActive is set to: ", (Object[])new Object[]{flag});
        }
        this.rrsGlobalTransactionReallyActive = flag;
    }

    public void markStale() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"mark mc stale", (Object[])new Object[0]);
        }
        this._mcStale = true;
    }

    public boolean isMCStale() {
        return this._mcStale;
    }

    void holdCurrentClientInfo(String _clientId, String _workStation, String _applicationName, String _accountInfo) {
        this.clientInfoHolder[0] = _clientId;
        this.clientInfoHolder[1] = _workStation;
        this.clientInfoHolder[2] = _applicationName;
        this.clientInfoHolder[3] = _accountInfo;
    }

    public String[] getCurrentClientInfo() {
        return (String[])this.clientInfoHolder.clone();
    }

    public WSRdbManagedConnectionImpl(WSManagedConnectionFactoryImpl mcf1, PooledConnection poolConn1, Connection conn, Subject sub, WSConnectionRequestInfoImpl cxRequestInfo, byte[] cookie) throws ResourceException {
        boolean isTraceOn;
        block22: {
            this.haveVendorConnectionPropertiesChanged = false;
            this.resetStmtsInCacheOnRemove = false;
            this.CONNECTION_VENDOR_DEFAULT_PROPERTIES = null;
            this.workNeedsToBeUnDone = false;
            this.handlesInUse = new WSJdbcConnection[maxHandlesInUse];
            this.connEvent = new WSConnectionEvent((ManagedConnection)this);
            this.rrsTransactional = false;
            this.currentSchema = null;
            this.currentNetworkTimeout = 0;
            this.clientInfoHolder = new String[4];
            this.shouldDoConPropFirstCallBeReset = true;
            this.doConnectoinSetupPerTranProps = null;
            this.supportIsolvlSwitching = false;
            this.inCleanup = false;
            isTraceOn = TraceComponent.isAnyTracingEnabled();
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object[])new Object[]{mcf1, AdapterUtil.toString(poolConn1), AdapterUtil.toString(conn), cxRequestInfo});
            }
            this.dsConfig = mcf1.dsConfig;
            this.sqlConn = conn;
            this.poolConn = poolConn1;
            this.mcf = mcf1;
            this.internalHelper = mcf1.internalHelper;
            this.cri = cxRequestInfo;
            this.doConnectoinSetupPerTranProps = new Properties();
            this.doConnectoinSetupPerTranProps.setProperty("FIRST_TIME_CALLED", "true");
            byte[] byArray = this.trustedContextCookie = cookie == null ? null : (byte[])cookie.clone();
            if (cxRequestInfo.trustedContextIdentityAttributesAreSet) {
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"saving trusted Context attributes from cri in mc", (Object[])new Object[]{cxRequestInfo});
                }
                this.mc_tc_name = cxRequestInfo.tc_name;
                this.mc_tc_realm = cxRequestInfo.tc_realm;
                this.mc_tc_userSecToken = cxRequestInfo.tc_userSecToken;
                this.mc_tc_originalUser = cxRequestInfo.tc_originalUser;
            }
            this.is2Phase = poolConn1 instanceof XAConnection;
            DSConfig config = this.dsConfig.get();
            if (poolConn1 == null) {
                if (isTraceOn && tc.isDebugEnabled() && !DataSource.class.equals(config.type) && !config.isUCP) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"##### poolConn is null which will cause is2Phase to always be false and that will cause XA to break", (Object[])new Object[0]);
                }
            } else if (!DataSource.class.equals(config.type) && !config.isUCP) {
                poolConn1.addConnectionEventListener(this);
                if (this.mcf.jdbcVersion >= 4) {
                    try {
                        poolConn1.addStatementEventListener(this);
                    }
                    catch (UnsupportedOperationException supportX) {
                        if (isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)"JDBC driver does not support addStatementEventListener", (Object[])new Object[0]);
                        }
                    }
                    catch (AbstractMethodError methErr) {
                        if (!isTraceOn || !tc.isDebugEnabled()) break block22;
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"JDBC driver does not implement addStatementEventListener", (Object[])new Object[0]);
                    }
                }
            }
        }
        this.subject = sub == null ? null : this.copySubject(sub);
        this.ivEventListeners = new ConnectionEventListener[1];
        this.numListeners = 0;
        this.threadID = this.dsConfig.get().enableMultithreadedAccessDetection ? Thread.currentThread() : this.threadID;
        this.mData = mcf1.dataStoreHelper.getMetaData();
        this.rrsTransactional = mcf1.getRRSTransactional();
        try {
            this.defaultHoldability = mcf1.getInternalDataStoreHelper().getHoldability(this.sqlConn);
        }
        catch (SQLException sqle) {
            FFDCFilter.processException((Throwable)sqle, (String)(this.getClass().getName() + ".init()"), (String)"300", (Object)this);
            throw AdapterUtil.translateSQLException(sqle, this, true, this.getClass());
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("defaultHoldability is " + AdapterUtil.getCursorHoldabilityString(this.defaultHoldability)), (Object[])new Object[0]);
        }
        this.initializeConnectionProperties();
        if (!DSConfigHelper._disablePK54589) {
            if (!this.cri.isCRIChangable()) {
                this.cri = WSConnectionRequestInfoImpl.createChangableCRIFromNon(this.cri);
            }
            this.cri.setDefaultValues(this.defaultCatalog, this.defaultHoldability, this.defaultReadOnly, this.defaultTypeMap, this.defaultSchema, this.defaultNetworkTimeout);
        }
        this.synchronizePropertiesWithCRI();
        int statementCacheSize = this.dsConfig.get().statementCacheSize;
        if (statementCacheSize > 0) {
            this.statementCache = new CacheMap(statementCacheSize);
        }
        this.stateMgr = new WSStateManager();
        this.supportIsolvlSwitching = this.internalHelper.isIsolationLevelSwitchingSupport();
        if (this.internalHelper.shouldTraceBeEnabled(this)) {
            this.internalHelper.enableJdbcLogging(this);
        } else if (this.internalHelper.shouldTraceBeDisabled(this)) {
            this.internalHelper.disableJdbcLogging(this);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    private final void addHandle(WSJdbcConnection handle) {
        (this.numHandlesInUse < this.handlesInUse.length - 1 ? this.handlesInUse : this.resizeHandleList())[this.numHandlesInUse++] = handle;
    }

    public void afterCompletionRRS() {
        this.stateMgr.setStateNoValidate(0);
        this.setRrsGlobalTransactionReallyActive(false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Setting transaction state to NO_TRANSACTION_ACTIVE", (Object[])new Object[0]);
        }
    }

    @Override
    public void connectionClosed(ConnectionEvent event) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"connectionClosed", (Object[])new Object[]{"Notification of connection closed received from the JDBC driver", AdapterUtil.toString(event.getSource())});
        }
        this.processConnectionErrorOccurredEvent(null, event.getSQLException());
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent event) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"connectionErrorOccurred", (Object[])new Object[]{"Notification of fatal connection error received from the JDBC driver.", AdapterUtil.toString(event.getSource()), event.getSQLException()});
        }
        this.processConnectionErrorOccurredEvent(null, event.getSQLException());
    }

    public final WSConnectionRequestInfoImpl createConnectionRequestInfo() throws ResourceException {
        try {
            WSConnectionRequestInfoImpl _criHold = null;
            if (this.isolationChanged || this.connectionPropertyChanged || this.holdabilityChanged || this.cri.isCRIChangable()) {
                _criHold = new WSConnectionRequestInfoImpl(this.cri.ivUserName, this.cri.ivPassword, this.isolationChanged ? this.currentTransactionIsolation : this.cri.ivIsoLevel, this.connectionPropertyChanged && this.mData.supportsGetCatalog() ? this.getCatalog() : this.cri.ivCatalog, this.connectionPropertyChanged && this.mData.supportsIsReadOnly() ? Boolean.valueOf(this.isReadOnly()) : this.cri.ivReadOnly, this.connectionPropertyChanged && this.mData.supportsGetTypeMap() ? this.getTypeMap() : this.cri.ivTypeMap, this.holdabilityChanged ? this.getHoldability() : this.cri.ivHoldability, this.connectionPropertyChanged && this.mData.supportsGetSchema() ? this.getSchemaSafely() : this.cri.ivSchema, this.connectionPropertyChanged && this.mData.supportsGetNetworkTimeout() ? this.getNetworkTimeoutSafely() : this.cri.ivNetworkTimeout, this.cri.ivConfigID, this.cri.supportIsolvlSwitching);
                if (!DSConfigHelper._disablePK54589) {
                    _criHold.setDefaultValues(this.cri.defaultCatalog, this.cri.defaultHoldability, this.cri.defaultReadOnly, this.cri.defaultTypeMap, this.cri.defaultSchema, this.cri.defaultNetworkTimeout);
                }
                _criHold.markAsChangable();
                if (this.cri.trustedConnectionMappingIsUsed) {
                    _criHold.setPropagateClientIdUsingTc(true);
                    _criHold.setTrustedContextOriginalUser(this.mc_tc_originalUser);
                    _criHold.setTrustedContextUserName(this.mc_tc_name);
                    _criHold.setTrustedContextUserSecToken(this.mc_tc_userSecToken);
                    _criHold.setTrustedContextRealm(this.mc_tc_realm);
                }
            } else {
                _criHold = this.cri;
            }
            return _criHold;
        }
        catch (SQLException sqle) {
            FFDCFilter.processException((Throwable)sqle, (String)(this.getClass().getName() + ".createConnectionRequestInfo"), (String)"379", (Object)this);
            throw new DataStoreAdapterException("DSA_ERROR", sqle, this.getClass());
        }
    }

    private void destroyStatement(Object unwantedStatement) {
        block3: {
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Statement cache at capacity. Discarding a statement.", (Object[])new Object[]{AdapterUtil.toString(unwantedStatement)});
                }
                ((Statement)unwantedStatement).close();
            }
            catch (SQLException closeX) {
                FFDCFilter.processException((Throwable)closeX, (String)(this.getClass().getName() + ".discardStatement"), (String)"511", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Error closing statement", (Object[])new Object[]{AdapterUtil.toString(unwantedStatement), closeX});
            }
        }
    }

    final void detectMultithreadedAccess() {
        Thread currentThreadID = Thread.currentThread();
        if (currentThreadID == this.threadID) {
            return;
        }
        if (this.threadID == null) {
            this.threadID = currentThreadID;
        } else {
            this.mcf.detectedMultithreadedAccess = true;
            StringWriter writer = new StringWriter();
            new Error().printStackTrace(new PrintWriter(writer));
            Tr.warning((TraceComponent)tc, (String)"MULTITHREADED_ACCESS_DETECTED", (Object[])new Object[]{this, Integer.toHexString(this.threadID.hashCode()) + ' ' + this.threadID, Integer.toHexString(currentThreadID.hashCode()) + ' ' + currentThreadID, writer.getBuffer().delete(0, "java.lang.Error".length())});
        }
    }

    public void dissociateConnections() throws ResourceException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"dissociateConnections", (Object[])new Object[0]);
        }
        ResourceException firstX = null;
        this.cleaningUpHandles = true;
        int i = this.numHandlesInUse;
        while (i > 0) {
            try {
                this.handlesInUse[--i].dissociate();
                this.handlesInUse[i] = null;
            }
            catch (ResourceException dissociationX) {
                dissociationX = this.processHandleDissociationError(i, dissociationX);
                if (firstX != null) continue;
                firstX = dissociationX;
            }
        }
        this.numHandlesInUse = 0;
        this.cleaningUpHandles = false;
        if (firstX != null) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"dissociateConnections", (Object)((Object)firstX));
            }
            throw firstX;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"dissociateConnections");
        }
    }

    public final void enforceAutoCommit(boolean autoCommit) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"enforceAutoCommit", (Object[])new Object[]{autoCommit});
        }
        if (autoCommit != this.currentAutoCommit || this.internalHelper.alwaysSetAutoCommit()) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("currentAutoCommit: " + this.currentAutoCommit + " --> " + autoCommit), (Object[])new Object[0]);
            }
            this.sqlConn.setAutoCommit(autoCommit);
            this.currentAutoCommit = autoCommit;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"enforceAutoCommit");
        }
    }

    public void enlistRRS() {
        this.stateMgr.setStateNoValidate(7);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Setting transaction state to RRS_GLOBAL_TRANSACTION_ACTIVE", (Object[])new Object[0]);
        }
    }

    protected void finalize() throws Throwable {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"finalize", (Object[])new Object[0]);
        }
        if (this.numHandlesInUse > 0) {
            this.fatalErrorCount = -1L;
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)(this.numHandlesInUse + " connection handles were left open by the application."), (Object[])new Object[0]);
            }
            this.cleaningUpHandles = false;
            while (this.numHandlesInUse > 0) {
                this.processConnectionClosedEvent(this.handlesInUse[0]);
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"finalize");
        }
    }

    public final String getCatalog() throws SQLException {
        return this.sqlConn.getCatalog();
    }

    public final int getCurrentNetworkTimeout() {
        return this.currentNetworkTimeout;
    }

    public final String getCurrentSchema() {
        return this.currentSchema;
    }

    public final DataStoreHelperMetaData getDataStoreHelperMetaData() {
        return this.mData;
    }

    public final boolean getDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public final int getHandleCount() {
        return this.numHandlesInUse;
    }

    private CacheMap getStatementCache() {
        int newSize = this.dsConfig.get().statementCacheSize;
        if (this.statementCache == null && newSize > 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"enable statement cache with size", (Object[])new Object[]{newSize});
            }
            this.statementCache = new CacheMap(newSize);
        } else if (this.statementCache != null && this.statementCache.getMaxSize() != newSize) {
            Object[] discards;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"resize statement cache to", (Object[])new Object[]{newSize});
            }
            CacheMap oldCache = this.statementCache;
            this.statementCache = newSize > 0 ? new CacheMap(newSize) : null;
            for (Object stmt : discards = newSize > 0 ? this.statementCache.addAll(oldCache) : oldCache.removeAll()) {
                this.destroyStatement(stmt);
            }
        }
        return this.statementCache;
    }

    public final Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.sqlConn.getTypeMap();
    }

    public Map<String, Class<?>> getTypeMapSafely() throws SQLException {
        if (!this.mData.supportsGetTypeMap()) {
            return this.defaultTypeMap;
        }
        try {
            return this.getTypeMap();
        }
        catch (SQLException e) {
            if (AdapterUtil.isUnsupportedException(e)) {
                this.mData.setGetTypeMapSupport(false);
                return this.defaultTypeMap;
            }
            throw e;
        }
    }

    public final boolean inGlobalTransaction() {
        int state = this.stateMgr.transtate;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"state == WSStateManager.GLOBAL_TRANSACTION_ACTIVE", (Object[])new Object[]{state == 2});
            Tr.debug((Object)this, (TraceComponent)tc, (String)"state == WSStateManager.RRS_GLOBAL_TRANSACTION_ACTIVE", (Object[])new Object[]{state == 7});
            Tr.debug((Object)this, (TraceComponent)tc, (String)"rrsGlobalTransactionReallyActive is: ", (Object[])new Object[]{this.rrsGlobalTransactionReallyActive});
            Tr.debug((Object)this, (TraceComponent)tc, (String)"(wasLazilyEnlisted && state == WSStateManager.LOCAL_TRANSACTION_ACTIVE)", (Object[])new Object[]{this.wasLazilyEnlisted && state == 1});
            Tr.debug((Object)this, (TraceComponent)tc, (String)"wasLazilyEnlisted", (Object[])new Object[]{this.wasLazilyEnlisted});
            Tr.debug((Object)this, (TraceComponent)tc, (String)"state == WSStateManager.LOCAL_TRANSACTION_ACTIVE", (Object[])new Object[]{state == 1});
        }
        return state == 2 || state == 7 || this.wasLazilyEnlisted && state == 1;
    }

    private void initializeConnectionProperties() throws ResourceException {
        try {
            if (this.rrsTransactional) {
                this.defaultAutoCommit = true;
                this.currentAutoCommit = true;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"MCF is rrsTransactional:  forcing currentAutoCommit and defaultAutoCommit to true", (Object[])new Object[0]);
                }
            } else {
                this.currentAutoCommit = this.defaultAutoCommit = this.sqlConn.getAutoCommit();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("MCF is NOT rrsTransactional:  setting currentAutoCommit and defaultAutoCommit to " + this.defaultAutoCommit + " from underlying Connection"), (Object[])new Object[0]);
                }
            }
            this.defaultCatalog = this.mData.supportsGetCatalog() ? this.sqlConn.getCatalog() : null;
            this.defaultReadOnly = this.mData.supportsIsReadOnly() ? this.sqlConn.isReadOnly() : false;
            this.defaultTypeMap = this.getTypeMapSafely();
            this.currentSchema = this.defaultSchema = this.getSchemaSafely();
            this.currentNetworkTimeout = this.defaultNetworkTimeout = this.getNetworkTimeoutSafely();
            this.currentHoldability = this.defaultHoldability;
            this.currentTransactionIsolation = this.sqlConn.getTransactionIsolation();
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".initializeConnectionProperties"), (String)"381", (Object)this);
            throw new DataStoreAdapterException("DSA_ERROR", sqlX, this.getClass());
        }
    }

    public String[] introspectSelf() {
        int i;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"introspectSelf", (Object[])new Object[0]);
        }
        FFDCLogger info = new FFDCLogger(this);
        info.append(this.is2Phase ? "TWO PHASE ENABLED" : "ONE PHASE ENABLED");
        info.append("Connection sharing: ", this.connectionSharing);
        info.append("Transaction State:", this.getTransactionStateAsString());
        info.append("Key:", key);
        info.append("Log Writer:", this.mcf == null ? null : this.mcf.logWriter);
        info.append("Subject:", this.subject == null ? null : "NON-NULL");
        info.append("ManagedConnection:", this);
        info.append("Counter of fatal connection errors for the ManagedConnectionFactory as of the most recent getConnection on this ManagedConnection:", this.fatalErrorCount);
        info.append("Default AutoCommit:", this.defaultAutoCommit);
        info.append("Current AutoCommit:", this.currentAutoCommit);
        info.append("Current Isolation:", AdapterUtil.getIsolationLevelString(this.currentTransactionIsolation));
        info.append("Isolation level has changed? :", this.isolationChanged);
        info.append("Support isolation level switching: ", this.supportIsolvlSwitching);
        info.append("The tc name is: ").append(this.mc_tc_name);
        info.append("The tc original user is: ").append(this.mc_tc_originalUser);
        info.append("The tc releam  is: ").append(this.mc_tc_realm);
        info.append("The tc user security token is: ").append(Arrays.toString(this.mc_tc_userSecToken));
        info.append("The gssCredential is: ").append(this.mc_gssCredential == null ? null : this.mc_gssCredential.toString());
        info.append("The gssName is: ").append(this.mc_gssName == null ? null : this.mc_gssName.toString());
        info.append("Catalog, IsReadOnly, TypeMap, Schema, or NetworkTimeout has changed? :", this.connectionPropertyChanged ? Boolean.TRUE : Boolean.FALSE);
        info.append("Default Holdability:", AdapterUtil.getCursorHoldabilityString(this.defaultHoldability));
        info.append("Current Holdability:", AdapterUtil.getCursorHoldabilityString(this.currentHoldability));
        info.append("Holdability value has changed? :", this.holdabilityChanged ? Boolean.TRUE : Boolean.FALSE);
        info.append("Thread ID:", this.threadID);
        info.append("Lazily enlisted in the current transaction? :", this.wasLazilyEnlisted ? Boolean.TRUE : Boolean.FALSE);
        info.append("Underlying Connection Object: " + AdapterUtil.toString(this.sqlConn), this.sqlConn);
        info.append("Underlying PooledConnection Object: " + AdapterUtil.toString(this.poolConn), this.poolConn);
        info.append("SQLJ Default Context: " + AdapterUtil.toString(this.sqljContext), this.sqljContext);
        info.append("Fatal connection error was detected? :", this.connectionErrorDetected ? Boolean.TRUE : Boolean.FALSE);
        info.append("Currently cleaning up handles? :", this.cleaningUpHandles ? Boolean.TRUE : Boolean.FALSE);
        info.append("Last ConnectionEvent sent for this ManagedConnection:");
        info.indent(AdapterUtil.toString((Object)this.connEvent));
        info.indent("Connection Handle: " + this.connEvent.getConnectionHandle());
        info.indent("Event ID: " + AdapterUtil.getConnectionEventString(this.connEvent.getId()));
        info.indent("Exception: " + this.connEvent.getException());
        info.eoln();
        info.append("Connection Event Listeners:");
        for (i = 0; i < this.numListeners; ++i) {
            try {
                info.indent(this.ivEventListeners[i]);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayX) {
                // empty catch block
            }
        }
        info.eoln();
        info.append("Maximum Handle List Size: " + maxHandlesInUse);
        info.append("Handle Count: " + this.numHandlesInUse);
        info.append("Handles:");
        if (this.handlesInUse != null) {
            try {
                for (i = 0; i < this.handlesInUse.length; ++i) {
                    info.indent(this.handlesInUse[i]);
                }
            }
            catch (Throwable th) {
                // empty catch block
            }
        }
        info.eoln();
        info.introspect("State Manager:", this.stateMgr);
        try {
            if (this.xares instanceof WSRdbXaResourceImpl) {
                ((WSRdbXaResourceImpl)((Object)this.xares)).introspectThisClassOnly(info);
            } else if (this.xares instanceof WSRdbOnePhaseXaResourceImpl) {
                ((WSRdbOnePhaseXaResourceImpl)((Object)this.xares)).introspectThisClassOnly(info);
            } else {
                info.append("XA Resource:", this.xares);
            }
        }
        catch (NullPointerException nullX) {
            // empty catch block
        }
        if (this.localTran == null) {
            info.append("SPI LocalTransaction :", "null");
        } else {
            try {
                ((WSRdbSpiLocalTransactionImpl)this.localTran).introspectThisClassOnly(info);
            }
            catch (NullPointerException nullX) {
                // empty catch block
            }
        }
        if (this.statementCache == null) {
            info.append("Statement Cache:", "null");
        } else {
            try {
                info.append("Statement Cache:", this.statementCache.display());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        info.introspect("ConnectionRequestInfo", (Object)this.cri);
        info.introspect("ManagedConnectionFactory", (Object)this.mcf);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"introspectSelf");
        }
        return info.toStringArray();
    }

    public final boolean is2Phase() {
        return this.is2Phase;
    }

    final boolean isEnlistmentDisabled() {
        return !this.isTransactional();
    }

    public final boolean isGlobalTransactionActive() {
        UOWCurrent uow = (UOWCurrent)this.mcf.connectorSvc.getTransactionManager();
        UOWCoordinator coord = uow == null ? null : uow.getUOWCoord();
        return coord != null && coord.isGlobal();
    }

    public final boolean isTransactional() {
        if (this.transactional == null) {
            this.transactional = this.mcf.dsConfig.get().transactional;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"transactional=", (Object[])new Object[]{this.transactional});
            }
        }
        return this.transactional;
    }

    public final boolean isReadOnly() throws SQLException {
        return this.sqlConn.isReadOnly();
    }

    public final boolean isStatementCachingEnabled() {
        return this.getStatementCache() != null;
    }

    private static final boolean match(Object obj1, Object obj2) {
        return obj1 == obj2 || obj1 != null && obj1.equals(obj2);
    }

    public void processConnectionClosedEvent(WSJdbcConnection handle) throws ResourceException {
        if (this.cleaningUpHandles) {
            return;
        }
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        this.connEvent.recycle(1, null, handle);
        if (isTraceOn && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"Firing CONNECTION CLOSED", (Object[])new Object[]{handle});
        }
        try {
            this.removeHandle(handle);
        }
        catch (NullPointerException nullX) {
            if (this.handlesInUse == null) {
                if (isTraceOn && tc.isEventEnabled()) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)"ManagedConnection already closed", (Object[])new Object[0]);
                }
                return;
            }
            throw nullX;
        }
        if (this.numHandlesInUse == 0) {
            try {
                this.internalHelper.processLastHandleClosed(this.sqlConn, this.currentAutoCommit, this.inGlobalTransaction());
            }
            catch (SQLException sqle) {
                FFDCFilter.processException((Throwable)sqle, (String)(this.getClass().getName() + ".processConnectionClosedEvent"), (String)"1467", (Object)this);
                throw new DataStoreAdapterException("DSA_ERROR", sqle, this.getClass());
            }
            if (this.haveVendorConnectionPropertiesChanged) {
                try {
                    this.internalHelper.doConnectionVendorPropertyReset(this.sqlConn, this.CONNECTION_VENDOR_DEFAULT_PROPERTIES);
                }
                catch (SQLException sqle) {
                    FFDCFilter.processException((Throwable)sqle, (String)this.getClass().getName(), (String)"1905", (Object)this);
                    throw new DataStoreAdapterException("DSA_ERROR", sqle, this.getClass());
                }
                this.haveVendorConnectionPropertiesChanged = false;
            }
        }
        for (int i = 0; i < this.numListeners; ++i) {
            this.ivEventListeners[i].connectionClosed((javax.resource.spi.ConnectionEvent)this.connEvent);
        }
    }

    private ResourceException processHandleDissociationError(int handleIndex, ResourceException dissociationX) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"processHandleDissociationError", (Object[])new Object[]{handleIndex, dissociationX.getMessage()});
        }
        WSJdbcConnection handle = this.handlesInUse[handleIndex];
        String errCode = dissociationX.getErrorCode();
        if (errCode != null && errCode.equals("HANDLE_IN_USE") && handle != null) {
            try {
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Unable to dissociate handle because it is doing work in the database.  Closing it instead.", (Object[])new Object[]{this.handlesInUse[handleIndex]});
                }
                handle.close();
                dissociationX = null;
            }
            catch (SQLException closeX) {
                dissociationX = AdapterUtil.createDataStoreAdapterException("DSA_ERROR", closeX, closeX, this.getClass());
            }
        }
        if (dissociationX != null) {
            FFDCFilter.processException((Throwable)dissociationX, (String)(this.getClass().getName() + ".processHandleDissociationError"), (String)"1024", (Object)this);
            if (isTraceOn && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)"Error dissociating handle. Continuing...", (Object[])new Object[]{handle});
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"processHandleDissociationError", (Object)(dissociationX == null ? null : dissociationX.getMessage()));
        }
        return dissociationX;
    }

    public void processLocalTransactionStartedEvent(Object handle) throws ResourceException {
        ResourceException re;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn) {
            if (tc.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)tc, (String)"processLocalTransactionStartedEvent", (Object[])new Object[]{handle});
            }
            if (tc.isDebugEnabled()) {
                String cId = null;
                try {
                    cId = this.mcf.getCorrelator(this);
                }
                catch (SQLException x) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"got an exception trying to get the correlator in commit, exception is: ", (Object[])new Object[]{x});
                }
                if (cId != null) {
                    StringBuffer stbuf = new StringBuffer(200);
                    stbuf.append("Correlator: DB2, ID: ");
                    stbuf.append(cId);
                    if (this.xares != null) {
                        stbuf.append(" Transaction : ");
                        stbuf.append(this.xares);
                    }
                    stbuf.append(" BEGIN");
                    Tr.debug((Object)this, (TraceComponent)tc, (String)stbuf.toString(), (Object[])new Object[0]);
                }
            }
        }
        if ((re = this.stateMgr.isValid(1)) == null) {
            if (this.currentAutoCommit) {
                try {
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"current autocommit is true, set to false", (Object[])new Object[0]);
                    }
                    this.setAutoCommit(false);
                }
                catch (SQLException sqle) {
                    FFDCFilter.processException((Throwable)sqle, (String)(this.getClass().getName() + ".processLocalTransactionStartedEvent"), (String)"550", (Object)this);
                    throw new DataStoreAdapterException("DSA_ERROR", sqle, this.getClass());
                }
            }
        } else {
            throw re;
        }
        this.stateMgr.transtate = 1;
        this.connEvent.recycle(2, null, handle);
        if (isTraceOn && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("Firing LOCAL TRANSACTION STARTED event for: " + handle), (Object[])new Object[]{this});
        }
        for (int i = 0; i < this.numListeners; ++i) {
            this.ivEventListeners[i].localTransactionStarted((javax.resource.spi.ConnectionEvent)this.connEvent);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"processLocalTransactionStartedEvent", (Object)handle);
        }
    }

    public void processLocalTransactionCommittedEvent(Object handle) throws ResourceException {
        ResourceException re;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn) {
            if (tc.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)tc, (String)"processLocalTransactionCommittedEvent", (Object[])new Object[]{handle});
            }
            if (tc.isDebugEnabled()) {
                String cId = null;
                try {
                    cId = this.mcf.getCorrelator(this);
                }
                catch (SQLException x) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"got an exception trying to get the correlator in commit, exception is: ", (Object[])new Object[]{x});
                }
                if (cId != null) {
                    StringBuffer stbuf = new StringBuffer(200);
                    stbuf.append("Correlator: DB2, ID: ");
                    stbuf.append(cId);
                    if (this.xares != null) {
                        stbuf.append(" Transaction : ");
                        stbuf.append(this.xares);
                    }
                    stbuf.append(" COMMIT");
                    Tr.debug((Object)this, (TraceComponent)tc, (String)stbuf.toString(), (Object[])new Object[0]);
                }
            }
        }
        if ((re = this.stateMgr.isValid(2)) == null) {
            if (!this.currentAutoCommit) {
                try {
                    this.sqlConn.commit();
                }
                catch (SQLException se) {
                    FFDCFilter.processException((Throwable)se, (String)"com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.processLocalTransactionCommittedEvent", (String)"554", (Object)this);
                    throw AdapterUtil.translateSQLException(se, this, true, this.getClass());
                }
            }
        } else {
            throw re;
        }
        this.stateMgr.transtate = 0;
        this.connEvent.recycle(3, null, handle);
        if (isTraceOn && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("Firing LOCAL TRANSACTION COMMITTED event for: " + handle), (Object[])new Object[]{this});
        }
        for (int i = 0; i < this.numListeners; ++i) {
            this.ivEventListeners[i].localTransactionCommitted((javax.resource.spi.ConnectionEvent)this.connEvent);
        }
        this.wasLazilyEnlisted = false;
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"processLocalTransactionCommittedEvent");
        }
    }

    public void processLocalTransactionRolledbackEvent(Object handle) throws ResourceException {
        ResourceException re;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn) {
            if (tc.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)tc, (String)"processLocalTransactionRolledbackEvent", (Object[])new Object[0]);
            }
            if (tc.isDebugEnabled()) {
                String cId = null;
                try {
                    cId = this.mcf.getCorrelator(this);
                }
                catch (SQLException x) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"got an exception trying to get the correlator in commit, exception is: ", (Object[])new Object[]{x});
                }
                if (cId != null) {
                    StringBuffer stbuf = new StringBuffer(200);
                    stbuf.append("Correlator: DB2, ID: ");
                    stbuf.append(cId);
                    if (this.xares != null) {
                        stbuf.append(" Transaction : ");
                        stbuf.append(this.xares);
                    }
                    stbuf.append(" ROLLBACK");
                    Tr.debug((Object)this, (TraceComponent)tc, (String)stbuf.toString(), (Object[])new Object[0]);
                }
            }
        }
        if ((re = this.stateMgr.isValid(3)) == null) {
            if (!this.currentAutoCommit) {
                try {
                    this.sqlConn.rollback();
                }
                catch (SQLException se) {
                    FFDCFilter.processException((Throwable)se, (String)"com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.processLocalTransactionRolledbackEvent", (String)"595", (Object)this);
                    throw AdapterUtil.translateSQLException(se, this, true, this.getClass());
                }
            }
        } else {
            throw re;
        }
        this.stateMgr.transtate = 0;
        this.connEvent.recycle(4, null, handle);
        if (isTraceOn && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("Firing LOCAL TRANSACTION ROLLEDBACK event for: " + handle), (Object[])new Object[]{this});
        }
        for (int i = 0; i < this.numListeners; ++i) {
            this.ivEventListeners[i].localTransactionRolledback((javax.resource.spi.ConnectionEvent)this.connEvent);
        }
        this.wasLazilyEnlisted = false;
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"processLocalTransactionRolledbackEvent");
        }
    }

    public void processConnectionErrorOccurredEvent(Object handle, Exception ex) {
        this.processConnectionErrorOccurredEvent(handle, ex, true);
    }

    public void processConnectionErrorOccurredEvent(Object handle, Exception ex, boolean logEvent) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (this.inCleanup) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"An error occured during connection cleanup. Since the container drives the cleanup op, it will directly receive the exception.", (Object[])new Object[0]);
            }
            return;
        }
        if (this.connectionErrorDetected) {
            if (isTraceOn && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)"CONNECTION_ERROR_OCCURRED event already fired", (Object[])new Object[0]);
            }
            return;
        }
        if (ex instanceof SQLException && this.mcf.internalHelper.isAnAuthorizationException((SQLException)ex)) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"CONNECTION_ERROR_OCCURRED will fire an event to only purge and destroy this connection", (Object[])new Object[0]);
            }
            this.connectionErrorDetected = true;
            this.closeHandles();
            this.connEvent.recycle(51, ex, handle);
            if (isTraceOn && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)"Firing Single CONNECTION_ERROR_OCCURRED", (Object[])new Object[]{handle});
            }
            for (int i = 0; i < this.numListeners; ++i) {
                this.ivEventListeners[i].connectionErrorOccurred((javax.resource.spi.ConnectionEvent)this.connEvent);
            }
            return;
        }
        this.mcf.fatalErrorCount.incrementAndGet();
        if (this.mcf.oracleRACXARetryDelay > 0L) {
            this.mcf.oracleRACLastStale.set(System.currentTimeMillis());
        }
        this.connectionErrorDetected = true;
        this.closeHandles();
        this.connEvent.recycle(logEvent ? 5 : 52, ex, handle);
        if (isTraceOn && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("Firing " + (logEvent ? "CONNECTION_ERROR_OCCURRED" : "CONNECTION_ERROR_OCCURRED_NO_EVENT")), (Object[])new Object[]{handle});
        }
        for (int i = 0; i < this.numListeners; ++i) {
            this.ivEventListeners[i].connectionErrorOccurred((javax.resource.spi.ConnectionEvent)this.connEvent);
        }
    }

    @Override
    public void statementClosed(StatementEvent event) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"statementClosed", (Object[])new Object[]{"Notification of statement closed received from the JDBC driver", AdapterUtil.toString(event.getSource()), AdapterUtil.toString(event.getStatement())});
        }
    }

    @Override
    public void statementErrorOccurred(StatementEvent event) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"statementErrorOccurred", (Object[])new Object[]{"Notification of a fatal statement error received from the JDBC driver", AdapterUtil.toString(event.getSource()), AdapterUtil.toString(event.getStatement()), event.getSQLException()});
        }
        for (int i = 0; i < this.numHandlesInUse; ++i) {
            this.handlesInUse[i].setPoolableFlag(event.getStatement(), false);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"statementErrorOccurred");
        }
    }

    public void lazyEnlist(LazyEnlistableConnectionManager lazyEnlistableConnectionManager) throws ResourceException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn) {
            if (tc.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)tc, (String)"lazyEnlist", (Object[])new Object[]{lazyEnlistableConnectionManager});
            }
            if (tc.isDebugEnabled()) {
                String cId = null;
                try {
                    cId = this.mcf.getCorrelator(this);
                }
                catch (SQLException x) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"got an exception trying to get the correlator in commit, exception is: ", (Object[])new Object[]{x});
                }
                if (cId != null) {
                    StringBuffer stbuf = new StringBuffer(200);
                    stbuf.append("Correlator: DB2, ID: ");
                    stbuf.append(cId);
                    if (this.xares != null) {
                        stbuf.append(" Transaction : ");
                        stbuf.append(this.xares);
                        stbuf.append(" BEGIN");
                    }
                    Tr.debug((Object)this, (TraceComponent)tc, (String)stbuf.toString(), (Object[])new Object[0]);
                }
            }
        }
        if (this.wasLazilyEnlisted) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"lazyEnlist", (Object)"already enlisted");
            }
        } else {
            lazyEnlistableConnectionManager.lazyEnlist((ManagedConnection)this);
            this.wasLazilyEnlisted |= this.stateMgr.transtate != 0;
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"lazyEnlist", (Object)this.wasLazilyEnlisted);
            }
        }
    }

    private final boolean removeHandle(WSJdbcConnection handle) {
        int i = this.numHandlesInUse;
        while (i > 0) {
            if (handle != this.handlesInUse[--i]) continue;
            this.handlesInUse[i] = this.handlesInUse[--this.numHandlesInUse];
            this.handlesInUse[this.numHandlesInUse] = null;
            return true;
        }
        return false;
    }

    private void replaceCRI(WSConnectionRequestInfoImpl newCRI) throws ResourceException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"replaceCRI", (Object[])new Object[]{"Current:", this.cri, "New:", newCRI});
        }
        if (this.numHandlesInUse > 0 || !this.cri.isReconfigurable(newCRI, false)) {
            if (this.numHandlesInUse > 0) {
                DataStoreAdapterException resX = AdapterUtil.createDataStoreAdapterException("WS_INTERNAL_ERROR", new Object[]{"ConnectionRequestInfo cannot be changed on a ManagedConnection with active handles.", AdapterUtil.EOLN + "Existing CRI: " + (Object)((Object)this.cri), AdapterUtil.EOLN + "Requested CRI: " + (Object)((Object)newCRI)}, null, this.getClass());
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"replaceCRI", (Object)((Object)resX));
                }
                throw resX;
            }
            DataStoreAdapterException resX = AdapterUtil.createDataStoreAdapterException("WS_INTERNAL_ERROR", new Object[]{"ConnectionRequestInfo cannot be changed because the users, passwords, or DataSource configurations do not match.", AdapterUtil.EOLN + "Existing CRI: " + (Object)((Object)this.cri), AdapterUtil.EOLN + "Requested CRI: " + (Object)((Object)newCRI)}, null, this.getClass());
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"replaceCRI", (Object)((Object)resX));
            }
            throw resX;
        }
        if (!DSConfigHelper._disablePK54589) {
            if (!newCRI.isCRIChangable()) {
                newCRI = WSConnectionRequestInfoImpl.createChangableCRIFromNon(newCRI);
            }
            newCRI.setDefaultValues(this.defaultCatalog, this.defaultHoldability, this.defaultReadOnly, this.defaultTypeMap, this.defaultSchema, this.defaultNetworkTimeout);
        }
        this.cri = newCRI;
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"replaceCRI");
        }
    }

    private void replaceCRIForCCI(WSConnectionRequestInfoImpl newCRI) throws ResourceException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"replaceCRIForCCI", (Object[])new Object[]{"Current:", this.cri, "New:", newCRI});
        }
        if (this.numHandlesInUse > 0 && !this.supportIsolvlSwitching) {
            DataStoreAdapterException resX = AdapterUtil.createDataStoreAdapterException("WS_INTERNAL_ERROR", new Object[]{"ConnectionRequestInfo cannot be changed on a ManagedConnection with active handles.", AdapterUtil.EOLN + "Existing CRI: " + (Object)((Object)this.cri), AdapterUtil.EOLN + "Requested CRI: " + (Object)((Object)newCRI)}, null, this.getClass());
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"replaceCRIForCCI", (Object)((Object)resX));
            }
            throw resX;
        }
        if (!DSConfigHelper._disablePK54589) {
            if (!newCRI.isCRIChangable()) {
                newCRI = WSConnectionRequestInfoImpl.createChangableCRIFromNon(newCRI);
            }
            newCRI.setDefaultValues(this.defaultCatalog, this.defaultHoldability, this.defaultReadOnly, this.defaultTypeMap, this.defaultSchema, this.defaultNetworkTimeout);
        }
        this.cri = newCRI;
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"replaceCRIForCCI");
        }
    }

    private WSJdbcConnection[] resizeHandleList() {
        this.handlesInUse = new WSJdbcConnection[maxHandlesInUse > this.numHandlesInUse ? maxHandlesInUse : (maxHandlesInUse = this.numHandlesInUse * 2)];
        System.arraycopy(this.handlesInUse, 0, this.handlesInUse, 0, this.numHandlesInUse);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Handle limit increased to: " + maxHandlesInUse), (Object[])new Object[0]);
        }
        return this.handlesInUse;
    }

    private void synchronizePropertiesWithCRI() throws ResourceException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        int previousTransactionIsolation = -1;
        int previousHoldability = -1;
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"synchronizePropertiesWithCRI", (Object[])new Object[0]);
        }
        try {
            this.isolationChanged = false;
            this.holdabilityChanged = false;
            if (this.trustedConnection) {
                if (!(WSRdbManagedConnectionImpl.match(this.mc_tc_name, this.cri.tc_name) && WSRdbManagedConnectionImpl.match(this.mc_tc_realm, this.cri.tc_realm) && WSRdbManagedConnectionImpl.match(this.mc_tc_originalUser, this.cri.tc_originalUser) && Arrays.equals(this.mc_tc_userSecToken, this.cri.tc_userSecToken))) {
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"synching security attributes on this mc and then clearing ps cache", (Object[])new Object[0]);
                    }
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"datasource is configured with Trusted Context without Authentication (i.e. useTrustedContextWithAuthentication is not set or set to false)", (Object[])new Object[0]);
                    }
                    if (this.statementCache != null) {
                        this.clearStatementCache();
                    }
                    this.mcf.internalHelper.reuseTrustedConnection(this.sqlConn, this.trustedContextCookie, this.cri.tc_name, null, this.cri.tc_realm, this.cri.tc_userSecToken, this.cri.tc_originalUser, null);
                    this.mc_tc_name = this.cri.tc_name;
                    this.mc_tc_originalUser = this.cri.tc_originalUser;
                    this.mc_tc_realm = this.cri.tc_realm;
                    this.mc_tc_userSecToken = this.cri.tc_userSecToken;
                    this.handleCleanReuse();
                }
            } else if (this.kerberosConnection && !AdapterUtil.matchGSSName(this.mc_gssName, this.cri.gssName)) {
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"synching kerberos gssCredential on this mc and then clearing ps cache", (Object[])new Object[0]);
                }
                if (this.statementCache != null) {
                    this.clearStatementCache();
                }
                this.mcf.internalHelper.reuseKerbrosConnection(this.sqlConn, this.cri.gssCredential, null);
                this.mc_gssCredential = this.cri.gssCredential;
                this.mc_gssName = this.cri.gssName;
                this.handleCleanReuse();
            }
            previousTransactionIsolation = this.getTransactionIsolation();
            previousHoldability = this.currentHoldability;
            if (this.currentTransactionIsolation != this.cri.ivIsoLevel) {
                this.setTransactionIsolation(this.cri.ivIsoLevel);
            }
            if (DSConfigHelper._disablePK54589) {
                if (this.cri.ivCatalog != null && this.defaultCatalog != this.cri.ivCatalog && this.mData.supportsGetCatalog()) {
                    this.setCatalog(this.cri.ivCatalog);
                }
            } else if (this.cri.ivCatalog != null && !this.cri.ivCatalog.equals(this.defaultCatalog) && this.mData.supportsGetCatalog()) {
                this.setCatalog(this.cri.ivCatalog);
            }
            if (this.cri.ivReadOnly != null && this.defaultReadOnly != this.cri.ivReadOnly && this.mData.supportsIsReadOnly()) {
                this.internalHelper.setReadOnly(this, this.cri.ivReadOnly, false);
            }
            if (this.cri.ivTypeMap != null && this.defaultTypeMap != this.cri.ivTypeMap && this.mData.supportsGetTypeMap()) {
                this.setTypeMap(this.cri.ivTypeMap);
            }
            if (this.mData.supportsGetNetworkTimeout() && this.cri.ivNetworkTimeout != this.currentNetworkTimeout) {
                ExecutorService libertyThreadPool = this.mcf.connectorSvc.getLibertyThreadPool();
                this.setNetworkTimeout(libertyThreadPool, this.cri.ivNetworkTimeout);
            }
            if (this.mData.supportsGetSchema() && (this.cri.ivSchema != null || this.defaultSchema != null)) {
                String targetSchema;
                String string = targetSchema = this.cri.ivSchema == null ? this.defaultSchema : this.cri.ivSchema;
                if (!AdapterUtil.match(this.currentSchema, targetSchema)) {
                    this.setSchema(targetSchema);
                }
            }
            if (this.defaultHoldability != 0) {
                int targetHoldability;
                int n = targetHoldability = this.cri.ivHoldability == 0 ? this.defaultHoldability : this.cri.ivHoldability;
                if (this.currentHoldability != targetHoldability) {
                    this.setHoldability(targetHoldability);
                }
            }
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".synchronizePropertiesWithCRI"), (String)"850", (Object)this);
            ResourceException x = AdapterUtil.translateSQLException(sqlX, this, true, this.getClass());
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"synchronizePropertiesWithCRI", (Object)sqlX);
            }
            throw x;
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"previous/current value:", (Object[])new Object[]{"AutoCommit:    " + this.currentAutoCommit + "/" + this.currentAutoCommit, "Isolation:     " + AdapterUtil.getIsolationLevelString(previousTransactionIsolation) + "/" + AdapterUtil.getIsolationLevelString(this.currentTransactionIsolation), "Catalog:       " + this.defaultCatalog + "/" + (this.cri.ivCatalog == null ? this.defaultCatalog : this.cri.ivCatalog), "Schema:        " + this.defaultSchema + "/" + (this.cri.ivSchema == null ? this.defaultSchema : this.cri.ivSchema), "NetworkTimeout:" + this.defaultNetworkTimeout + "/" + (this.cri.ivNetworkTimeout == 0 ? this.defaultNetworkTimeout : this.cri.ivNetworkTimeout), "IsReadOnly:    " + this.defaultReadOnly + "/" + (this.cri.ivReadOnly == null ? this.defaultReadOnly : this.cri.ivReadOnly), "TypeMap:       " + this.defaultTypeMap + "/" + (this.cri.ivTypeMap == null ? this.defaultTypeMap : this.cri.ivTypeMap), "Holdability:   " + AdapterUtil.getCursorHoldabilityString(previousHoldability) + "/" + AdapterUtil.getCursorHoldabilityString(this.currentHoldability)});
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"synchronizePropertiesWithCRI");
        }
    }

    private void handleCleanReuse() throws ResourceException {
        try {
            this.currentTransactionIsolation = this.sqlConn.getTransactionIsolation();
            this.currentHoldability = this.defaultHoldability;
            this.currentAutoCommit = this.sqlConn.getAutoCommit();
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".handleCleanReuse"), (String)"2787", (Object)this);
            throw AdapterUtil.translateSQLException(sqlX, this, true, this.getClass());
        }
        this.loggingEnabled = false;
        if (this.internalHelper.shouldTraceBeEnabled(this)) {
            this.internalHelper.enableJdbcLogging(this);
        }
    }

    public final Object getStatement(StatementCacheKey key) {
        Object stmt = this.statementCache.remove(key);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            if (stmt == null) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"No Matching Prepared Statement found in cache", (Object[])new Object[0]);
            } else {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Matching Prepared Statement found in cache: " + stmt), (Object[])new Object[0]);
            }
        }
        return stmt;
    }

    public final void cacheStatement(Statement statement, StatementCacheKey key) {
        CacheMap cache;
        Statement discardedStatement;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"cacheStatement", (Object[])new Object[]{AdapterUtil.toString(statement), key});
        }
        Statement statement2 = discardedStatement = (cache = this.getStatementCache()) == null ? statement : this.statementCache.add(key, statement);
        if (discardedStatement != null) {
            this.destroyStatement(discardedStatement);
        }
    }

    public final WSManagedConnectionFactoryImpl getManagedConnectionFactory() {
        return this.mcf;
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getConnection", (Object[])new Object[]{subject == null ? null : "subject", AdapterUtil.toString(cxRequestInfo)});
        }
        if (this._mcStale) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"MC is stale", (Object[])new Object[0]);
            }
            throw new DataStoreAdapterException("INVALID_CONNECTION", AdapterUtil.staleX(), WSRdbManagedConnectionImpl.class);
        }
        int transactionState = this.stateMgr.transtate;
        if (transactionState != 1 && transactionState != 2 && transactionState != 7 && transactionState != 0) {
            String message = "Operation 'getConnection' is not permitted for transaction state: " + this.getTransactionStateAsString();
            DataStoreAdapterException resX = AdapterUtil.createDataStoreAdapterException("WS_INTERNAL_ERROR", message, null, this.getClass());
            FFDCFilter.processException((Throwable)((Object)resX), (String)"com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.cleanupTransactions", (String)"939", (Object)this, (Object[])new Object[]{message, ". Possible components: Connection Manager"});
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"getConnection", (Object)("bad transaction state " + this.getTransactionStateAsString()));
            }
            throw resX;
        }
        WSConnectionRequestInfoImpl newCRI = (WSConnectionRequestInfoImpl)cxRequestInfo;
        if (!this.supportIsolvlSwitching) {
            if (!this.cri.equals((Object)newCRI)) {
                this.replaceCRI(newCRI);
            }
        } else {
            this.replaceCRIForCCI(newCRI);
        }
        if (this.numHandlesInUse == 0) {
            this.connectionSharing = this.dsConfig.get().connectionSharing;
            this.synchronizePropertiesWithCRI();
            if (this.stateMgr.getState() == 0 || this.stateMgr.getState() == 7 && !this.rrsGlobalTransactionReallyActive) {
                try {
                    this.mcf.dataStoreHelper.doConnectionSetupPerTransaction(subject, subject != null ? null : newCRI.ivUserName, this.sqlConn, this._claimedVictim, this.doConnectoinSetupPerTranProps);
                    if (this.shouldDoConPropFirstCallBeReset) {
                        this.doConnectoinSetupPerTranProps.setProperty("FIRST_TIME_CALLED", "false");
                        this.shouldDoConPropFirstCallBeReset = false;
                    }
                }
                catch (SQLException sqe) {
                    FFDCFilter.processException((Throwable)sqe, (String)(this.getClass().getName() + ".getConnection"), (String)"2294", (Object)this);
                    throw new DataStoreAdapterException("DSA_ERROR", sqe, this.getClass());
                }
                this.subject = subject;
                this._claimedVictim = false;
            }
        } else if (this.supportIsolvlSwitching && this.currentTransactionIsolation != this.cri.ivIsoLevel) {
            try {
                this.setTransactionIsolation(this.cri.ivIsoLevel);
            }
            catch (SQLException sqlX) {
                FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".getConnection"), (String)"1867", (Object)this);
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"getConnection", (Object)sqlX);
                }
                throw AdapterUtil.translateSQLException(sqlX, this, true, this.getClass());
            }
        }
        WSJdbcConnection handle = new WSJdbcConnection(this, this.sqlConn, key, this.threadID);
        this.addHandle(handle);
        if (this.internalHelper.shouldTraceBeEnabled(this)) {
            this.internalHelper.enableJdbcLogging(this);
        } else if (this.internalHelper.shouldTraceBeDisabled(this)) {
            this.internalHelper.disableJdbcLogging(this);
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"numHandlesInUse", (Object[])new Object[]{this.numHandlesInUse});
        }
        this.fatalErrorCount = this.mcf.fatalErrorCount.get();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"getConnection", (Object)handle);
        }
        return handle;
    }

    public void destroy() throws ResourceException {
        ResourceException dsae;
        boolean isTraceOn;
        block32: {
            DataStoreAdapterException resX;
            block31: {
                block30: {
                    block29: {
                        block28: {
                            block27: {
                                isTraceOn = TraceComponent.isAnyTracingEnabled();
                                if (isTraceOn && tc.isEntryEnabled()) {
                                    Tr.entry((Object)this, (TraceComponent)tc, (String)"destroy", (Object[])new Object[0]);
                                }
                                if (this.isAborted()) {
                                    if (isTraceOn && tc.isEntryEnabled()) {
                                        Tr.exit((Object)this, (TraceComponent)tc, (String)"destroy", (Object)"ManagedConnection is aborted -- skipping destroy");
                                    }
                                    return;
                                }
                                dsae = null;
                                try {
                                    this.cleanupTransactions(false);
                                }
                                catch (ResourceException re) {
                                    FFDCFilter.processException((Throwable)re, (String)"com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.destroy", (String)"957", (Object)this);
                                    Tr.warning((TraceComponent)tc, (String)"DSTRY_ERROR_EX", (Object[])new Object[]{re});
                                    if (dsae != null) break block27;
                                    dsae = re;
                                }
                            }
                            ResourceException closeX = this.closeHandles();
                            ResourceException resourceException = dsae = dsae == null ? closeX : dsae;
                            if (this.poolConn != null && !this.dsConfig.get().isUCP) {
                                this.poolConn.removeConnectionEventListener(this);
                                if (this.mcf.jdbcVersion >= 4) {
                                    try {
                                        this.poolConn.removeStatementEventListener(this);
                                    }
                                    catch (UnsupportedOperationException supportX) {
                                        if (isTraceOn && tc.isDebugEnabled()) {
                                            Tr.debug((Object)this, (TraceComponent)tc, (String)"JDBC driver does not support removeStatementEventListener", (Object[])new Object[0]);
                                        }
                                    }
                                    catch (AbstractMethodError methErr) {
                                        if (!isTraceOn || !tc.isDebugEnabled()) break block28;
                                        Tr.debug((Object)this, (TraceComponent)tc, (String)"JDBC driver does not implement removeStatementEventListener", (Object[])new Object[0]);
                                    }
                                }
                            }
                        }
                        if (this.statementCache != null) {
                            this.clearStatementCache();
                        }
                        if (this.sqljContext != null) {
                            try {
                                this.sqljContext.getClass().getMethod("close", new Class[0]).invoke(this.sqljContext, new Object[0]);
                            }
                            catch (Throwable x) {
                                FFDCFilter.processException((Throwable)x, (String)(this.getClass().getName() + ".destroy"), (String)"2596", (Object)this);
                                if (dsae != null) break block29;
                                dsae = new DataStoreAdapterException("DSA_ERROR", x instanceof InvocationTargetException ? x.getCause() : x, this.getClass());
                            }
                        }
                    }
                    if (this.cachedConnection != null) {
                        try {
                            this.cachedConnection.close();
                        }
                        catch (SQLException sqlex) {
                            FFDCFilter.processException((Throwable)sqlex, (String)"com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.destroy", (String)"2607", (Object)this);
                            DataStoreAdapterException dsex = new DataStoreAdapterException("DSA_ERROR", sqlex, this.getClass());
                            if (dsae != null) break block30;
                            dsae = dsex;
                        }
                    }
                }
                if (this.sqlConn != null) {
                    try {
                        this.sqlConn.close();
                    }
                    catch (SQLException se) {
                        FFDCFilter.processException((Throwable)se, (String)"com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.destroy", (String)"1005", (Object)this);
                        resX = new DataStoreAdapterException("DSA_ERROR", se, this.getClass());
                        if (dsae != null) break block31;
                        dsae = resX;
                    }
                }
            }
            if (this.poolConn != null) {
                try {
                    this.poolConn.close();
                }
                catch (SQLException se) {
                    FFDCFilter.processException((Throwable)se, (String)"com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.destroy", (String)"1024", (Object)this);
                    resX = new DataStoreAdapterException("DSA_ERROR", se, this.getClass());
                    if (dsae != null) break block32;
                    dsae = resX;
                }
            }
        }
        this.defaultCatalog = null;
        this.defaultTypeMap = null;
        this.defaultSchema = null;
        this.handlesInUse = null;
        this.ivEventListeners = null;
        this.numListeners = 0;
        this.localTran = null;
        this.xares = null;
        this.cri = null;
        this.subject = null;
        this.sqlConn = null;
        this.poolConn = null;
        this.statementCache = null;
        this.sqljContext = null;
        this.cachedConnection = null;
        if (dsae != null) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"destroy", (Object)((Object)dsae));
            }
            throw dsae;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"destroy");
        }
    }

    public void dissociateHandle(WSJdbcConnection connHandle) {
        if (!this.cleaningUpHandles && !this.removeHandle(connHandle) && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Unable to dissociate Connection handle with current ManagedConnection because it is not currently associated with the ManagedConnection.", (Object[])new Object[]{connHandle});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cleanup() throws ResourceException {
        boolean isTraceOn;
        block24: {
            ResourceException firstX;
            block23: {
                isTraceOn = TraceComponent.isAnyTracingEnabled();
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.entry((Object)this, (TraceComponent)tc, (String)"cleanup", (Object[])new Object[0]);
                }
                if (this.isAborted()) {
                    if (isTraceOn && tc.isEntryEnabled()) {
                        Tr.exit((Object)this, (TraceComponent)tc, (String)"cleanup", (Object)"ManagedConnection is aborted -- skipping cleanup");
                    }
                    return;
                }
                firstX = this.numHandlesInUse < 1 ? null : this.closeHandles();
                try {
                    this.cleanupTransactions(true);
                }
                catch (ResourceException resX) {
                    if (firstX != null) break block23;
                    firstX = resX;
                }
            }
            this.threadID = null;
            if (firstX != null) {
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"cleanup", (Object)((Object)firstX));
                }
                throw firstX;
            }
            this.cleanupStates();
            if (this.fatalErrorCount == -1L) {
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"cleanup", (Object)"Exception");
                }
                throw AdapterUtil.createDataStoreAdapterException("CONN_NEVER_CLOSED", null, null, this.getClass());
            }
            try {
                if (!this.connectionErrorDetected && this.mcf.fatalErrorCount.get() != this.fatalErrorCount && this.mcf.connMgr.getPurgePolicy() != PurgePolicy.EntirePool) {
                    try {
                        this.inCleanup = true;
                        this.preTestConnection(false);
                        this.fatalErrorCount = this.mcf.fatalErrorCount.get();
                    }
                    catch (ResourceException resX) {
                        if (isTraceOn && tc.isEntryEnabled()) {
                            Tr.exit((Object)this, (TraceComponent)tc, (String)"cleanup", (Object)"Exception");
                        }
                        throw AdapterUtil.createDataStoreAdapterException("CONN_ERROR_ON_CLEANUP", null, null, this.getClass());
                    }
                }
                if (!this.workNeedsToBeUnDone) break block24;
                this.workNeedsToBeUnDone = false;
                try {
                    boolean dCsPgC = this.mcf.getDataStoreHelper().doConnectionCleanupPerCloseConnection(this.sqlConn, false, null);
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"calling doConnectionCleanupPerCloseConnection during cleanup", (Object[])new Object[]{this.mcf.getDataStoreHelper(), this.sqlConn, dCsPgC});
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"this is only called if the connection wasn't closed and instead is being disassociated", (Object[])new Object[0]);
                    }
                }
                catch (Throwable x) {
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"doConnectionCleanupPerCloseConnection method caught an exception", (Object[])new Object[]{x});
                    }
                    if (x instanceof SQLException) {
                        throw AdapterUtil.translateSQLException((SQLException)x, this, false, this.getClass());
                    }
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"initializing a new sqlexception based on the non-sql thrown by doConnectionCleanupPerCloseConnection", (Object[])new Object[]{x});
                    }
                    throw AdapterUtil.translateSQLException(new SQLException(x.getMessage(), null, 999999), this, false, this.getClass());
                }
            }
            finally {
                this.inCleanup = false;
            }
        }
        this.transactional = null;
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"cleanup");
        }
    }

    /*
     * Unable to fully structure code
     */
    private void cleanupStates() throws ResourceException {
        this.stateMgr.transtate = 0;
        this.rrsGlobalTransactionReallyActive = false;
        if (!this.connectionErrorDetected && this.sqljContext != null) {
            try {
                execCtx = this.sqljContext.getClass().getMethod("getExecutionContext", new Class[0]).invoke(this.sqljContext, new Object[0]);
                ExecutionContext = execCtx.getClass();
                ExecutionContext.getMethod("setBatching", new Class[]{Boolean.TYPE}).invoke(execCtx, new Object[]{false});
                ExecutionContext.getMethod("setBatchLimit", new Class[]{Integer.TYPE}).invoke(execCtx, new Object[]{-7});
                ExecutionContext.getMethod("setFetchDirection", new Class[]{Integer.TYPE}).invoke(execCtx, new Object[]{1000});
                ExecutionContext.getMethod("setFetchSize", new Class[]{Integer.TYPE}).invoke(execCtx, new Object[]{0});
                ExecutionContext.getMethod("setMaxFieldSize", new Class[]{Integer.TYPE}).invoke(execCtx, new Object[]{0});
                ExecutionContext.getMethod("setMaxRows", new Class[]{Integer.TYPE}).invoke(execCtx, new Object[]{0});
                ExecutionContext.getMethod("setQueryTimeout", new Class[]{Integer.TYPE}).invoke(execCtx, new Object[]{0});
            }
            catch (Exception x) {
                FFDCFilter.processException((Throwable)x, (String)this.getClass().getName(), (String)"3740", (Object)this);
                throw new DataStoreAdapterException("DSA_ERROR", x, this.getClass());
            }
        }
        try {
            if (!this.connectionErrorDetected) {
                this.internalHelper.resetClientInformation(this);
            }
            if (!this.connectionErrorDetected) {
                this.internalHelper.doConnectionCleanupOnWrapper(this);
            }
            wasCleanupReturnTrue = this.mcf.dataStoreHelper.doConnectionCleanup(this.sqlConn);
            if (!this.connectionErrorDetected) {
                if (this.internalHelper.shouldTraceBeEnabled(this)) {
                    this.internalHelper.enableJdbcLogging(this);
                } else if (this.internalHelper.shouldTraceBeDisabled(this)) {
                    this.internalHelper.disableJdbcLogging(this);
                }
            }
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)(this.getClass().getName() + ".cleanupStates"), (String)"1298", (Object)this);
            throw new DataStoreAdapterException("DSA_ERROR", ex, WSRdbManagedConnectionImpl.class);
        }
        if (!this.connectionErrorDetected && (this.connectionPropertyChanged || wasCleanupReturnTrue)) {
            block64: {
                block63: {
                    block62: {
                        if (this.mData.supportsIsReadOnly()) {
                            try {
                                this.internalHelper.setReadOnly(this, this.defaultReadOnly, false);
                                if (ConnectionSharing.MatchCurrentReadOnly.isEnabled(this.connectionSharing)) {
                                    if (!this.cri.isCRIChangable()) {
                                        this.setCRI(WSConnectionRequestInfoImpl.createChangableCRIFromNon(this.cri));
                                    }
                                    this.cri.setReadOnly(this.defaultReadOnly);
                                }
                            }
                            catch (SQLException sqle) {
                                FFDCFilter.processException((Throwable)sqle, (String)(this.getClass().getName() + ".cleanupStates"), (String)"1226", (Object)this);
                                throw new DataStoreAdapterException("DSA_ERROR", sqle, this.getClass());
                            }
                        }
                        if (this.mData.supportsGetCatalog()) {
                            try {
                                this.setCatalog(this.defaultCatalog);
                                if (ConnectionSharing.MatchCurrentCatalog.isEnabled(this.connectionSharing)) {
                                    if (!this.cri.isCRIChangable()) {
                                        this.setCRI(WSConnectionRequestInfoImpl.createChangableCRIFromNon(this.cri));
                                    }
                                    this.cri.setCatalog(this.defaultCatalog);
                                }
                            }
                            catch (SQLException sqle) {
                                FFDCFilter.processException((Throwable)sqle, (String)(this.getClass().getName() + ".cleanupStates"), (String)"1227", (Object)this);
                                throw new DataStoreAdapterException("DSA_ERROR", sqle, this.getClass());
                            }
                        }
                        if (this.mData.supportsGetTypeMap()) {
                            try {
                                this.setTypeMap(this.defaultTypeMap);
                                if (ConnectionSharing.MatchCurrentTypeMap.isEnabled(this.connectionSharing)) {
                                    if (!this.cri.isCRIChangable()) {
                                        this.setCRI(WSConnectionRequestInfoImpl.createChangableCRIFromNon(this.cri));
                                    }
                                    this.cri.setTypeMap(this.defaultTypeMap);
                                }
                            }
                            catch (SQLFeatureNotSupportedException nse) {
                            }
                            catch (UnsupportedOperationException uoe) {
                            }
                            catch (SQLException sqle) {
                                if (AdapterUtil.isUnsupportedException(sqle)) break block62;
                                FFDCFilter.processException((Throwable)sqle, (String)(this.getClass().getName() + ".cleanupStates"), (String)"1228", (Object)this);
                                throw new DataStoreAdapterException("DSA_ERROR", sqle, this.getClass());
                            }
                        }
                    }
                    if (this.mData.supportsGetSchema()) {
                        try {
                            this.setSchema(this.defaultSchema);
                            if (ConnectionSharing.MatchCurrentSchema.isEnabled(this.connectionSharing)) {
                                if (!this.cri.isCRIChangable()) {
                                    this.setCRI(WSConnectionRequestInfoImpl.createChangableCRIFromNon(this.cri));
                                }
                                this.cri.setSchema(this.defaultSchema);
                            }
                        }
                        catch (SQLFeatureNotSupportedException nse) {
                        }
                        catch (UnsupportedOperationException uoe) {
                        }
                        catch (SQLException sqle) {
                            if (AdapterUtil.isUnsupportedException(sqle)) break block63;
                            FFDCFilter.processException((Throwable)sqle, (String)(this.getClass().getName() + ".cleanupStates"), (String)"3644", (Object)this);
                            throw new DataStoreAdapterException("DSA_ERROR", sqle, this.getClass());
                        }
                    }
                }
                if (this.mData.supportsGetNetworkTimeout()) {
                    try {
                        libertyThreadPool = this.mcf.connectorSvc.getLibertyThreadPool();
                        this.setNetworkTimeout(libertyThreadPool, this.defaultNetworkTimeout);
                        if (ConnectionSharing.MatchCurrentNetworkTimeout.isEnabled(this.connectionSharing)) {
                            if (!this.cri.isCRIChangable()) {
                                this.setCRI(WSConnectionRequestInfoImpl.createChangableCRIFromNon(this.cri));
                            }
                            this.cri.setNetworkTimeout(this.defaultNetworkTimeout);
                        }
                    }
                    catch (SQLFeatureNotSupportedException nse) {
                    }
                    catch (UnsupportedOperationException uoe) {
                    }
                    catch (SQLException sqle) {
                        if (AdapterUtil.isUnsupportedException(sqle)) break block64;
                        FFDCFilter.processException((Throwable)sqle, (String)(this.getClass().getName() + ".cleanupStates"), (String)"3672", (Object)this);
                        throw new DataStoreAdapterException("DSA_ERROR", sqle, this.getClass());
                    }
                }
            }
            this.connectionPropertyChanged = false;
            if (wasCleanupReturnTrue) {
                try {
                    this.currentAutoCommit = this.sqlConn.getAutoCommit();
                    if (this.cachedConnection != null) {
                        this.cachedConnection.setCurrentAutoCommit(this.currentAutoCommit, WSRdbManagedConnectionImpl.key);
                    }
                }
                catch (SQLException sqle) {
                    FFDCFilter.processException((Throwable)sqle, (String)(this.getClass().getName() + ".cleanupStates"), (String)"1308", (Object)this);
                    throw new DataStoreAdapterException("DSA_ERROR", sqle, this.getClass());
                }
                try {
                    this.currentTransactionIsolation = this.sqlConn.getTransactionIsolation();
                    if (this.cachedConnection != null) {
                        this.cachedConnection.setCurrentTransactionIsolation(this.currentTransactionIsolation, WSRdbManagedConnectionImpl.key);
                    }
                    if (!this.supportIsolvlSwitching && ConnectionSharing.MatchCurrentIsolation.isEnabled(this.connectionSharing)) {
                        if (!this.cri.isCRIChangable()) {
                            this.setCRI(WSConnectionRequestInfoImpl.createChangableCRIFromNon(this.cri));
                        }
                        this.cri.setTransactionIsolationLevel(this.currentTransactionIsolation);
                    }
                }
                catch (SQLException sqle) {
                    FFDCFilter.processException((Throwable)sqle, (String)(this.getClass().getName() + ".cleanupStates"), (String)"1318", (Object)this);
                    throw new DataStoreAdapterException("DSA_ERROR", sqle, this.getClass());
                }
                try {
                    this.currentHoldability = this.mcf.getInternalDataStoreHelper().getHoldability(this.sqlConn);
                    if (ConnectionSharing.MatchCurrentHoldability.isEnabled(this.connectionSharing)) {
                        if (!this.cri.isCRIChangable()) {
                            this.setCRI(WSConnectionRequestInfoImpl.createChangableCRIFromNon(this.cri));
                        }
                        this.cri.setHoldability(this.defaultHoldability);
                    }
                }
                catch (SQLException sqle) {
                    FFDCFilter.processException((Throwable)sqle, (String)(this.getClass().getName() + ".cleanupStates()"), (String)"3626", (Object)this);
                    throw new DataStoreAdapterException("DSA_ERROR", sqle, this.getClass());
                }
            }
            if (!this.isTransactional() && this.currentAutoCommit != this.defaultAutoCommit) {
                try {
                    if (TraceComponent.isAnyTracingEnabled() && WSRdbManagedConnectionImpl.tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)WSRdbManagedConnectionImpl.tc, (String)"autoCommit on connection doesn't match the database default, setting it to: ", (Object[])new Object[]{this.defaultAutoCommit});
                    }
                    this.sqlConn.setAutoCommit(this.defaultAutoCommit);
                    this.currentAutoCommit = this.defaultAutoCommit;
                    if (this.cachedConnection == null) ** GOTO lbl163
                    this.cachedConnection.setCurrentAutoCommit(this.defaultAutoCommit, WSRdbManagedConnectionImpl.key);
                }
                catch (SQLException sqle) {
                    FFDCFilter.processException((Throwable)sqle, (String)(this.getClass().getName() + ".cleanupStates()"), (String)"3652", (Object)this);
                    throw new DataStoreAdapterException("DSA_ERROR", sqle, this.getClass());
                }
            }
        } else if (this.cachedConnection != null && !this.connectionErrorDetected) {
            this.cachedConnection.setCurrentAutoCommit(this.defaultAutoCommit, WSRdbManagedConnectionImpl.key);
        }
lbl163:
        // 6 sources

        this.wasLazilyEnlisted = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void cleanupTransactions(boolean inCleanup) throws ResourceException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        switch (this.stateMgr.transtate) {
            case 2: {
                try {
                    ((WSRdbXaResourceImpl)((Object)this.xares)).end();
                }
                catch (XAException xae) {
                    // empty catch block
                }
                try {
                    ((WSRdbXaResourceImpl)((Object)this.xares)).rollback();
                }
                catch (XAException xae) {
                    FFDCFilter.processException((Throwable)xae, (String)"com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.cleanupTransactions", (String)"1200", (Object)this);
                    if (!isTraceOn || !tc.isEventEnabled()) throw new DataStoreAdapterException("DSA_ERROR", xae, this.getClass());
                    Tr.event((Object)this, (TraceComponent)tc, (String)"Failed to end or rollback XAResource during cleanup from failure state. Continuing with cleanup.", (Object[])new Object[]{AdapterUtil.getXAExceptionCodeString(xae.errorCode)});
                    throw new DataStoreAdapterException("DSA_ERROR", xae, this.getClass());
                }
                if (!inCleanup) break;
                String message = "Cannot call 'cleanup' on a ManagedConnection while it is still in a transaction.";
                DataStoreAdapterException resX = AdapterUtil.createDataStoreAdapterException("DSA_ERROR", message, null, this.getClass());
                FFDCFilter.processException((Throwable)((Object)resX), (String)"com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.cleanupTransactions", (String)"1562", (Object)this, (Object[])new Object[]{message, " Possible components: Connection Manager, Transactions"});
                throw resX;
            }
            case 1: 
            case 4: {
                if (!this.currentAutoCommit) {
                    try {
                        this.sqlConn.rollback();
                    }
                    catch (SQLException se) {
                        FFDCFilter.processException((Throwable)se, (String)"com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.cleanupTransactions", (String)"1223", (Object)this);
                        if (!isTraceOn || !tc.isEventEnabled()) throw new DataStoreAdapterException("DSA_ERROR", se, this.getClass());
                        Tr.event((Object)this, (TraceComponent)tc, (String)"Connection rollback failed. Continuing with cleanup.", (Object[])new Object[0]);
                        throw new DataStoreAdapterException("DSA_ERROR", se, this.getClass());
                    }
                }
                if (!inCleanup) break;
                String message = "Cannot call 'cleanup' on a ManagedConnection while it is still in a transaction.";
                DataStoreAdapterException resX = AdapterUtil.createDataStoreAdapterException("DSA_ERROR", message, null, this.getClass());
                FFDCFilter.processException((Throwable)((Object)resX), (String)"com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.cleanupTransactions", (String)"1592", (Object)this, (Object[])new Object[]{message, " Possible components: Connection Manager"});
                throw resX;
            }
            case 7: {
                if (!inCleanup) break;
                String message = "Cannot call 'cleanup' on a ManagedConnection while it is still in an RRS managed transaction.";
                DataStoreAdapterException resX = AdapterUtil.createDataStoreAdapterException("DSA_ERROR", message, null, this.getClass());
                FFDCFilter.processException((Throwable)((Object)resX), (String)"com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.cleanupTransactions", (String)"3340", (Object)this, (Object[])new Object[]{message, " Possible components: Connection Manager"});
                throw resX;
            }
        }
        CommitOrRollbackOnCleanup cleanupAction = this.dsConfig.get().commitOrRollbackOnCleanup;
        if (this.connectionErrorDetected) return;
        if (cleanupAction != null) {
            if (this.mcf.dataStoreHelper.getMetaData().supportsUOWDetection()) {
                String operation = "none";
                try {
                    if (!this.mcf.internalHelper.isInDatabaseUnitOfWork(this.sqlConn)) return;
                    if (cleanupAction == CommitOrRollbackOnCleanup.commit) {
                        operation = "commit";
                        if (!this.mcf.loggedDbUowMessage) {
                            Tr.info((TraceComponent)tc, (String)"RESOLVING_DB_IMPLICIT_TRANSACTIONS", (Object[])new Object[]{operation});
                            this.mcf.loggedDbUowMessage = true;
                        } else if (isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)"committing implicit transaction", (Object[])new Object[0]);
                        }
                        try {
                            this.sqlConn.commit();
                            return;
                        }
                        catch (SQLException e) {
                            String message = "Error resolving implicitly started transaction on ManagedConnection.";
                            Tr.info((TraceComponent)tc, (String)"ERROR_RESOLVING_DB_IMPLICIT_TRANSACTIONS", (Object[])new Object[]{operation, e});
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.cleanupTransactions", (String)"3588", (Object)this, (Object[])new Object[]{message});
                            if (isTraceOn && tc.isDebugEnabled()) {
                                Tr.debug((Object)this, (TraceComponent)tc, (String)"Error resolving implicitly started transaction on ManagedConnection.  Exception is:", (Object[])new Object[]{e});
                            }
                            LocalTransactionException lte = (LocalTransactionException)new LocalTransactionException(e.getMessage()).initCause((Throwable)e);
                            throw lte;
                        }
                    }
                    if (cleanupAction != CommitOrRollbackOnCleanup.rollback) return;
                    operation = "rollback";
                    if (!this.mcf.loggedDbUowMessage) {
                        Tr.info((TraceComponent)tc, (String)"RESOLVING_DB_IMPLICIT_TRANSACTIONS", (Object[])new Object[]{operation});
                        this.mcf.loggedDbUowMessage = true;
                    } else if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"rolling back implicit transaction", (Object[])new Object[0]);
                    }
                    try {
                        this.sqlConn.rollback();
                        return;
                    }
                    catch (SQLException e) {
                        String message = "Error resolving implicitly started transaction on ManagedConnection.";
                        Tr.info((TraceComponent)tc, (String)"ERROR_RESOLVING_DB_IMPLICIT_TRANSACTIONS", (Object[])new Object[]{operation, e});
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.cleanupTransactions", (String)"3594", (Object)this, (Object[])new Object[]{message});
                        if (isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)"Error resolving implicitly started transaction on ManagedConnection.  Exception is:", (Object[])new Object[]{e});
                        }
                        LocalTransactionException lte = (LocalTransactionException)new LocalTransactionException(e.getMessage()).initCause((Throwable)e);
                        throw lte;
                    }
                }
                catch (ResourceException e) {
                    throw e;
                }
                catch (SQLException e) {
                    String message = "SQLException created in process of cleaning up implicitly started transaction on ManagedConnection.";
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.cleanupTransactions", (String)"3786", (Object)this, (Object[])new Object[]{message});
                    ResourceException res = (ResourceException)new ResourceException("Unable to complete connection cleanup; we shouldn't continue to use this connection.").initCause((Throwable)e);
                    throw res;
                }
            }
            try {
                if (cleanupAction == CommitOrRollbackOnCleanup.commit) {
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"Commit connection automatically per custom property commitOrRollbackOnCleanup", (Object[])new Object[0]);
                    }
                    if (this.currentAutoCommit) return;
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"AC is false, so we will issue a commit in case there is an implicit tra.", (Object[])new Object[0]);
                    }
                    this.sqlConn.commit();
                    return;
                }
                if (cleanupAction != CommitOrRollbackOnCleanup.rollback) return;
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Rollback connection automatically per custom property commitOrRollbackOnCleanup", (Object[])new Object[0]);
                }
                if (this.currentAutoCommit) return;
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"AC is false, so we will issue a rollback in case there is an implicit tra.", (Object[])new Object[0]);
                }
                this.sqlConn.rollback();
                return;
            }
            catch (Throwable t) {
                String message = "Error resolving implicitly started transaction on ManagedConnection.";
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.cleanupTransactions", (String)"3622", (Object)this, (Object[])new Object[]{message});
                if (!isTraceOn || !tc.isDebugEnabled()) return;
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Error resolving implicitly started transaction on ManagedConnection.  Exception is:", (Object[])new Object[]{t});
            }
            return;
        }
        if (this.mcf.dataStoreHelper.getMetaData().supportsUOWDetection()) {
            try {
                if (!this.mcf.internalHelper.isInDatabaseUnitOfWork(this.sqlConn)) return;
                if (!this.mcf.loggedImmplicitTransactionFound) {
                    Tr.info((TraceComponent)tc, (String)"IMPLICIT_TRANSACTION_FOUND", (Object[])new Object[0]);
                    this.mcf.loggedImmplicitTransactionFound = true;
                }
                this.sqlConn.rollback();
                return;
            }
            catch (Throwable t) {
                String message = "Error while attempting to rollback database implicitly started transaction on ManagedConnection.";
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.cleanupTransactions", (String)"3761", (Object)this, (Object[])new Object[]{message});
                if (!isTraceOn || !tc.isDebugEnabled()) return;
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Error while attempting to rollback database implicitly started transaction on ManagedConnection.", (Object[])new Object[]{t});
            }
            return;
        } else {
            if (this.currentAutoCommit || this.isTransactional() || this.mcf.warnedAboutNonTransactionalDataSource) return;
            Tr.warning((TraceComponent)tc, (String)"NONTRAN_DATASOURCE_WARNING", (Object[])new Object[]{DataSourceDef.transactional.name() + "=false", "commitOrRollbackOnCleanup"});
            this.mcf.warnedAboutNonTransactionalDataSource = true;
        }
    }

    public final void clearStatementCache() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (this.statementCache == null) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"statement cache is null. caching is disabled", (Object[])new Object[0]);
            }
            return;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"clearStatementCache", (Object[])new Object[0]);
        }
        Object[] stmts = this.statementCache.removeAll();
        int i = stmts.length;
        while (i > 0) {
            try {
                ((Statement)stmts[--i]).close();
            }
            catch (SQLException closeX) {
                FFDCFilter.processException((Throwable)closeX, (String)(this.getClass().getName() + ".clearStatementCache"), (String)"2169", (Object)this);
                if (!isTraceOn || !tc.isDebugEnabled()) continue;
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Error closing statement", (Object[])new Object[]{closeX});
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"clearStatementCache");
        }
    }

    private ResourceException closeHandles() {
        DataStoreAdapterException firstX = null;
        WSJdbcConnection conn = null;
        this.cleaningUpHandles = true;
        int i = this.numHandlesInUse;
        while (i > 0) {
            conn = this.handlesInUse[--i];
            this.handlesInUse[i] = null;
            try {
                conn.close();
            }
            catch (SQLException closeX) {
                FFDCFilter.processException((Throwable)closeX, (String)(this.getClass().getName() + ".closeHandles"), (String)"1414", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)"Error closing handle. Continuing...", (Object[])new Object[]{conn});
                }
                DataStoreAdapterException resX = new DataStoreAdapterException("DSA_ERROR", closeX, this.getClass());
                if (firstX != null) continue;
                firstX = resX;
            }
        }
        this.numHandlesInUse = 0;
        this.cleaningUpHandles = false;
        return firstX;
    }

    private Subject copySubject(final Subject sub) throws ResourceException {
        return AccessController.doPrivileged(new PrivilegedAction<Subject>(){

            @Override
            public Subject run() {
                return new Subject(sub.isReadOnly(), sub.getPrincipals(), sub.getPublicCredentials(), sub.getPrivateCredentials());
            }
        });
    }

    public void associateConnection(Object connection) throws ResourceException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"associateConnection", (Object[])new Object[]{connection});
        }
        WSJdbcConnection connHandle = (WSJdbcConnection)connection;
        try {
            ConnectionRequestInfo newCRI;
            int tranState;
            WSRdbManagedConnectionImpl oldMC = (WSRdbManagedConnectionImpl)connHandle.getManagedConnection(key);
            int n = tranState = oldMC == null ? 0 : oldMC.stateMgr.transtate;
            if (oldMC != null) {
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Old ManagedConnection rrsGlobalTransactionReallyActive :", (Object[])new Object[]{oldMC.rrsGlobalTransactionReallyActive});
                }
                this.rrsGlobalTransactionReallyActive = oldMC.rrsGlobalTransactionReallyActive;
            }
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Old ManagedConnection transaction state:", (Object[])new Object[]{oldMC == null ? null : oldMC.getTransactionStateAsString()});
                Tr.debug((Object)this, (TraceComponent)tc, (String)"New ManagedConnection transaction state:", (Object[])new Object[]{this.getTransactionStateAsString()});
            }
            if (!(tranState != 2 && tranState != 7 && tranState != 1 || connHandle.isReserved())) {
                if (isTraceOn && tc.isEventEnabled()) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)"Reassociation requested within a transaction; handle reassociation will be ignored.", (Object[])new Object[0]);
                }
                connHandle.reserve(key);
                oldMC.dissociateHandle(connHandle);
                newCRI = connHandle.getCRI();
            } else {
                if (connHandle.getState() == WSJdbcWrapper.State.ACTIVE) {
                    connHandle.dissociate();
                }
                newCRI = connHandle.getCRI();
                connHandle.reassociate((ManagedConnection)this, this.sqlConn, key);
            }
            if (!this.cri.equals(newCRI)) {
                this.replaceCRI((WSConnectionRequestInfoImpl)newCRI);
            }
            if (this.numHandlesInUse == 0) {
                this.connectionSharing = this.dsConfig.get().connectionSharing;
                this.synchronizePropertiesWithCRI();
            }
            this.addHandle(connHandle);
        }
        catch (ResourceException resX) {
            FFDCFilter.processException((Throwable)resX, (String)"com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.associateConnection", (String)"1981", (Object)this);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"associateConnection", (Object)"Exception");
            }
            throw resX;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"associateConnection");
        }
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"addConnectionEventListener", (Object[])new Object[]{listener});
        }
        if (listener == null) {
            throw new NullPointerException("Cannot add null ConnectionEventListener.");
        }
        if (this.numListeners >= this.ivEventListeners.length) {
            ConnectionEventListener[] tempArray = this.ivEventListeners;
            this.ivEventListeners = new ConnectionEventListener[this.numListeners + 3];
            System.arraycopy(tempArray, 0, this.ivEventListeners, 0, tempArray.length);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("received more ConnectionEventListeners than expected, increased array size to " + this.ivEventListeners.length), (Object[])new Object[0]);
            }
        }
        this.ivEventListeners[this.numListeners++] = listener;
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"removeConnectionEventListener", (Object[])new Object[]{listener});
        }
        if (listener == null) {
            NullPointerException nullX = new NullPointerException("Cannot remove null ConnectionEventListener.");
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"removeConnectionEventListener", (Object)nullX);
            }
            throw nullX;
        }
        for (int i = 0; i < this.numListeners; ++i) {
            if (listener != this.ivEventListeners[i]) continue;
            this.ivEventListeners[i] = this.ivEventListeners[--this.numListeners];
            this.ivEventListeners[this.numListeners] = null;
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"removeConnectionEventListener");
            }
            return;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"removeConnectionEventListener", (Object)"Listener not found for remove.");
        }
    }

    public XAResource getXAResource() throws ResourceException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getXAResource", (Object[])new Object[0]);
        }
        if (this.xares != null) {
            if (isTraceOn && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)"Returning existing XAResource", (Object[])new Object[]{this.xares});
            }
        } else if (this.is2Phase) {
            try {
                XAResource xa = ((XAConnection)this.poolConn).getXAResource();
                this.xares = new WSRdbXaResourceImpl(xa, this);
            }
            catch (SQLException se) {
                FFDCFilter.processException((Throwable)se, (String)"com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl.getXAResource", (String)"1638", (Object)this);
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"getXAResource", (Object)se);
                }
                throw AdapterUtil.translateSQLException(se, this, true, this.getClass());
            }
        } else {
            this.xares = new WSRdbOnePhaseXaResourceImpl(this.sqlConn, this);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"getXAResource");
        }
        return this.xares;
    }

    public final LocalTransaction getLocalTransaction() throws ResourceException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getLocalTransaction", (Object[])new Object[0]);
        }
        WSRdbSpiLocalTransactionImpl wSRdbSpiLocalTransactionImpl = this.localTran = this.localTran == null ? new WSRdbSpiLocalTransactionImpl(this, this.sqlConn) : this.localTran;
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"getLocalTransaction", (Object)this.localTran);
        }
        return this.localTran;
    }

    public final int getTransactionState() {
        return this.stateMgr.transtate;
    }

    public final String getTransactionStateAsString() {
        return this.stateMgr.getStateAsString();
    }

    public final ManagedConnectionMetaData getMetaData() throws ResourceException {
        throw new NotSupportedException();
    }

    public final void setLogWriter(PrintWriter out) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"setLogWriter on the mc is a no-op when calling this method", (Object[])new Object[0]);
        }
    }

    public final PrintWriter getLogWriter() throws ResourceException {
        return this.mcf.getLogWriter();
    }

    public final boolean getAutoCommit() {
        return this.currentAutoCommit;
    }

    public final void setAutoCommit(boolean value) throws SQLException {
        if (value != this.currentAutoCommit || this.internalHelper.alwaysSetAutoCommit()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Set AutoCommit to " + value), (Object[])new Object[0]);
            }
            this.sqlConn.setAutoCommit(value);
            this.currentAutoCommit = value;
            if (this.cachedConnection != null) {
                this.cachedConnection.setCurrentAutoCommit(this.currentAutoCommit, key);
            }
        }
    }

    public final void setTransactionIsolation(int isoLevel) throws SQLException {
        if (this.currentTransactionIsolation != isoLevel) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Set Isolation Level to " + AdapterUtil.getIsolationLevelString(isoLevel)), (Object[])new Object[0]);
            }
            this.sqlConn.setTransactionIsolation(isoLevel);
            this.currentTransactionIsolation = isoLevel;
            if (this.cachedConnection != null) {
                this.cachedConnection.setCurrentTransactionIsolation(this.currentTransactionIsolation, key);
            }
            this.isolationChanged = true;
        }
    }

    public final int getTransactionIsolation() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            try {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"The current isolation level from our tracking is: ", (Object[])new Object[]{this.currentTransactionIsolation});
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Isolation reported by the JDBC driver: ", (Object[])new Object[]{this.sqlConn.getTransactionIsolation()});
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.currentTransactionIsolation;
    }

    public final void setHoldability(int holdability) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"setHoldability", (Object[])new Object[]{"Set Holdability to " + AdapterUtil.getCursorHoldabilityString(holdability)});
        }
        this.sqlConn.setHoldability(holdability);
        this.currentHoldability = holdability;
        this.holdabilityChanged = true;
    }

    public final int getHoldability() throws SQLException {
        if (this.currentHoldability != 0) {
            return this.currentHoldability;
        }
        return this.sqlConn.getHoldability();
    }

    public final int getCurrentHoldability() {
        return this.currentHoldability;
    }

    public final void setCatalog(String catalog) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Set Catalog to " + catalog), (Object[])new Object[0]);
        }
        this.sqlConn.setCatalog(catalog);
        this.connectionPropertyChanged = true;
    }

    public final void setReadOnly(boolean isReadOnly) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Set readOnly to " + isReadOnly), (Object[])new Object[0]);
        }
        this.sqlConn.setReadOnly(isReadOnly);
        this.connectionPropertyChanged = true;
    }

    public final ConnectionRequestInfo getConnectionRequestInfo() {
        return this.cri;
    }

    public final void setCRI(WSConnectionRequestInfoImpl newCRI) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"setCRI to ", (Object[])new Object[]{newCRI});
        }
        this.cri = newCRI;
    }

    public final Subject getSubject() {
        return this.subject;
    }

    public final void setTypeMap(Map<String, Class<?>> typeMap) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Set TypeMap to " + typeMap), (Object[])new Object[0]);
        }
        try {
            this.sqlConn.setTypeMap(typeMap);
        }
        catch (SQLFeatureNotSupportedException nse) {
            this.mData.setGetTypeMapSupport(false);
            throw nse;
        }
        catch (UnsupportedOperationException uoe) {
            this.mData.setGetTypeMapSupport(false);
            throw uoe;
        }
        this.connectionPropertyChanged = true;
    }

    public final Object getSQLJConnectionContext(Class<?> DefaultContext) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getSQLJConnectionContext", (Object[])new Object[0]);
        }
        if (this.sqljContext == null) {
            try {
                this.sqljContext = this.internalHelper.getSQLJContext(this, DefaultContext);
            }
            catch (SQLException se) {
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"getSQLJConnectionContext", (Object)se);
                }
                throw se;
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"getSQLJConnectionContext", (Object)this.sqljContext);
        }
        return this.sqljContext;
    }

    public void validate() throws ResourceException {
        this.preTestConnection(true);
    }

    void preTestConnection(boolean logWarningForUndefinedSQLStatement) throws ResourceException {
        boolean isTraceOn;
        block31: {
            int validationTimeout = -1;
            isTraceOn = TraceComponent.isAnyTracingEnabled();
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)tc, (String)"preTestConnection", (Object[])new Object[]{"timeout: " + validationTimeout});
            }
            try {
                if (validationTimeout >= 0) {
                    if (this.mcf.jdbcVersion < 4) {
                        if (this.mcf.warnedAboutValidationByTimeout) {
                            if (isTraceOn && tc.isDebugEnabled()) {
                                Tr.debug((Object)this, (TraceComponent)tc, (String)("Connection.isValid(timeout) is not available in JDBC " + this.mcf.jdbcVersion), (Object[])new Object[0]);
                            }
                        } else {
                            Tr.warning((TraceComponent)tc, (String)"REQUIRES_SPEC_LEVEL", (Object[])new Object[]{"validateNewConnectionTimeout", "4.0"});
                            this.mcf.warnedAboutValidationByTimeout = true;
                        }
                    } else if (!this.internalHelper.connectionIsValid(this.sqlConn, validationTimeout)) {
                        String message = AdapterUtil.getNLSMessage("NOT_VALIDATED");
                        SQLRecoverableException staleX = new SQLRecoverableException(message, "08003", 0);
                        DataStoreAdapterException x = AdapterUtil.createDataStoreAdapterException("NOT_VALIDATED", null, staleX, this.getClass());
                        if (isTraceOn && tc.isEntryEnabled()) {
                            Tr.exit((Object)this, (TraceComponent)tc, (String)"preTestConnection", (Object)"not validated");
                        }
                        throw x;
                    }
                } else {
                    this.sqlConn.createStatement().close();
                }
                if (!this.currentAutoCommit) {
                    this.sqlConn.rollback();
                }
                this.mcf.dataStoreHelper.doConnectionCleanup(this.sqlConn);
                this.sqlConn.clearWarnings();
            }
            catch (SQLException sqle) {
                block30: {
                    block29: {
                        ResourceException resX = AdapterUtil.translateSQLException(sqle, this, false, this.getClass());
                        if (isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)"preTestConnection", (Object[])new Object[]{AdapterUtil.getStackTraceWithState(sqle)});
                        }
                        if (WSJdbcUtil.isConnectionError(sqle, (Object)this.mcf)) {
                            if (isTraceOn && tc.isEntryEnabled()) {
                                Tr.exit((Object)this, (TraceComponent)tc, (String)"preTestConnection", (Object)"connection is bad");
                            }
                            throw AdapterUtil.translateSQLException(sqle, this, false, this.getClass());
                        }
                        if (resX instanceof SecurityException) {
                            if (isTraceOn && tc.isEntryEnabled()) {
                                Tr.exit((Object)this, (TraceComponent)tc, (String)"preTestConnection", (Object)"authorization exception.  Exception will be thrown back to the application");
                            }
                            throw resX;
                        }
                        if (!this.currentAutoCommit) {
                            try {
                                this.sqlConn.rollback();
                            }
                            catch (SQLException rollbackEx) {
                                if (!WSJdbcUtil.isConnectionError(rollbackEx, (Object)this.mcf)) break block29;
                                if (isTraceOn && tc.isEntryEnabled()) {
                                    Tr.exit((Object)this, (TraceComponent)tc, (String)"preTestConnection", (Object)"connection is bad");
                                }
                                throw AdapterUtil.translateSQLException(rollbackEx, this, false, this.getClass());
                            }
                        }
                    }
                    try {
                        this.mcf.dataStoreHelper.doConnectionCleanup(this.sqlConn);
                    }
                    catch (SQLException cleanEx) {
                        if (!WSJdbcUtil.isConnectionError(cleanEx, (Object)this.mcf)) break block30;
                        if (isTraceOn && tc.isEntryEnabled()) {
                            Tr.exit((Object)this, (TraceComponent)tc, (String)"preTestConnection", (Object)"connection is bad");
                        }
                        throw AdapterUtil.translateSQLException(cleanEx, this, false, this.getClass());
                    }
                }
                try {
                    this.sqlConn.clearWarnings();
                }
                catch (SQLException cleanEx) {
                    if (!WSJdbcUtil.isConnectionError(cleanEx, (Object)this.mcf)) break block31;
                    if (isTraceOn && tc.isEntryEnabled()) {
                        Tr.exit((Object)this, (TraceComponent)tc, (String)"preTestConnection", (Object)"connection is bad");
                    }
                    throw AdapterUtil.translateSQLException(cleanEx, this, false, this.getClass());
                }
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"preTestConnection");
        }
    }

    public void setClaimedVictim() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"marking this mc as _claimedVictim", (Object[])new Object[0]);
        }
        this._claimedVictim = true;
    }

    public String toString() {
        return new StringBuffer("WSRdbManagedConnectionImpl").append('@').append(Integer.toHexString(this.hashCode())).toString();
    }

    public int getNumberOfInUseHandles() {
        return this.numHandlesInUse;
    }

    public void setSchema(String schema) throws SQLException {
        Transaction suspendTx = null;
        if (this.mcf.beforeJDBCVersion(JDBCRuntimeVersion.VERSION_4_1)) {
            throw new SQLFeatureNotSupportedException();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Set Schema to " + schema), (Object[])new Object[0]);
        }
        if (AdapterUtil.isZOS() && this.isGlobalTransactionActive()) {
            suspendTx = this.suspendGlobalTran();
        }
        try {
            this.mcf.jdbcRuntime.doSetSchema(this.sqlConn, schema);
            this.currentSchema = schema;
            this.connectionPropertyChanged = true;
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            if (suspendTx != null) {
                this.resumeGlobalTran(suspendTx);
            }
        }
    }

    public String getSchema() throws SQLException {
        String schema;
        Transaction suspendTx = null;
        if (this.mcf.beforeJDBCVersion(JDBCRuntimeVersion.VERSION_4_1)) {
            return null;
        }
        if (AdapterUtil.isZOS() && this.isGlobalTransactionActive()) {
            suspendTx = this.suspendGlobalTran();
        }
        try {
            schema = this.mcf.jdbcRuntime.doGetSchema(this.sqlConn);
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            if (suspendTx != null) {
                this.resumeGlobalTran(suspendTx);
            }
        }
        return schema;
    }

    public String getSchemaSafely() throws SQLException {
        if (!this.mData.supportsGetSchema() || this.mcf.beforeJDBCVersion(JDBCRuntimeVersion.VERSION_4_1)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Returning default schema", (Object[])new Object[]{this.defaultSchema});
            }
            return this.defaultSchema;
        }
        try {
            return this.getSchema();
        }
        catch (AbstractMethodError e) {
            this.mData.setSchemaSupport(false);
            return this.defaultSchema;
        }
        catch (NoSuchMethodError e) {
            this.mData.setSchemaSupport(false);
            return this.defaultSchema;
        }
        catch (SQLException e) {
            if (AdapterUtil.isUnsupportedException(e)) {
                this.mData.setSchemaSupport(false);
                return this.defaultSchema;
            }
            throw e;
        }
    }

    public void abort(Executor ex) throws SQLFeatureNotSupportedException {
        if (this.mcf.beforeJDBCVersion(JDBCRuntimeVersion.VERSION_4_1)) {
            throw new SQLFeatureNotSupportedException();
        }
        try {
            this.setAborted(true);
            this.mcf.jdbcRuntime.doAbort(this.sqlConn, ex);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public boolean isAborted() {
        if (this.mcf.beforeJDBCVersion(JDBCRuntimeVersion.VERSION_4_1)) {
            return false;
        }
        return this.aborted;
    }

    public void setAborted(boolean aborted) throws SQLFeatureNotSupportedException {
        if (this.mcf.beforeJDBCVersion(JDBCRuntimeVersion.VERSION_4_1)) {
            throw new SQLFeatureNotSupportedException();
        }
        this.aborted = aborted;
    }

    public int getNetworkTimeout() throws SQLException {
        int timeOut;
        Transaction suspendTx = null;
        if (AdapterUtil.isZOS() && this.isGlobalTransactionActive()) {
            suspendTx = this.suspendGlobalTran();
        }
        try {
            timeOut = this.mcf.jdbcRuntime.doGetNetworkTimeout(this.sqlConn);
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            if (suspendTx != null) {
                this.resumeGlobalTran(suspendTx);
            }
        }
        return timeOut;
    }

    public int getNetworkTimeoutSafely() throws SQLException {
        if (!this.mData.supportsGetNetworkTimeout() || this.mcf.beforeJDBCVersion(JDBCRuntimeVersion.VERSION_4_1)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Returning default network timeout.", (Object[])new Object[]{this.defaultNetworkTimeout});
            }
            return this.defaultNetworkTimeout;
        }
        try {
            return this.getNetworkTimeout();
        }
        catch (AbstractMethodError e) {
            this.mData.setNetworkTimeoutSupport(false);
            return this.defaultNetworkTimeout;
        }
        catch (NoSuchMethodError e) {
            this.mData.setNetworkTimeoutSupport(false);
            return this.defaultNetworkTimeout;
        }
        catch (SQLException e) {
            if (AdapterUtil.isUnsupportedException(e)) {
                this.mData.setNetworkTimeoutSupport(false);
                return this.defaultNetworkTimeout;
            }
            throw e;
        }
    }

    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        if (this.mcf.beforeJDBCVersion(JDBCRuntimeVersion.VERSION_4_1)) {
            throw new SQLFeatureNotSupportedException();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Set NetworkTimeout to " + milliseconds), (Object[])new Object[0]);
        }
        Transaction suspendTx = null;
        if (AdapterUtil.isZOS() && this.isGlobalTransactionActive()) {
            suspendTx = this.suspendGlobalTran();
        }
        try {
            this.mcf.jdbcRuntime.doSetNetworkTimeout(this.sqlConn, executor, milliseconds);
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            if (suspendTx != null) {
                this.resumeGlobalTran(suspendTx);
            }
        }
        this.currentNetworkTimeout = milliseconds;
        this.connectionPropertyChanged = true;
    }

    private Transaction suspendGlobalTran() throws SQLException {
        EmbeddableWebSphereTransactionManager tm = this.mcf.connectorSvc.getTransactionManager();
        try {
            return tm.suspend();
        }
        catch (SystemException e) {
            throw new SQLException(e);
        }
    }

    private void resumeGlobalTran(Transaction t) throws SQLException {
        EmbeddableWebSphereTransactionManager tm = this.mcf.connectorSvc.getTransactionManager();
        try {
            tm.resume(t);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    static {
        VENDOR_PROPERTY_SETTERS.add("setDefaultExecuteBatch");
        VENDOR_PROPERTY_SETTERS.add("setDefaultRowPrefetch");
        VENDOR_PROPERTY_SETTERS.add("setDefaultTimeZone");
        VENDOR_PROPERTY_SETTERS.add("setIncludeSynonyms");
        VENDOR_PROPERTY_SETTERS.add("setRemarksReporting");
        VENDOR_PROPERTY_SETTERS.add("setRestrictGetTables");
        VENDOR_PROPERTY_SETTERS.add("setSessionTimeZone");
        VENDOR_STM_AND_CONNECTION_PROPERTY_SETTERS = new HashSet<String>();
        VENDOR_STM_AND_CONNECTION_PROPERTY_SETTERS.add("setDefaultExecuteBatch");
        VENDOR_STM_AND_CONNECTION_PROPERTY_SETTERS.add("setDefaultRowPrefetch");
        maxHandlesInUse = 15;
        key = new byte[0];
        tc = Tr.register(WSRdbManagedConnectionImpl.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    }
}

