/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.ejs.cm.logger.TraceWriter;
import com.ibm.ejs.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.rsadapter.DSConfigHelper;
import com.ibm.ws.rsadapter.jdbc.WSJdbcUtil;
import com.ibm.ws.rsadapter.spi.InternalGenericDataStoreHelper;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;
import com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.Statement;
import javax.resource.ResourceException;

public class InternalSybaseDataStoreHelper
extends InternalGenericDataStoreHelper {
    private static final TraceComponent tc = com.ibm.websphere.ras.Tr.register(InternalSybaseDataStoreHelper.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    private transient com.ibm.ejs.ras.TraceComponent sybaseTc = Tr.register((String)"com.ibm.ws.sybase.logwriter", (String)"WAS.database", null);
    private transient PrintWriter sybasePw = null;

    public InternalSybaseDataStoreHelper() {
        this(null);
    }

    public InternalSybaseDataStoreHelper(ClassLoader loader) {
        super(loader);
    }

    @Override
    public PrintWriter getPrintWriter() throws ResourceException {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (this.sybasePw == null) {
            this.sybasePw = this.externalHelper.getPrintWriter();
            if (this.sybasePw == null) {
                this.sybasePw = new PrintWriter((Writer)new TraceWriter(this.sybaseTc), true);
            } else if (trace && tc.isDebugEnabled()) {
                com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"user supplied own printWriter in datastore helper, will use provided one", (Object[])new Object[]{this.sybasePw});
            }
        }
        if (trace && tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"returning", (Object[])new Object[]{this.sybasePw});
        }
        return this.sybasePw;
    }

    @Override
    public com.ibm.ejs.ras.TraceComponent getTracer() {
        return this.sybaseTc;
    }

    @Override
    public int getUpdateCount(Statement stmt) throws SQLException {
        try {
            return stmt.getUpdateCount();
        }
        catch (SQLException x) {
            if ("JZ0PA".equals(x.getSQLState())) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"Returning stmt.getUpdateCount = -1 to work around Sybase bug", (Object[])new Object[]{x.getMessage()});
                }
                return -1;
            }
            throw x;
        }
    }

    @Override
    public void gatherAndDisplayMetaDataInfo(Connection conn, WSManagedConnectionFactoryImpl mcf) throws SQLException {
        block3: {
            this.setDatabaseProductName("Sybase SQL Server");
            try {
                super.gatherAndDisplayMetaDataInfo(conn, mcf);
            }
            catch (SQLException x) {
                if (WSJdbcUtil.isConnectionError(x, (Object)mcf)) {
                    throw x;
                }
                com.ibm.websphere.ras.Tr.info((TraceComponent)tc, (String)"META_DATA_EXCEPTION", (Object[])new Object[]{x.getMessage()});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)("meta data access caused a non SCE, continuing without displaying metadata: " + x), (Object[])new Object[0]);
            }
        }
    }

    @Override
    boolean isAuthException(SQLException x) {
        return x instanceof SQLInvalidAuthorizationSpecException || "JZ00L".equals(x.getSQLState()) || "JZ001".equals(x.getSQLState()) || "JZ002".equals(x.getSQLState());
    }

    @Override
    public void setReadOnly(WSRdbManagedConnectionImpl managedConn, boolean readOnly, boolean externalCall) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"setReadOnly", (Object[])new Object[]{managedConn, readOnly, externalCall});
        }
        if (!externalCall) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"setReadOnly ignored for internal call", (Object[])new Object[0]);
            }
        } else if (DSConfigHelper._allowSetReadOnlyForSybase) {
            managedConn.setReadOnly(readOnly);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"Method setReadOnly() is ignored by WebSphere. Sybase does not honor the setReadOnly method.", (Object[])new Object[0]);
        }
    }

    @Override
    public boolean shouldTraceBeEnabled(WSManagedConnectionFactoryImpl mcf) {
        return this.sybaseTc.isDebugEnabled() && !mcf.loggingEnabled;
    }

    @Override
    public boolean shouldTraceBeEnabled(WSRdbManagedConnectionImpl mc) {
        return this.shouldTraceBeEnabled(mc.mcf);
    }

    @Override
    public boolean shouldTraceBeDisabled(WSRdbManagedConnectionImpl mc) {
        return !this.sybaseTc.isDebugEnabled() && mc.mcf.loggingEnabled;
    }
}

