/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.ejs.cm.logger.TraceWriter;
import com.ibm.ejs.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.rsadapter.spi.InternalGenericDataStoreHelper;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;
import com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.Statement;
import javax.resource.ResourceException;

public class InternalInformixDataStoreHelper
extends InternalGenericDataStoreHelper {
    private static final TraceComponent tc = com.ibm.websphere.ras.Tr.register(InternalInformixDataStoreHelper.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    private transient com.ibm.ejs.ras.TraceComponent infxTc = Tr.register((String)"com.ibm.ws.informix.logwriter", (String)"WAS.database", null);
    private transient PrintWriter ifxPw = null;

    public InternalInformixDataStoreHelper() {
        this(null);
    }

    public InternalInformixDataStoreHelper(ClassLoader loader) {
        super(loader);
    }

    @Override
    public PrintWriter getPrintWriter() throws ResourceException {
        if (this.ifxPw == null) {
            this.ifxPw = this.externalHelper.getPrintWriter();
            if (this.ifxPw != null) {
                com.ibm.websphere.ras.Tr.debug((TraceComponent)this.infxTc, (String)"user supplied own printWriter in datastore helper, will use provided one", (Object[])new Object[]{this.ifxPw});
            } else {
                this.ifxPw = new PrintWriter((Writer)new TraceWriter(this.infxTc), true);
            }
        }
        com.ibm.websphere.ras.Tr.debug((TraceComponent)this.infxTc, (String)"returning", (Object[])new Object[]{this.ifxPw});
        return this.ifxPw;
    }

    @Override
    public com.ibm.ejs.ras.TraceComponent getTracer() {
        return this.infxTc;
    }

    @Override
    public int getUpdateCount(Statement stmt) throws SQLException {
        try {
            return stmt.getUpdateCount();
        }
        catch (SQLException x) {
            if (x.getErrorCode() == -79733) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    com.ibm.websphere.ras.Tr.debug((TraceComponent)tc, (String)"Returning stmt.getUpdateCount = -1 to work around Informix bug", (Object[])new Object[]{x.getMessage()});
                }
                return -1;
            }
            throw x;
        }
    }

    @Override
    boolean isAuthException(SQLException x) {
        int ec = x.getErrorCode();
        return x instanceof SQLInvalidAuthorizationSpecException || x.getSQLState() != null && x.getSQLState().startsWith("28") || -951 == ec || -952 == ec || -956 == ec || -1782 == ec || -11018 == ec || -11033 == ec || -25590 == ec || -29007 == ec;
    }

    @Override
    public boolean shouldTraceBeEnabled(WSManagedConnectionFactoryImpl mcf) {
        return TraceComponent.isAnyTracingEnabled() && this.infxTc.isDebugEnabled() && !mcf.loggingEnabled;
    }

    @Override
    public boolean shouldTraceBeEnabled(WSRdbManagedConnectionImpl mc) {
        return this.shouldTraceBeEnabled(mc.mcf);
    }

    @Override
    public boolean shouldTraceBeDisabled(WSRdbManagedConnectionImpl mc) {
        return TraceComponent.isAnyTracingEnabled() && !this.infxTc.isDebugEnabled() && mc.mcf.loggingEnabled;
    }
}

