/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.ejs.cm.logger.TraceWriter;
import com.ibm.ejs.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.rsadapter.DataStoreHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.DSConfigHelper;
import com.ibm.ws.rsadapter.exceptions.DataStoreAdapterException;
import com.ibm.ws.rsadapter.jdbc.WSJdbcUtil;
import com.ibm.ws.rsadapter.spi.ConnectionResults;
import com.ibm.ws.rsadapter.spi.InternalDataStoreHelper;
import com.ibm.ws.rsadapter.spi.WSConnectionRequestInfoImpl;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;
import com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl;
import java.io.PrintWriter;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.resource.ResourceException;
import javax.sql.CommonDataSource;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import javax.sql.XADataSource;
import org.ietf.jgss.GSSCredential;

public class InternalGenericDataStoreHelper
implements InternalDataStoreHelper {
    private static final com.ibm.ejs.ras.TraceComponent databaseTc = Tr.register((String)"com.ibm.ws.database.logwriter", (String)"WAS.database", null);
    private static final TraceComponent tc = com.ibm.websphere.ras.Tr.register(InternalGenericDataStoreHelper.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    private transient PrintWriter genPw = null;
    protected transient DataStoreHelper externalHelper = null;
    private String databaseProductName = null;
    private String driverName;
    int driverMajorVersion;
    WSManagedConnectionFactoryImpl mcf;
    protected boolean holdabilitySupported = true;

    public InternalGenericDataStoreHelper() {
        this(null);
    }

    public InternalGenericDataStoreHelper(ClassLoader loader) {
    }

    @Override
    public boolean alwaysSetAutoCommit() {
        return false;
    }

    @Override
    public boolean failoverOccurred(SQLException sqlX) {
        return false;
    }

    @Override
    public Boolean getRRSTransactional() {
        return Boolean.FALSE;
    }

    @Override
    public String getThreadIdentitySupport() {
        return "NOTALLOWED";
    }

    @Override
    public Boolean getThreadSecurity() {
        return Boolean.FALSE;
    }

    @Override
    public com.ibm.ejs.ras.TraceComponent getTracer() {
        return databaseTc;
    }

    @Override
    public int getUpdateCount(Statement stmt) throws SQLException {
        return stmt.getUpdateCount();
    }

    @Override
    public Object getUtility() {
        return null;
    }

    @Override
    public String getCorrelator(WSRdbManagedConnectionImpl mc) throws SQLException {
        return null;
    }

    @Override
    public void setManagedConnectionFactory(WSManagedConnectionFactoryImpl managedConnFactory) {
        this.mcf = managedConnFactory;
    }

    @Override
    public void setProperties(Properties props) throws ResourceException {
    }

    @Override
    public boolean shouldTraceBeEnabled(WSManagedConnectionFactoryImpl mcf) {
        return databaseTc.isDebugEnabled() && !mcf.loggingEnabled;
    }

    @Override
    public boolean shouldTraceBeEnabled(WSRdbManagedConnectionImpl mc) {
        return this.shouldTraceBeEnabled(mc.mcf);
    }

    @Override
    public boolean shouldTraceBeDisabled(WSRdbManagedConnectionImpl mc) {
        return !databaseTc.isDebugEnabled() && mc.mcf.loggingEnabled;
    }

    @Override
    public void disableJdbcLogging(WSRdbManagedConnectionImpl mc) throws ResourceException {
        mc.mcf.reallySetLogWriter(null);
        mc.mcf.loggingEnabled = false;
    }

    @Override
    public void enableJdbcLogging(WSManagedConnectionFactoryImpl mcf) throws ResourceException {
        PrintWriter pw = this.getPrintWriter();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((TraceComponent)tc, (String)"enabling logging", (Object[])new Object[]{mcf, pw});
        }
        mcf.reallySetLogWriter(pw);
        mcf.loggingEnabled = true;
    }

    @Override
    public void enableJdbcLogging(WSRdbManagedConnectionImpl mc) throws ResourceException {
        this.enableJdbcLogging(mc.mcf);
    }

    @Override
    public PrintWriter getPrintWriter() throws ResourceException {
        if (this.genPw == null) {
            PrintWriter pw = this.externalHelper.getPrintWriter();
            if (pw != null) {
                if (tc.isDebugEnabled()) {
                    com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"user supplied own printWriter in the DataStoreHelper, will use provided one", (Object[])new Object[]{pw});
                }
                this.genPw = pw;
            } else {
                this.genPw = new PrintWriter((Writer)new TraceWriter(databaseTc), true);
            }
        }
        if (tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"returning", (Object[])new Object[]{this.genPw});
        }
        return this.genPw;
    }

    @Override
    public void setReadOnly(WSRdbManagedConnectionImpl managedConn, boolean readOnly, boolean externalCall) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"setReadOnly", (Object[])new Object[]{managedConn, readOnly, externalCall});
        }
        managedConn.setReadOnly(readOnly);
    }

    @Override
    public int getHoldability(Connection conn) throws SQLException {
        if (tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"getHoldability", (Object[])new Object[]{AdapterUtil.toString(conn)});
        }
        int holdability = 0;
        try {
            if (this.holdabilitySupported) {
                holdability = conn.getHoldability();
                return holdability;
            }
            return 0;
        }
        catch (AbstractMethodError ame) {
            if (tc.isDebugEnabled()) {
                com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"getHoldability", (Object[])new Object[]{"getHoldability is not supported in this JDBC driver. Encounter a java.lang.AbstractMethodError"});
            }
            this.holdabilitySupported = false;
            return 0;
        }
        catch (UnsupportedOperationException uex) {
            if (tc.isDebugEnabled()) {
                com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"getHoldability", (Object[])new Object[]{"getHoldability is not supported in this JDBC driver. Encounter a java.lang.UnsupportedOperationException"});
            }
            this.holdabilitySupported = false;
            return 0;
        }
        catch (SQLException sqe) {
            sqe = this.externalHelper.mapException(sqe);
            if (this.externalHelper.isConnectionError(sqe)) {
                throw sqe;
            }
            if (tc.isDebugEnabled()) {
                com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"getHoldability is not supported in this JDBC driver. Encounter a java.sql.SQLException", (Object[])new Object[]{sqe});
            }
            this.holdabilitySupported = false;
            return 0;
        }
    }

    @Override
    public boolean isIsolationLevelSwitchingSupport() {
        return false;
    }

    @Override
    public void psSetBytes(PreparedStatement pstmtImpl, int i, byte[] x) throws SQLException {
        pstmtImpl.setBytes(i, x);
    }

    @Override
    public void psSetString(PreparedStatement pstmtImpl, int i, String x) throws SQLException {
        pstmtImpl.setString(i, x);
    }

    @Override
    public void setExternalHelper(DataStoreHelper externalHelper) {
        if (tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"setExternalHelper", (Object[])new Object[]{externalHelper});
        }
        this.externalHelper = externalHelper;
    }

    @Override
    public void setDatabaseProductName(String databaseProductName) {
        this.databaseProductName = databaseProductName;
    }

    void setDriverMajorVersion(int version) {
        this.driverMajorVersion = version;
    }

    void setDriverName(String name) {
        this.driverName = name;
    }

    @Override
    public String getDatabaseProductName() {
        return this.databaseProductName;
    }

    @Override
    public void setClientInformationEndToEndMonitoring(Properties props, WSRdbManagedConnectionImpl mc, boolean explicitCall) throws SQLException {
        if (props == null) {
            return;
        }
        if (tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((TraceComponent)tc, (String)"setClientInformationEndToEndMonitoring", (Object[])new Object[]{AdapterUtil.hidePassword(props), mc, explicitCall});
        }
    }

    int getDriverMajorVersion() {
        return this.driverMajorVersion;
    }

    String getDriverName() {
        return this.driverName;
    }

    @Override
    public void setClientInformation(Properties props, WSRdbManagedConnectionImpl mc, boolean explicitCall) throws SQLException {
        if (props == null) {
            return;
        }
        if (tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((TraceComponent)tc, (String)"setClientInformation", (Object[])new Object[]{AdapterUtil.hidePassword(props), mc, explicitCall});
        }
    }

    @Override
    public void setClientInformationArray(String[] clientInfoArray, WSRdbManagedConnectionImpl mc, boolean explicitCall) throws SQLException {
    }

    @Override
    public void resetClientInformation(WSRdbManagedConnectionImpl mc) throws SQLException {
        if (mc.mcf.jdbcVersion >= 4 && (mc.clientInfoExplicitlySet || mc.clientInfoImplicitlySet)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                com.ibm.websphere.ras.Tr.entry((Object)this, (TraceComponent)tc, (String)"resetClientInformation", (Object[])new Object[]{mc});
            }
            try {
                mc.sqlConn.setClientInfo(mc.mcf.defaultClientInfo);
                mc.clientInfoExplicitlySet = false;
                mc.clientInfoImplicitlySet = false;
            }
            catch (SQLException ex) {
                FFDCFilter.processException((Throwable)ex, (String)(this.getClass().getName() + "resetClientInformation"), (String)"780", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    com.ibm.websphere.ras.Tr.exit((Object)this, (TraceComponent)tc, (String)"resetClientInformation", (Object)ex);
                }
                throw AdapterUtil.mapSQLException(ex, mc);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                com.ibm.websphere.ras.Tr.exit((Object)this, (TraceComponent)tc, (String)"resetClientInformation");
            }
        }
    }

    @Override
    public Object getSQLJContext(WSRdbManagedConnectionImpl mc, Class<?> DefaultContext) throws SQLException {
        return null;
    }

    @Override
    public void doConnectionCleanupOnWrapper(WSRdbManagedConnectionImpl mc) throws SQLException {
    }

    @Override
    public void processLastHandleClosed(Connection conn, boolean autoCommit, boolean inGlobal) throws SQLException {
    }

    @Override
    public void gatherAndDisplayMetaDataInfo(Connection conn, WSManagedConnectionFactoryImpl mcf) throws SQLException {
        block25: {
            DatabaseMetaData mData;
            block24: {
                String databaseProductVersion;
                String driverVersion;
                String driverName;
                String databaseProductName;
                block23: {
                    mData = conn.getMetaData();
                    databaseProductName = mData.getDatabaseProductName();
                    driverName = mData.getDriverName();
                    driverVersion = null;
                    databaseProductVersion = null;
                    try {
                        driverVersion = mData.getDriverVersion();
                        databaseProductVersion = mData.getDatabaseProductVersion();
                    }
                    catch (Exception e) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block23;
                        com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"Exception occurred while getting metaData info. Exception is: ", (Object[])new Object[]{e});
                    }
                }
                this.setDatabaseProductName(databaseProductName);
                this.setDriverName(driverName);
                this.setDriverMajorVersion(mData.getDriverMajorVersion());
                com.ibm.websphere.ras.Tr.info((TraceComponent)tc, (String)"DB_PRODUCT_NAME", (Object[])new Object[]{databaseProductName});
                com.ibm.websphere.ras.Tr.info((TraceComponent)tc, (String)"DB_PRODUCT_VERSION", (Object[])new Object[]{databaseProductVersion});
                com.ibm.websphere.ras.Tr.info((TraceComponent)tc, (String)"JDBC_DRIVER_NAME", (Object[])new Object[]{driverName});
                com.ibm.websphere.ras.Tr.info((TraceComponent)tc, (String)"JDBC_DRIVER_VERSION", (Object[])new Object[]{driverVersion});
                try {
                    if (mData.supportsResultSetHoldability(1) && mData.supportsResultSetHoldability(2)) {
                        if (tc.isDebugEnabled()) {
                            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"Holdabiliy is supported", (Object[])new Object[0]);
                        }
                        this.holdabilitySupported = true;
                    } else {
                        if (tc.isDebugEnabled()) {
                            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"Holdability not supported", (Object[])new Object[0]);
                        }
                        this.holdabilitySupported = false;
                    }
                }
                catch (Throwable x) {
                    if (x instanceof SQLException) {
                        SQLException sqe = this.externalHelper.mapException((SQLException)x);
                        if (this.externalHelper.isConnectionError(sqe)) {
                            throw sqe;
                        }
                        this.holdabilitySupported = false;
                        if (tc.isDebugEnabled()) {
                            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"getHoldability is not supported in this JDBC driver. Encounter a java.sql.SQLException", (Object[])new Object[]{sqe});
                        }
                    }
                    if (!tc.isDebugEnabled()) break block24;
                    com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"caught an exception when testing the holdability from metadata, will call the holdability itself to know if supported", (Object[])new Object[]{x});
                }
            }
            try {
                mcf.jdbcVersion = mData.getJDBCMajorVersion();
            }
            catch (AbstractMethodError methError) {
                mcf.jdbcVersion = 2;
            }
            catch (UnsupportedOperationException supportX) {
                mcf.jdbcVersion = 2;
            }
            catch (SQLException sqlX) {
                mcf.jdbcVersion = 2;
                if (tc.isDebugEnabled()) {
                    com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"metadata.getJDBCMajorVersion", (Object[])new Object[]{sqlX});
                }
                if (!WSJdbcUtil.isConnectionError(sqlX, (Object)mcf)) break block25;
                throw sqlX;
            }
        }
        if (mcf.jdbcVersion >= 4) {
            try {
                Properties clientInfo = conn.getClientInfo();
                if (clientInfo != null) {
                    mcf.defaultClientInfo.putAll((Map<?, ?>)clientInfo);
                }
            }
            catch (SQLFeatureNotSupportedException featureX) {
                com.ibm.websphere.ras.Tr.warning((TraceComponent)tc, (String)"FEATURE_NOT_IMPLEMENTED", (Object[])new Object[]{"java.sql.Connection.getClientInfo"});
            }
            catch (AbstractMethodError methErr) {
                if (tc.isDebugEnabled()) {
                    com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)("JDBC spec level, " + mcf.jdbcVersion + ", reported by the driver is not valid. Using 3 instead."), (Object[])new Object[0]);
                }
                mcf.jdbcVersion = 3;
            }
            catch (UnsupportedOperationException operationX) {
                com.ibm.websphere.ras.Tr.warning((TraceComponent)tc, (String)"FEATURE_NOT_IMPLEMENTED", (Object[])new Object[]{"java.sql.Connection.getClientInfo"});
            }
        }
    }

    @Override
    public boolean isInDatabaseUnitOfWork(Connection conn) throws SQLException {
        com.ibm.websphere.ras.Tr.info((TraceComponent)tc, (String)"UNSUPPORTED_METHOD", (Object[])new Object[]{"isInDatabaseUnitOfWork"});
        throw new SQLException("method not supported for this backend database");
    }

    @Override
    public ConnectionResults getPooledConnection(final CommonDataSource ds, String userName, String password, final boolean is2Phase, WSConnectionRequestInfoImpl cri, boolean useKerberos, Object gssCredential) throws ResourceException {
        if (tc.isEntryEnabled()) {
            com.ibm.websphere.ras.Tr.entry((Object)this, (TraceComponent)tc, (String)"getPooledConnection", (Object[])new Object[]{AdapterUtil.toString(ds), userName, "******", is2Phase ? "two-phase" : "one-phase", cri, useKerberos, gssCredential});
        }
        if (useKerberos) {
            com.ibm.websphere.ras.Tr.warning((TraceComponent)tc, (String)"KERBEROS_NOT_SUPPORTED_WARNING", (Object[])new Object[0]);
        }
        final String user = userName == null ? null : userName.trim();
        final String pwd = password == null ? null : password.trim();
        PrivilegedExceptionAction<Object> innerAction = new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                return is2Phase ? (user == null ? ((XADataSource)ds).getXAConnection() : ((XADataSource)ds).getXAConnection(user, pwd)) : (user == null ? ((ConnectionPoolDataSource)ds).getPooledConnection() : ((ConnectionPoolDataSource)ds).getPooledConnection(user, pwd));
            }
        };
        try {
            PooledConnection pConn = (PooledConnection)AccessController.doPrivileged(innerAction);
            if (tc.isEntryEnabled()) {
                com.ibm.websphere.ras.Tr.exit((Object)this, (TraceComponent)tc, (String)"getPooledConnection", (Object)AdapterUtil.toString(pConn));
            }
            return new ConnectionResults(pConn, null, null);
        }
        catch (PrivilegedActionException pae) {
            FFDCFilter.processException((Throwable)pae.getException(), (String)"com.ibm.ws.rsadapter.spi.InternalGenericDataStoreHelper.getPooledCon", (String)"1298");
            DataStoreAdapterException resX = AdapterUtil.createDataStoreAdapterException("JAVAX_CONN_ERR", is2Phase ? "XAConnection" : "PooledConnection", pae.getException(), InternalGenericDataStoreHelper.class);
            if (tc.isEntryEnabled()) {
                com.ibm.websphere.ras.Tr.exit((Object)this, (TraceComponent)tc, (String)"getPooledConnection", (Object)"Exception");
            }
            throw resX;
        }
        catch (ClassCastException castX) {
            FFDCFilter.processException((Throwable)castX, (String)"com.ibm.ws.rsadapter.spi.InternalGenericDataStoreHelper.getPooledCon", (String)"1312");
            if (tc.isDebugEnabled()) {
                com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"Caught ClassCastException", (Object[])new Object[]{castX});
            }
            DataStoreAdapterException resX = AdapterUtil.createDataStoreAdapterException(is2Phase ? "NOT_A_2_PHASE_DS" : "NOT_A_1_PHASE_DS", castX.getMessage(), null, InternalGenericDataStoreHelper.class);
            if (tc.isEntryEnabled()) {
                com.ibm.websphere.ras.Tr.exit((Object)this, (TraceComponent)tc, (String)"getPooledConnection", (Object)"Exception");
            }
            throw resX;
        }
    }

    @Override
    public Connection getTrustedConnection(PooledConnection pcon, String originalUser, String identityName, String password, String realm, byte[] userSecToken, byte[] cookie, Properties props) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("TRUSTED_NOT_SUPPORTED_ERROR_DSRA9541E"));
    }

    @Override
    public void reuseTrustedConnection(Connection conn, byte[] cookie, String user, String password, String userRegistry, byte[] userSecToken, String originalUser, Properties properties) throws SQLException {
        if (tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"Trusted Connection is not supported when using Generic DataStoreHelper.  No-op operation.", (Object[])new Object[0]);
        }
    }

    @Override
    public void setClientRerouteData(Object dataSource, String cRJNDIName, String cRAlternateServer, String cRAlternatePort, String cRPrimeServer, String cRPrimePort, Context jndiContext, String driverType) throws Throwable {
        if (tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"Client reroute is not supported on non-DB2 JCC driver.", (Object[])new Object[0]);
        }
    }

    @Override
    public boolean isAnAuthorizationException(SQLException x) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            com.ibm.websphere.ras.Tr.entry((Object)this, (TraceComponent)tc, (String)"isAnAuthorizationException", (Object[])new Object[]{x});
        }
        boolean isAuthError = false;
        LinkedList<SQLException> stack = new LinkedList<SQLException>();
        if (x != null && !DSConfigHelper._disableCheckingForAuthorizationException) {
            stack.push(x);
        }
        for (int depth = 0; depth < 20 && !isAuthError && !stack.isEmpty(); ++depth) {
            x = (SQLException)stack.pop();
            isAuthError |= this.isAuthException(x);
            if (x.getNextException() != null) {
                stack.push(x.getNextException());
            }
            if (!(x.getCause() instanceof SQLException) || x.getCause() == x.getNextException()) continue;
            stack.push((SQLException)x.getCause());
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            com.ibm.websphere.ras.Tr.exit((Object)this, (TraceComponent)tc, (String)"isAnAuthorizationException", (Object)isAuthError);
        }
        return isAuthError;
    }

    boolean isAuthException(SQLException x) {
        return x instanceof SQLInvalidAuthorizationSpecException || x.getSQLState() != null && x.getSQLState().startsWith("28");
    }

    @Override
    public void reuseKerbrosConnection(Connection sqlConn, GSSCredential gssCred, Properties props) throws SQLException {
        if (tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"Kerberos reuse is not supported when using Generic DataStoreHelper.  No-op operation.", (Object[])new Object[0]);
        }
    }

    @Override
    public boolean connectionIsValid(Connection conn, int timeout) throws SQLException {
        return conn.isValid(timeout);
    }

    @Override
    public void postCMXMessage(int cmxMessageType, Object[] cmxArgs, Object DBObject, boolean sendEvent) {
        if (tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"postCMXMessage: no-op", (Object[])new Object[0]);
        }
    }

    @Override
    public boolean isMonitoringEnabled(Object dsProxy) {
        if (tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"isMonitoringEnabled: false", (Object[])new Object[0]);
        }
        return false;
    }

    @Override
    public int branchCouplingSupported(int couplingType) {
        if (couplingType == 0 || couplingType == 1) {
            if (tc.isDebugEnabled()) {
                com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"Specified branch coupling type not supported", (Object[])new Object[0]);
            }
            return -1;
        }
        return 0;
    }

    @Override
    public int getDefaultBranchCoupling() {
        return -1;
    }

    @Override
    public Map<String, Object> cacheVendorConnectionProps(Connection sqlConn) throws SQLException {
        return null;
    }

    @Override
    public boolean doConnectionVendorPropertyReset(Connection sqlConn, Map<String, Object> props) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubjectDoAsForKerberos() {
        return false;
    }
}

