/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.ejs.cm.logger.TraceWriter;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.rsadapter.spi.InternalDerbyDataStoreHelper;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import javax.resource.ResourceException;

public class InternalDerbyNetworkServerDataStoreHelper
extends InternalDerbyDataStoreHelper {
    private static final Class<?> currClass = InternalDerbyNetworkServerDataStoreHelper.class;
    private static transient TraceComponent tc = Tr.register(currClass, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    private static final String TRACE_FILE = "traceFile";
    private static final String TRACE_FILE_DIR = "traceDirectory";
    private static final String TRACE_FILE_APPEND = "traceFileAppend";
    private transient PrintWriter derbyNSPw;
    private transient String traceFile;
    boolean traceAppend = false;
    String traceDir = null;

    public InternalDerbyNetworkServerDataStoreHelper() {
        this(null);
    }

    public InternalDerbyNetworkServerDataStoreHelper(ClassLoader loader) {
        super(loader);
    }

    @Override
    public com.ibm.ejs.ras.TraceComponent getTracer() {
        return null;
    }

    @Override
    public void setProperties(Properties props) throws ResourceException {
        super.setProperties(props);
        if (props != null) {
            this.traceFile = props.getProperty(TRACE_FILE);
            this.traceDir = props.getProperty(TRACE_FILE_DIR);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"traceDir is set to ", (Object[])new Object[]{this.traceDir});
            }
            this.traceDir = this.traceDir != null && !this.traceDir.equals("") ? this.traceDir + File.separator : "";
            String holder = props.getProperty(TRACE_FILE_APPEND);
            boolean bl = this.traceAppend = holder != null && Boolean.valueOf(holder) != false;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Trace Append is set to ", (Object[])new Object[]{holder});
            }
        }
        if (this.traceFile != null && !this.traceFile.equals("")) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Derby network server JDBC trace was configured to go to a file, Thus no integration with WAS trace.  File name is: ", (Object[])new Object[]{this.traceDir + this.traceFile});
            }
            this.derbyNSPw = AccessController.doPrivileged(new PrivilegedAction<PrintWriter>(){

                @Override
                public PrintWriter run() {
                    try {
                        return new PrintWriter(new FileOutputStream(InternalDerbyNetworkServerDataStoreHelper.this.traceDir + InternalDerbyNetworkServerDataStoreHelper.this.traceFile, InternalDerbyNetworkServerDataStoreHelper.this.traceAppend), true);
                    }
                    catch (IOException e) {
                        Tr.error((TraceComponent)tc, (String)"DB2_FILE_OUTSTREAM_ERROR", (Object[])new Object[]{InternalDerbyNetworkServerDataStoreHelper.this.traceFile});
                        return null;
                    }
                }
            });
        } else {
            this.derbyNSPw = new PrintWriter((Writer)new TraceWriter(derbyTc), true);
        }
    }

    @Override
    public PrintWriter getPrintWriter() throws ResourceException {
        if (this.derbyNSPw == null) {
            this.derbyNSPw = this.externalHelper.getPrintWriter();
            if (this.derbyNSPw != null) {
                Tr.debug((TraceComponent)derbyTc, (String)"user supplied own printWriter in the datastore helper, will use provided one", (Object[])new Object[]{this.derbyNSPw});
            } else {
                this.derbyNSPw = new PrintWriter((Writer)new TraceWriter(derbyTc), true);
            }
        }
        Tr.debug((TraceComponent)derbyTc, (String)"returning", (Object[])new Object[]{this.derbyNSPw});
        return this.derbyNSPw;
    }

    @Override
    public void enableJdbcLogging(WSManagedConnectionFactoryImpl mcf) throws ResourceException {
        PrintWriter pw = this.getPrintWriter();
        if (TraceComponent.isAnyTracingEnabled() && derbyTc.isDebugEnabled()) {
            Tr.debug((TraceComponent)derbyTc, (String)"enabling Derby logging {mcf, pw}: ", (Object[])new Object[]{mcf, pw});
        }
        mcf.reallySetLogWriter(pw);
        mcf.loggingEnabled = true;
    }
}

