/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.ejs.cm.logger.TraceWriter;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.DSConfig;
import com.ibm.ws.rsadapter.dbutils.DB2UniversalUtility;
import com.ibm.ws.rsadapter.dbutils.impl.DB2UniversalUtilityImpl;
import com.ibm.ws.rsadapter.exceptions.DataStoreAdapterException;
import com.ibm.ws.rsadapter.jdbc.WSJdbcConnection;
import com.ibm.ws.rsadapter.jdbc.WSJdbcUtil;
import com.ibm.ws.rsadapter.spi.ConnectionResults;
import com.ibm.ws.rsadapter.spi.InternalDB2DataStoreHelper;
import com.ibm.ws.rsadapter.spi.WSConnectionRequestInfoImpl;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;
import com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Properties;
import javax.resource.ResourceException;
import javax.sql.CommonDataSource;
import javax.sql.PooledConnection;
import org.ietf.jgss.GSSCredential;

public class InternalDB2UniversalDataStoreHelper
extends InternalDB2DataStoreHelper {
    static TraceComponent tc = Tr.register(InternalDB2UniversalDataStoreHelper.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    private static final String DB2_TRACE_LEVEL = "traceLevel";
    private static final String DB2_TRACE_FILE = "traceFile";
    private static final String DB2_TRACE_FILE_DIR = "traceDirectory";
    private static final String DB2_TRACE_FILE_APPEND = "traceFileAppend";
    DB2UniversalUtility db2UniversalUtility = null;
    private int driverType = 0;
    private int jdbcDriverMajorVersion;
    private int jdbcDriverMinorVersion;
    private boolean tightBranchCouplingSupported;
    private boolean tightBranchCouplingSupportedbyDB;
    private transient PrintWriter db2UPw;
    private transient String traceFile;
    private transient int configuredTraceLevel;
    private transient Class<InternalDB2UniversalDataStoreHelper> currClass = InternalDB2UniversalDataStoreHelper.class;
    private transient boolean _dataSourceSetFlag = false;
    private transient boolean _foundDatasourceClientInfoValue = false;
    private transient String _applicationName = " ";
    private transient String _accountInfo = " ";
    private transient String _workStation = " ";
    private transient String _clientId = " ";
    private transient Object _dataSourceLockObject = new byte[0];
    private transient boolean specialConnectionIsValidSupported = true;

    public InternalDB2UniversalDataStoreHelper() throws Exception {
        this(null);
    }

    public InternalDB2UniversalDataStoreHelper(ClassLoader loader) throws Exception {
        super(loader);
        this.db2UniversalUtility = new DB2UniversalUtilityImpl(loader);
        this.configuredTraceLevel = 0;
    }

    @Override
    public boolean failoverOccurred(SQLException sqlX) {
        return sqlX.getErrorCode() == -4498;
    }

    @Override
    public int branchCouplingSupported(int couplingType) {
        if (couplingType == 1) {
            if (this.tightBranchCouplingSupported) {
                return 0x800000;
            }
            DSConfig config = this.mcf.dsConfig.get();
            if (this.tightBranchCouplingSupportedbyDB) {
                Tr.warning((TraceComponent)tc, (String)"TBC_JCC_NOT_SUPPORTED", (Object[])new Object[]{config.jndiName == null ? config.id : config.jndiName});
            } else {
                Tr.warning((TraceComponent)tc, (String)"TBC_DB_NOT_SUPPORTED", (Object[])new Object[]{config.jndiName == null ? config.id : config.jndiName});
            }
        }
        return 0;
    }

    @Override
    public int getDefaultBranchCoupling() {
        return 0;
    }

    @Override
    public void setProperties(Properties props) throws ResourceException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        super.setProperties(props);
        this.isRRSTransaction = false;
        this.threadIdentitySupport = "NOTALLOWED";
        this.threadSecurity = false;
        boolean traceAppend = false;
        String traceDir = null;
        String dtype = null;
        boolean validDriverTypeSpecified = false;
        if (props != null) {
            dtype = props.getProperty("driverType");
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("internalDB2UniversalDataStoreHelper.setProperties():  driverType property = " + dtype), (Object[])new Object[0]);
            }
            if (dtype != null) {
                this.driverType = Integer.valueOf(dtype);
                if (this.driverType == 2 || this.driverType == 4) {
                    validDriverTypeSpecified = true;
                }
            }
        }
        if (!validDriverTypeSpecified) {
            throw new ResourceException("Required driverType property was not specifed or is invalid. The driverType property is " + dtype);
        }
        if (this.localZOS && this.driverType == 2 && props != null) {
            String dsClassName = props.getProperty("dataSourceClass");
            if (dsClassName.equals("com.ibm.db2.jcc.DB2XADataSource")) {
                throw new ResourceException(AdapterUtil.getNLSMessage("DB2ZOS_TYPE2_ERROR"));
            }
            if (dsClassName.equals("com.ibm.db2.jcc.DB2ConnectionPoolDataSource")) {
                this.isRRSTransaction = true;
                this.threadIdentitySupport = "ALLOWED";
                this.threadSecurity = true;
                Tr.info((TraceComponent)tc, (String)"DB2ZOS_CONFIG_INFO", (Object[])new Object[0]);
            }
        }
        if (props != null) {
            String holder = props.getProperty(DB2_TRACE_LEVEL);
            if (holder != null && !holder.equals("")) {
                this.configuredTraceLevel = Integer.parseInt(holder);
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"traceLevel is set to", (Object[])new Object[]{this.configuredTraceLevel});
                }
            } else if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"traceLevel is not set, using WAS default: TRACE_CONNECTION_CALLS | TRACE_DRIVER_CONFIGURATION | TRACE_CONNECTS", (Object[])new Object[0]);
            }
            this.traceFile = props.getProperty(DB2_TRACE_FILE);
            traceDir = props.getProperty(DB2_TRACE_FILE_DIR);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"traceDir is set to ", (Object[])new Object[]{traceDir});
            }
            traceDir = traceDir != null && !traceDir.equals("") ? traceDir + File.separator : "";
            holder = props.getProperty(DB2_TRACE_FILE_APPEND);
            traceAppend = Boolean.valueOf(holder);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Trace Append is set to ", (Object[])new Object[]{holder});
            }
        }
        if (this.traceFile != null && !this.traceFile.equals("")) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"DB2 JDBC trace was configured to go to a file, Thus no integration with WAS trace.  File name is: ", (Object[])new Object[]{traceDir + this.traceFile});
            }
            try {
                final String file = traceDir + this.traceFile;
                final boolean append = traceAppend;
                this.db2UPw = new PrintWriter(AccessController.doPrivileged(new PrivilegedExceptionAction<FileOutputStream>(){

                    @Override
                    public FileOutputStream run() throws FileNotFoundException {
                        return new FileOutputStream(file, append);
                    }
                }), true);
            }
            catch (PrivilegedActionException privX) {
                Exception x = privX.getException();
                FFDCFilter.processException((Throwable)x, (String)this.getClass().getName(), (String)"343", (Object)this);
                if (x instanceof FileNotFoundException) {
                    Tr.error((TraceComponent)tc, (String)"DB2_FILE_OUTSTREAM_ERROR", (Object[])new Object[]{this.traceFile});
                }
                if (x instanceof RuntimeException) {
                    throw (RuntimeException)x;
                }
                throw new ResourceException((Throwable)x);
            }
        } else {
            this.db2UPw = new PrintWriter((Writer)new TraceWriter(db2Tc), true);
        }
    }

    @Override
    public String getCorrelator(WSRdbManagedConnectionImpl mc) throws SQLException {
        try {
            return this.db2UniversalUtility.getDB2Correlator(mc.sqlConn);
        }
        catch (NullPointerException npx) {
            Tr.warning((TraceComponent)tc, (String)"DSA_GENERIC_MSG", (Object[])new Object[]{"getDB2Correlator()", npx, "method not supported on DB2 driver being used"});
            return null;
        }
        catch (NoSuchMethodError nsex) {
            Tr.warning((TraceComponent)tc, (String)"DSA_GENERIC_MSG", (Object[])new Object[]{"getDB2Correlator()", nsex, "method not supported on DB2 driver being used"});
            return null;
        }
        catch (SQLException sqlex) {
            AdapterUtil.mapSQLException(sqlex, mc);
            Tr.warning((TraceComponent)tc, (String)"DSA_GENERIC_MSG", (Object[])new Object[]{"getDB2Correlator()", sqlex, "method not supported on DB2 driver being used"});
            return null;
        }
    }

    @Override
    public boolean shouldTraceBeEnabled(WSRdbManagedConnectionImpl mc) {
        return TraceComponent.isAnyTracingEnabled() && db2Tc.isDebugEnabled() && !mc.loggingEnabled;
    }

    @Override
    public boolean shouldTraceBeDisabled(WSRdbManagedConnectionImpl mc) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        return (!isTraceOn || !db2Tc.isDebugEnabled()) && mc.loggingEnabled;
    }

    @Override
    public void disableJdbcLogging(WSRdbManagedConnectionImpl mc) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && db2Tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)db2Tc, (String)"Disabling logging on connection: ", (Object[])new Object[]{mc.sqlConn});
        }
        try {
            this.db2UniversalUtility.setJCCLogWriter(mc.sqlConn, null);
        }
        catch (SQLException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.rsadapter.spi.InternalDB2UniversalDataStoreHelper.disableJdbcLogging", (String)"402", (Object)this);
            throw AdapterUtil.translateSQLException(e, mc, true, this.currClass);
        }
        mc.loggingEnabled = false;
    }

    @Override
    public void enableJdbcLogging(WSRdbManagedConnectionImpl mc) throws ResourceException {
        PrintWriter pw = this.getPrintWriter();
        if (TraceComponent.isAnyTracingEnabled() && db2Tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)db2Tc, (String)"Setting printWriter on connection and with level", (Object[])new Object[]{pw, mc.sqlConn, this.configuredTraceLevel});
        }
        try {
            this.db2UniversalUtility.setJCCLogWriter(mc.sqlConn, pw, this.configuredTraceLevel);
        }
        catch (SQLException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.rsadapter.spi.InternalDB2UniversalDataStoreHelper.enableJdbcLogging", (String)"419", (Object)this);
            throw AdapterUtil.translateSQLException(e, mc, true, this.currClass);
        }
        mc.loggingEnabled = true;
    }

    @Override
    public PrintWriter getPrintWriter() throws ResourceException {
        if (this.db2UPw == null) {
            this.db2UPw = this.externalHelper.getPrintWriter();
            if (this.db2UPw != null && db2Tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)db2Tc, (String)"user supplied own printWriter in the datastore helper, will use provided one", (Object[])new Object[]{this.db2UPw});
            } else {
                this.db2UPw = new PrintWriter((Writer)new TraceWriter(db2Tc), true);
            }
        }
        if (db2Tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)db2Tc, (String)"returning", (Object[])new Object[]{this.db2UPw});
        }
        return this.db2UPw;
    }

    @Override
    public void setClientInformation(Properties props, WSRdbManagedConnectionImpl mc, boolean explicitCall) throws SQLException {
        this.setClientInformation(props, mc, explicitCall, false);
    }

    @Override
    public void setClientInformationEndToEndMonitoring(Properties props, WSRdbManagedConnectionImpl mc, boolean explicitCall) throws SQLException {
        this.setClientInformation(props, mc, explicitCall, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClientInformation(Properties props, WSRdbManagedConnectionImpl mc, boolean explicitCall, boolean isUsedForEndToEndFunction) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        String _applicationName = " ";
        String _accountInfo = " ";
        String _workStation = " ";
        String _clientId = " ";
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"setClientInformation", (Object[])new Object[]{AdapterUtil.hidePassword(props), mc, explicitCall, mc.sqlConn});
        }
        if (explicitCall) {
            _accountInfo = props.getProperty("CLIENT_ACCOUNTING_INFO");
            if (_accountInfo == null || _accountInfo.equals("")) {
                _accountInfo = this._accountInfo;
            }
            if ((_workStation = props.getProperty("CLIENT_LOCATION")) == null || _workStation.equals("")) {
                _workStation = this._workStation;
            }
            if ((_clientId = props.getProperty("CLIENT_ID")) == null || _clientId.equals("")) {
                _clientId = this._clientId;
            }
            if ((_applicationName = props.getProperty("CLIENT_APPLICATION_NAME")) == null || _applicationName.equals("")) {
                _applicationName = this._applicationName;
            }
            mc.clientInfoExplicitlySet = true;
        } else if (props != null) {
            Object object = this._dataSourceLockObject;
            synchronized (object) {
                if (!this._dataSourceSetFlag) {
                    this._accountInfo = props.getProperty("clientAccountingInformation");
                    if (this._accountInfo == null || this._accountInfo.equals("")) {
                        this._accountInfo = " ";
                    } else {
                        this._foundDatasourceClientInfoValue = true;
                    }
                    this._workStation = props.getProperty("clientWorkstation");
                    if (this._workStation == null || this._workStation.equals("")) {
                        this._workStation = " ";
                    } else {
                        this._foundDatasourceClientInfoValue = true;
                    }
                    this._clientId = props.getProperty("clientUser");
                    if (this._clientId == null || this._clientId.equals("")) {
                        this._clientId = " ";
                    } else {
                        this._foundDatasourceClientInfoValue = true;
                    }
                    this._applicationName = props.getProperty("clientApplicationInformation");
                    if (this._applicationName == null || this._applicationName.equals("")) {
                        this._applicationName = " ";
                    } else {
                        this._foundDatasourceClientInfoValue = true;
                    }
                    this._dataSourceSetFlag = true;
                }
            }
            if (this._foundDatasourceClientInfoValue) {
                _accountInfo = this._accountInfo;
                _workStation = this._workStation;
                _clientId = this._clientId;
                _applicationName = this._applicationName;
                mc.clientInfoExplicitlySet = true;
            }
        }
        if (_applicationName.equals(" ")) {
            try {
                J2EEName j2eeName = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData().getJ2EEName();
                _applicationName = j2eeName == null ? "NON-J2EE application" : j2eeName.getApplication();
            }
            catch (NullPointerException x) {
                _applicationName = "NON-J2EE application";
            }
            mc.clientInfoImplicitlySet = true;
        }
        StringBuffer sb = new StringBuffer(100);
        sb.append(RasHelper.getThreadId());
        sb.append('_');
        sb.append(mc.toString());
        if (!_accountInfo.equals(" ")) {
            sb.append('_');
            sb.append(_accountInfo);
        }
        _accountInfo = sb.toString();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"The accountInfo new String is:", (Object[])new Object[]{_accountInfo});
        }
        mc.holdCurrentClientInfo(_clientId, _workStation, _applicationName, _accountInfo);
        try {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("setClientInfo values  mc.sqlConn " + mc.sqlConn + " _clientId " + _clientId + " _workStation " + _workStation + " _applicationName " + _applicationName + " _accountInfo " + _accountInfo), (Object[])new Object[0]);
            }
            this.db2UniversalUtility.setDB2ClientInfo(mc.sqlConn, _clientId, _workStation, _applicationName, _accountInfo);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.spi.InternalDB2UniversalDataStoreHelper.setClientInformation", (String)"567", (Object)this);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"setClientInformation - Exception", (Object[])new Object[]{ex});
            }
            throw AdapterUtil.mapSQLException(ex, mc);
        }
    }

    @Override
    public void setClientInformationArray(String[] clientInfoArray, WSRdbManagedConnectionImpl mc, boolean explicitCall) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"setClientInformationArray", (Object[])new Object[]{clientInfoArray, mc, explicitCall});
        }
        if (explicitCall) {
            mc.clientInfoExplicitlySet = true;
        } else {
            mc.clientInfoImplicitlySet = true;
        }
        try {
            this.db2UniversalUtility.setDB2ClientInfo(mc.sqlConn, clientInfoArray[0], clientInfoArray[1], clientInfoArray[2], clientInfoArray[3]);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.spi.InternalDB2UniversalDataStoreHelper.setClientInformationArray", (String)"611", (Object)this);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"setClientInformationArray - Exception", (Object[])new Object[]{ex});
            }
            throw AdapterUtil.mapSQLException(ex, mc);
        }
    }

    @Override
    public void resetClientInformation(WSRdbManagedConnectionImpl mc) throws SQLException {
        if (mc.clientInfoExplicitlySet || mc.clientInfoImplicitlySet) {
            boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"resetClientInformation is called on: ", (Object[])new Object[]{mc});
            }
            try {
                Properties defaultClientInfo = mc.mcf.defaultClientInfo;
                String clientuser = defaultClientInfo.getProperty("ClientUser");
                String clienthostname = defaultClientInfo.getProperty("ClientHostname");
                String applicationname = defaultClientInfo.getProperty("ApplicationName");
                String clientacccountinginformation = defaultClientInfo.getProperty("ClientAccountingInformation");
                this.db2UniversalUtility.setDB2ClientInfo(mc.sqlConn, clientuser == null ? "" : clientuser, clienthostname == null ? "" : clienthostname, applicationname == null ? "" : applicationname, clientacccountinginformation == null ? "" : clientacccountinginformation);
                mc.clientInfoExplicitlySet = false;
                mc.clientInfoImplicitlySet = false;
            }
            catch (SQLException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.spi.InternalDB2UniversalDataStoreHelper.resetClientInformation", (String)"677", (Object)this);
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"resetClientInformation -- Exception", (Object[])new Object[]{ex});
                }
                throw AdapterUtil.mapSQLException(ex, mc);
            }
        }
    }

    @Override
    public boolean isIsolationLevelSwitchingSupport() {
        return true;
    }

    @Override
    public Object getSQLJContext(WSRdbManagedConnectionImpl mc, Class<?> DefaultContext) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getSQLJContext", (Object[])new Object[0]);
        }
        Object rtnctx = null;
        try {
            if (mc.cachedConnection == null) {
                mc.cachedConnection = new WSJdbcConnection(mc, mc.sqlConn, WSRdbManagedConnectionImpl.key, mc.threadID);
                mc.cachedConnection.initialize(mc.mcf.connMgr, WSRdbManagedConnectionImpl.key);
                mc.cachedConnection.setCurrentAutoCommit(mc.currentAutoCommit, WSRdbManagedConnectionImpl.key);
            } else {
                mc.cachedConnection.setThreadID(mc.threadID, WSRdbManagedConnectionImpl.key);
            }
        }
        catch (ResourceException rex) {
            FFDCFilter.processException((Throwable)rex, (String)"com.ibm.ws.rsadapter.spi.InternalDB2UniversalDataStoreHelper.getSQLJContext", (String)"550", (Object)this);
            SQLException sqlX = AdapterUtil.toSQLException(rex);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"getSQLJContext", (Object)((Object)rex));
            }
            throw sqlX;
        }
        catch (SQLException sqlx) {
            FFDCFilter.processException((Throwable)sqlx, (String)"com.ibm.ws.rsadapter.spi.InternalDB2UniversalDataStoreHelper.getSQLJContext", (String)"1009", (Object)this);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"getSQLJContext", (Object)sqlx);
            }
            throw WSJdbcUtil.mapException(mc.cachedConnection, sqlx);
        }
        try {
            rtnctx = DefaultContext.getConstructor(Connection.class).newInstance(mc.cachedConnection);
        }
        catch (Exception x) {
            RuntimeException rx;
            FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.rsadapter.spi.InternalDB2UniversalDataStoreHelper.getSQLJContext", (String)"549", (Object)this);
            if (x instanceof InvocationTargetException && x.getCause() instanceof SQLException) {
                SQLException sqlX = WSJdbcUtil.mapException(mc.cachedConnection, (SQLException)x.getCause());
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"getSQLJContext", (Object)sqlX);
                }
                throw sqlX;
            }
            RuntimeException runtimeException = rx = x instanceof RuntimeException ? (RuntimeException)x : new RuntimeException(x);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"getSQLJContext", (Object)x);
            }
            throw rx;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"getSQLJContext", rtnctx);
        }
        return rtnctx;
    }

    @Override
    public void processLastHandleClosed(Connection conn, boolean autoCommit, boolean inGlobal) throws SQLException {
    }

    @Override
    public void doConnectionCleanupOnWrapper(WSRdbManagedConnectionImpl mc) throws SQLException {
    }

    @Override
    public void gatherAndDisplayMetaDataInfo(Connection conn, WSManagedConnectionFactoryImpl mcf) throws SQLException {
        boolean isTraceOn;
        block9: {
            block8: {
                isTraceOn = TraceComponent.isAnyTracingEnabled();
                super.gatherAndDisplayMetaDataInfo(conn, mcf);
                try {
                    DatabaseMetaData mdata = conn.getMetaData();
                    this.jdbcDriverMajorVersion = mdata.getDriverMajorVersion();
                    this.jdbcDriverMinorVersion = mdata.getDriverMinorVersion();
                    if (this.driverType == 4) {
                        String productVersion = mdata.getDatabaseProductVersion().toUpperCase();
                        if (productVersion.startsWith("DSN") || productVersion.startsWith("SQL")) {
                            int version = Integer.parseInt(productVersion.substring(3, 5));
                            boolean bl = this.tightBranchCouplingSupportedbyDB = version > 7;
                        }
                        if (this.jdbcDriverMajorVersion > 4 || this.jdbcDriverMajorVersion == 4 && this.jdbcDriverMinorVersion >= 1 || this.jdbcDriverMajorVersion == 3 && (this.jdbcDriverMinorVersion >= 51 || this.jdbcDriverMinorVersion >= 6 && this.jdbcDriverMinorVersion < 50)) {
                            this.tightBranchCouplingSupported = this.tightBranchCouplingSupportedbyDB;
                        }
                    }
                }
                catch (Throwable x) {
                    FFDCFilter.processException((Throwable)x, (String)(this.getClass().getName() + ".gatherAndDisplayMetaDataInfo"), (String)"1633", (Object)this);
                    if (!isTraceOn || !tc.isDebugEnabled()) break block8;
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Unable to determine JDBC driver major/minor version.", (Object[])new Object[]{x});
                }
            }
            try {
                this.db2UniversalUtility.isInDB2UnitOfWork(conn);
                this.externalHelper.getMetaData().setSupportsUOWDetection(true);
            }
            catch (Throwable t) {
                if (!isTraceOn || !tc.isDebugEnabled()) break block9;
                Tr.debug((Object)this, (TraceComponent)tc, (String)"JCC Driver version does not support isInDB2UnitOfWork method", (Object[])new Object[0]);
            }
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"JCC Driver version supports isInDB2UnitOfWork method", (Object[])new Object[0]);
        }
    }

    @Override
    public boolean isInDatabaseUnitOfWork(Connection conn) throws SQLException {
        boolean flag = this.db2UniversalUtility.isInDB2UnitOfWork(conn);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"isInDatabaseUnitOfWork", (Object[])new Object[]{flag});
        }
        return flag;
    }

    private PooledConnection getPooledConnectionUsingKerberos(final Object gssCredential, final boolean is2Phase, final Object DSObject) throws ResourceException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getPooledConnectionUsingKerberos", (Object[])new Object[]{gssCredential, is2Phase ? "two-phase" : "one-phase", DSObject});
        }
        PooledConnection pconn = null;
        try {
            PrivilegedExceptionAction<Object> action = new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return InternalDB2UniversalDataStoreHelper.this.db2UniversalUtility.getPooledConnection(DSObject, gssCredential, is2Phase);
                }
            };
            pconn = (PooledConnection)AccessController.doPrivileged(action);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"getPooledConnectionUsingKerberos", (Object)AdapterUtil.toString(pconn));
            }
            return pconn;
        }
        catch (PrivilegedActionException pae) {
            FFDCFilter.processException((Throwable)pae.getException(), (String)"com.ibm.ws.rsadapter.InternalDB2UniversalDataStoreHelper.getPooledConnectionUsingKerberos", (String)"1412");
            DataStoreAdapterException resX = AdapterUtil.createDataStoreAdapterException("JAVAX_CONN_ERR", "PooledConnection", pae.getException(), InternalDB2UniversalDataStoreHelper.class);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"getPooledConnectionUsingKerberos", (Object)pae.getException().getMessage());
            }
            Tr.warning((TraceComponent)tc, (String)"KERBEROS_METHOD_NOT_SUPPORTED_WARNING", (Object[])new Object[0]);
            throw resX;
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.rsadapter.InternalDB2UniversalDataStoreHelper.getPooledConnectionUsingKerberos", (String)"1430");
            DataStoreAdapterException resX = AdapterUtil.createDataStoreAdapterException("JAVAX_CONN_ERR", "PooledConnection using Kerberos", t, InternalDB2UniversalDataStoreHelper.class);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"getPooledConnectionUsingKerberos", (Object)t.getMessage());
            }
            Tr.warning((TraceComponent)tc, (String)"KERBEROS_METHOD_NOT_SUPPORTED_WARNING", (Object[])new Object[0]);
            throw resX;
        }
    }

    @Override
    public ConnectionResults getPooledConnection(final CommonDataSource ds, String userName, String password, final boolean is2Phase, WSConnectionRequestInfoImpl cri, final boolean useKerberos, final Object gssCredential) throws ResourceException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getPooledConnection", (Object[])new Object[]{AdapterUtil.toString(ds), userName, "******", is2Phase ? "two-phase" : "one-phase", cri, useKerberos, gssCredential});
        }
        if (!cri.trustedConnectionMappingIsUsed || !cri.trustedContextIdentityAttributesAreSet) {
            ConnectionResults results = useKerberos ? new ConnectionResults(this.getPooledConnectionUsingKerberos(gssCredential, is2Phase, ds), null, null) : super.getPooledConnection(ds, userName, password, is2Phase, cri, useKerberos, gssCredential);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"getPooledConnection", (Object)results);
            }
            return results;
        }
        final String user = userName == null ? null : userName.trim();
        final String pwd = password == null ? null : password.trim();
        PrivilegedExceptionAction<Object[]> innerAction = new PrivilegedExceptionAction<Object[]>(){

            @Override
            public Object[] run() throws Exception {
                return is2Phase ? (user == null ? InternalDB2UniversalDataStoreHelper.this.db2UniversalUtility.getDB2TrustedXAConnection((Object)ds, useKerberos, gssCredential) : InternalDB2UniversalDataStoreHelper.this.db2UniversalUtility.getDB2TrustedXAConnection((Object)ds, user, pwd)) : (user == null ? InternalDB2UniversalDataStoreHelper.this.db2UniversalUtility.getDB2TrustedPooledConnection((Object)ds, useKerberos, gssCredential) : InternalDB2UniversalDataStoreHelper.this.db2UniversalUtility.getDB2TrustedPooledConnection((Object)ds, user, pwd));
            }
        };
        try {
            Object[] values = AccessController.doPrivileged(innerAction);
            ConnectionResults results = new ConnectionResults((PooledConnection)values[0], (byte[])values[1], null);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"getPooledConnection", (Object)values);
            }
            return results;
        }
        catch (PrivilegedActionException pae) {
            FFDCFilter.processException((Throwable)pae.getException(), (String)"com.ibm.ws.rsadapter.spi.InternalDB2UniversalDataStoreHelper.getPooledCon", (String)"1301");
            DataStoreAdapterException resX = AdapterUtil.createDataStoreAdapterException("JAVAX_CONN_ERR", is2Phase ? "TrustedXAConnection" : "TrustedPooledConnection", pae.getException(), InternalDB2UniversalDataStoreHelper.class);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"getPooledConnection", (Object)"Exception");
            }
            throw resX;
        }
        catch (ClassCastException castX) {
            FFDCFilter.processException((Throwable)castX, (String)"com.ibm.ws.rsadapter.spi.InternalDB2UniversalDataStoreHelper.getPooledCon", (String)"1312");
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Caught ClassCastException", (Object[])new Object[]{castX});
            }
            DataStoreAdapterException resX = AdapterUtil.createDataStoreAdapterException(is2Phase ? "NOT_A_2_PHASE_DS" : "NOT_A_1_PHASE_DS", castX.getMessage(), null, InternalDB2UniversalDataStoreHelper.class);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"getPooledConnection", (Object)"Exception");
            }
            throw resX;
        }
    }

    @Override
    public Connection getTrustedConnection(PooledConnection pcon, String originalUser, String identityName, String password, String realm, byte[] userSecToken, byte[] cookie, Properties props) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"getTrustedConnection", (Object[])new Object[]{pcon, originalUser, identityName, password == null ? null : "*******", realm, userSecToken, props});
        }
        return this.db2UniversalUtility.getDB2Connection(pcon, originalUser, identityName, password, realm, userSecToken, cookie, props);
    }

    @Override
    public void reuseTrustedConnection(Connection conn, byte[] cookie, String user, String password, String userRegistry, byte[] userSecToken, String originalUser, Properties properties) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"reuseConnection", (Object[])new Object[]{conn, "cookie", user, null, userRegistry, userSecToken, originalUser, AdapterUtil.hidePassword(properties)});
        }
        this.db2UniversalUtility.reuseDB2Connection(conn, cookie, user, password, userRegistry, userSecToken, originalUser, properties);
    }

    @Override
    public void reuseKerbrosConnection(Connection sqlConn, GSSCredential gssCred, Properties props) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"reuseKerbrosConnection", (Object[])new Object[]{sqlConn, gssCred, AdapterUtil.hidePassword(props)});
        }
        this.db2UniversalUtility.reuseDB2Connection(sqlConn, gssCred, props);
    }

    @Override
    public boolean connectionIsValid(Connection conn, int timeout) throws SQLException {
        block4: {
            if (this.specialConnectionIsValidSupported) {
                try {
                    return this.db2UniversalUtility.isDBValid(conn, true, timeout);
                }
                catch (SQLException x) {
                    throw x;
                }
                catch (Throwable t) {
                    this.specialConnectionIsValidSupported = false;
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"JCC Driver version does not support isDBValid method, checking will not be reattempted", (Object[])new Object[0]);
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Reason for isDBValid failure was: " + t), (Object[])new Object[0]);
                }
            }
        }
        return super.connectionIsValid(conn, timeout);
    }

    @Override
    public void postCMXMessage(int cmxMessageType, Object[] cmxArgs, Object DBObject, boolean sendEvent) {
        block3: {
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"postCMXMessage", (Object[])new Object[]{AdapterUtil.getCMXMessageString(cmxMessageType), cmxArgs, DBObject});
            }
            try {
                this.db2UniversalUtility.pushDataToCMX(cmxMessageType, cmxArgs, DBObject, sendEvent);
            }
            catch (Throwable t) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Caught exception trying to push data to CMX, exception " + t), (Object[])new Object[0]);
            }
        }
    }

    @Override
    public boolean isMonitoringEnabled(Object dsProxy) {
        boolean flag;
        block3: {
            flag = false;
            try {
                flag = this.db2UniversalUtility.isCMXMonitoringEnabled(dsProxy);
            }
            catch (ClassCastException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                Tr.debug((Object)this, (TraceComponent)tc, (String)"isMonitoringEnabled caught a Class cast exception isMonitoringEnabled:", (Object[])new Object[]{flag + " exception " + e});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"isMonitoringEnabled:", (Object[])new Object[]{flag});
        }
        return flag;
    }
}

