/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.ejs.cm.logger.TraceWriter;
import com.ibm.ejs.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.DSConfig;
import com.ibm.ws.rsadapter.dbutils.DB2UniversalUtility;
import com.ibm.ws.rsadapter.dbutils.impl.DB2UniversalUtilityImpl;
import com.ibm.ws.rsadapter.spi.InternalGenericDataStoreHelper;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;
import com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLInvalidAuthorizationSpecException;
import javax.resource.ResourceException;

public class InternalDB2DataStoreHelper
extends InternalGenericDataStoreHelper {
    private static TraceComponent tc = com.ibm.websphere.ras.Tr.register(InternalDB2DataStoreHelper.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    private DB2UniversalUtility UTILITY = null;
    protected static final TraceComponent db2Tc = Tr.register((String)"com.ibm.ws.db2.logwriter", (String)"WAS.database", null);
    String osType;
    boolean isRRSTransaction = false;
    String threadIdentitySupport = "NOTALLOWED";
    boolean threadSecurity = false;
    boolean localZOS = false;
    protected static final boolean private_disableResetUOW;
    private static Field mTransactionStateField;
    String productName = null;
    static int JDBC;
    static int SQLJ;
    int connType = 0;
    private transient PrintWriter db2Pw;

    public InternalDB2DataStoreHelper() throws Exception {
        this(null);
    }

    public InternalDB2DataStoreHelper(ClassLoader loader) throws Exception {
        super(loader);
        this.UTILITY = new DB2UniversalUtilityImpl(loader);
        if (AdapterUtil.isZOS()) {
            this.localZOS = true;
        }
        if (this.localZOS) {
            this.isRRSTransaction = true;
            this.threadIdentitySupport = "ALLOWED";
            this.threadSecurity = true;
        }
    }

    @Override
    public Boolean getRRSTransactional() {
        return this.isRRSTransaction;
    }

    @Override
    public String getThreadIdentitySupport() {
        return this.threadIdentitySupport;
    }

    @Override
    public Boolean getThreadSecurity() {
        return this.threadSecurity;
    }

    @Override
    public com.ibm.ejs.ras.TraceComponent getTracer() {
        return null;
    }

    @Override
    public PrintWriter getPrintWriter() throws ResourceException {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (this.db2Pw == null) {
            this.db2Pw = this.externalHelper.getPrintWriter();
            if (this.db2Pw != null) {
                if (trace && db2Tc.isDebugEnabled()) {
                    com.ibm.websphere.ras.Tr.debug((TraceComponent)db2Tc, (String)"user supplied own printWriter in the datastore helper, will use provided one", (Object[])new Object[]{this.db2Pw});
                }
            } else {
                this.db2Pw = new PrintWriter((Writer)new TraceWriter(db2Tc), true);
            }
        }
        if (trace && tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"returning", (Object[])new Object[]{this.db2Pw});
        }
        return this.db2Pw;
    }

    @Override
    boolean isAuthException(SQLException x) {
        int ec = x.getErrorCode();
        return x instanceof SQLInvalidAuthorizationSpecException || "28000".equals(x.getSQLState()) || -1403 == ec || -4214 == ec || -30082 == ec || x.getMessage() != null && x.getMessage().indexOf("[2013]") > 0;
    }

    @Override
    public void processLastHandleClosed(Connection conn, boolean autoCommit, boolean inGlobal) throws SQLException {
        if (this.localZOS && autoCommit && !inGlobal) {
            this.resetUOWBoundary(conn);
        }
    }

    @Override
    public void doConnectionCleanupOnWrapper(WSRdbManagedConnectionImpl mc) throws SQLException {
        if (this.localZOS) {
            this.resetUOWBoundary(mc.sqlConn);
        }
    }

    private void resetUOWBoundary(Connection conn) throws SQLException {
        if (tc.isEntryEnabled()) {
            com.ibm.websphere.ras.Tr.entry((Object)this, (TraceComponent)tc, (String)"resetUOWBoundary", (Object[])new Object[0]);
        }
        if (!private_disableResetUOW) {
            boolean rollback;
            block12: {
                rollback = true;
                if (this.localZOS && this.externalHelper.getMetaData().supportsUOWDetection()) {
                    try {
                        int mTransactionStateValue;
                        Object db2Obj = this.UTILITY.getDB2Object(conn);
                        if (mTransactionStateField == null) {
                            Class<?> db2ObjClass = db2Obj.getClass();
                            mTransactionStateField = db2ObjClass.getField("mTransactionState");
                        }
                        if ((mTransactionStateValue = mTransactionStateField.getInt(db2Obj)) == 0) {
                            rollback = false;
                        }
                    }
                    catch (Exception e) {
                        if (!tc.isEventEnabled()) break block12;
                        com.ibm.websphere.ras.Tr.event((Object)this, (TraceComponent)tc, (String)"JDBC Driver does not support UOW detection because of: ", (Object[])new Object[]{e});
                    }
                }
            }
            if (rollback) {
                if (tc.isDebugEnabled()) {
                    com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"Issuing rollback to reset UOW boundary", (Object[])new Object[0]);
                }
                conn.rollback();
            } else if (tc.isDebugEnabled()) {
                com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"Connection already on UOW boundary; skip rollback", (Object[])new Object[0]);
            }
        }
        if (tc.isEntryEnabled()) {
            com.ibm.websphere.ras.Tr.exit((Object)this, (TraceComponent)tc, (String)"resetUOWBoundary");
        }
    }

    @Override
    public boolean shouldTraceBeEnabled(WSManagedConnectionFactoryImpl mcf) {
        return db2Tc.isDebugEnabled() && !mcf.loggingEnabled;
    }

    @Override
    public boolean shouldTraceBeEnabled(WSRdbManagedConnectionImpl mc) {
        return this.shouldTraceBeEnabled(mc.mcf);
    }

    @Override
    public boolean shouldTraceBeDisabled(WSRdbManagedConnectionImpl mc) {
        return !db2Tc.isDebugEnabled() && mc.mcf.loggingEnabled;
    }

    @Override
    public boolean isInDatabaseUnitOfWork(Connection conn) throws SQLException {
        return this.UTILITY.isInDB2UnitOfWork(conn);
    }

    @Override
    public void gatherAndDisplayMetaDataInfo(Connection conn, WSManagedConnectionFactoryImpl mcf) throws SQLException {
        super.gatherAndDisplayMetaDataInfo(conn, mcf);
        if (this.getDriverName().equalsIgnoreCase("DSNAJDBC")) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"application using <DB2 for zOS Local JDBC Provider (RRS)> which is not supported anymore in WAS6.1", (Object[])new Object[0]);
            }
            com.ibm.websphere.ras.Tr.warning((TraceComponent)tc, (String)"PROVIDER_NOT_SUPPORTED", (Object[])new Object[]{"DB2 for zOS Local JDBC Provider (RRS)", "DB2 Universal JDBC Driver Provider Type 2"});
            throw new SQLException(AdapterUtil.getNLSMessage("PROVIDER_NOT_SUPPORTED", "DB2 for zOS Local JDBC Provider (RRS)", "DB2 Universal JDBC Driver Provider Type 2"));
        }
    }

    @Override
    public int branchCouplingSupported(int couplingType) {
        if (couplingType == 1) {
            DSConfig config = this.mcf.dsConfig.get();
            com.ibm.websphere.ras.Tr.warning((TraceComponent)tc, (String)"TBC_NOT_SUPPORTED", (Object[])new Object[]{config.jndiName == null ? config.id : config.jndiName});
            return -1;
        }
        return 0;
    }

    static {
        mTransactionStateField = null;
        JDBC = 1;
        SQLJ = 2;
        private_disableResetUOW = Boolean.valueOf(AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("private_disableResetUOW");
            }
        }));
        if (tc.isDebugEnabled() && private_disableResetUOW) {
            com.ibm.websphere.ras.Tr.debug((TraceComponent)tc, (String)"resetUOW is disabled", (Object[])new Object[0]);
        }
    }
}

