/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.spi.InternalDB2DataStoreHelper;
import com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import javax.resource.ResourceException;

public class InternalDB2AS400ToolboxDataStoreHelper
extends InternalDB2DataStoreHelper {
    private static TraceComponent tc = Tr.register(InternalDB2AS400ToolboxDataStoreHelper.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    private final AtomicReference<Class<?>> com_ibm_as400_access_AS400JDBCConnectionHandle_class = new AtomicReference();
    private final AtomicReference<Method> getServerJobIdentifier = new AtomicReference();
    boolean isolationLevelSwitchingSupport = false;

    public InternalDB2AS400ToolboxDataStoreHelper() throws Exception {
        this(null);
    }

    public InternalDB2AS400ToolboxDataStoreHelper(ClassLoader loader) throws Exception {
        super(loader);
        this.localZOS = false;
        this.isRRSTransaction = false;
        this.threadIdentitySupport = "NOTALLOWED";
        this.threadSecurity = false;
    }

    @Override
    public void setProperties(Properties properties) throws ResourceException {
        if (properties != null) {
            super.setProperties(properties);
            String switchingSupported = properties.getProperty("isolationLevelSwitchingSupport");
            if (switchingSupported != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("internalDB2AS400ToolboxDataStoreHelper.setProperties():  isolationSwitchingSupported property = " + switchingSupported), (Object[])new Object[0]);
                }
                this.isolationLevelSwitchingSupport = Boolean.valueOf(switchingSupported);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"internalDB2AS400ToolboxDataStoreHelper.setProperties():  isolationSwitchingSupported property not set for this datasource", (Object[])new Object[0]);
            }
        }
    }

    @Override
    public String getCorrelator(WSRdbManagedConnectionImpl mc) throws SQLException {
        block8: {
            try {
                Class<?> c = this.com_ibm_as400_access_AS400JDBCConnectionHandle_class.get();
                if (c == null) {
                    c = mc.mcf.dataSourceImplClass.getClassLoader().loadClass("com.ibm.as400.access.AS400JDBCConnectionHandle");
                    this.com_ibm_as400_access_AS400JDBCConnectionHandle_class.set(c);
                }
                if (c.isInstance(mc.sqlConn)) {
                    Method m = this.getServerJobIdentifier.get();
                    if (m == null) {
                        m = c.getMethod("getServerJobIdentifier", new Class[0]);
                        this.getServerJobIdentifier.set(m);
                    }
                    return (String)m.invoke((Object)mc.sqlConn, new Object[0]);
                }
            }
            catch (NullPointerException npx) {
                Tr.warning((TraceComponent)tc, (String)"DSA_GENERIC_MSG", (Object[])new Object[]{"getServerJobIdentifier()", npx, "method not supported on DB2 driver being used"});
            }
            catch (NoSuchMethodError nsex) {
                Tr.warning((TraceComponent)tc, (String)"DSA_GENERIC_MSG", (Object[])new Object[]{"getServerJobIdentifier()", nsex, "method not supported on DB2 driver being used"});
            }
            catch (IllegalAccessError illegalaccesserror) {
                Tr.warning((TraceComponent)tc, (String)"DSA_GENERIC_MSG", (Object[])new Object[]{"getServerJobIdentifier()", illegalaccesserror, ": AS400JDBCConnectionHandle is not a public class in the version of the Toolbox driver being used."});
            }
            catch (Exception e) {
                Tr.warning((TraceComponent)tc, (String)"DSA_GENERIC_MSG", (Object[])new Object[]{"getServerJobIdentifier()", e, "method may not be supported on DB2 driver being used"});
                if (!(e.getCause() instanceof SQLException)) break block8;
                AdapterUtil.mapSQLException((SQLException)e.getCause(), mc);
            }
        }
        return null;
    }

    @Override
    public boolean isIsolationLevelSwitchingSupport() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("internalDB2AS400ToolboxDataStoreHelper.isIsolationLevelSwitchingSupport():  isolationSwitchingSupported has a value of " + this.isolationLevelSwitchingSupport), (Object[])new Object[0]);
        }
        return this.isolationLevelSwitchingSupport;
    }
}

