/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.jdbc;

import com.ibm.websphere.ce.cm.StaleConnectionException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.rsadapter.DataStoreHelper;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.jdbc.WSJdbcConnection;
import com.ibm.ws.rsadapter.jdbc.WSJdbcDataSource;
import com.ibm.ws.rsadapter.jdbc.WSJdbcObject;
import com.ibm.ws.rsadapter.jdbc.WSJdbcWrapper;
import com.ibm.ws.rsadapter.spi.InternalDataStoreHelper;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;
import com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLRecoverableException;
import java.sql.SQLTransientConnectionException;

public class WSJdbcUtil {
    private static final TraceComponent tc = Tr.register(WSJdbcUtil.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");

    public static SQLException handleStaleStatement(WSJdbcWrapper jdbcWrapper, SQLException sqlX) {
        block6: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Encountered a Stale Statement: " + jdbcWrapper), (Object[])new Object[0]);
            }
            if (jdbcWrapper instanceof WSJdbcObject) {
                try {
                    WSJdbcConnection connWrapper = (WSJdbcConnection)((WSJdbcObject)jdbcWrapper).getConnectionWrapper();
                    WSRdbManagedConnectionImpl mc = connWrapper.managedConn;
                    connWrapper.markStmtsAsNotPoolable();
                    if (mc != null) {
                        mc.clearStatementCache();
                    }
                }
                catch (NullPointerException nullX) {
                    if (((WSJdbcObject)jdbcWrapper).isClosed()) break block6;
                    throw nullX;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"remapping StaleStatementException to StaleConnectionException", (Object[])new Object[0]);
        }
        return new StaleConnectionException(sqlX.getNextException());
    }

    public static final boolean isConnectionError(SQLException sqlX, Object mapper) {
        DataStoreHelper helper;
        DataStoreHelper dataStoreHelper = mapper instanceof WSManagedConnectionFactoryImpl ? ((WSManagedConnectionFactoryImpl)((Object)mapper)).getDataStoreHelper() : (mapper instanceof WSJdbcDataSource ? ((WSJdbcDataSource)mapper).managedConnFactory.getDataStoreHelper() : (helper = mapper instanceof WSJdbcConnection ? ((WSJdbcConnection)mapper).helper : null));
        InternalDataStoreHelper iHelper = mapper instanceof WSManagedConnectionFactoryImpl ? ((WSManagedConnectionFactoryImpl)((Object)mapper)).getInternalDataStoreHelper() : (mapper instanceof WSJdbcDataSource ? ((WSJdbcDataSource)mapper).managedConnFactory.getInternalDataStoreHelper() : (mapper instanceof WSJdbcConnection ? ((WSJdbcConnection)mapper).mcf.getInternalDataStoreHelper() : null));
        return sqlX instanceof SQLRecoverableException || sqlX instanceof SQLNonTransientConnectionException || sqlX instanceof SQLTransientConnectionException && iHelper != null && iHelper.failoverOccurred(sqlX) || sqlX instanceof StaleConnectionException && helper != null && helper.isConnectionError(sqlX);
    }

    public static SQLException mapException(WSJdbcWrapper jdbcWrapper, SQLException sqlX) {
        WSManagedConnectionFactoryImpl mapper = null;
        WSJdbcConnection connWrapper = null;
        if (jdbcWrapper instanceof WSJdbcObject) {
            connWrapper = (WSJdbcConnection)((WSJdbcObject)jdbcWrapper).getConnectionWrapper();
            if (connWrapper != null) {
                mapper = connWrapper.isClosed() ? connWrapper.mcf : connWrapper.managedConn;
            }
        } else if (jdbcWrapper instanceof WSJdbcDataSource) {
            mapper = ((WSJdbcDataSource)jdbcWrapper).managedConnFactory;
        }
        return (SQLException)AdapterUtil.mapException(sqlX, connWrapper, (Object)mapper, true);
    }
}

