/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.exceptions;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import com.ibm.websphere.ce.cm.StaleStatementException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.exception.WsException;
import com.ibm.ws.exception.WsNestedException;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.DSConfigHelper;
import com.ibm.ws.rsadapter.exceptions.WSDataTruncation;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.BatchUpdateException;
import java.sql.ClientInfoStatus;
import java.sql.DataTruncation;
import java.sql.SQLClientInfoException;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLNonTransientException;
import java.sql.SQLRecoverableException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTimeoutException;
import java.sql.SQLTransactionRollbackException;
import java.sql.SQLTransientConnectionException;
import java.sql.SQLTransientException;
import java.util.Locale;
import java.util.Map;
import javax.resource.ResourceException;

public class DataStoreAdapterException
extends ResourceException
implements WsNestedException {
    private static final long serialVersionUID = -1282552127378991160L;
    private static final String DEFAULTTEXT = "Error in a data store adapter";
    private WsException ivException = null;
    static final String resBundle = "com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS";
    private static final TraceComponent tcLocal = Tr.register(DataStoreAdapterException.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    private boolean connectionError = false;
    private boolean containsSqlException = false;
    private boolean beenMapped = false;
    private transient String messageKey;
    private boolean authorizationException = false;
    private Object[] formatArgs;

    public DataStoreAdapterException(String resourceKey, String defaultText, Class<?> logClass) {
        this(resourceKey, null, null, defaultText, logClass);
    }

    public DataStoreAdapterException(String resourceKey, Throwable ex, String defaultText, Class<?> logClass) {
        this(resourceKey, new Object[]{ex.getMessage()}, ex, defaultText, logClass);
    }

    public DataStoreAdapterException(String resourceKey, Throwable ex, Class<?> logClass) {
        this(resourceKey, new Object[]{ex.getMessage()}, ex, DEFAULTTEXT, logClass);
    }

    public DataStoreAdapterException(String resourceKey, Object[] formatArguments, String defaultText, Class<?> logClass) {
        this(resourceKey, formatArguments, null, defaultText, logClass);
    }

    public DataStoreAdapterException(String resourceKey, Object[] formatArguments, Throwable exception, String defaultText, Class<?> logClass) {
        this(TraceNLS.getFormattedMessage((String)resBundle, (String)resourceKey, (Locale)Locale.US, (Object[])formatArguments, (String)defaultText), resourceKey, formatArguments, exception, logClass);
    }

    private DataStoreAdapterException(String EnglishMessage, String resourceKey, Object[] formatArguments, Throwable exception, Class<?> logClass) {
        super(EnglishMessage);
        this.messageKey = resourceKey;
        this.formatArgs = formatArguments;
        TraceComponent tc = Tr.register(logClass, (String)"RRA", (String)resBundle);
        if (exception == null) {
            this.ivException = new WsException(EnglishMessage);
            this.ivException.fillInStackTrace();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tcLocal, (String)"DSA_ERROR", (Object[])new Object[]{this});
            }
        } else {
            if (exception instanceof SQLException) {
                this.containsSqlException = true;
                SQLException sqlex = (SQLException)exception;
                SQLException sqlexChained = sqlex.getNextException();
                Throwable cause = sqlex.getCause();
                String _sqlState = sqlex.getSQLState();
                int _errorCode = sqlex.getErrorCode();
                StringBuffer st = new StringBuffer(150);
                st.append(EnglishMessage).append(" with SQL State : ").append(_sqlState).append(" SQL Code : ").append(_errorCode);
                EnglishMessage = st.toString();
                if (DSConfigHelper._enableReplacementOfErrorMessages) {
                    String _message = AdapterUtil.getNLSMessage("SQL_STATE_ERROR_CODE", _sqlState, _errorCode);
                    if (exception instanceof StaleStatementException) {
                        exception = new StaleStatementException(sqlex.getMessage() + " " + _message, _sqlState, _errorCode);
                    } else if (exception instanceof StaleConnectionException) {
                        exception = new StaleConnectionException(sqlex.getMessage() + " " + _message, _sqlState, _errorCode);
                    } else if (exception instanceof BatchUpdateException) {
                        int[] updateCounts = ((BatchUpdateException)exception).getUpdateCounts();
                        exception = new BatchUpdateException(sqlex.getMessage() + " " + _message, _sqlState, _errorCode, updateCounts);
                    } else if (exception instanceof DataTruncation) {
                        DataTruncation dataX = (DataTruncation)exception;
                        exception = new WSDataTruncation(dataX.getMessage() + " " + _message, dataX.getIndex(), dataX.getParameter(), dataX.getRead(), dataX.getDataSize(), dataX.getTransferSize());
                        ((DataTruncation)exception).setNextWarning(dataX.getNextWarning());
                    } else if (exception instanceof SQLClientInfoException) {
                        Map<String, ClientInfoStatus> failedProps = ((SQLClientInfoException)exception).getFailedProperties();
                        exception = new SQLClientInfoException(sqlex.getMessage() + " " + _message, _sqlState, _errorCode, failedProps);
                    } else {
                        exception = exception instanceof SQLDataException ? new SQLDataException(sqlex.getMessage() + " " + _message, _sqlState, _errorCode) : (exception instanceof SQLFeatureNotSupportedException ? new SQLFeatureNotSupportedException(sqlex.getMessage() + " " + _message, _sqlState, _errorCode) : (exception instanceof SQLIntegrityConstraintViolationException ? new SQLIntegrityConstraintViolationException(sqlex.getMessage() + " " + _message, _sqlState, _errorCode) : (exception instanceof SQLInvalidAuthorizationSpecException ? new SQLInvalidAuthorizationSpecException(sqlex.getMessage() + " " + _message, _sqlState, _errorCode) : (exception instanceof SQLNonTransientException ? new SQLNonTransientException(sqlex.getMessage() + " " + _message, _sqlState, _errorCode) : (exception instanceof SQLRecoverableException ? new SQLRecoverableException(sqlex.getMessage() + " " + _message, _sqlState, _errorCode) : (exception instanceof SQLSyntaxErrorException ? new SQLSyntaxErrorException(sqlex.getMessage() + " " + _message, _sqlState, _errorCode) : (exception instanceof SQLTimeoutException ? new SQLTimeoutException(sqlex.getMessage() + " " + _message, _sqlState, _errorCode) : (exception instanceof SQLTransactionRollbackException ? new SQLTransactionRollbackException(sqlex.getMessage() + " " + _message, _sqlState, _errorCode) : (exception instanceof SQLTransientConnectionException ? new SQLTransientConnectionException(sqlex.getMessage() + " " + _message, _sqlState, _errorCode) : (exception instanceof SQLNonTransientConnectionException ? new SQLNonTransientConnectionException(sqlex.getMessage() + " " + _message, _sqlState, _errorCode) : (exception instanceof SQLTransientException ? new SQLTransientException(sqlex.getMessage() + " " + _message, _sqlState, _errorCode) : new SQLException(sqlex.getMessage() + " " + _message, _sqlState, _errorCode))))))))))));
                    }
                    exception.setStackTrace(sqlex.getStackTrace());
                    if (cause != null) {
                        exception.initCause(cause);
                    }
                    if (sqlexChained != null) {
                        ((SQLException)exception).setNextException(sqlexChained);
                    }
                }
            }
            this.ivException = new WsException(EnglishMessage, exception);
            this.ivException.setStackTrace(exception.getStackTrace());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception", (Object[])new Object[]{exception});
            }
        }
    }

    public void printStackTrace() {
        this.ivException.printStackTrace();
    }

    public void printStackTrace(PrintWriter pw) {
        this.ivException.printStackTrace(pw);
    }

    public void printStackTrace(PrintStream stream) {
        this.ivException.printStackTrace(stream);
    }

    public void printSuperStackTrace(PrintWriter pw) {
        super.printStackTrace(pw);
    }

    public boolean beenMapped() {
        return this.beenMapped;
    }

    public void setBeenMapped() {
        this.beenMapped = true;
    }

    public boolean isConnectionError() {
        return this.connectionError;
    }

    public boolean containsSqlException() {
        return this.containsSqlException;
    }

    public void setConnectionError(boolean connErr) {
        this.connectionError = connErr;
    }

    public Exception getLinkedException() {
        for (Throwable t = this.getCause(); t != null; t = t.getCause()) {
            if (!(t instanceof Exception)) continue;
            return (Exception)t;
        }
        return null;
    }

    public void setLinkedException(Exception ex) {
        String defaultText = this.ivException.getMessage();
        this.ivException = new WsException(defaultText, (Throwable)ex);
        this.containsSqlException = ex instanceof SQLException;
    }

    public Throwable getCause() {
        return this.ivException.getCause();
    }

    public Throwable initCause(Throwable cause) throws IllegalArgumentException, IllegalStateException {
        return this.ivException.initCause(cause);
    }

    public final String translate(Locale locale) {
        if (this.messageKey == null) {
            return this.getMessage();
        }
        return TraceNLS.getFormattedMessage((String)resBundle, (String)this.messageKey, (Locale)locale, (Object[])this.formatArgs, (String)this.messageKey);
    }

    public boolean isAuthorizationException() {
        return this.authorizationException;
    }

    public void setAuthorizationException(boolean connAuthErr) {
        this.authorizationException = connAuthErr;
    }
}

