/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.dbutils.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.dbutils.OracleUtility;
import com.ibm.ws.rsadapter.jdbc.WSJdbcTracer;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import javax.transaction.xa.XAException;

public class OracleUtilityImpl
implements OracleUtility {
    private static TraceComponent tc = Tr.register(OracleUtilityImpl.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    private static final int NOT_CACHED = -99;
    private int driverMajorVersion = -99;
    private static final String oracle_jdbc_OracleConnection = "oracle.jdbc.OracleConnection";
    private static final String oracle_jdbc_OraclePreparedStatement = "oracle.jdbc.OraclePreparedStatement";
    private static final String oracle_jdbc_driver_OracleLog = "oracle.jdbc.driver.OracleLog";
    private final ClassLoader loader;
    private final AtomicReference<Class<?>> oracle_jdbc_OracleConnection_class = new AtomicReference();
    private final AtomicReference<Method> clearDefines = new AtomicReference();
    private final AtomicReference<Method> close = new AtomicReference();
    private final AtomicReference<Method> getDefaultExecuteBatch = new AtomicReference();
    private final AtomicReference<Method> getDefaultRowPrefetch = new AtomicReference();
    private final AtomicReference<Method> getDefaultTimeZone = new AtomicReference();
    private final AtomicReference<Method> getIncludeSynonyms = new AtomicReference();
    private final AtomicReference<Method> getRemarksReporting = new AtomicReference();
    private final AtomicReference<Method> getRestrictGetTables = new AtomicReference();
    private final AtomicReference<Method> getSessionTimeZone = new AtomicReference();
    private final AtomicReference<Method> isProxySession = new AtomicReference();
    private final AtomicReference<Method> setClientIdentifier = new AtomicReference();
    private final AtomicReference<Method> setDefaultExecuteBatch = new AtomicReference();
    private final AtomicReference<Method> setDefaultRowPrefetch = new AtomicReference();
    private final AtomicReference<Method> setDefaultTimeZone = new AtomicReference();
    private final AtomicReference<Method> setEndToEndMetrics = new AtomicReference();
    private final AtomicReference<Method> setIncludeSynonyms = new AtomicReference();
    private final AtomicReference<Method> setLobPrefetchSize = new AtomicReference();
    private final AtomicReference<Method> setRemarksReporting = new AtomicReference();
    private final AtomicReference<Method> setRestrictGetTables = new AtomicReference();
    private final AtomicReference<Method> setRowPrefetch = new AtomicReference();
    private final AtomicReference<Method> setSessionTimeZone = new AtomicReference();

    public OracleUtilityImpl(ClassLoader loader) {
        this.loader = loader;
    }

    @Override
    public void setLogVolume(int arg) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLogWriter(PrintWriter writer) {
        try {
            Class<?> c = this.loader.loadClass(oracle_jdbc_driver_OracleLog);
            c.getMethod("setLogWriter", PrintWriter.class).invoke(null, writer);
        }
        catch (NoSuchMethodException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Method not found.", (Object[])new Object[]{"setLogWriter", e});
            }
            Tr.warning((TraceComponent)tc, (String)"METHOD_NOT_FOUND_WARNING", (Object[])new Object[]{"setLogWriter", oracle_jdbc_driver_OracleLog});
        }
        catch (Throwable e) {
            Tr.warning((TraceComponent)tc, (String)"METHOD_EXEC_FAILED_WARNING", (Object[])new Object[]{"setLogWriter", e});
        }
    }

    @Override
    public void setClientIdentifier(Connection sqlConn, String id) throws SQLException {
        try {
            Method m = this.setClientIdentifier.get();
            if (m == null) {
                Class<?> c = this.loader.loadClass("oracle.jdbc.driver.OracleConnection");
                m = c.getMethod("setClientIdentifier", String.class);
                this.setClientIdentifier.set(m);
            }
            m.invoke(WSJdbcTracer.getImpl(sqlConn), id);
        }
        catch (NoSuchMethodException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Method not found.", (Object[])new Object[]{"setClientIdentifier", e});
            }
            Tr.warning((TraceComponent)tc, (String)"METHOD_NOT_FOUND_WARNING", (Object[])new Object[]{"setClientIdentifier", WSJdbcTracer.getImpl(sqlConn)});
        }
        catch (Throwable e) {
            Tr.warning((TraceComponent)tc, (String)"METHOD_EXEC_FAILED_WARNING", (Object[])new Object[]{"setLogWriter", e});
            throw AdapterUtil.toSQLException(e);
        }
    }

    @Override
    public int getEndToEndStateIndexMax() {
        return 4;
    }

    @Override
    public void setTrace(boolean b) {
        try {
            Class<?> c = this.loader.loadClass(oracle_jdbc_driver_OracleLog);
            c.getMethod("setTrace", Boolean.TYPE).invoke(null, b);
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new RuntimeException(x instanceof InvocationTargetException ? x.getCause() : x);
        }
    }

    @Override
    public int getEndToEndClientIdIndex() {
        return 1;
    }

    @Override
    public void setEndToEndMetrics(Connection sqlConn, String[] matrix, short s) throws SQLException {
        try {
            Method m = this.setEndToEndMetrics.get();
            if (m == null) {
                Class<?> c = this.oracle_jdbc_OracleConnection_class.get();
                if (c == null) {
                    c = this.loader.loadClass(oracle_jdbc_OracleConnection);
                    this.oracle_jdbc_OracleConnection_class.set(c);
                }
                m = c.getMethod("setEndToEndMetrics", String[].class, Short.TYPE);
                this.setEndToEndMetrics.set(m);
            }
            m.invoke(WSJdbcTracer.getImpl(sqlConn), matrix, s);
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw AdapterUtil.toSQLException(x);
        }
    }

    @Override
    public Map<String, Object> cacheVendorConnectionProps(Connection sqlConn) throws SQLException {
        try {
            Method m;
            Class<?> c = this.oracle_jdbc_OracleConnection_class.get();
            if (c == null) {
                c = this.loader.loadClass(oracle_jdbc_OracleConnection);
                this.oracle_jdbc_OracleConnection_class.set(c);
            }
            HashMap<String, Object> tempProps = new HashMap<String, Object>();
            if (this.driverMajorVersion == -99) {
                this.driverMajorVersion = sqlConn.getMetaData().getDriverMajorVersion();
            }
            if ((m = this.getDefaultExecuteBatch.get()) == null) {
                m = c.getMethod("getDefaultExecuteBatch", new Class[0]);
                this.getDefaultExecuteBatch.set(m);
            }
            tempProps.put("DefaultExecuteBatch", m.invoke((Object)sqlConn, new Object[0]));
            m = this.getDefaultRowPrefetch.get();
            if (m == null) {
                m = c.getMethod("getDefaultRowPrefetch", new Class[0]);
                this.getDefaultRowPrefetch.set(m);
            }
            tempProps.put("DefaultRowPrefetch", m.invoke((Object)sqlConn, new Object[0]));
            if (this.driverMajorVersion > 10) {
                m = this.getDefaultTimeZone.get();
                if (m == null) {
                    m = c.getMethod("getDefaultTimeZone", new Class[0]);
                    this.getDefaultTimeZone.set(m);
                }
                tempProps.put("DefaultTimeZone", m.invoke((Object)sqlConn, new Object[0]));
            }
            if ((m = this.getIncludeSynonyms.get()) == null) {
                m = c.getMethod("getIncludeSynonyms", new Class[0]);
                this.getIncludeSynonyms.set(m);
            }
            tempProps.put("IncludeSynonyms", m.invoke((Object)sqlConn, new Object[0]));
            m = this.getRemarksReporting.get();
            if (m == null) {
                m = c.getMethod("getRemarksReporting", new Class[0]);
                this.getRemarksReporting.set(m);
            }
            tempProps.put("RemarksReporting", m.invoke((Object)sqlConn, new Object[0]));
            m = this.getRestrictGetTables.get();
            if (m == null) {
                m = c.getMethod("getRestrictGetTables", new Class[0]);
                this.getRestrictGetTables.set(m);
            }
            tempProps.put("RestrictGetTables", m.invoke((Object)sqlConn, new Object[0]));
            m = this.getSessionTimeZone.get();
            if (m == null) {
                m = c.getMethod("getSessionTimeZone", new Class[0]);
                this.getSessionTimeZone.set(m);
            }
            tempProps.put("SessionTimeZone", m.invoke((Object)sqlConn, new Object[0]));
            return tempProps;
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw AdapterUtil.toSQLException(x);
        }
    }

    @Override
    public void clearDefines(PreparedStatement stmt) throws SQLException {
        try {
            Method m = this.clearDefines.get();
            if (m == null) {
                Class<?> c = this.loader.loadClass(oracle_jdbc_OraclePreparedStatement);
                m = c.getMethod("clearDefines", new Class[0]);
                this.clearDefines.set(m);
            }
            m.invoke((Object)stmt, new Object[0]);
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw AdapterUtil.toSQLException(x);
        }
    }

    @Override
    public boolean closeProxySession(Connection conn) throws SQLException {
        boolean result;
        boolean trace;
        block11: {
            trace = TraceComponent.isAnyTracingEnabled();
            if (trace && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"closeProxySession", (Object[])new Object[0]);
            }
            result = false;
            try {
                Class<?> c = this.oracle_jdbc_OracleConnection_class.get();
                if (c == null) {
                    c = this.loader.loadClass(oracle_jdbc_OracleConnection);
                    this.oracle_jdbc_OracleConnection_class.set(c);
                }
                if (!c.isInstance(conn)) break block11;
                try {
                    Method m = this.isProxySession.get();
                    if (m == null) {
                        m = c.getMethod("isProxySession", new Class[0]);
                        this.isProxySession.set(m);
                    }
                    if (((Boolean)m.invoke((Object)conn, new Object[0])).booleanValue()) {
                        m = this.close.get();
                        if (m == null) {
                            m = c.getMethod("close", Integer.TYPE);
                            this.close.set(m);
                        }
                        m.invoke((Object)conn, 1);
                        result = true;
                    }
                }
                catch (NoSuchMethodException nsme) {}
            }
            catch (RuntimeException x) {
                throw x;
            }
            catch (Exception x) {
                throw AdapterUtil.toSQLException(x);
            }
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"closeProxySession", (Object)result);
        }
        return result;
    }

    @Override
    public boolean doConnectionVendorPropertyReset(Connection sqlConn, Map<String, Object> props) throws SQLException {
        try {
            Method m;
            Class<?> c = this.oracle_jdbc_OracleConnection_class.get();
            if (c == null) {
                c = this.loader.loadClass(oracle_jdbc_OracleConnection);
                this.oracle_jdbc_OracleConnection_class.set(c);
            }
            if ((m = this.setDefaultExecuteBatch.get()) == null) {
                m = c.getMethod("setDefaultExecuteBatch", Integer.TYPE);
                this.setDefaultExecuteBatch.set(m);
            }
            m.invoke((Object)sqlConn, props.get("DefaultExecuteBatch"));
            m = this.setDefaultRowPrefetch.get();
            if (m == null) {
                m = c.getMethod("setDefaultRowPrefetch", Integer.TYPE);
                this.setDefaultRowPrefetch.set(m);
            }
            m.invoke((Object)sqlConn, props.get("DefaultRowPrefetch"));
            if (this.driverMajorVersion > 10) {
                m = this.setDefaultTimeZone.get();
                if (m == null) {
                    m = c.getMethod("setDefaultTimeZone", TimeZone.class);
                    this.setDefaultTimeZone.set(m);
                }
                m.invoke((Object)sqlConn, props.get("DefaultTimeZone"));
            }
            if ((m = this.setIncludeSynonyms.get()) == null) {
                m = c.getMethod("setIncludeSynonyms", Boolean.TYPE);
                this.setIncludeSynonyms.set(m);
            }
            m.invoke((Object)sqlConn, props.get("IncludeSynonyms"));
            m = this.setRemarksReporting.get();
            if (m == null) {
                m = c.getMethod("setRemarksReporting", Boolean.TYPE);
                this.setRemarksReporting.set(m);
            }
            m.invoke((Object)sqlConn, props.get("RemarksReporting"));
            m = this.setRestrictGetTables.get();
            if (m == null) {
                m = c.getMethod("setRestrictGetTables", Boolean.TYPE);
                this.setRestrictGetTables.set(m);
            }
            m.invoke((Object)sqlConn, props.get("RestrictGetTables"));
            String s = (String)props.get("SessionTimeZone");
            if (s == null) {
                s = TimeZone.getDefault().getID();
            }
            if ((m = this.setSessionTimeZone.get()) == null) {
                m = c.getMethod("setSessionTimeZone", String.class);
                this.setSessionTimeZone.set(m);
            }
            m.invoke((Object)sqlConn, s);
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw AdapterUtil.toSQLException(x);
        }
        return true;
    }

    @Override
    public String getXAExceptionContents(XAException xae) {
        StringBuilder xsb;
        block4: {
            xsb = new StringBuilder(350);
            try {
                Class<?> c = this.loader.loadClass("oracle.jdbc.xa.OracleXAException");
                if (c.isInstance(xae)) {
                    int xaerror = (Integer)c.getMethod("getXAError", new Class[0]).invoke((Object)xae, new Object[0]);
                    int oraerr = (Integer)c.getMethod("getOracleError", new Class[0]).invoke((Object)xae, new Object[0]);
                    Method getXAErrorMessage = c.getMethod("getXAErrorMessage", Integer.TYPE);
                    String EOLN = AdapterUtil.EOLN;
                    xsb.append(EOLN).append("The XA Error is            : ").append(xaerror).append(EOLN);
                    xsb.append("The XA Error message is    : ").append(getXAErrorMessage.invoke(null, xaerror)).append(EOLN);
                    xsb.append("The Oracle Error code is   : ").append(oraerr).append(EOLN);
                    xsb.append("The Oracle Error message is: ").append(getXAErrorMessage.invoke(null, oraerr)).append(EOLN);
                }
            }
            catch (Exception x) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)"getXAExceptionContents", (Object[])new Object[]{x});
            }
        }
        if (xae.getCause() != null) {
            xsb.append("The cause is               : ").append(xae.getCause());
        }
        return new String(xsb);
    }

    @Override
    public void setDefaultRowPrefetch(PreparedStatement stmt) throws SQLException {
        try {
            Method m = this.getDefaultRowPrefetch.get();
            if (m == null) {
                Class<?> c = this.oracle_jdbc_OracleConnection_class.get();
                if (c == null) {
                    c = this.loader.loadClass(oracle_jdbc_OracleConnection);
                    this.oracle_jdbc_OracleConnection_class.set(c);
                }
                m = c.getMethod("getDefaultRowPrefetch", new Class[0]);
                this.getDefaultRowPrefetch.set(m);
            }
            Object defaultRowPrefetch = m.invoke((Object)stmt.getConnection(), new Object[0]);
            m = this.setRowPrefetch.get();
            if (m == null) {
                Class<?> c = this.loader.loadClass(oracle_jdbc_OraclePreparedStatement);
                m = c.getMethod("setRowPrefetch", Integer.TYPE);
                this.setRowPrefetch.set(m);
            }
            m.invoke((Object)stmt, defaultRowPrefetch);
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw AdapterUtil.toSQLException(x);
        }
    }

    @Override
    public void setLobPrefetchSize(PreparedStatement stmt, int size) throws SQLException {
        try {
            Method m = this.setLobPrefetchSize.get();
            if (m == null) {
                Class<?> c = this.loader.loadClass(oracle_jdbc_OraclePreparedStatement);
                m = c.getMethod("setLobPrefetchSize", Integer.TYPE);
                this.setLobPrefetchSize.set(m);
            }
            m.invoke((Object)stmt, size);
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw AdapterUtil.toSQLException(x);
        }
    }
}

