/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.jca.cm.ConnectorService;
import com.ibm.ws.jdbc.internal.DataSourceDef;
import com.ibm.ws.jdbc.osgi.JDBCRuntimeVersion;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.CommitOrRollbackOnCleanup;
import com.ibm.ws.rsadapter.ConnectionSharing;
import com.ibm.ws.rsadapter.DSConfigHelper;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;
import com.ibm.wsspi.kernel.service.utils.MetatypeUtils;
import java.io.Serializable;
import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.resource.ResourceException;
import javax.sql.CommonDataSource;

public class DSConfig
implements FFDCSelfIntrospectable {
    private static final TraceComponent tc = Tr.register(DSConfig.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    public static final String BEGIN_TRAN_FOR_SCROLLING_APIS = "beginTranForResultSetScrollingAPIs";
    public static final String BEGIN_TRAN_FOR_VENDOR_APIS = "beginTranForVendorAPIs";
    public static final String COMMIT_OR_ROLLBACK_ON_CLEANUP = "commitOrRollbackOnCleanup";
    public static final String CONNECTION_MANAGER_REF = "connectionManagerRef";
    public static final String CONNECTION_SHARING = "connectionSharing";
    public static final String CONTAINER_AUTH_DATA_REF = "containerAuthDataRef";
    public static final String DATA_STORE_HELPER_CLASS = "dataStoreHelperClass";
    public static final String ENABLE_CONNECTION_CASTING = "enableConnectionCasting";
    public static final String ENABLE_MULTITHREADED_ACCESS_DETECTION = "enableMultithreadedAccessDetection";
    public static final String JDBC_DRIVER_REF = "jdbcDriverRef";
    public static final String QUERY_TIMEOUT = "queryTimeout";
    public static final String RECOVERY_AUTH_DATA_REF = "recoveryAuthDataRef";
    public static final String RESULTSET_UNUSABLE_WHEN_NO_MORE_RESULTS = "resultSetUnusableWhenNoMoreResults";
    public static final String STATEMENT_CACHE_SIZE = "statementCacheSize";
    public static final String SUPPLEMENTAL_JDBC_TRACE = "supplementalJDBCTrace";
    public static final String SYNC_QUERY_TIMEOUT_WITH_TRAN_TIMEOUT = "syncQueryTimeoutWithTransactionTimeout";
    public static final String TYPE = "type";
    public static final List<String> DATA_SOURCE_PROPS = Collections.unmodifiableList(Arrays.asList("beginTranForResultSetScrollingAPIs", "beginTranForVendorAPIs", "commitOrRollbackOnCleanup", "connectionManagerRef", "connectionSharing", "containerAuthDataRef", "dataStoreHelperClass", DataSourceDef.isolationLevel.name(), "enableConnectionCasting", "jdbcDriverRef", "queryTimeout", "recoveryAuthDataRef", "statementCacheSize", "supplementalJDBCTrace", "syncQueryTimeoutWithTransactionTimeout", DataSourceDef.transactional.name(), "type"));
    private static final AtomicInteger NUM_INITIALIZED = new AtomicInteger();
    public static final String ORACLE_UCP_DATASOURCE_CP_IMPL = "oracle.ucp.jdbc.PoolDataSourceImpl";
    public static final String ORACLE_UCP_DATASOURCE_XA_IMPL = "oracle.ucp.jdbc.PoolXADataSourceImpl";
    public final boolean beginTranForResultSetScrollingAPIs;
    public final boolean beginTranForVendorAPIs;
    public final ClassLoader classloader;
    public final CommitOrRollbackOnCleanup commitOrRollbackOnCleanup;
    private int configID;
    public final int connectionSharing;
    public final ConnectorService connectorSvc;
    private String dataStoreHelperClass;
    public final boolean enableConnectionCasting;
    public final boolean enableMultithreadedAccessDetection;
    public final boolean enableWASConnectionPooling;
    private NavigableMap<String, Object> entries;
    private Map.Entry<String, Object> entry;
    public final String id;
    public final int isolationLevel;
    public final boolean isUCP;
    public final String jndiName;
    private WSManagedConnectionFactoryImpl mcf;
    public final Properties propsWithStringValues;
    public final Integer queryTimeout;
    public final int statementCacheSize;
    public final Boolean supplementalJDBCTrace;
    public final boolean syncQueryTimeoutWithTransactionTimeout;
    public final boolean resultSetUnusableWhenNoMoreResults;
    public final boolean transactional;
    public final Class<? extends CommonDataSource> type;
    public final Properties vendorProps;

    public DSConfig(DSConfig source, NavigableMap<String, Object> wProps) throws Exception {
        this(source.id, source.jndiName, source.type, wProps, source.vendorProps, source.propsWithStringValues, source.mcf.getDataSourceClassName(), source.connectorSvc);
        this.configID = source.configID;
        this.mcf = source.mcf;
    }

    public DSConfig(String id, String jndi, Class<? extends CommonDataSource> ifc, NavigableMap<String, Object> wProps, Properties vProps, Properties svProps, Class<?> dsImplClass, ConnectorService connectorSvc) throws Exception {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)this.getClass().getSimpleName(), (Object[])new Object[]{jndi, wProps});
        }
        this.classloader = dsImplClass.getClassLoader();
        this.connectorSvc = connectorSvc;
        this.id = id;
        this.jndiName = jndi;
        this.type = ifc;
        this.vendorProps = vProps;
        this.propsWithStringValues = svProps;
        String dsImplClassName = dsImplClass.getName();
        this.isUCP = ORACLE_UCP_DATASOURCE_CP_IMPL.equals(dsImplClassName) || ORACLE_UCP_DATASOURCE_XA_IMPL.equals(dsImplClassName);
        boolean bl = this.enableWASConnectionPooling = !this.isUCP;
        if (!this.enableWASConnectionPooling) {
            Tr.info((TraceComponent)tc, (String)"WAS_CONNECTION_POOLING_DISABLED_INFO", (Object[])new Object[0]);
        }
        this.entries = wProps;
        this.entry = this.entries.pollFirstEntry();
        this.beginTranForResultSetScrollingAPIs = this.remove(BEGIN_TRAN_FOR_SCROLLING_APIS, true);
        this.beginTranForVendorAPIs = this.remove(BEGIN_TRAN_FOR_VENDOR_APIS, true);
        CommitOrRollbackOnCleanup commitOrRollback = this.remove(COMMIT_OR_ROLLBACK_ON_CLEANUP, null, CommitOrRollbackOnCleanup.class);
        this.connectionSharing = this.remove((String)CONNECTION_SHARING, ConnectionSharing.MatchOriginalRequest, ConnectionSharing.class).value;
        this.dataStoreHelperClass = this.remove(DATA_STORE_HELPER_CLASS, (String)null);
        this.enableConnectionCasting = this.remove(ENABLE_CONNECTION_CASTING, false);
        this.enableMultithreadedAccessDetection = false;
        this.isolationLevel = this.remove(DataSourceDef.isolationLevel.name(), -1, -1, null, -1, 0, 1, 2, 4, 8, 16, 4096);
        this.queryTimeout = this.remove(QUERY_TIMEOUT, null, 0, TimeUnit.SECONDS, new int[0]);
        this.resultSetUnusableWhenNoMoreResults = this.remove(RESULTSET_UNUSABLE_WHEN_NO_MORE_RESULTS, false);
        this.statementCacheSize = this.remove(STATEMENT_CACHE_SIZE, this.enableWASConnectionPooling ? 10 : 0, 0, null, new int[0]);
        this.supplementalJDBCTrace = this.remove(SUPPLEMENTAL_JDBC_TRACE, (Boolean)null);
        this.syncQueryTimeoutWithTransactionTimeout = this.remove(SYNC_QUERY_TIMEOUT_WITH_TRAN_TIMEOUT, false);
        this.transactional = this.remove(DataSourceDef.transactional.name(), true);
        Object object = commitOrRollback == null ? (this.transactional ? null : CommitOrRollbackOnCleanup.rollback) : (this.commitOrRollbackOnCleanup = commitOrRollback);
        if (trace && tc.isDebugEnabled() && this.entry != null) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("unknown attributes: " + this.entries), (Object[])new Object[0]);
        }
        this.entries = null;
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)this.getClass().getSimpleName(), (Object)this);
        }
    }

    public DSConfig(WSManagedConnectionFactoryImpl mcf, String dsImplClassName, Properties originalProps, Properties p, Properties helperProps) {
        throw new IllegalStateException();
    }

    public final int getConfigID() {
        return this.configID;
    }

    public final WSManagedConnectionFactoryImpl getManagedConnectionFactory() {
        return this.mcf;
    }

    public void init(AtomicReference<DSConfig> dsConfigRef, CommonDataSource ds, JDBCRuntimeVersion jdbcFeatureVersion) throws ResourceException {
        dsConfigRef.set(this);
        this.configID = NUM_INITIALIZED.incrementAndGet();
        String dsImplClassName = ds.getClass().getName();
        this.propsWithStringValues.remove("password");
        this.propsWithStringValues.setProperty("dataSourceClass", dsImplClassName);
        if (this.dataStoreHelperClass == null) {
            this.dataStoreHelperClass = DSConfigHelper.getDataStoreHelperClassName(dsImplClassName);
        }
        this.mcf = new WSManagedConnectionFactoryImpl(dsConfigRef, ds, jdbcFeatureVersion, this.classloader, this.dataStoreHelperClass, this.propsWithStringValues);
    }

    public String[] introspectSelf() {
        List<Serializable> nameValuePairs = Arrays.asList(new Serializable[]{BEGIN_TRAN_FOR_SCROLLING_APIS, Boolean.valueOf(this.beginTranForResultSetScrollingAPIs), BEGIN_TRAN_FOR_VENDOR_APIS, Boolean.valueOf(this.beginTranForVendorAPIs), COMMIT_OR_ROLLBACK_ON_CLEANUP, this.commitOrRollbackOnCleanup, CONNECTION_SHARING, Integer.valueOf(this.connectionSharing), DataSourceDef.isolationLevel.name(), Integer.valueOf(this.isolationLevel), "jndiName", this.jndiName, ENABLE_CONNECTION_CASTING, Boolean.valueOf(this.enableConnectionCasting), QUERY_TIMEOUT, this.queryTimeout, RESULTSET_UNUSABLE_WHEN_NO_MORE_RESULTS, Boolean.valueOf(this.resultSetUnusableWhenNoMoreResults), STATEMENT_CACHE_SIZE, Integer.valueOf(this.statementCacheSize), SUPPLEMENTAL_JDBC_TRACE, this.supplementalJDBCTrace, SYNC_QUERY_TIMEOUT_WITH_TRAN_TIMEOUT, Boolean.valueOf(this.syncQueryTimeoutWithTransactionTimeout), DataSourceDef.transactional.name(), Boolean.valueOf(this.transactional)});
        List<Object> valuesOnly = Arrays.asList(this.classloader, this.enableWASConnectionPooling, this.isUCP, this.type);
        return new String[]{this.toString(), nameValuePairs.toString(), valuesOnly.toString(), AdapterUtil.hidePassword(this.propsWithStringValues).toString()};
    }

    private Boolean remove(String name, Boolean defaultValue) throws SQLException {
        int diff;
        Boolean value = null;
        while (value == null && this.entry != null && (diff = this.entry.getKey().compareTo(name)) <= 0) {
            if (diff == 0) {
                value = this.entry.getValue() instanceof Boolean ? (Boolean)this.entry.getValue() : Boolean.parseBoolean((String)this.entry.getValue());
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("unrecognized attribute: " + name), (Object[])new Object[0]);
            }
            this.entry = this.entries.pollFirstEntry();
        }
        return value == null ? defaultValue : value;
    }

    /*
     * Unable to fully structure code
     */
    private <E extends Enum<E>> E remove(String name, E defaultValue, Class<E> type) throws Exception {
        value = null;
        while (value == null && this.entry != null && (diff = this.entry.getKey().compareTo(name)) <= 0) {
            if (diff == 0) {
                try {
                    value = Enum.valueOf(type, (String)this.entry.getValue());
                }
                catch (Exception x) {
                    x = (Exception)this.connectorSvc.ignoreWarnOrFail(null, (Throwable)x, x.getClass(), "UNSUPPORTED_VALUE_J2CA8011", new Object[]{this.entry.getValue(), name, this.jndiName == null ? this.id : this.jndiName});
                    if (x == null) ** GOTO lbl13
                    throw x;
                }
            } else if (TraceComponent.isAnyTracingEnabled() && DSConfig.tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)DSConfig.tc, (String)("unrecognized attribute: " + name), (Object[])new Object[0]);
            }
lbl13:
            // 5 sources

            this.entry = this.entries.pollFirstEntry();
        }
        return (E)(value == null ? defaultValue : value);
    }

    private Integer remove(String name, Integer defaultValue, int min, TimeUnit units, int ... range) throws Exception {
        long l;
        int diff;
        Object value = null;
        while (value == null && this.entry != null && (diff = this.entry.getKey().compareTo(name)) <= 0) {
            if (diff == 0) {
                value = this.entry.getValue();
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("unrecognized attribute: " + name), (Object[])new Object[0]);
            }
            this.entry = this.entries.pollFirstEntry();
        }
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            l = ((Number)value).longValue();
        } else {
            try {
                l = units == null ? (long)Integer.parseInt((String)value) : MetatypeUtils.evaluateDuration((String)((String)value), (TimeUnit)units);
            }
            catch (Exception x) {
                x = (Exception)this.connectorSvc.ignoreWarnOrFail(null, (Throwable)x, x.getClass(), "UNSUPPORTED_VALUE_J2CA8011", new Object[]{value, name, this.jndiName == null ? this.id : this.jndiName});
                if (x == null) {
                    return defaultValue;
                }
                throw x;
            }
        }
        if (l < (long)min || l > Integer.MAX_VALUE || range.length > 0 && Arrays.binarySearch(range, (int)l) < 0) {
            SQLNonTransientException x = (SQLNonTransientException)this.connectorSvc.ignoreWarnOrFail(null, null, SQLNonTransientException.class, "UNSUPPORTED_VALUE_J2CA8011", new Object[]{value, name, this.jndiName == null ? this.id : this.jndiName});
            if (x == null) {
                return defaultValue;
            }
            throw x;
        }
        return (int)l;
    }

    private <T> T remove(String name, T defaultValue) throws SQLException {
        int diff;
        Object value = null;
        while (value == null && this.entry != null && (diff = this.entry.getKey().compareTo(name)) <= 0) {
            if (diff == 0) {
                value = this.entry.getValue();
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("unrecognized attribute: " + name), (Object[])new Object[0]);
            }
            this.entry = this.entries.pollFirstEntry();
        }
        return (T)(value == null ? defaultValue : value);
    }
}

