/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.rsadapter;

import com.ibm.websphere.ce.cm.StaleConnectionException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.rsadapter.GenericDataStoreHelper;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.jdbc.WSJdbcTracer;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;

public class MicrosoftSQLServerDataStoreHelper
extends GenericDataStoreHelper {
    private static final TraceComponent tc = Tr.register(MicrosoftSQLServerDataStoreHelper.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    private static final String RESPONSE_BUFFERING = "responseBuffering";
    private String responseBuffering;
    private Method methodSetResponseBuffering;

    public MicrosoftSQLServerDataStoreHelper(WSManagedConnectionFactoryImpl mcf, Properties props) {
        super(mcf, props);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object[])new Object[]{props});
        }
        this.dshMd.setDatabaseDefaultIsolationLevel(4);
        this.dshMd.setGetTypeMapSupport(false);
        this.dshMd.setHelperType(10);
        this.dshMd.setReadOnlySupport(false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Metadata for MicrosoftSQLServerDataStoreHelper:", (Object[])new Object[]{this.dshMd});
        }
        this.genErrorMap.put(new Integer(230), StaleConnectionException.class);
        this.genErrorMap.put(new Integer(6002), StaleConnectionException.class);
        this.genErrorMap.put(new Integer(6001), StaleConnectionException.class);
        this.genErrorMap.put(new Integer(6005), StaleConnectionException.class);
        this.genErrorMap.put(new Integer(6006), StaleConnectionException.class);
        String string = this.responseBuffering = props != null && props.containsKey(RESPONSE_BUFFERING) ? props.getProperty(RESPONSE_BUFFERING) : "adaptive";
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Default responseBuffering = " + this.responseBuffering), (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    @Override
    public void doStatementCleanup(PreparedStatement stmt) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"doStatementCleanup", (Object[])new Object[]{AdapterUtil.toString(stmt)});
        }
        stmt.setCursorName(null);
        stmt.setFetchDirection(1000);
        stmt.setMaxFieldSize(Integer.MAX_VALUE);
        stmt.setMaxRows(0);
        Integer queryTimeout = this.mcf.dsConfig.get().queryTimeout;
        if (queryTimeout == null) {
            queryTimeout = this.defaultQueryTimeout;
        }
        stmt.setQueryTimeout(queryTimeout);
        stmt = (PreparedStatement)WSJdbcTracer.getImpl(stmt);
        if (this.responseBuffering != null && this.methodSetResponseBuffering == null) {
            try {
                this.methodSetResponseBuffering = stmt.getClass().getMethod("setResponseBuffering", String.class);
            }
            catch (NoSuchMethodException x) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"ResponseBuffering not supported.", (Object[])new Object[0]);
                }
                this.responseBuffering = null;
            }
        }
        if (this.responseBuffering != null) {
            try {
                this.methodSetResponseBuffering.invoke((Object)stmt, this.responseBuffering);
            }
            catch (InvocationTargetException x) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"doStatementCleanup", (Object)x.getCause());
                }
                throw (SQLException)x.getCause();
            }
            catch (IllegalAccessException x) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"ResponseBuffering not supported.", (Object[])new Object[0]);
                }
                this.responseBuffering = null;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"doStatementCleanup");
        }
    }
}

