/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.rsadapter;

import com.ibm.ejs.cm.logger.TraceWriter;
import com.ibm.ejs.ras.Tr;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import com.ibm.websphere.ce.cm.StaleStatementException;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.rsadapter.GenericDataStoreHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class InformixDataStoreHelper
extends GenericDataStoreHelper {
    private static final TraceComponent tc = com.ibm.websphere.ras.Tr.register(InformixDataStoreHelper.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    private static final TraceComponent infxTc = Tr.register((String)"com.ibm.ws.informix.logwriter", (String)"WAS.database", null);
    private HashMap<Object, Class<?>> infxErrorMap = new HashMap(17);
    private HashMap<Object, Class<?>> userNewMap = null;
    private static final int HASHSIZE = 17;
    private int informixLockModeWait = 0;
    private boolean informixAllowNewLine = false;

    public InformixDataStoreHelper(WSManagedConnectionFactoryImpl mcf, Properties props) {
        super(mcf, props);
        if (props != null) {
            String holder = props.getProperty("informixLockModeWait");
            if (holder != null) {
                this.informixLockModeWait = Integer.parseInt(holder);
            }
            holder = props.getProperty("informixAllowNewLine");
            this.informixAllowNewLine = Boolean.valueOf(holder);
            if (tc.isDebugEnabled()) {
                com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"the INFORMIX_ALLOW_NEWLINE datasource custom property is set to: ", (Object[])new Object[]{holder});
            }
        }
        this.addInitialMaps();
        this.dshMd.setHelperType(14);
        this.dshMd.setDatabaseDefaultIsolationLevel(4);
        if (tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"the metadata for the informix helper is", (Object[])new Object[]{this.dshMd});
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"done constructing Infx helper: InformixLockModeWait is: ", (Object[])new Object[]{this.informixLockModeWait});
        }
    }

    private void addInitialMaps() {
        this.infxErrorMap.put(new Integer(43012), StaleConnectionException.class);
        this.infxErrorMap.put(new Integer(-908), StaleConnectionException.class);
        this.infxErrorMap.put(new Integer(-25580), StaleConnectionException.class);
        this.infxErrorMap.put(new Integer(-27002), StaleConnectionException.class);
        this.infxErrorMap.put(new Integer(-43207), StaleConnectionException.class);
        this.infxErrorMap.put(new Integer(-79716), StaleConnectionException.class);
        this.infxErrorMap.put(new Integer(-79735), StaleConnectionException.class);
        this.infxErrorMap.put(-710, StaleStatementException.class);
    }

    @Override
    public final Class<?> findMappingClass(SQLException e) {
        Class<?> eClass = null;
        String sqlState = null;
        if (tc.isEntryEnabled()) {
            com.ibm.websphere.ras.Tr.entry((Object)this, (TraceComponent)tc, (String)("findMappingClass for: " + e), (Object[])new Object[0]);
        }
        if (e != null) {
            if (this.userNewMap != null) {
                eClass = this.userNewMap.get(e.getErrorCode());
                if (eClass != null) {
                    if (tc.isEntryEnabled()) {
                        com.ibm.websphere.ras.Tr.exit((Object)this, (TraceComponent)tc, (String)"findMappingClass", eClass);
                    }
                    return eClass;
                }
                sqlState = e.getSQLState();
                if (sqlState != null && (eClass = this.userNewMap.get(sqlState)) != null) {
                    if (tc.isEntryEnabled()) {
                        com.ibm.websphere.ras.Tr.exit((Object)this, (TraceComponent)tc, (String)"findMappingClass", eClass);
                    }
                    return eClass;
                }
            }
            if ((eClass = this.infxErrorMap.get(e.getErrorCode())) != null) {
                if (tc.isEntryEnabled()) {
                    com.ibm.websphere.ras.Tr.exit((Object)this, (TraceComponent)tc, (String)"findMappingClass", eClass);
                }
                return eClass;
            }
            sqlState = e.getSQLState();
            if (sqlState != null) {
                eClass = this.infxErrorMap.get(sqlState);
            }
            if (eClass == null) {
                SQLException nextException = e.getNextException();
                if (nextException != null && nextException != e) {
                    eClass = this.findMappingClass(nextException);
                    if (tc.isEntryEnabled()) {
                        com.ibm.websphere.ras.Tr.exit((Object)this, (TraceComponent)tc, (String)"findMappingClass", eClass);
                    }
                    return eClass;
                }
                eClass = super.findMappingClass(e);
                if (tc.isEntryEnabled()) {
                    com.ibm.websphere.ras.Tr.exit((Object)this, (TraceComponent)tc, (String)"findMappingClass", eClass);
                }
                return eClass;
            }
        }
        if (tc.isEntryEnabled()) {
            com.ibm.websphere.ras.Tr.exit((Object)this, (TraceComponent)tc, (String)"findMappingClass", eClass);
        }
        return eClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doConnectionSetup(Connection conn) throws SQLException {
        Statement stmt;
        block11: {
            stmt = null;
            if (tc.isEntryEnabled()) {
                com.ibm.websphere.ras.Tr.entry((Object)this, (TraceComponent)tc, (String)"doConnectionSetup", (Object[])new Object[]{this.informixAllowNewLine});
            }
            try {
                stmt = conn.createStatement();
                if (!this.informixAllowNewLine) break block11;
                stmt.execute("EXECUTE PROCEDURE IFX_ALLOW_NEWLINE('T')");
            }
            catch (Throwable throwable) {
                block13: {
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.websphere.rsadapter.InformixDataStoreHelper.doConnectionSetup", (String)"231", (Object)this);
                        if (!tc.isDebugEnabled()) break block13;
                        com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"SQLException occured in closing the statement ", (Object[])new Object[]{e});
                    }
                }
                throw throwable;
            }
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.websphere.rsadapter.InformixDataStoreHelper.doConnectionSetup", (String)"231", (Object)this);
            if (tc.isDebugEnabled()) {
                com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"SQLException occured in closing the statement ", (Object[])new Object[]{e});
            }
        }
        if (tc.isEntryEnabled()) {
            com.ibm.websphere.ras.Tr.exit((Object)this, (TraceComponent)tc, (String)"doConnectionSetup");
        }
    }

    @Override
    public void doStatementCleanup(PreparedStatement stmt) throws SQLException {
        stmt.setFetchDirection(1000);
        stmt.setMaxFieldSize(0);
        stmt.setMaxRows(0);
        Integer queryTimeout = this.mcf.dsConfig.get().queryTimeout;
        if (queryTimeout == null) {
            queryTimeout = this.defaultQueryTimeout;
        }
        stmt.setQueryTimeout(queryTimeout);
    }

    @Override
    public final void setUserDefinedMap(Map newmap) {
        this.userNewMap = new HashMap(newmap);
    }

    @Override
    public PrintWriter getPrintWriter() {
        if (infxTc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"Informix logging is enabled", (Object[])new Object[0]);
            return new PrintWriter(new TraceWriter(infxTc));
        }
        return null;
    }
}

