/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.rsadapter;

import com.ibm.websphere.ce.cm.StaleConnectionException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.rsadapter.DerbyDataStoreHelper;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;

public class DerbyNetworkServerDataStoreHelper
extends DerbyDataStoreHelper {
    private static final TraceComponent tc = Tr.register(DerbyNetworkServerDataStoreHelper.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");

    public DerbyNetworkServerDataStoreHelper(WSManagedConnectionFactoryImpl mcf, Properties props) {
        super(mcf, props);
        this.addInitialMaps();
        this.dshMd.setHelperType(18);
        this.dshMd.setStatementCacheIsoLevel(true);
        this.dshMd.setNetworkTimeoutSupport(true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"the Derby network server metadata is :", (Object[])new Object[]{this.dshMd});
            Tr.debug((Object)this, (TraceComponent)tc, (String)"done constructing Derby network server helper", (Object[])new Object[]{this});
        }
    }

    private void addInitialMaps() {
        this.derbyErrorMap.put(new Integer(-4499), StaleConnectionException.class);
    }

    @Override
    public void doStatementCleanup(PreparedStatement stmt) throws SQLException {
        stmt.setFetchDirection(1000);
        stmt.setMaxFieldSize(0);
        stmt.setMaxRows(0);
        Integer queryTimeout = this.mcf.dsConfig.get().queryTimeout;
        if (queryTimeout == null) {
            queryTimeout = this.defaultQueryTimeout;
        }
        stmt.setQueryTimeout(queryTimeout);
    }
}

