/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.rsadapter;

import com.ibm.ejs.ras.Tr;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import com.ibm.websphere.ce.cm.StaleStatementException;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.rsadapter.GenericDataStoreHelper;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class DerbyDataStoreHelper
extends GenericDataStoreHelper {
    private static final TraceComponent tc = com.ibm.websphere.ras.Tr.register(DerbyDataStoreHelper.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    protected static final com.ibm.ejs.ras.TraceComponent derbyTc = Tr.register((String)"com.ibm.ws.derby.logwriter", (String)"WAS.database", null);
    protected HashMap<Object, Class<?>> derbyErrorMap = new HashMap(13);
    private HashMap<Object, Class<?>> userNewMap = null;
    private static final int HASHSIZE = 13;

    public DerbyDataStoreHelper(WSManagedConnectionFactoryImpl mcf, Properties props) {
        super(mcf, props);
        this.addInitialMaps();
        this.dshMd.setGetTypeMapSupport(false);
        this.dshMd.setNetworkTimeoutSupport(false);
        this.dshMd.setHelperType(19);
        this.dshMd.setDatabaseDefaultIsolationLevel(4);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"the Derby metadata is :", (Object[])new Object[]{this.dshMd});
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"done constructing Derby helper", (Object[])new Object[]{this});
        }
    }

    private void addInitialMaps() {
        this.derbyErrorMap.put("XCL10", StaleStatementException.class);
        this.derbyErrorMap.put(new Integer(40000), StaleConnectionException.class);
        this.derbyErrorMap.put(new Integer(45000), StaleConnectionException.class);
        this.derbyErrorMap.put(new Integer(50000), StaleConnectionException.class);
    }

    @Override
    public void doStatementCleanup(PreparedStatement stmt) throws SQLException {
        stmt.setCursorName(null);
        stmt.setFetchDirection(1000);
        stmt.setMaxFieldSize(0);
        stmt.setMaxRows(0);
        Integer queryTimeout = this.mcf.dsConfig.get().queryTimeout;
        if (queryTimeout == null) {
            queryTimeout = this.defaultQueryTimeout;
        }
        stmt.setQueryTimeout(queryTimeout);
    }

    @Override
    public final Class<?> findMappingClass(SQLException e) {
        String methodName = "findMappingClass";
        Class<?> eClass = null;
        String sqlState = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            com.ibm.websphere.ras.Tr.entry((Object)this, (TraceComponent)tc, (String)"findMappingClass", (Object[])new Object[]{e});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            com.ibm.websphere.ras.Tr.event((Object)this, (TraceComponent)tc, (String)"the DataStoreHelper is: ", (Object[])new Object[]{this});
        }
        if (e != null) {
            if (this.userNewMap != null) {
                eClass = this.userNewMap.get(e.getErrorCode());
                if (eClass != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        com.ibm.websphere.ras.Tr.exit((Object)this, (TraceComponent)tc, (String)"findMappingClass", eClass);
                    }
                    return eClass;
                }
                sqlState = e.getSQLState();
                if (sqlState != null && (eClass = this.userNewMap.get(sqlState)) != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        com.ibm.websphere.ras.Tr.exit((Object)this, (TraceComponent)tc, (String)"findMappingClass", eClass);
                    }
                    return eClass;
                }
            }
            if (this.derbyErrorMap != null) {
                eClass = this.derbyErrorMap.get(e.getErrorCode());
                if (eClass != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        com.ibm.websphere.ras.Tr.exit((Object)this, (TraceComponent)tc, (String)"findMappingClass", eClass);
                    }
                    return eClass;
                }
                sqlState = e.getSQLState();
                if (sqlState != null) {
                    eClass = this.derbyErrorMap.get(sqlState);
                }
            }
            if (eClass == null) {
                SQLException nextException = e.getNextException();
                if (nextException != null && nextException != e) {
                    eClass = this.findMappingClass(nextException);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        com.ibm.websphere.ras.Tr.exit((Object)this, (TraceComponent)tc, (String)"findMappingClass", eClass);
                    }
                    return eClass;
                }
                eClass = super.findMappingClass(e);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    com.ibm.websphere.ras.Tr.exit((Object)this, (TraceComponent)tc, (String)"findMappingClass", eClass);
                }
                return eClass;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            com.ibm.websphere.ras.Tr.exit((Object)this, (TraceComponent)tc, (String)"findMappingClass", eClass);
        }
        return eClass;
    }

    @Override
    public final void setUserDefinedMap(Map newmap) {
        this.userNewMap = new HashMap(newmap);
    }
}

