/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.rsadapter;

import com.ibm.websphere.ce.cm.StaleConnectionException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.rsadapter.DB2DataStoreHelper;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;
import java.io.PrintWriter;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;

public class DB2UniversalDataStoreHelper
extends DB2DataStoreHelper {
    private static final TraceComponent tc = Tr.register(DB2UniversalDataStoreHelper.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    public static final String DRIVER_TYPE = "driverType";
    private int driverType = 0;

    public DB2UniversalDataStoreHelper(WSManagedConnectionFactoryImpl mcf, Properties props) {
        super(mcf, props);
        this.db2ErrorMap.put(new Integer(-4498), StaleConnectionException.class);
        this.db2ErrorMap.put(new Integer(-4499), StaleConnectionException.class);
        this.db2ErrorMap.put(new Integer(-1776), StaleConnectionException.class);
        this.dshMd.setHelperType(4);
        String dtype = props.getProperty(DRIVER_TYPE);
        if (dtype != null) {
            this.driverType = new Integer(dtype);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"DB2UniversalDataStoreHelper constructor:  driverType = ", (Object[])new Object[]{dtype});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Creating DataStoreHelper", (Object[])new Object[]{this});
        }
    }

    @Override
    public PrintWriter getPrintWriter() {
        return null;
    }

    public final int getDriverType() {
        return this.driverType;
    }

    @Override
    public void doStatementCleanup(PreparedStatement stmt) throws SQLException {
        Integer queryTimeout;
        try {
            stmt.setCursorName(null);
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        stmt.setFetchDirection(1000);
        if (stmt.getMaxFieldSize() != 0) {
            stmt.setMaxFieldSize(0);
        }
        if (stmt.getMaxRows() != 0) {
            stmt.setMaxRows(0);
        }
        if ((queryTimeout = this.mcf.dsConfig.get().queryTimeout) == null) {
            queryTimeout = this.defaultQueryTimeout;
        }
        stmt.setQueryTimeout(queryTimeout);
    }
}

