/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.rsadapter;

import com.ibm.ejs.ras.Tr;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import com.ibm.websphere.ce.cm.StaleStatementException;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.rsadapter.GenericDataStoreHelper;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.Transaction.UOWCurrent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;
import com.ibm.ws.tx.embeddable.EmbeddableWebSphereTransactionManager;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;

public class DB2DataStoreHelper
extends GenericDataStoreHelper {
    private static final TraceComponent tc = com.ibm.websphere.ras.Tr.register(DB2DataStoreHelper.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    protected static final TraceComponent db2Tc = Tr.register((String)"com.ibm.ws.db2.logwriter", (String)"WAS.database", null);
    private static final String ZOS_CURRENT_SQLID = "currentSQLID";
    HashMap<Object, Class<?>> db2ErrorMap = null;
    private static final int HASHSIZE = 37;
    private boolean db2ZOS;
    private String productName = null;
    private String currentSQLid = null;

    public DB2DataStoreHelper(WSManagedConnectionFactoryImpl mcf, Properties props) {
        super(mcf, props);
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        this.db2ErrorMap = new HashMap(37);
        if (props != null) {
            this.currentSQLid = props.getProperty(ZOS_CURRENT_SQLID);
            if (isTraceOn && tc.isDebugEnabled()) {
                com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"DSConfigHelper.ZOS_CURRENT_SQLID is", (Object[])new Object[]{this.currentSQLid});
            }
        }
        this.addInitialMaps();
        this.dshMd.setGetTypeMapSupport(false);
        this.dshMd.setHelperType(1);
        this.dshMd.setStatementCacheIsoLevel(true);
        this.dshMd.setDatabaseDefaultIsolationLevel(4);
        String osType = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("os.name");
            }
        });
        boolean bl = this.db2ZOS = osType.equalsIgnoreCase("OS/390") || osType.equalsIgnoreCase("Z/OS");
        if (isTraceOn && tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"the metadata for the Db2 is", (Object[])new Object[]{this.dshMd});
        }
    }

    private void addInitialMaps() {
        this.db2ErrorMap.put(-1015, StaleConnectionException.class);
        this.db2ErrorMap.put(-1034, StaleConnectionException.class);
        this.db2ErrorMap.put(-1035, StaleConnectionException.class);
        this.db2ErrorMap.put(-6036, StaleConnectionException.class);
        this.db2ErrorMap.put(-30081, StaleConnectionException.class);
        this.db2ErrorMap.put(-30108, StaleConnectionException.class);
        this.db2ErrorMap.put(-1224, StaleConnectionException.class);
        this.db2ErrorMap.put(-1229, StaleConnectionException.class);
        this.db2ErrorMap.put("58004", StaleConnectionException.class);
        this.db2ErrorMap.put(-518, StaleStatementException.class);
        this.db2ErrorMap.put(-514, StaleStatementException.class);
        this.db2ErrorMap.put(-30080, StaleConnectionException.class);
        this.db2ErrorMap.put(-924, StaleConnectionException.class);
        this.db2ErrorMap.put(-923, StaleConnectionException.class);
        this.db2ErrorMap.put(-906, StaleConnectionException.class);
        this.db2ErrorMap.put("S1000", Void.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doConnectionSetup(Connection conn) throws SQLException {
        EmbeddableWebSphereTransactionManager tm;
        Transaction suspendedTx;
        Statement stmt;
        boolean isTraceOn;
        block35: {
            isTraceOn = TraceComponent.isAnyTracingEnabled();
            if (isTraceOn && tc.isEntryEnabled()) {
                com.ibm.websphere.ras.Tr.entry((Object)this, (TraceComponent)tc, (String)"doConnectionSetup", (Object[])new Object[0]);
            }
            if (this.productName == null) {
                DatabaseMetaData dmd = conn.getMetaData();
                this.productName = dmd.getDatabaseProductName();
                if (isTraceOn && tc.isDebugEnabled()) {
                    com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)("Product name = " + this.productName), (Object[])new Object[0]);
                }
                this.db2ZOS = this.productName.equals("DB2") || this.productName.toUpperCase().startsWith("DSN");
            }
            stmt = null;
            suspendedTx = null;
            tm = this.mcf.connectorSvc.getTransactionManager();
            try {
                boolean inGlobalTransaction;
                if (this.currentSQLid == null || this.currentSQLid.equals("")) break block35;
                UOWCurrent uow = (UOWCurrent)tm;
                UOWCoordinator coord = uow == null ? null : uow.getUOWCoord();
                boolean bl = inGlobalTransaction = coord != null && coord.isGlobal();
                if (inGlobalTransaction) {
                    try {
                        suspendedTx = tm.suspend();
                    }
                    catch (Throwable t) {
                        throw new SQLException(t);
                    }
                }
                if (isTraceOn && tc.isDebugEnabled()) {
                    com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)("Setting currentSQLID : " + this.currentSQLid), (Object[])new Object[0]);
                }
                stmt = conn.createStatement();
                String sql = "set current sqlid = '" + this.currentSQLid + "'";
                stmt.executeUpdate(sql);
            }
            catch (Throwable throwable) {
                try {
                    if (stmt == null) throw throwable;
                    stmt.close();
                    throw throwable;
                }
                catch (SQLException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.websphere.rsadapter.DB2DataStoreHelper.doConnectionSetup", (String)"231", (Object)this);
                    if (!isTraceOn) throw throwable;
                    if (!tc.isDebugEnabled()) throw throwable;
                    com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"SQLException occured in closing the statement ", (Object[])new Object[]{e});
                    throw throwable;
                }
                finally {
                    if (suspendedTx != null) {
                        try {
                            tm.resume(suspendedTx);
                        }
                        catch (Throwable t) {
                            throw new SQLException(t);
                        }
                    }
                }
            }
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.websphere.rsadapter.DB2DataStoreHelper.doConnectionSetup", (String)"231", (Object)this);
            if (isTraceOn && tc.isDebugEnabled()) {
                com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"SQLException occured in closing the statement ", (Object[])new Object[]{e});
            }
        }
        finally {
            if (suspendedTx != null) {
                try {
                    tm.resume(suspendedTx);
                }
                catch (Throwable t) {
                    throw new SQLException(t);
                }
            }
        }
        if (!isTraceOn) return;
        if (!tc.isEntryEnabled()) return;
        com.ibm.websphere.ras.Tr.exit((Object)this, (TraceComponent)tc, (String)"doConnectionSetup", (Object)this.db2ZOS);
    }

    @Override
    public void doStatementCleanup(PreparedStatement stmt) throws SQLException {
        Integer queryTimeout;
        stmt.setFetchDirection(1000);
        if (stmt.getMaxFieldSize() != 0) {
            stmt.setMaxFieldSize(0);
        }
        if (stmt.getMaxRows() != 0) {
            stmt.setMaxRows(0);
        }
        if ((queryTimeout = this.mcf.dsConfig.get().queryTimeout) == null) {
            queryTimeout = this.defaultQueryTimeout;
        }
        stmt.setQueryTimeout(queryTimeout);
    }

    @Override
    public final Class<?> findMappingClass(SQLException e) {
        HashSet<SQLException> chain = new HashSet<SQLException>();
        while (e != null) {
            if (chain.contains(e)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    com.ibm.websphere.ras.Tr.debug((TraceComponent)tc, (String)"Cycle detected in SQLException chain -- returning null", (Object[])new Object[0]);
                }
                return null;
            }
            chain.add(e);
            Class<?> eClass = this.db2ErrorMap.get(e.getErrorCode());
            if (eClass != null) {
                return eClass;
            }
            String sqlState = e.getSQLState();
            if (sqlState != null) {
                eClass = this.db2ErrorMap.get(sqlState);
            }
            if (eClass != null) {
                return eClass;
            }
            eClass = super.findMappingClass(e);
            if (eClass != null) {
                return eClass;
            }
            e = e.getNextException();
        }
        return null;
    }

    @Override
    public PrintWriter getPrintWriter() {
        if (TraceComponent.isAnyTracingEnabled() && db2Tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.info((TraceComponent)tc, (String)"DB2_TRACE_INFORMATION", (Object[])new Object[0]);
        }
        return null;
    }

    @Override
    public String getXAExceptionContents(XAException x) {
        StringBuffer xsb = new StringBuffer(200);
        Throwable t = x.getCause();
        if (t != null && t instanceof SQLException) {
            SQLException e = (SQLException)t;
            String EOLN = AdapterUtil.EOLN;
            xsb.append(EOLN).append("The DB2 Error message is : ").append(e.getMessage()).append(EOLN);
            xsb.append("The DB2 Error code is    : ").append(e.getErrorCode()).append(EOLN);
            xsb.append("The DB2 SQLState is      : ").append(e.getSQLState()).append(EOLN);
        }
        return xsb.toString();
    }
}

