/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.rsadapter;

import com.ibm.websphere.ce.cm.StaleConnectionException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.rsadapter.DB2DataStoreHelper;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Properties;

public class DB2AS400DataStoreHelper
extends DB2DataStoreHelper {
    private static final TraceComponent tc = Tr.register(DB2AS400DataStoreHelper.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");

    public DB2AS400DataStoreHelper(WSManagedConnectionFactoryImpl mcf, Properties props) {
        super(mcf, props);
        this.db2ErrorMap.put("HY017", StaleConnectionException.class);
        this.dshMd.setGetTypeMapSupport(false);
        this.dshMd.setHelperType(2);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"the metadata for the AS400 is", (Object[])new Object[]{this.dshMd});
            Tr.debug((Object)this, (TraceComponent)tc, (String)"done constructing the DB2As400Helper", (Object[])new Object[]{this});
        }
    }

    @Override
    public boolean doConnectionCleanup(Connection conn) throws SQLException {
        block8: {
            SQLWarning warn;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)tc, (String)"doConnectionCleanup", (Object[])new Object[0]);
            }
            if ((warn = conn.getWarnings()) == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"doConnectionCleanup(): no warnings to cleanup", (Object[])new Object[0]);
                }
            } else {
                try {
                    conn.clearWarnings();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"doConnectionCleanup(): cleanup of warnings done", (Object[])new Object[0]);
                    }
                }
                catch (SQLException se) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block8;
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"doConnectionCleanup(): cleanup of warnings failed", (Object[])new Object[]{se});
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"doConnectionCleanup");
        }
        return false;
    }

    @Override
    public void doStatementCleanup(PreparedStatement stmt) throws SQLException {
        stmt.setCursorName(null);
        stmt.setFetchDirection(1000);
        stmt.setMaxFieldSize(0);
        stmt.setMaxRows(0);
        Integer queryTimeout = this.mcf.dsConfig.get().queryTimeout;
        if (queryTimeout == null) {
            queryTimeout = this.defaultQueryTimeout;
        }
        stmt.setQueryTimeout(queryTimeout);
    }
}

